$ExeIcon:'D:/Comet Programs/CometSkip.ico'
Screen _NewImage(1777, 1000, 32)
'Screen _NewImage(1920, 1080, 32) ' Need to change ALL screen print commands to do this
_ScreenMove 0, 0 ' moves program screen to upper left
'_SCREENMOVE _MIDDLE ' SHIFTS SCREEN TO MIDDLE OF COMPUTER MONITOR

'WINDOW (1800, 900)-(12000, 6000) ' scale window to new listed coordinates. Use WINDOW SCREEEN (a,b)-(c,d) to have y = 0 at top
'_FULLSCREEN _SQUAREPIXELS


Dim Shared PrevAA As Double, AA As Double
Dim Shared SimulationScreenSize As Integer
SimulationScreenSize = 9

Dim Shared PlanetCenterX As Double, PlanetCenterY As Double, PlanetCenterZ As Double, GravityConstant As Double, GEarth As Double, GSun As Double, GSun2 As Double
Dim Shared PlanetMass As Double, PlanetRadius As Double

Dim Shared SunCenterX As Double, SunCenterY As Double, SunCenterZ As Double, SunMass As Double, SunScale As Double, SunRadius As Double, DrawSunRadius As Double
Dim Shared HitEarth$, HitJupiter$, HitEarthBefore$

Dim Shared Earth002CenterX As Double, Earth002CenterY As Double, Earth002CenterZ As Double, Earth002Mass As Double, Earth002Radius As Double
Dim Shared Earth002Distance As Double, Earth002Acceleration As Double, GEarth002 As Double
Dim Shared Earth002SpeedX As Double, Earth002SpeedY As Double, Earth002SpeedZ As Double
Dim Shared PreviousY As Long, CometYears As Long, PreviousDif As Long, PreviousCT As Long

Dim Shared MercuryDistance As Double, MercuryAcceleration As Double, GMercury As Double, MercuryMass As Double
Dim Shared MercuryCenterX As Double, MercuryCenterY As Double, MercuryCenterZ As Double, MercuryRadius As Double
Dim Shared MercurySpeedX As Double, MercurySpeedY As Double, MercurySpeedZ As Double

Dim Shared VenusDistance As Double, VenusAcceleration As Double, GVenus As Double, VenusMass As Double
Dim Shared VenusCenterX As Double, VenusCenterY As Double, VenusCenterZ As Double, VenusRadius As Double
Dim Shared VenusSpeedX As Double, VenusSpeedY As Double, VenusSpeedZ As Double

Dim Shared MarsDistance As Double, MarsAcceleration As Double, GMars As Double, MarsMass As Double
Dim Shared MarsCenterX As Double, MarsCenterY As Double, MarsCenterZ As Double, MarsRadius As Double
Dim Shared MarsSpeedX As Double, MarsSpeedY As Double, MarsSpeedZ As Double

Dim Shared JupiterDistance As Double, JupiterAcceleration As Double, GJupiter As Double, JupiterMass As Double
Dim Shared JupiterCenterX As Double, JupiterCenterY As Double, JupiterCenterZ As Double, JupiterRadius As Double
Dim Shared JupiterSpeedX As Double, JupiterSpeedY As Double, JupiterSpeedZ As Double

Dim Shared GanymedeDistance As Double, GanymedeAcceleration As Double, GGanymede As Double, GanymedeMass As Double
Dim Shared GanymedeSpeedX As Double, GanymedeSpeedY As Double, GanymedeSpeedZ As Double, GanymedeRadius As Double
Dim Shared GanymedeCenterX As Double, GanymedeCenterY As Double, GanymedeCenterZ As Double

Dim Shared SaturnDistance As Double, SaturnAcceleration As Double, GSaturn As Double, SaturnMass As Double
Dim Shared SaturnCenterX As Double, SaturnCenterY As Double, SaturnCenterZ As Double, SaturnRadius As Double
Dim Shared SaturnSpeedX As Double, SaturnSpeedY As Double, SaturnSpeedZ As Double

Dim Shared NeptuneDistance As Double, NeptuneAcceleration As Double, GNeptune As Double, NeptuneMass As Double
Dim Shared NeptuneCenterX As Double, NeptuneCenterY As Double, NeptuneCenterZ As Double, NeptuneRadius As Double
Dim Shared NeptuneSpeedX As Double, NeptuneSpeedY As Double, NeptuneSpeedZ As Double

Dim Shared UranusDistance As Double, UranusAcceleration As Double, GUranus As Double, UranusMass As Double
Dim Shared UranusCenterX As Double, UranusCenterY As Double, UranusCenterZ As Double, UranusRadius As Double
Dim Shared UranusSpeedX As Double, UranusSpeedY As Double, UranusSpeedZ As Double

Dim Shared MercuryGravity$, VenusGravity$, EarthGravity$, MarsGravity$, JupiterGravity$, SaturnGravity$, UranusNeptuneGravity$
Dim Shared EnckeGravity$
Dim Shared RunImpactProbabilities$, ShowPaths$, RemoveNonEarthCrossing$
Dim Shared WorldX(1101) As Double, WorldY(1101) As Double, WorldZ(1101) As Double

Dim Shared SwiftView$, SkipimpactatStart$, ZoomedtoComet$, MonoColor$, PresentMonoColor As Long, TempCometColor As Long, PointCount As Double

Dim Shared ARandom As Double, RA As Double, RB As Double, RC As Double, RD As Double, RE As Double, RF As Double, MaxYNumber As Double, EarthRotation As Double
' Dim Shared AccX As Double, AccY As Double, AccZ As Double

Dim Shared CometSpeedX(405, 405) As Double, CometSpeedY(405, 405) As Double, CometSpeedZ(405, 405) As Double
Dim Shared CometCenterX As Double, CometCenterY As Double, CometCenterZ As Double, CometRadius As Double, CometIIcount As Integer
Dim Shared CometLastCenterX As Double, CometLastCenterY As Double, CometLastCenterZ As Double
Dim Shared CometLastCenterX2 As Double, CometLastCenterY2 As Double, CometLastCenterZ2 As Double
Dim Shared CometLastCenterX3 As Double, CometLastCenterY3 As Double, CometLastCenterZ3 As Double
Dim Shared CometItSelfCenterX As Double, CometItSelfCenterY As Double, CometItSelfCenterZ As Double
Dim Shared CometItSelfCenterSpeedX As Double, CometItSelfCenterSpeedY As Double, CometItSelfCenterSpeedZ As Double
Dim Shared CometInitialSpeedX, CometInitialSpeedY, CometInitialSpeedZ
Dim Shared CometItselfX(15) As Double, CometItselfY(15) As Double, CometItselfZ(15) As Double, CometItselfRadius(15) As Single, CometItselfColor(15) As Long
Dim Shared CometItselfSpeedX(15) As Double, CometItselfSpeedY(15) As Double, CometItselfSpeedZ(15) As Double

Dim Shared LakeMichLocX(105, 15) As Double, LakeMichLocY(105, 15) As Double, LakeMichLocZ(105, 15) As Double, LakeMichLocRad(105, 15) As Double, LakeMichCount As Integer
Dim Shared EarthRotation$, DrawCraters$, HighlightSpeed$, RemoveHighSpeed$, CometFiresOn$, AddMorePoints$, CarolinaNumbers As Integer

Dim Shared SunZoomFactor As Double, SpeedUpFactor As Double, SimulationSlowFactor As Double
Dim Shared EnckeDebrisCount As Double, EnckeTimeX As Integer, EnckeTimeY As Integer, EnckeStartTime As Integer, ShowEnckeOrbits$

Dim Shared RunReverse$, AutoRotate$, ViewAngle As Double
Dim Shared x As Integer, y As Integer, z As Integer, CircularizeCount As Integer
Dim Shared CometMass(405, 405) As Double, CometSize(405, 405) As Double, CometColor(405, 405) As Long, NextCometColor As Long
Dim Shared CometX(405, 405) As Double, CometY(405, 405) As Double, CometZ(405, 405) As Double
Dim Shared PreviousCometX(405, 405) As Double, PreviousCometY(405, 405) As Double, PreviousCometZ(405, 405) As Double
Dim Shared PreviousCometX2(405, 405) As Double, PreviousCometY2(405, 405) As Double, PreviousCometZ2(405, 405) As Double

Dim Shared DemoCometColor(301, 301) As Long, DemoCometMass(301, 301) As Double
Dim Shared DemoCometSpeedX(301, 301) As Double, DemoCometSpeedY(301, 301) As Double, DemoCometSpeedZ(301, 301) As Double
Dim Shared DemoCometX(301, 301) As Double, DemoCometY(301, 301) As Double, DemoCometZ(301, 301) As Double
Dim Shared DemoEarthPoints(3001, 451) As Integer, CometAngleofApproach As Double

Dim Shared EarthX(10000, 30) As Double, EarthY(10000, 30) As Double, EarthColor(10000, 30) As Long, EarthMass(10000, 30) As Long

Dim Shared EarthSpeedX(10000, 30) As Double, EarthSpeedY(10000, 30) As Double, EarthSpeedZ(10000, 30) As Double
Dim Shared jDist As Double, CometTime As Long, pi As Double, CometTime150 As Double
Dim Shared ZoomTime1 As Double, ZoomTime2 As Double, ZoomTime3 As Double, ZoomTime4 As Double
Dim Shared ZoomWindow1 As Single, ZoomWindow2 As Single, ZoomWindow3 As Single, ZoomWindow4 As Single
Dim Shared ZoomFactor(4, 4) As Integer, FactorJ As Single
Dim Shared LinesLatitudeOnOff As Integer, CometPAthOnOff As Integer, AutoZoomOnOff As Integer

Dim Shared Scene$, ColorofPlanet$, CircularizingOnOff$
Dim Shared CDistance As Double, TiltofEarth As Single, TiltRotation As Single
Dim Shared ToggleRadius As Integer, DrawPathstartX As Double, DrawPathstartY As Double, DrawPathstartZ As Double
Dim Shared DrawPathCometSpeedX As Double, DrawPathCometSpeedY As Double, DrawPathCometSpeedZ As Double, ToggleDrawCometCenterPath As Integer
Dim Shared StartImpactTime As Double, EndImpactTime As Double
Dim Shared SaveTheImage As Integer, SaveOneInTen As Integer, CometFileName$, SaveDebrisOrbits$
Dim Shared ButtonNumber As Integer, OutGassing$, OutGasOnOrbit$, OutGasAtStart$
Dim Shared TimetobePrinted As Double, PreviousTimetobePrinted As Double
Dim Shared ImpactAngleProbs(100) As Double, ImpactAngleProbPercents(100) As Double

Dim Shared PlanetIColor As Long, CometParticlesColor As Long

_Title "Comet Skip Impacts Visulization Program.    (c) John Burgener 2021-2023"

'DIM SHARED Grid(60000, 30000) AS INTEGER

' GRID of 15,000 X 7,500 = 1 km pixels.   NOTE: This aims at 100 meter pieces for simulation. Each pixel in calculations will be 100X100m
' set size of comet
' for size 30km diameter, need to calculate which pixels have mass and therefore color
' if diameter = 30, then radius = 15, center = 150,150


'MISC FACTORS FOR SPACE AND SOLAR SYSTEM
'G = 6.67408 x 10^-11 m^3 / kg s^2
'G = 6.67408 x 10^-14 km^3 / kg s^2
' Mass of the Sun = 1.9891 X 10^30 kg
' Sun GM = 1.32712440018 * 10^20 m/sec^3
' SunGM = 1.32712440018 * 10^20 * 6.67408 x 10^-11  =~ 13 * 10^-11 * 10^30 = 13 * 10^19 = 1.3*10^20 = 133,400,000,000,000,000,000 ' Sun G * M in m/sec^3
'SunRadius = 695700000 ' Sun Radius in Meters (695,700 km)
'EarthGM = 400200000000000 ' Earth G * M in m/sec^3
'EarthRadius = 6371000 'Earth Radius in Meters (6,371 km)
'EarthRadius = 6371 km
'Earth Distance from Sun = 149.6 X 10^9 m
'Earth Mass = 5.972 X 10^24 kg
'MoonRadius = 1737000 'Moon Radius in Meters (1,737 km)
'MoondistancefromEarth = 384400000 ' Moon distance from Earth in Meters (384,000 km)

' Mars distance from sun = 227,939,200 km
' Mars Speed:24.0 km/s
' Mars Mass = 6.417 X 10^23
' Mars Radius = 3396 km

'Juiter distance from Sun: 778,000,000 km
'Jupiter speed: 13.07 km/s
'Jupiter Radius: 69911 km
'Jupiter Mass: 1.8982 X 10^27


'CometRadius = 30000 ' Comet Radius in Meters (30 km)
'EarthSpeed = 29790 ' Earth Speed in m/s
'CometSpeed = 41710 ' Comet speed in m/s
'Acc =  GM/r^2
' r^2 = Sqrt(x^2+y^2)
'GSun = 6.67408 * 10 ^ -11 * 1.9891 X 10^30  in meters
'GSun = 6.67408 * 10 ^ -20 * 1.9891 X 10^30  in km


'CALCULATIONS WITH EARTH AT 0,0
'WHILE Math.Abs(CometX) < CometStartDist
'TimeInterval = DistEarth / 100000000
'IF TimeInterval < 0.01 THEN TimeInterval = 0.01
'CalCount = CalCount + 1
'IF CometX = 0 THEN
'IF CometY > 0 THEN
'Angle = Math.ArcTan(9999999)
'ELSE
'Angle = Math.ArcTan(-9999999)
'END IF
'ELSE
'Angle = Math.ArcTan(CometY / CometX)
'IF OldCometY <> CometY THEN
'ImpactAngle = (Angle - Math.ArcTan((OldCometY - CometY) / (OldCometX - CometX)))
'END IF
'END IF
'
'DistEarth = Math.SquareRoot(CometY * CometY + CometX * CometX) ' Distance_from_Center of Earth
'x = Math.Cos(Angle) * EarthGM / (DistEarth * DistEarth)
'y = Math.Sin(Angle) * EarthGM / (DistEarth * DistEarth)
'AngleDegrees = Math.GetDegrees(Angle)
'IF Math.GetDegrees(ImpactAngle) > 0 THEN
'ImpactAngleDegrees = 90 - Math.GetDegrees(ImpactAngle)
'ELSE
'ImpactAngleDegrees = -Math.GetDegrees(ImpactAngle) - 90
'END IF
'


' Calculation of outgassing speeds is around line 450. IF OutGassing$ = "Yes" AND OutGasAtStart$ = "Yes" THEN CometSpeedX(x, y) = CometSpeedX(x, y) + .3 * (RND(32) - .5) * RND(33) ' add up to 0.15 km/sec = 150 m/sec = 540km/hour random speed. Most are slower.
' add up to 0.15km/sec = 540 km/hour random speed in each direction, total = SQRT(2) * .15 = 0.212 km/sec = 212 m/sec


RunReverse$ = "No"
RemoveNonEarthCrossing$ = "No"
SaveOneInTen = 2000
SaveTheImage = 2000
SaveOneInTen = 0
SaveTheImage = 0
EarthRotation$ = "Yes"
CarolinaNumbers = 0

Scene$ = "Comet 1991 L3 Levy from 19 degree inclination at 11 km/s relative speed" '  start at 11 km/s, hit at 13.6 km/s, change from 19 degrees to 71 - 72 degrees
Scene$ = "Head On Impact as if Halley's comet hit - Relative Speed 70 km/s"
Scene$ = "From Above at 45 degrees - Relative Speed 40 km/s"
Scene$ = "Crossing from Sun 100km comet - Relative Speed 40 km/s"
Scene$ = "Swift Tuttle from above at 66.55 degrees after impact - Relative Speed 42 km/s"
Scene$ = "Impact Jupiter then Earth twice at 1.5 and 1.6 years later"
Scene$ = "Impact Jupiter, near miss Earth, then impact Earth 8.1 years later"
Scene$ = "Impact Jupiter then Earth 10.2 years later"
Scene$ = "Impact Jupiter then Earth a year later"
Scene$ = "Impact Earth not Jupiter"
Scene$ = "SwiftTuttle Impact at Start"
Scene$ = "SwiftTuttle Orbit, outgassing along the orbit"
Scene$ = "Overtaking Earth from behind at 10 km/s"
Scene$ = "Saginaw 1"
Scene$ = "Saginaw 2"
Scene$ = "Egypt"
Scene$ = "Carolina Bays"
Scene$ = "Encke and Swift-Tuttle Origins"
Scene$ = "Mercury and Encke"
Scene$ = "Venus and Encke"
Scene$ = "Earth and Encke Nov"
Scene$ = "Earth and Encke July"
Scene$ = "Earth and ST"
Scene$ = "Demonstration of impact probabilities"
Scene$ = "Demo Shapes"
Scene$ = "ChesapeakeBay"
Scene$ = "MARS"
Scene$ = "Encke"
SwiftView$ = "Top"

MonoColor$ = "No": PresentMonoColor = _RGB(255, 255, 0)

CircularizingOnOff$ = ""
ToggleRadius = 0
SaveDebrisOrbits$ = ""


TiltofEarth = 23.4
LinesLatitudeOnOff = 1
CometPAthOnOff = 1
AutoZoomOnOff = 1
pi = 3.141592653589793

ZoomFactor(1, 1) = 19
ZoomFactor(2, 1) = 17
ZoomFactor(3, 1) = -21
ZoomFactor(4, 1) = -6

ZoomFactor(1, 2) = -10
ZoomFactor(2, 2) = -8
ZoomFactor(3, 2) = 10
ZoomFactor(4, 2) = 4

ZoomFactor(1, 3) = -15
ZoomFactor(2, 3) = -10
ZoomFactor(3, 3) = 15
ZoomFactor(4, 3) = 7




View (0, 0)-(1776, 999)
Window (-3000, -10000)-(35000, 11375)

' GOTO StartProgram ' Skip Opening Discourse for testing

OpeningDiscourse:
Cls
Line (-3000, -10000)-(35000, 11375), _RGB(255, 255, 240), BF

Color _RGB(0, 0, 255), _RGB(255, 255, 240)
Locate 5, 20: Print "                                             Comet Low Angle Impact / Skip Simulations Program"
Color _RGB(0, 0, 0)
Locate 7, 10: Print "This program is a display of what a low angle impact by a comet hitting Earth may look like. It is based on gravity as the main physical force, and uses iSALE Hydrocode examples and low velocity experiments"
Locate 8, 10: Print "as the basis of the presentation. iSALE is an excellent program but it works at much lower resolutions than here due to its more accurate calculations of the interactions between the energy of the impactor"
Locate 9, 10: Print "and the Earth. This program is NOT hydrocode. While it does accurately calculate the gravational forces acting on each particle once they have been impacted, the impact energy transfer is based on"
Locate 10, 10: Print " random number applications to the Earth sections hit by the comet sections. The comparision of the results to real world events is probably realistic but that is NOT verified. The lack of verification"
Locate 11, 10: Print "is also largely due to a lack of real world events like these ever happening while we were in a position to observe them. However, what the program presents matches well with what I see in low velocity"
Locate 12, 10: Print "impacts in clay experiments. So although not proven, it is reasonably realstic."
Locate 13, 10: Print "This program works with up to 90,000 points in the comet (depending on the simulation and comet size selected) and 1,350,000 points on Earth. The individual particles are various sizes."
Locate 14, 10: Print ""
Color _RGB(50, 50, 255)
Locate 15, 10: Print "                                                    Impacts on Earth are RARE.  Low Angle / Skip impacts are VERY RARE."
Color _RGB(0, 0, 0)
Locate 17, 10: Print "While very rare, it is proposed that such events happened in the recent past. Rare is not the same as IMPOSSIBLE. It is rare to win a lottery, but lottery winners happen every month,"
Locate 18, 10: Print "even with the odds being one in millions. It is proposed that comet 109P Swift-Tuttle has impacted Earth as presented in simulations F1, and Ctrl S"
Locate 19, 10: Print "and that the debris from the impact is the source of the Perseid meteor showers of mid August, and the fireballs associated with them."
Locate 20, 10: Print "The fireballs are in multiple orbits with only one point in common: the crossing of Earth's orbit. This program shows that such a set of orbits is predicted as expected in such an event. Instead of being"
Locate 21, 10: Print "impossible to explain, the fireball orbits are an obvious result of such an event."
Locate 22, 10: Print ""
Locate 23, 10: Print "It is further proposed that the event occured near the end of the ice age, approximately 12,700 years ago, and formed Lake Michigan as the impact crater. Such an event will lead to millions of small"
Locate 24, 10: Print "pieces of ice and earth to be tossed about 1000-2000 km which fits the expectation that the Carolina Bays are recent impacts from low angle, low mass, low speed ice blocks.  It would also fit as the source"
Locate 25, 10: Print "of the Younger Dryas event that led to the extinction of the large animals in North America. Lake Michigan is very close in size and shape to the low angle impact, Orcus Patera, on Mars."
Locate 26, 10: Print "It is to be noted that a comet in a skip type of impact will lose a lot of material. With comet Swift-Tuttle presently 29 km in diameter, the simulation is valid in assuming that the original comet was"
Locate 27, 10: Print "about 50 - 100 km diameter, and as the simulations show, the comet will lose at least 1/2 of its mass in a skip event."
Locate 28, 10: Print ""
Locate 29, 10: Print "The F1-F5 simulations show comet particles after impact as blue points if traveling below escape velocity from Earth, and red to yellow for ones above escape velocity."
Locate 30, 10: Print "Earth Particles are calculated as 1 km diameter pieces, the same as the comet pieces. They are drawn larger to allow one to see which ones are from Earth."
Locate 31, 10: Print "Earth Particles are white (for Ice) for the top 3 km layers, and yellow for the deeper layers. The simulation assumes that the impact will not effect deep layers."
Locate 32, 10: Print ""
Locate 33, 10: Print "The program has 5 preprogramed comet skip impact scenes showing low angle impacts / skips for some various possibilities by comets. A comet can pass Earth while crossing Earth's orbit while travelling on"
Locate 34, 10: Print "the Ecliptic plane (F4), or while crossing from above or below the Ecliptic plane (F1 or F2), or if the comet's orbit is closest to the Sun at the distance of Earth's orbit, then the comet can come up from"
Locate 35, 10: Print "behind Earth, (the minimal impact speed) (F3) or collide head on (maximum impact speed) (F5).  Simulations F1 to F5 are focused on showing the varieties of skip impacts and the debris tossed into space."
Locate 36, 10: Print "When you press the space bar to pause the F1-F5 simulations, a new window pops up to show the calculated orbits in the solar system of the comet and Earth particles tossed into space by the impact."
Locate 37, 10: Print "It is a small, random selection of the possible orbits - it would not show anything if all were ploted. The point of this program is to show that NASA's calculated orbits of the fireballs associated with"
Locate 38, 10: Print "comet 109P Swift Tuttle are best explained by a previous impact between Earth and a comet, as shown in example #1. Note that the present orbit of Swift Tuttle can be predicted from the orbit"
Locate 39, 10: Print "that best lines up with an impact in Lake Michigan's location."
Locate 40, 10: Print ""
Locate 41, 10: Print "There are additional simulations with different related purposes:"
Locate 42, 10: Print "Simulatons Ctrl Q and Ctrl W are focused on showing how the debris from a skip impact compares with outgassing by a comet over long periods."
Locate 43, 10: Print "Simulations Ctrl E, R, T, Y are an answer to a challenge: Could a comet skip impact Jupiter (or one of its nmoons) and then continue on to hit Earth. The answer is yes, in several scenes."
Locate 44, 10: Print "Simulations Ctrl S, D, F are 3D simulations designed to see what range of secondary impacts result from a skip impact, and showing that the millions of Carolina Bays do match such secondary impacts."
Locate 45, 10: Print "Ctrl S shows Comet Swift Tuttle hitting Earth and forming Lake Michigan as the main crater, and forming the multitude of secondary craters that would become the Carolina Bays."
Locate 46, 10: Print "Ctrl D and F show Michael Davias' theory of the Saginaw Bay area and another impact west of Lake Michigan causing the secondary Carolina Bay craters. Both events will fit as the source of the Carolina Bays."
Locate 47, 10: Print "Ctrl G shows my theory that Egypt was hit by a comet, causing the Angel of Death passing over the Hebrews, destroying Luxor, and triggering Thera which exploded a week or so later causing a Red Sea tsumani."
Locate 48, 10: Print "The theory of recent comet skip impacts is not a popular theory, but it explains many otherwise unresolvable facts, including the origins of lakes supposedly carved out by glaciers that did not leave any"
Locate 49, 10: Print "end moraine or mountains of excavated dirt south of the lakes, and the mass extinction at the end of the ice age, and the Younger Dryas event."
Locate 50, 10: Print "Ctrl A shows the range of comet impacts possible on a planet, in 3D, with the simulation starting with an array of comets spaced 2 diameters apart, extending for thousands of km up and down, right and left,"
Locate 51, 10: Print "starting at 160,000 km from Earth. The speed ranges from 0 to 80km/s starting speed towards Earth, and the percentages of each range of impact angles is calculated and the shapes of craters shown."
Locate 52, 10: Print "Ctrl L allows you to set any parameters for an impact and see the results.       Ctrl M shows a skip impact that would form a crater matching the shape ofOrcus Patera on Mars."
Locate 53, 10: Print ""
Color _RGB(255, 110, 0)
Locate 54, 10: Print "Press the 'Esc' key to stop the program."
Color _RGB(0, 0, 255)
Locate 55, 80: Print "Press the Space Bar to continue"
Color _RGB(0, 0, 0)
Locate 55, 10: Print ""
Locate 56, 10: Print "This program is written in QB64. QB64 was developed by Rob Galleon and team, and is available for free from the QB64.com web site."
Locate 57, 10: Print "QB64 was chosen for processing speed. It is lacking windows, Menu bars and other niceites of newer software, but it runs about 800X faster than Visual Studio 2019 products."
Locate 58, 10: Print "I expect that Swift Tuttle was much larger when it hit than today, so the simulation's smallest comets are 50 km. Larger sizes are included to see the effects better."
Locate 60, 10: Print "(c) John Burgener 2020 - 2023        For more information: john@burgener.ca         Web pages: www.craters.ca"


_Display

A$ = "": While A$ = "": A$ = InKey$: Wend
If A$ = Chr$(27) Then End


DisplayMenu:

CometFileName$ = "D:/CometImages/Comets" ' Need something to start

Window (-3000, -10000)-(35000, 11375)
Cls
Color _RGB(255, 255, 0), _RGB(50, 50, 90)
Line (-3000, -10000)-(35000, 11375), _RGB(50, 50, 90), BF

Locate 5, 20: Print "                                             Comet Low Angle Impact / Skip Simulations Program"
Color _RGB(255, 255, 255)
Locate 7, 10: Print "Different Simulations may be selected at any time while running other simulations."
Locate 8, 10: Print ""
Locate 9, 10: Print ""
Color _RGB(255, 255, 0)
Locate 10, 10: Print "2 dimensional Skip Impact Simulations focused on debris tossed into space:"
Locate 11, 10: Print ""
Color _RGB(255, 255, 255)
Locate 12, 10: Print "F1: Swift Tuttle        F2: From Above at 45 degrees       F3: From behind, at 10 km/s relative speed     F4: From the Sun, crossing at 40 km/s       F5: Head-On impact at 70 km/s"
Color _RGB(180, 180, 180)
Locate 13, 10: Print "The comet's path is displayed at the start of the simulation. Pressing F7 removes it and speeds up the program. Larger comets require more processing time. Pressing F6 changes the comet size."
Color _RGB(255, 255, 0)
Locate 12, 10: Print "F1:": Locate 12, 34: Print "F2:": Locate 12, 69: Print "F3:": Locate 12, 116: Print "F4:": Locate 12, 160: Print "F5:"
Locate 14, 10: Print ""
Locate 15, 10: Print ""
Locate 16, 10: Print ""
Locate 17, 10: Print "2.5 dimensional Skip Impact Simulations on comparison of Skip Impact and Comet outgassing to create the fireball distribution seen in the Perseid Meteor showers."
Color _RGB(255, 255, 255)
Locate 18, 10: Print "2.5 dimensions since the simulation is largely 2 dimensional, but the planets are in the Ecliptic and Swift Tuttle is not."
Locate 19, 10: Print ""
Locate 20, 10: Print "Ctrl Q: Swift Tuttle impacting Earth and spreading debris into the Solar System in an array of all orbits possible."
Locate 21, 10: Print "Ctrl W: Swift Tuttle only outgassing and not impacting, spreading debris in a wide array, but concentrated along the comet's orbit."
Color _RGB(180, 180, 180)
Locate 22, 10: Print "Ideally these simulations should run for 10,000+ years simulation time, which requires many hours computer time. Faster computes are possible with less points. Press the number keys to change the # of points."
Color _RGB(255, 255, 0)
Locate 20, 10: Print "Ctrl Q:"
Locate 21, 10: Print "Ctrl W:"
Locate 24, 10: Print ""
Locate 25, 10: Print ""
Color _RGB(100, 255, 100)
Locate 26, 10: Print "2 Dimensional simulations of a comet impacting one of Jupiter's moons and then continuing on to hit Earth"
Color _RGB(255, 255, 255)
Locate 27, 10: Print ""
Locate 28, 10: Print "Ctrl E: Impact Jupiter then Earth a year later"
Locate 29, 10: Print "Ctrl R: Impact Jupiter then Earth twice at 1.5 and 1.6 years later"
Locate 30, 10: Print "Ctrl T: Impact Jupiter, near miss Earth, then impact Earth 8.1 years later"
Locate 31, 10: Print "Ctrl U: Impact Earth not Jupiter"
Locate 32, 10: Print "Ctrl Y: Impact Jupiter then Earth 10.2 years later"
Color _RGB(100, 255, 100)
Locate 28, 10: Print "Ctrl E:"
Locate 29, 10: Print "Ctrl R:"
Locate 30, 10: Print "Ctrl T:"
Locate 31, 10: Print "Ctrl U:"
Locate 32, 10: Print "Ctrl Y:"
Locate 33, 10: Print ""
Locate 36, 10: Print "3 Dimensional presentation of possible comet impact angles, speeds and crater shapes of large comets impacting Earth"
Locate 37, 10: Print ""
Color _RGB(255, 255, 255)
Locate 38, 10: Print "Ctrl A: Shows the range of comet impacts possible on a planet, with listings of speeds, angles, and calculations of crater shapes."
Locate 39, 10: Print "Ctrl L: Shows high resolution impacts of various angles and speeds. The focus is of course skips, but you can set the parameters for any angle and speed. (Press 'L' to get menu for settings)."
Color _RGB(100, 255, 100)
Locate 38, 10: Print "Ctrl A:"
Locate 39, 10: Print "Ctrl L:"
Locate 43, 10: Print "3 Dimensional presentations of proposed recent Skip Impacts"
Color _RGB(255, 255, 255)
Locate 44, 10: Print ""
Locate 45, 10: Print "Ctrl S: Comet Swift Tuttle hitting Earth and forming Lake Michigan as the main crater, and forming the multitude of secondary craters that would become the Carolina Bays."
Locate 46, 10: Print "Ctrl D: Saginaw Bay impact providing a potential source of the secondary craters forming the Carolina Bays."
Locate 47, 10: Print "Ctrl F: Saginaw Bay impact and a second crater west of Lake Michigan also providing a potential source of the secondary craters forming the Carolina Bays."
Locate 48, 10: Print "Ctrl G: Egyptian Impact of ~ 1625 BC forming the Qattera Depression and fitting the Exodus event"
Locate 49, 10: Print "Ctrl J: Chesapeake Bay impact"
Locate 50, 10: Print "Ctrl K: Comet Encke - 3D Simulation of Comet Encke's orbit"
Locate 51, 10: Print "Ctrl O: Comet Encke - 3D  Simulation of Comet Encke's orbit - with screen save every 25 years"
Locate 52, 10: Print "Ctrl I: Comet Encke - 3D  Simulation of Comet Encke's orbit with Time and Direction of planets reversed - with screen save every 25 years"
Locate 53, 10: Print "Ctrl M: Mars' Orcus Patera"
Locate 54, 10: Print "Ctrl N: Comets Encke and Swift-Tuttle origins  - would a close approach to Earth move a comet into an Encke or Swift-Tuttel like orbit? (Yes, it can)"
Locate 55, 10: Print "        Note: Ctrl N has 3 simulations, with a different one run after each press of Ctrl N. Also to see the resultant orbits, press the END key to change from near Earth to viewing far away."
Locate 56, 10: Print "Ctrl V: Venus & Comet Encke origins - would a close approach to Venus move a comet into an Encke like orbit? (Yes, it can)"
Locate 57, 10: Print "Ctrl B: Mercury & Comet Encke origins - would a close approach to Mercury move a comet into an Encke like orbit? (No it can not)"

Color _RGB(100, 255, 100)
Locate 45, 10: Print "Ctrl S:"
Locate 46, 10: Print "Ctrl D:"
Locate 47, 10: Print "Ctrl F:"
Locate 48, 10: Print "Ctrl G:"
Locate 49, 10: Print "Ctrl J:"
Locate 50, 10: Print "Ctrl K:"
Locate 51, 10: Print "Ctrl O:"
Locate 52, 10: Print "Ctrl I:"
Locate 53, 10: Print "Ctrl M:"
Locate 54, 10: Print "Ctrl N:"
Locate 56, 10: Print "Ctrl V:"
Locate 57, 10: Print "Ctrl B:"

Locate 59, 10: Print "Ctrl H: Returns back to this Menu"

Color _RGB(255, 255, 255), _RGB(0, 0, 0)


waituntilkeypressed:

_Display

A$ = "": While A$ = "": A$ = InKey$: Wend

Call CheckifChangeScene(A$, RunProgram$)
If RunProgram$ = "StartOverMenu" Then GoTo DisplayMenu
If RunProgram$ = "" Then
    Color _RGB(255, 0, 0)
    Locate 50, 10: Print "Please seelct one of the above options to continue."
    GoTo waituntilkeypressed
End If


Line (-3000, -10000)-(35000, 11375), _RGB(0, 0, 0), BF
Color _RGB(255, 255, 255), _RGB(0, 0, 0)
Cls



StartProgram:

MaxYNumber = 66 ' MaxYNumber = # of y points to be included, more = denser cloud and slower claculations. X = 300 so 66*300 =~ 20,000
HitEarthBefore$ = "No"

' **********************************************    END SETUP OF PLANET FACTORS    ******************************************************


BeginProgram:


Randomize (32)
Cls

'define section of matrix with planet
SunZoomFactor = 1: SpeedUpFactor = 1: SimulationSlowFactor = 1 ' for regular Skips (F1-F5), set these to 1

'define section of matrix with planet
SunRadius = 695700
SunScale = 695700 / SunRadius
SunCenterX = 0: SunCenterY = 0: SunCenterZ = 0
'GSun = 6.67408 * 10 ^ -11 * 1.9891 X 10^30  in meters
'GSun = 6.67408 * 10 ^ -20 * 1.9891 X 10^30  in km
SunMass = 1.9891 * 10 ^ 30 ' mass of Sun in kg
GravityConstant = 6.67408 * 10 ^ -11 ' m3/kg s = 6.67408 * 10^ -2 km3/kg s    NOTE G is in meters NOT km
GSun = GravityConstant * SunMass
GSun2 = 2 * GSun

' acceleration = G M1 M2/R^2

Call InitializePlanets


PlanetRadius = 6371
PlanetCenterX = 5500: PlanetCenterY = -2000: PlanetCenterZ = 0
PlanetMass = 5.972 * 10 ^ 24 ' mass of Earth in kg
GEarth = GravityConstant * PlanetMass
' acceleration = G M1 M2/R^2
'GravityConstant = 6.67408 * 10 ^ -11 ' m3/kg s = 6.67408 * 10^ -2 km3/kg s    NOTE G is in meters NOT km
'GEarth = GravityConstant * PlanetMass

If Scene$ = "Mercury and Encke" Then
    PlanetRadius = 2439.7 ' Radius of Mars
    PlanetMass = 3.3011 * 10 ^ 23 ' mass of Mars in kg
    GravityConstant = 6.67408 * 10 ^ -11 ' m3/kg s = 6.67408 * 10^ -2 km3/kg s    NOTE G is in meters NOT km
    GEarth = GravityConstant * PlanetMass
End If
If Scene$ = "Venus and Encke" Then
    PlanetRadius = 6052 ' Radius of Mars
    PlanetMass = 4.8675 * 10 ^ 24 ' mass of Mars in kg
    GravityConstant = 6.67408 * 10 ^ -11 ' m3/kg s = 6.67408 * 10^ -2 km3/kg s    NOTE G is in meters NOT km
    GEarth = GravityConstant * PlanetMass
End If

If Scene$ = "MARS" Then
    'EarthGM = 400200000000000 ' Earth G * M in m/sec^3
    'EarthRadius = 6371000 'Earth Radius in Meters (6,371 km)
    'EarthRadius = 6371 km
    'Earth Distance from Sun = 149.6 X 10^9 m
    'Earth Mass = 5.972 X 10^24 kg
    'MoonRadius = 1737000 'Moon Radius in Meters (1,737 km)
    'MoondistancefromEarth = 384400000 ' Moon distance from Earth in Meters (384,000 km)

    ' Mars distance from sun = 227,939,200 km
    ' Mars Speed:24.0 km/s
    ' Mars Mass = 6.417 X 10^23
    ' Mars Radius = 3396 km

    PlanetRadius = 3396 ' Radius of Mars
    PlanetCenterX = 5500: PlanetCenterY = -2000
    PlanetMass = 6.417 * 10 ^ 23 ' mass of Mars in kg
    GravityConstant = 6.67408 * 10 ^ -11 ' m3/kg s = 6.67408 * 10^ -2 km3/kg s    NOTE G is in meters NOT km
    GEarth = GravityConstant * PlanetMass
End If



'define comet mass in 300X300 grid
CircularizeCount = 300
CometCenterX = 150: CometCenterY = 150: CometCenterZ = 150 ' NOTE: Comet Center variable is the x,y CoOrdinates of the central variable NOT the location
CometLastCenterX = CometCenterX + 10: CometLastCenterY = CometCenterY + 10: CometLastCenterZ = CometCenterZ + 10
CometLastCenterX2 = CometCenterX + 20: CometLastCenterY2 = CometCenterY + 20: CometLastCenterZ2 = CometCenterZ + 20
CometLastCenterX3 = CometCenterX + 30: CometLastCenterY3 = CometCenterY + 30: CometLastCenterZ3 = CometCenterZ + 30
CometRadius = 100 '200 km diameter = 200 pixels with each pixel at 1000 meters / 1 km

PointCount = Int(MaxYNumber * 300)
EnckeTimeX = 1: EnckeTimeY = 1

ColorofPlanet$ = "Blue"
OutGassing$ = "": OutGasOnOrbit$ = "": OutGasAtStart$ = ""
LinesLatitudeOnOff = 1
SkipimpactatStart$ = "No"
RunImpactProbabilities$ = "No"

CometPAthOnOff = 1: ToggleDrawCometCenterPath = 1
AutoRotate$ = ""

For ii = 0 To 400 ' Clear out any previous numbers in the array
    For jj = 0 To 400
        CometMass(ii, jj) = 0
        CometColor(ii, jj) = _RGB(0, 0, 0)
        CometX(ii, jj) = 0: CometY(ii, jj) = 0: CometZ(ii, jj) = 0
        CometSpeedX(ii, jj) = 0: CometSpeedY(ii, jj) = 0: CometSpeedZ(ii, jj) = 0
        CometSize(ii, jj) = 0
    Next jj
Next ii
SwiftView$ = "Left"


For ii = 1 To 1100 ' Clear Planet Earth and Planet Mars outlines
    WorldX(ii) = 0: WorldY(ii) = 0: WorldZ(ii) = 0
Next ii



Select Case Scene$
    Case "Comet 1991 L3 Levy from 19 degree inclination at 11 km/s relative speed"
        'working system for impacter from comet catching up behind earth
        CometInitialSpeedX = 10.5 ' km/sec
        CometInitialSpeedY = -3.4 ' km/sec
        '        CometStartX = -1850: CometStartY = 5500
        'comet 1991 L3 Levy:CometInitialSpeedX = 10.5 ' km/sec:CometInitialSpeedY = -3.4 ' km/sec
        CometStartX = -2500: CometStartY = 8500
        If ToggleRadius = 0 Then CometRadius = 50 Else CometRadius = ToggleRadius 'Comet diameter = 2 X CometRadius, with 1 pixel = 1 km size
        ZoomWindow1 = -3000: ZoomWindow2 = -10000: ZoomWindow3 = 35000: ZoomWindow4 = 11375
        ZoomTime1 = 300: ZoomTime2 = 800: ZoomTime3 = 1450: ZoomTime4 = 2000: ZoomTime5 = 5000
        TiltofEarth = 0
        CircularizingOnOff$ = "No"
        AutoRotate$ = "Off"
    Case "Overtaking Earth from behind at 10 km/s"
        'working system for impacter from comet catching up behind earth
        CometInitialSpeedX = 10 ' km/sec
        CometInitialSpeedY = 0 ' km/sec
        CometStartX = -1850: CometStartY = 5500
        If ToggleRadius = 0 Then CometRadius = 50 Else CometRadius = ToggleRadius 'Comet diameter = 2 X CometRadius, with 1 pixel = 1 km size
        ZoomWindow1 = -3000: ZoomWindow2 = -10000: ZoomWindow3 = 35000: ZoomWindow4 = 11375
        ZoomTime1 = 300: ZoomTime2 = 800: ZoomTime3 = 1450: ZoomTime4 = 2000: ZoomTime5 = 5000
        TiltofEarth = 17
        CircularizingOnOff$ = "Yes"
        AutoRotate$ = "Off"
    Case "From Above at 45 degrees - Relative Speed 40 km/s"
        'working system for impacter from comet from above at 45 degrees
        CometInitialSpeedX = 25.5 ' km/sec
        CometInitialSpeedY = -25 ' km/sec
        CometStartX = 4000: CometStartY = 8000
        If ToggleRadius = 0 Then CometRadius = 100 Else CometRadius = ToggleRadius 'Comet diameter = 2 X CometRadius, with 1 pixel = 1 km size
        ZoomWindow1 = -3000: ZoomWindow2 = -12000: ZoomWindow3 = 35000: ZoomWindow4 = 9375
        ZoomTime1 = 50: ZoomTime2 = 400: ZoomTime3 = 550: ZoomTime4 = 750: ZoomTime5 = 3000
        TiltofEarth = -3
        CircularizingOnOff$ = "Yes"
        AutoRotate$ = "Off"
    Case "Swift Tuttle from above at 66.55 degrees after impact - Relative Speed 42 km/s" ' starting at 60, changing to 66 as it goes past earth
        'working system for impacter from comet from above at 66 degrees = Swift Tuttle which passes at 42 km/sec and is doing 40.2 y, 12.3 x
        CometInitialSpeedX = 18.95 ' km/sec
        CometInitialSpeedY = -36.7 ' km/sec
        '        CometInitialSpeedX = 30 ' km/sec  'start for 70 km/sec initial speed
        '       CometInitialSpeedY = -65 ' km/sec  'start for 70 km/sec initial speed
        CometStartX = 6165: CometStartY = 10000: ' CometStartX = 6590 'start for 70 km/sec initial speed
        If ToggleRadius = 0 Then CometRadius = 50 Else CometRadius = ToggleRadius 'Comet diameter = 2 X CometRadius, with 1 pixel = 1 km size
        ZoomWindow1 = -3000: ZoomWindow2 = -12000: ZoomWindow3 = 35000: ZoomWindow4 = 9375
        ZoomTime1 = 1: ZoomTime2 = 200: ZoomTime3 = 300: ZoomTime4 = 850: ZoomTime5 = 3000
        TiltofEarth = -23.4
        CircularizingOnOff$ = "Yes"
        AutoRotate$ = "Off"
    Case "Crossing from Sun 100km comet - Relative Speed 40 km/s"
        'working system for impacter from comet moving out from sun crossing Earth's orbit
        CometInitialSpeedX = 40 ' km/sec
        CometInitialSpeedY = -3 ' km/sec
        CometStartX = -10500: CometStartY = 5440
        If ToggleRadius = 0 Then CometRadius = 50 Else CometRadius = ToggleRadius 'Comet diameter = 2 X CometRadius, with 1 pixel = 1 km size
        ZoomWindow1 = -4000: ZoomWindow2 = -8000: ZoomWindow3 = 28000: ZoomWindow4 = 10000
        ZoomTime1 = 1: ZoomTime2 = 300: ZoomTime3 = 500: ZoomTime4 = 850: ZoomTime5 = 3000
        TiltofEarth = 23.4
        CircularizingOnOff$ = "Yes"
        AutoRotate$ = "Off"
    Case "Head On Impact as if Halley's comet hit - Relative Speed 70 km/s"
        'working system for impacter from comet moving out from sun crossing Earth's orbit
        CometInitialSpeedX = -70 ' km/sec
        CometInitialSpeedY = 5 ' km/sec
        CometStartX = 22000: CometStartY = 2950
        If ToggleRadius = 0 Then CometRadius = 40 Else CometRadius = ToggleRadius 'Comet diameter = 2 X CometRadius, with 1 pixel = 1 km size
        ZoomWindow1 = -10000: ZoomWindow2 = -4000: ZoomWindow3 = 22000: ZoomWindow4 = 14000
        ZoomTime1 = 1: ZoomTime2 = 155: ZoomTime3 = 270: ZoomTime4 = 650: ZoomTime5 = 3000
        TiltofEarth = 23.4
        CircularizingOnOff$ = "Yes"
        AutoRotate$ = "Off"
    Case "Encke"
        'Encke goes out to 4.11 au, with 1 au = 1,496,000 km. So need to setup a run with the path extending out 6148560 km.
        'Encke max speed ~ 69.9 km/s, min speed 0.80 km/s, offset from ecliptic 11.76 degrees so start y = 69.9 cos 11.76 = 68.43, startz = 69.9 sin 11.76 = 14.246
        ' diameter of sun = 1.4 million km
        'Closest approach of Encke is .3302 AU (1,496,000 km), just inside Mecury's orbit = 49.398 million km

        '        JupiterCenterX = 778000000: JupiterCenterY = 0: JupiterCenterZ = 0
        '        JupiterSpeedX = 0: JupiterSpeedY = 0: JupiterSpeedZ = -13071

        '        JupiterCenterX = -778000000: JupiterCenterY = 0: JupiterCenterZ = 0
        '        JupiterSpeedX = 0: JupiterSpeedY = 13071: JupiterSpeedZ = 0

        PlanetCenterX = 0: PlanetCenterY = 0: PlanetCenterZ = 0
        PlanetMass = 1.9891 * 10 ^ 30 ' mass of Sun in kg *1000
        GEarth = GravityConstant * PlanetMass
        GSun = GEarth
        MercuryGravity$ = "On": VenusGravity$ = "On"
        OutGassing$ = "Yes": OutGasOnOrbit$ = "Yes": OutGasAtStart$ = "No": SkipimpactatStart$ = "No": ZoomedtoComet$ = "No"
        'working system for comet in fast orbit dissasociating from gravity
        '        CometInitialSpeedX = -0 ' km/sec

        CometInitialSpeedX = 0 ' km/sec
        CometInitialSpeedY = -69190 ' m/sec
        CometInitialSpeedZ = -15770 ' m/sec
        If RunReverse$ = "Yes" Then
            CometInitialSpeedY = 69190 ' m/sec
            CometInitialSpeedZ = 15770 ' m/sec
        End If

        CometStartX = -50859000: CometStartY = 0: CometStartZ = 0
        CometStartX = -50851000: CometStartY = 0: CometStartZ = 0
        ' 50,800,000 km = Encke closest approach to sun
        'Encke goes out to 4.11 au, with 1 au = 1,496,000 km. So need to setup a run with the path extending out 6,148,560 km.


        If ToggleRadius = 0 Then CometRadius = 10 Else CometRadius = ToggleRadius 'Comet diameter = 2 X CometRadius, with 1 pixel = 1 km size
        ZoomWindow1 = -405000000: ZoomWindow2 = -364500000: ZoomWindow3 = 891000000: ZoomWindow4 = 364500000
        ZoomTime1 = 1: ZoomTime2 = 300: ZoomTime3 = 500: ZoomTime4 = 850: ZoomTime5 = 3000
        TiltofEarth = 23.4: AutoZoomOnOff = 0
        LinesLatitudeOnOff = 0
        PlanetRadius = 1400000
        PlanetRadius = PlanetRadius * 25 ' Sun = 1.4 million km but need to be larger to see
        ColorofPlanet$ = "Yellow"
        SunZoomFactor = 182900000
        SpeedUpFactor = 175
        SimulationSlowFactor = 40 ' larger = slower = more calculations per orbit. At 40 it takes days to do 200 years. At 5 it takes hours. But flattens the orbit.
        SimulationSlowFactor = 5 ' At a 5 factor, the simulation flattens the orbit so that the planets interact a LOT with encke. Each calculation / time count of this simulation = 2 hours
        SpeedUpFactor = SpeedUpFactor / SimulationSlowFactor '  ################################ lower speed to match Swift Tuttle  ############################################################
        SunZoomFactor = SunZoomFactor / SimulationSlowFactor

        CometPAthOnOff = 0
        ToggleDrawCometCenterPath = 0
        EnckeStartTime = 1
        SwiftView$ = "Top": EnckeGravity$ = "On": ShowEnckeOrbits$ = "On"
        ViewAngle = 90



    Case "SwiftTuttle Impact at Start", "SwiftTuttle Orbit, outgassing along the orbit"

        'Swift Tuttle goes out to 26 au, with 1 au = 150 million km. So need to setup a run with the path extending out 4,000 MILLION km.
        ' Swift Tuttle max speed 42.6 km/s, min speed 0.80 km/s
        ' diameter of sun = 1.4 million km
        'Closest approach of swift tuttle is about 1 au = 150 million km

        PlanetCenterX = 0: PlanetCenterY = 0: PlanetCenterZ = 0
        PlanetMass = 1.9891 * 10 ^ 30 ' mass of Sun in kg *1000
        GEarth = GravityConstant * PlanetMass
        GSun = GEarth

        OutGassing$ = "Yes": OutGasOnOrbit$ = "Yes": OutGasAtStart$ = "No": SkipimpactatStart$ = "No": ZoomedtoComet$ = "No"
        'working system for comet in fast orbit dissasociating from gravity
        CometInitialSpeedX = -7740 ' km/sec
        '        CometInitialSpeedY = 42600 ' m/sec                        ' produces Swift Tuttle orbit of 133 years
        '        CometStartX = -150000000: CometStartY = 0
        '        CometInitialSpeedY = 42660 ' m/sec   ' Range from 39660 to 42860 fits orbits in 0.1 - 2 X 133 year orbits if X = 0  at start - above 43000 it leaves sun orbit range
        CometInitialSpeedY = -500 ' m/sec   ' Range from 39660 to 42860 fits orbits in 0.1 - 2 X 133 year orbits if X = 0  at start - above 43000 it leaves sun orbit range
        CometInitialSpeedZ = -42138.5 ' m/sec   ' Range from 39660 to 42860 fits orbits in 0.1 - 2 X 133 year orbits if X = 0  at start - above 43000 it leaves sun orbit range
        '        CometStartX = -149000000: CometStartY = 1000: CometStartZ = 1000
        CometStartX = -149000000: CometStartY = 0: CometStartZ = 0

        If ToggleRadius = 0 Then CometRadius = 50 Else CometRadius = ToggleRadius 'Comet diameter = 2 X CometRadius, with 1 pixel = 1 km size
        ZoomWindow1 = -900000000: ZoomWindow2 = -1940000000: ZoomWindow3 = 9000000000: ZoomWindow4 = 3640000000
        ZoomTime1 = 1: ZoomTime2 = 300: ZoomTime3 = 500: ZoomTime4 = 850: ZoomTime5 = 3000
        TiltofEarth = 23.4: AutoZoomOnOff = 0
        LinesLatitudeOnOff = 0
        PlanetRadius = 1400000
        PlanetRadius = PlanetRadius * 30 ' Sun = 1.4 million km but need to be larger to see
        ColorofPlanet$ = "Yellow"
        SunZoomFactor = 182900000
        SpeedUpFactor = 175
        SimulationSlowFactor = 4
        SimulationSlowFactor = 1
        SpeedUpFactor = SpeedUpFactor / SimulationSlowFactor '  ################################ lower speed to match Swift Tuttle  ############################################################
        SunZoomFactor = SunZoomFactor / SimulationSlowFactor

        If Scene$ = "SwiftTuttle Impact at Start" Then SkipimpactatStart$ = "Yes"

        CometPAthOnOff = 0
        ToggleDrawCometCenterPath = 0

        SwiftView$ = "Back"
        ViewAngle = 90

    Case "Impact Jupiter then Earth a year later", "Impact Jupiter then Earth twice at 1.5 and 1.6 years later", "Impact Jupiter, near miss Earth, then impact Earth 8.1 years later", "Impact Jupiter then Earth 10.2 years later"


        OutGassing$ = "No": OutGasOnOrbit$ = "No": OutGasAtStart$ = "No"
        AutoRotate$ = "Off"
        SunCenterX = 0: SunCenterY = 0: SunCenterZ = 0
        SunMass = 1.9891 * 10 ^ 30 ' mass of Sun in kg *1000
        GSun = GravityConstant * SunMass


        'working system for comet in fast orbit dissasociating from gravity
        ' Swift Tuttle start
        CometInitialSpeedX = 0 ' m/sec
        CometInitialSpeedY = 42600 ' m/sec
        CometInitialSpeedZ = 0 ' m/sec
        CometStartX = -150000000: CometStartY = 0: CometStartZ = 0

        MaxYNumber = 200 ' MaxYNumber = # of y points to be included, more = denser cloud and slower claculations

        Select Case Scene$
            Case "Impact Jupiter, near miss Earth, then impact Earth 8.1 years later"
                '        skip impact on jupiter and impact on Earth
                CometStartX = -779570400: CometStartY = 0
                CometInitialSpeedX = 222.9 ' m/sec
                CometInitialSpeedY = -1800 ' m/sec
                CometPAthOnOff = 1: ToggleDrawCometCenterPath = 1
            Case "Impact Jupiter then Earth 10.2 years later"
                CometStartX = -799000000: CometStartY = 15430000
                CometInitialSpeedX = 12000 ' m/sec
                CometInitialSpeedY = 8000 ' m/sec
                CometPAthOnOff = 1: ToggleDrawCometCenterPath = 1
            Case "Impact Jupiter then Earth a year later"
                ' Start far from Jupiter and hit  Jupiter then earth
                CometStartX = -1000000000: CometStartY = 250000000
                CometInitialSpeedX = 12050 ' m/sec
                CometInitialSpeedY = 0 ' m/sec
            Case "Impact Jupiter then Earth twice at 1.5 and 1.6 years later" ' NOTE AT 84 years, the comet hits Jupiter again and hits Earth again. Then zooms out of the solar system.
                CometStartX = -820750000: CometStartY = 40000000
                CometInitialSpeedX = 13468 ' m/sec       ' works for distance from earth for impact at 65 X radius.
                CometInitialSpeedY = 1500 ' m/sec
        End Select

        If ToggleRadius = 0 Then CometRadius = 50 Else CometRadius = ToggleRadius 'Comet diameter = 2 X CometRadius, with 1 pixel = 1 km size
        ZoomWindowJ1 = -960: ZoomWindowJ2 = -540: ZoomWindowJ3 = 960: ZoomWindowJ4 = 540: ' window should be 1920 / 1080 ratio  Window(x1,y1,X2,y2)
        FactorJ = 1500000
        ZoomWindow1 = ZoomWindowJ1 * FactorJ: ZoomWindow2 = ZoomWindowJ2 * FactorJ: ZoomWindow3 = ZoomWindowJ3 * FactorJ: ZoomWindow4 = ZoomWindowJ4 * FactorJ

        ZoomTime1 = 1: ZoomTime2 = 300: ZoomTime3 = 500: ZoomTime4 = 850: ZoomTime5 = 3000
        TiltofEarth = 23.4: AutoZoomOnOff = 0
        LinesLatitudeOnOff = 0
        DrawSunRadius = 1400000
        DrawSunRadius = DrawSunRadius * 10 ' Sun = 1.4 million km but need to be larger to see
        ColorofPlanet$ = "Yellow"
        SunZoomFactor = 182900000
        SpeedUpFactor = 175
        '               ****************************@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*********************************

        SunZoomFactor = SunZoomFactor / 5 ' 5 times slower, 5 times more calculations
        SpeedUpFactor = SpeedUpFactor / 5
        HitEarth$ = "No"
        HitJupiter$ = "No"
        HitEarthBefore$ = "No"

    Case "Impact Earth not Jupiter"
        OutGassing$ = "No": OutGasOnOrbit$ = "No": OutGasAtStart$ = "No"
        AutoRotate$ = "Off"
        SunCenterX = 0: SunCenterY = 0: SunCenterZ = 0
        SunMass = 1.9891 * 10 ^ 30 ' mass of Sun in kg
        GravityConstant = 6.67408 * 10 ^ -11 ' m3/kg s = 6.67408 * 10^ -2 km3/kg s    NOTE G is in meters NOT km
        GSun = GravityConstant * SunMass '  NOTE This is in Meters not Km


        'working system for comet in fast orbit dissasociating from gravity
        ' Swift Tuttle start
        CometInitialSpeedX = 0 ' m/sec
        CometInitialSpeedY = 42600 ' m/sec
        CometInitialSpeedZ = 0 ' m/sec
        CometStartX = -150000000: CometStartY = 0: CometStartZ = 0 ' Note distances in Km - KiloMeters - NOT meters

        MaxYNumber = 200 ' MaxYNumber = # of y points to be included, more = denser cloud and slower claculations

        '   *******************   Comet gets to 1.2 earth radius but does not change orbit - poasses at too high a speed     *************************
        '                CometStartX = -822009000: CometStartY = 135001000
        '                CometInitialSpeedX = 16719 ' m/sec       ' works for distance from earth for impact at 65 X radius.
        '                CometInitialSpeedY = 1500 ' m/sec
        '                If Scene$ = "Impact Earth not Jupiter" Then
        '                    SunZoomFactor = SunZoomFactor / 6
        '                    SpeedUpFactor = SpeedUpFactor / 6
        '                End If
        '                CometStartX = 820000000: CometStartY = 200000000 ' hits earth but does not change orbit
        '                CometInitialSpeedX = -16100 ' m/sec
        '                CometInitialSpeedY = 2099 ' m/sec
        '                If Scene$ = "Impact Earth not Jupiter" Then
        '                    SunZoomFactor = SunZoomFactor / 6
        '                    SpeedUpFactor = SpeedUpFactor / 6
        '                End If
        CometStartX = 820000000: CometStartY = 330000000 ' Note distances in Km - KiloMeters - NOT meters
        CometInitialSpeedX = -23034.1 ' m/sec NOT Km/sec
        CometInitialSpeedY = -1700 ' m/sec

        HitEarth$ = "No"
        HitJupiter$ = "No"
        HitEarthBefore$ = ""

        If ToggleRadius = 0 Then CometRadius = 50 Else CometRadius = ToggleRadius 'Comet diameter = 2 X CometRadius, with 1 pixel = 1 km size
        ZoomWindowJ1 = -960: ZoomWindowJ2 = -540: ZoomWindowJ3 = 960: ZoomWindowJ4 = 540: ' window should be 1920 / 1080 ratio  Window(x1,y1,X2,y2)
        FactorJ = 1500000
        ZoomWindow1 = ZoomWindowJ1 * FactorJ: ZoomWindow2 = ZoomWindowJ2 * FactorJ: ZoomWindow3 = ZoomWindowJ3 * FactorJ: ZoomWindow4 = ZoomWindowJ4 * FactorJ

        DrawSunRadius = 1400000
        DrawSunRadius = DrawSunRadius * 10 ' Sun = 1.4 million km but need to be larger to see
        ColorofPlanet$ = "Yellow"

        SunZoomFactor = 182900000
        '        SunZoomFactor = 1
        SpeedUpFactor = 175

        SunZoomFactor = SunZoomFactor / 5 ' 5 times slower, 5 times more calculations
        SpeedUpFactor = SpeedUpFactor / 5

    Case "Demonstration of impact probabilities"
        'lots of comets hitting from a distance at variable speeds
        '        CometInitialSpeedX = -2.850232 ' km/sec ' at 2.850232 lowest impact is at 75.2 / 14.8 degrees tangent IF cometStartY = PlanetcenterY-250 + 25250
        CometPAthOnOff = 0: ToggleDrawCometCenterPath = 0
        CometInitialSpeedX = -2 ' km/sec
        CometInitialSpeedY = 0 ' km/sec
        CometInitialSpeedZ = 0
        ToggleRadius = 0: CometRadius = 30
        CometStartX = 100000
        CometStartY = PlanetCenterY - 250 + 25250 ' 1000 of 50 km diameter comets is sufficient for this demo
        ZoomWindow1 = -52500: ZoomWindow2 = -60000: ZoomWindow3 = 179340: ZoomWindow4 = 64740
        ZoomTime1 = 0: ZoomTime2 = 0: ZoomTime3 = 0: ZoomTime4 = 0: ZoomTime5 = 0
        TiltofEarth = 0: AutoZoomOnOff = 0
        CircularizingOnOff$ = "No"
        LinesLatitudeOnOff = 0
        CometFileName$ = "D:/CometImages/" '

    Case "Mercury and Encke"
        CometFileName$ = "D:/CometImages/Mercury" '
        AutoRotate$ = "Off"
        SwiftView$ = "Left"

    Case "Venus and Encke"
        CometFileName$ = "D:/CometImages/Venus" '
        AutoRotate$ = "Off"
        SwiftView$ = "Left"

    Case "Earth and Encke Nov", "Earth and Encke July", "Earth and ST"
        CometFileName$ = "D:/CometImages/Earth" '
        CometPAthOnOff = 0: ToggleDrawCometCenterPath = 0
        TiltofEarth = 0: AutoZoomOnOff = 0
        CircularizingOnOff$ = "No"
        LinesLatitudeOnOff = 0
        AutoRotate$ = "Off"
        SwiftView$ = "Left"

    Case "Encke and Swift-Tuttle Origins"
        'lots of comets hitting from a distance at variable speeds
        '        CometInitialSpeedX = -2.850232 ' km/sec ' at 2.850232 lowest impact is at 75.2 / 14.8 degrees tangent IF cometStartY = PlanetcenterY-250 + 25250
        CometPAthOnOff = 0: ToggleDrawCometCenterPath = 0
        CometInitialSpeedX = -40 ' km/sec
        CometInitialSpeedY = 0 ' km/sec
        CometInitialSpeedZ = 0
        If ToggleRadius = 0 Then CometRadius = 25 Else CometRadius = ToggleRadius 'Comet diameter = 2 X CometRadius, with 1 pixel = 1 km size
        CometStartX = 100000
        CometStartY = PlanetCenterY - 250 + 25250 ' 1000 of 50 km diameter comets is sufficient for this demo
        ZoomWindow1 = -52500: ZoomWindow2 = -60000: ZoomWindow3 = 179340: ZoomWindow4 = 64740
        ZoomTime1 = 0: ZoomTime2 = 0: ZoomTime3 = 0: ZoomTime4 = 0: ZoomTime5 = 0
        TiltofEarth = 0: AutoZoomOnOff = 0
        CircularizingOnOff$ = "No"
        LinesLatitudeOnOff = 0
        CometFileName$ = "D:/CometImages/Origins" '
        AutoRotate$ = "Off"
        SwiftView$ = "Left"

    Case "Carolina Bays", "Egypt", "MARS"
        'lots of comets hitting from a distance at variable speeds
        '        CometInitialSpeedX = -2.850232 ' km/sec ' at 2.850232 lowest impact is at 75.2 / 14.8 degrees tangent IF cometStartY = PlanetcenterY-250 + 25250
        CometPAthOnOff = 0: ToggleDrawCometCenterPath = 0
        CometInitialSpeedX = -40 ' km/sec
        CometInitialSpeedY = 0 ' km/sec
        CometInitialSpeedZ = 0
        If ToggleRadius = 0 Then CometRadius = 25 Else CometRadius = ToggleRadius 'Comet diameter = 2 X CometRadius, with 1 pixel = 1 km size
        CometStartX = 100000
        CometStartY = PlanetCenterY - 250 + 25250 ' 1000 of 50 km diameter comets is sufficient for this demo
        ZoomWindow1 = -52500: ZoomWindow2 = -60000: ZoomWindow3 = 179340: ZoomWindow4 = 64740
        ZoomTime1 = 0: ZoomTime2 = 0: ZoomTime3 = 0: ZoomTime4 = 0: ZoomTime5 = 0
        TiltofEarth = 0: AutoZoomOnOff = 0
        CircularizingOnOff$ = "No"
        LinesLatitudeOnOff = 0
        CometFileName$ = "D:/CometImages/" '
        If Scene$ = "MARS" Then CometFileName$ = "D:/CometImages/Mars" '
        If Scene$ = "Egypt" Then EarthRotation$ = "No": CometFileName$ = "D:/CometImages/Egypt" '
        AutoRotate$ = "Off"
        SwiftView$ = "Left"

    Case "Saginaw 1", "Saginaw 2"
        CometPAthOnOff = 0: ToggleDrawCometCenterPath = 0
        CometInitialSpeedX = -40 ' km/sec
        CometInitialSpeedY = 0 ' km/sec
        CometInitialSpeedZ = 0
        If ToggleRadius = 0 Then CometRadius = 25 Else CometRadius = ToggleRadius 'Comet diameter = 2 X CometRadius, with 1 pixel = 1 km size
        CometStartX = 100000
        CometStartY = PlanetCenterY - 250 + 25250 ' 1000 of 50 km diameter comets is sufficient for this demo
        ZoomWindow1 = -52500: ZoomWindow2 = -60000: ZoomWindow3 = 179340: ZoomWindow4 = 64740
        ZoomTime1 = 0: ZoomTime2 = 0: ZoomTime3 = 0: ZoomTime4 = 0: ZoomTime5 = 0
        TiltofEarth = 0: AutoZoomOnOff = 0
        CircularizingOnOff$ = "No"
        LinesLatitudeOnOff = 0
        CometFileName$ = "D:/CometImages/" '
        AutoRotate$ = "Off"
        SwiftView$ = "Left"

    Case "ChesapeakeBay"
        CometPAthOnOff = 0: ToggleDrawCometCenterPath = 0
        CometInitialSpeedX = -40 ' km/sec
        CometInitialSpeedY = 0 ' km/sec
        CometInitialSpeedZ = 0
        If ToggleRadius = 0 Then CometRadius = 1 Else CometRadius = ToggleRadius 'Comet diameter = 2 X CometRadius, with 1 pixel = 1 km size
        CometStartX = 100000
        CometStartY = PlanetCenterY - 250 + 25250
        ZoomWindow1 = -52500: ZoomWindow2 = -60000: ZoomWindow3 = 179340: ZoomWindow4 = 64740
        ZoomTime1 = 0: ZoomTime2 = 0: ZoomTime3 = 0: ZoomTime4 = 0: ZoomTime5 = 0
        TiltofEarth = 0: AutoZoomOnOff = 0
        CircularizingOnOff$ = "No"
        LinesLatitudeOnOff = 0
        CometFileName$ = "D:/CometImages/" '
        AutoRotate$ = "Off"
        SwiftView$ = "Left"

    Case "Demo Shapes"
        'lots of comets hitting from a distance at variable speeds
        '        CometInitialSpeedX = -2.850232 ' km/sec ' at 2.850232 lowest impact is at 75.2 / 14.8 degrees tangent IF cometStartY = PlanetcenterY-250 + 25250
        CometPAthOnOff = 0: ToggleDrawCometCenterPath = 0
        CometInitialSpeedX = -2 ' km/sec
        CometInitialSpeedY = 0 ' km/sec
        CometInitialSpeedZ = 0
        ToggleRadius = 0: CometRadius = 30
        CometStartX = 100000
        CometStartY = PlanetCenterY - 250 + 25250 ' 1000 of 50 km diameter comets is sufficient for this demo
        ZoomWindow1 = -52500: ZoomWindow2 = -60000: ZoomWindow3 = 179340: ZoomWindow4 = 64740
        ZoomTime1 = 0: ZoomTime2 = 0: ZoomTime3 = 0: ZoomTime4 = 0: ZoomTime5 = 0
        TiltofEarth = 0: AutoZoomOnOff = 0
        CircularizingOnOff$ = "No"
        CometFileName$ = "D:/CometImages/" '
End Select



If Scene$ = "Demo Shapes" Then
    Call DemoShapes
    If Scene$ = "Menu" Then GoTo DisplayMenu
    GoTo BeginProgram
End If

If Scene$ = "Demonstration of impact probabilities" Then
    Call ImpactProbabilities
    If Scene$ = "Menu" Then GoTo DisplayMenu
    GoTo BeginProgram
End If


If Scene$ = "Carolina Bays" Or Scene$ = "Egypt" Or Scene$ = "MARS" Or Scene$ = "Saginaw 1" Or Scene$ = "Saginaw 2" Or Scene$ = "Encke and Swift-Tuttle Origins" Or Scene$ = "Earth and Encke Nov" Or Scene$ = "Earth and Encke July" Or Scene$ = "Earth and ST" Or Scene$ = "Venus and Encke" Or Scene$ = "Mercury and Encke" Then
    Call CarolinaBaysDemo
    If Scene$ = "Menu" Then GoTo DisplayMenu
    GoTo BeginProgram
End If

If Scene$ = "ChesapeakeBay" Then
    Call ChesapeakeBay
    If Scene$ = "Menu" Then GoTo DisplayMenu
    GoTo BeginProgram
End If



' Set comet shape as pixels of a listed Radius
CometRadiusFinal = CometRadius
If InStr(Scene$, "Sun out") > 0 Or InStr(Scene$, "Jupiter") > 0 Or Scene$ = "SwiftTuttle Impact at Start" Then CometRadiusFinal = CometRadiusFinal / 2 ' shrink comet radius for outgassing at start for Sun simulations

For x = 1 To 400
    For y = 1 To 400
        w = (x - CometCenterX) ^ 2 + (y - CometCenterY) ^ 2
        w = Sqr(w)
        CometX(x, y) = x
        CometY(x, y) = y
        If w <= CometRadiusFinal Then
            CometColor(x, y) = _RGB(255, x / 6, y / 3)
            CometSpeedX(x, y) = CometInitialSpeedX
            CometSpeedY(x, y) = CometInitialSpeedY
            CometSpeedZ(x, y) = CometInitialSpeedZ
            CometMass(x, y) = 1 ' mass of 1 = traveling in space, Mass of 2 = hit earth
            CometX(x, y) = x + CometCenterX
            CometY(x, y) = y + CometCenterY
            CometZ(x, y) = Rnd(CometRadiusFinal) * w
            PreviousCometX2(x, y) = 150000000 ' start at Earth's distance from sun for Ctrl Q scene
            PreviousCometY2(x, y) = 0 ' use prev Y as a marked of direction away from sun or towards. 0 = away, 1 = towards
            PreviousCometZ2(x, y) = 0 ' use prev Z as a marked of direction away from sun or towards. 0 = away, 1 = towards
        Else
            CometColor(x, y) = _RGB(0, 0, 0)
            CometSpeedX(x, y) = CometInitialSpeedX
            CometSpeedY(x, y) = CometInitialSpeedY
            CometSpeedZ(x, y) = CometInitialSpeedZ
            CometMass(x, y) = 0 ' clear old comet info if re-starting from key press
        End If
    Next y
Next x


'Shift comet center to where we want it on grid 15,000 X 7,500 1 km spacings
'start simulation with comet center at:
For x = 1 To 400
    For y = 1 To 400
        CometX(x, y) = CometX(x, y) + CometStartX
        CometY(x, y) = CometY(x, y) + CometStartY
        CometZ(x, y) = CometZ(x, y) + CometStartZ
    Next y
Next x



CometItSelfCenterX = CometX(CometCenterX, CometCenterY)
CometItSelfCenterY = CometY(CometCenterX, CometCenterY)
CometItSelfCenterZ = CometZ(CometCenterZ, CometCenterZ)
CometItSelfCenterSpeedX = CometSpeedX(CometCenterX, CometCenterY)
CometItSelfCenterSpeedY = CometSpeedY(CometCenterX, CometCenterY)
CometItSelfCenterSpeedZ = CometSpeedZ(CometCenterX, CometCenterY)



If CometItSelfCenterSpeedX > 0 Then StartCircularizingX = 1500 / CometItSelfCenterSpeedX Else StartCircularizingX = 1500
If Abs(CometItSelfCenterSpeedY) > 0 Then StartCircularizingY = 1500 / CometItSelfCenterSpeedY Else StartCircularizingY = 1500
If StartCircularizingX > StartCircularizingY Then StartCircularizing = StartCircularizingX Else StartCircularizing = StartCircularizingY
If StartCircularizing < 300 Then StartCircularizing = 300


' add outgassing to comet - give every particule some random velocity away from center     $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
If OutGassing$ = "Yes" And OutGasAtStart$ = "Yes" Then '  NOTE: This is never true in present program. Useful for test cases sometimes.
    For x = 1 To 400
        For y = 1 To 400
            If CometMass(x, y) > 0 Then
                If x <> 150 Or y <> 150 Then ' no random speed to center point
                    '                    CometSpeedX(x, y) = CometSpeedX(x, y) + 14500 * (RND(32) - .5) * RND(33) ' add up to 14500 m/sec = which X 2^.5 = total from X and Y, = ~ 20000 m/sec. Most are slower.
                    '                    CometSpeedY(x, y) = CometSpeedY(x, y) + 14500 * (RND(32) - .5) * RND(33)
                    ARandom = Rnd(32) - .5
                    '                    ARandom = ARandom * 2 'random - .5 = range from -.5 to +.5, need -1 to +1
                    CometSpeedX(x, y) = CometSpeedX(x, y) + 145 * ARandom
                    '                    CometSpeedX(x, y) = CometSpeedX(x, y) * RND(33) + 20000 * ARandom ' add up to 14500 m/sec = which X 2^.5 = total from X and Y, = ~ 20000 m/sec. Most are slower.
                    ARandom = Rnd(32) - .5
                    '                   ARandom = ARandom * 2 'random - .5 = range from -.5 to +.5, need -1 to +1
                    CometSpeedY(x, y) = CometSpeedY(x, y) + 145 * ARandom
                    'CometSpeedY(x, y) = CometSpeedY(x, y) * RND(33) + 20000 * ARandom
                    CometMass(x, y) = 1.2
                    CometColor(x, y) = _RGB(255, 0, 255)
                End If
            End If
        Next y
    Next x
End If



' for ONLY outgassing - give every particule Zero mass or motion - have NO regular particules, just the outgassing
If OutGassing$ = "Yes" And OutGasOnOrbit$ = "Yes" And OutGasAtStart$ = "No" Then
    For x = 1 To 400
        For y = 1 To 400
            CometMass(x, y) = 0
        Next y
    Next x
    CometMass(150, 150) = 1
End If




'Assign points to earth
For i = 1 To 7000
    For j = 1 To 7
        EarthX(i, j) = PlanetCenterX + i
        jDist = (PlanetRadius - j + 1) ^ 2 - (PlanetCenterX - EarthX(i, j)) ^ 2
        If jDist < 0 Then jDist = 0
        jDist = Sqr(jDist)
        EarthY(i, j) = PlanetCenterY + jDist
        If j = 1 Then EarthColor(i, j) = _RGB(255, 255, 255)
        If j = 2 Then EarthColor(i, j) = _RGB(250, 255, 255)
        If j = 3 Then EarthColor(i, j) = _RGB(250, 255, 255)
        If j = 4 Then EarthColor(i, j) = _RGB(200, 200, 155)
        If j = 5 Then EarthColor(i, j) = _RGB(200, 200, 50)
        If j = 6 Then EarthColor(i, j) = _RGB(200, 150, 50)
        If j = 7 Then EarthColor(i, j) = _RGB(200, 150, 20)
        EarthMass(i, j) = 5
        EarthSpeedX(i, j) = 0
        EarthSpeedY(i, j) = 0
        EarthSpeedZ(i, j) = 0
    Next j
Next i

CometTime = 0
StartImpactTime = 0
EndImpactTime = 0
DrawPathstartX = CometX(150, 150)
DrawPathstartY = CometY(150, 150)
DrawPathstartZ = CometZ(150, 150)
DrawPathCometSpeedX = CometSpeedX(150, 150)
DrawPathCometSpeedY = CometSpeedY(150, 150)
DrawPathCometSpeedZ = CometSpeedZ(150, 150)


If SkipimpactatStart$ = "Yes" Then Call DemoExplosionSwiftTuttle




'@@@@@@@@@@@@@@@@@@@@@@@@  Main Body of Program Starts HERE   @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

RunProgram$ = InKey$

While RunProgram$ = ""

    CometTime = CometTime + 1

    If HitJupiter$ = "Yes" Then Call DemoExplosionJupiter: HitJupiter$ = "Done"

    If AutoZoomOnOff = 1 Then
        ' Zoom IN
        If CometTime > ZoomTime1 And CometTime <= ZoomTime2 And (ZoomWindow3 - ZoomWindow1) > 15000 Then Call Zooming(1)
        'Zoom OUT
        If CometTime > ZoomTime3 And CometTime <= ZoomTime4 Then Call Zooming(2)
        If CometTime > ZoomTime4 And CometTime <= ZoomTime5 And (ZoomWindow3 - ZoomWindow1) < 200000 Then Call Zooming(3)
    End If

    Window (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, ZoomWindow4)


    '-------------------------------------------------------------------------------------------------  COMETS AND IMPACT PROBABILITIES   -----------------------------------------------

    DrawSwiftEnckeCometOrbits:
    If ShowPaths$ <> "Yes" Then Cls

    If CircularizingOnOff$ = "Yes" Then
        If CometTime > StartCircularizing And CometTime < StartCircularizing + 2500 And Int(CometTime / 2) * 2 = Int(CometTime) Then Call circularizeComet
    End If

    Select Case Scene$
        Case "SwiftTuttle Impact at Start", "SwiftTuttle Orbit, outgassing along the orbit", "Encke"
            Call DrawPlanetsSwiftTuttle
            Select Case Scene$ ' Draw Sun
                Case "Encke"
                    Select Case SwiftView$
                        Case "Trio"
                            For i = 1 To PlanetRadius / 4 Step PlanetRadius / 25
                                Circle (PlanetCenterX, PlanetCenterY + 200000000), i, _RGB(255, 255, 0)
                                Circle (PlanetCenterX, PlanetCenterY - 200000000), i, _RGB(255, 255, 0)
                                Circle (PlanetCenterX - 500000000, PlanetCenterY + 200000000), i, _RGB(255, 255, 0)
                            Next i
                        Case Else
                            For i = 1 To PlanetRadius / 4 Step PlanetRadius / 25
                                Circle (PlanetCenterX, PlanetCenterY), i, _RGB(255, 255, 0)
                            Next i
                    End Select
                Case Else
                    For i = 1 To PlanetRadius / 1.5 Step PlanetRadius / 40
                        Circle (PlanetCenterX, PlanetCenterY), i, _RGB(255, 255, 0)
                    Next i
            End Select

            ' Redraw Earth and Mars for passing sun to right to be in front
            '            Call DrawPlanets2SwiftTuttle
            'Encke goes out to 4.11 au, with 1 au = 149,600,000 km. So need to setup a run with the path extending out 614,856,000 km.


            If AutoRotate$ = "On" Then
                IncreaseperStep = 0.1
                If PointCount > 5000 Then IncreaseperStep = 0.1 * Int(PointCount / 5000)
                ViewAngle = ViewAngle + IncreaseperStep: If ViewAngle >= 360 Then ViewAngle = 0 ' : If RotatingColors = 1 Then RotatingColors = 2 Else RotatingColors = 1
            End If

            '                Circle (0, 0), 378479000, _RGB(55, 0, 0), , , Sin(Radian(ViewAngle)) ' sin starts with zero at the center - ie horizontal line for sin (0)
            '            Circle (0, 0), 378479000, _RGB(0, 0, 255), , , Cos(Radian(ViewAngle)) ' cos starts with zero at the outside - ie full circle for cos (0)

            Select Case SwiftView$ ' Draw Orbits and axis
                Case "Top"
                    If ShowEnckeOrbits$ = "On" Then
                        OrbitAspect = 1: If AutoRotate$ = "On" Or AutoRotate$ = "Hold" Then OrbitAspect = Abs(Sin(Radian(ViewAngle)))
                        Circle (0, 0), 57909000, _RGB(255, 0, 0), , , OrbitAspect ' Mercury Orbit average in Km = 57,909,000 Km
                        Circle (0, 0), 108208000, _RGB(255, 255, 255), , , OrbitAspect ' Venus Orbit in Km = 108,000,000 Km
                        Circle (0, 0), 149600000, _RGB(0, 255, 255), , , OrbitAspect ' Earth Average Orbit
                        '                        Circle (0, 0), 147100000, _RGB(0, 0, 255), , , OrbitAspect ' Earth Orbit
                        '                        Circle (0, 0), 152100000, _RGB(0, 0, 255), , , OrbitAspect ' Earth Orbit

                        'Jupiter average distance from Sun: 778,479,000 km, Min = 740595000 km, Max = 816363000
                        '                    Circle (0, 0), 740595000, _RGB(0, 255, 0) ' Jupiter Orbit min
                        Circle (0, 0), 228900000, _RGB(255, 0, 0), , , OrbitAspect ' Mars Orbit average
                        Circle (0, 0), 778479000, _RGB(255, 125, 0), , , OrbitAspect ' Jupiter Orbit average
                        Circle (0, 0), 1433530000, _RGB(0, 255, 255), , , OrbitAspect ' Saturn Orbit average
                        If Scene$ = "Encke" Then
                            Circle (0, 0), 613000000, _RGB(110, 110, 210), , , OrbitAspect ' Encke Farthest distance
                        Else
                            Circle (0, 0), 2880000000, _RGB(100, 255, 100), , , OrbitAspect ' Uranus Orbit average
                            Circle (0, 0), 4500000000, _RGB(150, 255, 50), , , OrbitAspect ' Neptune Orbit average
                        End If
                    End If
                    Line (0, 0)-(30000000, 0), _RGB(255, 255, 0) ' X Axis
                    If AutoRotate$ = "On" Or AutoRotate$ = "Hold" Then
                        Line (0, 0)-(0, 30000000 * Sin(Radian(ViewAngle))), _RGB(0, 255, 0) ' Y axis
                        Line (0, 0)-(0, 30000000 * Cos(Radian(ViewAngle))), _RGB(0, 0, 255) ' Z axis
                    Else
                        Line (0, 0)-(0, 30000000), _RGB(0, 255, 0) ' Y axis
                    End If
                Case "Front"
                    If ShowEnckeOrbits$ = "On" Then
                        Line (-100000000, 5000000)-(108208000, -5000000), _RGB(255, 255, 255) ' Venus Orbit
                        Line (-149000000, 0)-(149000000, 0), _RGB(0, 0, 255) ' Earth Orbit
                    End If
                    Line (0, 0)-(0, 30000000), _RGB(0, 0, 255) ' Z axis
                    Line (0, 0)-(30000000, 0), _RGB(255, 255, 0) ' X Axis
                Case "Bottom"
                    If ShowEnckeOrbits$ = "On" Then
                        Circle (0, 0), 57909000, _RGB(255, 0, 0) ' Mercury Orbit average in Km = 57,909,000 Km
                        Circle (0, 0), 108208000, _RGB(255, 255, 255) ' Venus Orbit in Km = 108,000,000 Km
                        Circle (0, 0), 149000000, _RGB(0, 255, 255) ' Earth Orbit
                        Circle (0, 0), 228900000, _RGB(255, 0, 0) ' Mars Orbit average
                        Circle (0, 0), 778479000, _RGB(255, 125, 0) ' Jupiter Orbit average
                        '                    Circle (0, 0), 1352550000, _RGB(0, 255, 255) ' Saturn Orbit Min
                        Circle (0, 0), 1433530000, _RGB(0, 255, 255) ' Saturn Orbit average
                        '                    Circle (0, 0), 1514500000, _RGB(0, 255, 255) ' Saturn Orbit Max
                        If Scene$ = "Encke" Then
                            Circle (0, 0), 613000000, _RGB(110, 110, 210), , , OrbitAspect ' Encke Farthest distance
                        Else
                            Circle (0, 0), 2880000000, _RGB(100, 255, 100), , , OrbitAspect ' Uranus Orbit average
                            Circle (0, 0), 4500000000, _RGB(150, 255, 50), , , OrbitAspect ' Neptune Orbit average
                        End If
                    End If
                    Line (0, 0)-(0, -30000000), _RGB(125, 255, 0) ' Y Axis
                    Line (0, 0)-(30000000, 0), _RGB(255, 255, 0) ' X axis
                    Line (0, 0)-(0, 0), _RGB(0, 0, 255) ' Z Axis
                Case "Back"
                    If ShowEnckeOrbits$ = "On" Then
                        Line (-100000000, -5000000)-(108208000, 5000000), _RGB(255, 255, 255) ' Venus Orbit
                        Line (-149000000, 0)-(149000000, 0), _RGB(0, 255, 255) ' Earth Orbit
                    End If
                    Line (0, 0)-(0, -30000000), _RGB(0, 0, 255) ' Z axis
                    Line (0, 0)-(30000000, 0), _RGB(255, 255, 0) ' X Axis
                Case "RightSide"
                    If ShowEnckeOrbits$ = "On" Then
                        Line (0, -100000000)-(0, 108208000), _RGB(255, 255, 255) ' Venus Orbit
                        Line (0, -149000000)-(0, 149000000), _RGB(0, 255, 255) ' Earth Orbit
                        Line (0, -778479000)-(0, 778479000), _RGB(255, 125, 0) ' Jupiter Orbit average
                    End If
                    Line (0, 0)-(0, 30000000), _RGB(125, 255, 0) ' Y axis
                    Line (0, 0)-(-30000000, 0), _RGB(0, 0, 255) ' Z Axis
                Case "LeftSide"
                    If ShowEnckeOrbits$ = "On" Then
                        Line (0, -100000000)-(0, 108208000), _RGB(255, 255, 255) ' Venus Orbit
                        Line (0, -149000000)-(0, 149000000), _RGB(0, 255, 255) ' Earth Orbit
                        Line (0, -778479000)-(0, 778479000), _RGB(255, 125, 0) ' Jupiter Orbit average
                    End If
                    Line (0, 0)-(0, 30000000), _RGB(125, 255, 0) ' Y axis
                    Line (0, 0)-(30000000, 0), _RGB(0, 0, 255) ' Z Axis
            End Select



            If CometPAthOnOff = 1 And CometTime > 10 Then 'draw line showing path of comet, but not if rotating
                '                A = 200 * (CometX(150, 150) - CometLastCenterX)
                '                B = 200 * (CometY(150, 150) - CometLastCenterY)
                '                C = 200 * (CometZ(150, 150) - CometLastCenterZ)
                A = (CometX(150, 150) - CometLastCenterX)
                B = (CometY(150, 150) - CometLastCenterY)
                C = (CometZ(150, 150) - CometLastCenterZ)
                D = (A * A + B * B + C * C) ^ 0.5
                A = A * 500000000 / D: B = B * 500000000 / D: C = C * 500000000 / D
                If Scene$ = "Encke" Then A = A / 5: B = B / 5: C = C / 5

                Select Case SwiftView$
                    Case "Top"
                        If AutoRotate$ <> "On" And AutoRotate$ <> "Hold" Then
                            Line (CometX(150, 150) - A, CometY(150, 150) - B)-(CometX(150, 150) + A, CometY(150, 150) + B), _RGB(255, 0, 0)
                        Else
                            Line (CometX(150, 150) - A, (CometY(150, 150) - B) * Sin(Radian(ViewAngle)) + (CometZ(150, 150) - C) * Cos(Radian(ViewAngle)))-(CometX(150, 150) + A, (CometY(150, 150) + B) * Sin(Radian(ViewAngle)) + (CometZ(150, 150) + C) * Cos(Radian(ViewAngle))), _RGB(255, 0, 0)
                        End If
                    Case "Front"
                        Line (CometX(150, 150) - A, CometZ(150, 150) - C)-(CometX(150, 150) + A, CometZ(150, 150) + C), _RGB(255, 0, 0)
                    Case "Bottom"
                        Line (CometX(150, 150) - A, -(CometY(150, 150) - B))-(CometX(150, 150) + A, -(CometY(150, 150) + B)), _RGB(255, 0, 0)
                    Case "Back"
                        Line (CometX(150, 150) - A, -(CometZ(150, 150) - C))-(CometX(150, 150) + A, -(CometZ(150, 150) + C)), _RGB(255, 0, 0)
                    Case "LeftSide"
                        Line (CometZ(150, 150) - C, (CometY(150, 150) - B))-(C + CometZ(150, 150), (B + CometY(150, 150))), _RGB(255, 0, 0)
                    Case "RightSide"
                        Line (-(CometZ(150, 150) - C), (CometY(150, 150) - B))-(-(C + CometZ(150, 150)), (B + CometY(150, 150))), _RGB(255, 0, 0)
                End Select
            End If



            CometLastCenterX = CometLastCenterX2: CometLastCenterY = CometLastCenterY2: CometLastCenterZ = CometLastCenterZ2
            CometLastCenterX2 = CometLastCenterX3: CometLastCenterY2 = CometLastCenterY3: CometLastCenterZ2 = CometLastCenterZ3
            CometLastCenterX3 = CometX(CometCenterX, CometCenterY): CometLastCenterY3 = CometY(CometCenterX, CometCenterY): CometLastCenterZ3 = CometZ(CometCenterX, CometCenterY)
            CDistance = Sqr((CometX(CometCenterX, CometCenterY) - PlanetCenterX) ^ 2 + (CometY(CometCenterX, CometCenterY) - PlanetCenterY) ^ 2 + (CometZ(CometCenterX, CometCenterY) - PlanetCenterZ) ^ 2)
            If StartImpactTime = 0 And CDistance - CometRadius < PlanetRadius Then StartImpactTime = CometTime
            If StartImpactTime > 0 And EndImpactTime = 0 And CDistance - CometRadius > PlanetRadius Then EndImpactTime = CometTime

        Case "Impact Jupiter then Earth twice at 1.5 and 1.6 years later", "Impact Jupiter, near miss Earth, then impact Earth 8.1 years later", "Impact Jupiter then Earth 10.2 years later", "Impact Jupiter then Earth a year later", "Impact Earth not Jupiter"
            Call DrawPlanetsJupiter

            If CometPAthOnOff = 1 And CometTime > 10 Then 'draw line showing path of comet
                A = 100 * (CometX(CometCenterX, CometCenterY) - CometLastCenterX)
                B = 100 * (CometY(CometCenterX, CometCenterY) - CometLastCenterY)
                Line (CometX(CometCenterX, CometCenterY) - A, CometY(CometCenterX, CometCenterY) - B)-(A + CometX(CometCenterX, CometCenterY), B + CometY(CometCenterX, CometCenterY)), _RGB(255, 0, 0)
            End If
            CometLastCenterX = CometLastCenterX2: CometLastCenterY = CometLastCenterY2
            CometLastCenterX2 = CometLastCenterX3: CometLastCenterY2 = CometLastCenterY3
            CometLastCenterX3 = CometX(CometCenterX, CometCenterY): CometLastCenterY3 = CometY(CometCenterX, CometCenterY)
            CDistance = Sqr((CometX(CometCenterX, CometCenterY) - SunCenterX) ^ 2 + (CometY(CometCenterX, CometCenterY) - SunCenterY) ^ 2)
            If StartImpactTime = 0 And CDistance - CometRadius < SunRadius Then StartImpactTime = CometTime
            If StartImpactTime > 0 And EndImpactTime = 0 And CDistance - CometRadius > SunRadius Then EndImpactTime = CometTime


        Case Else
            'Draw planet Earth on grid:     Scene$ = "Overtaking Earth from behind at 10 km/s" and others
            For i = 7 To PlanetRadius Step 5
                EarthColorization = 255 - 100 * i / PlanetRadius
                EarthColorization2 = 165 - 160 * i / PlanetRadius
                Circle (PlanetCenterX, PlanetCenterY), i, _RGB(EarthColorization2, EarthColorization2, EarthColorization)
            Next i
            ' Draw Moon if zoomed out enough
            If ZoomWindow3 > 380000 Then Call DrawMoon
            If LinesLatitudeOnOff = 1 Then Call Circle3DLatitudes

            If CometPAthOnOff = 1 And CometTime > 10 Then 'draw line showing path of comet
                A = 50 * (CometX(CometCenterX, CometCenterY) - CometLastCenterX)
                B = 50 * (CometY(CometCenterX, CometCenterY) - CometLastCenterY)
                Line (CometX(CometCenterX, CometCenterY) - A, CometY(CometCenterX, CometCenterY) - B)-(A + CometX(CometCenterX, CometCenterY), B + CometY(CometCenterX, CometCenterY)), _RGB(255, 0, 0)
            End If
            CometLastCenterX = CometLastCenterX2: CometLastCenterY = CometLastCenterY2
            CometLastCenterX2 = CometLastCenterX3: CometLastCenterY2 = CometLastCenterY3
            CometLastCenterX3 = CometX(CometCenterX, CometCenterY): CometLastCenterY3 = CometY(CometCenterX, CometCenterY)
            CDistance = Sqr((CometX(CometCenterX, CometCenterY) - PlanetCenterX) ^ 2 + (CometY(CometCenterX, CometCenterY) - PlanetCenterY) ^ 2)
            If StartImpactTime = 0 And CDistance - CometRadius < PlanetRadius Then StartImpactTime = CometTime
            If StartImpactTime > 0 And EndImpactTime = 0 And CDistance - CometRadius > PlanetRadius Then EndImpactTime = CometTime
    End Select

    '##################################     Draw Comet Path      #############################################
    If ToggleDrawCometCenterPath = 1 Then Call DrawCometCenterPath

    '##################################     Move and draw comet debris       #################################
    '    For x = 1 To 400
    '        For y = 1 To 400
    '    For x = 1 To 300
    If Scene$ = "Encke" Then MaxX = 50 Else MaxX = 300 ' For long Encke Run - use max of 50 for x. Faster than doing all 300 or 400 each time. BUT comet itself is X=150, y=150
    For x = 1 To MaxX
        If Scene$ = "Encke" And x = 50 Then x = 150
        For y = 1 To 300
            Select Case CometMass(x, y)
                Case Is < 1
                Case 1 To 3.5
                    Call CalXYAcc(AccX, AccY, AccZ)
                    CometSpeedX(x, y) = CometSpeedX(x, y) + AccX
                    CometSpeedY(x, y) = CometSpeedY(x, y) + AccY
                    CometSpeedZ(x, y) = CometSpeedZ(x, y) + AccZ
                    '                    PreviousCometX2(x, y) set to 150,000,000 at start, with  PreviousCometY2(x, y) set to 0 indicating moving away from sun
                    '                    PreviousCometX2(x, y) = Sqr(CometX(x, y) ^ 2 + CometY(x, y) ^ 2 + CometZ(x, y) ^ 2) ' distance from Sun
                    PreviousCometX2(x, y) = Sqr(CometX(x, y) ^ 2 + CometY(x, y) ^ 2 + CometZ(x, y) ^ 2) ' distance from Sun
                    CometX(x, y) = CometX(x, y) + CometSpeedX(x, y) * SpeedUpFactor
                    CometY(x, y) = CometY(x, y) + CometSpeedY(x, y) * SpeedUpFactor
                    CometZ(x, y) = CometZ(x, y) + CometSpeedZ(x, y) * SpeedUpFactor
                    '                    DistanceFromSun = Sqr(CometX(x, y) ^ 2 + CometY(x, y) ^ 2 + CometZ(x, y) ^ 2)
                    DistanceFromSun = Sqr(CometX(x, y) ^ 2 + CometY(x, y) ^ 2 + CometZ(x, y) ^ 2)
                    If DistanceFromSun < PreviousCometX2(x, y) And PreviousCometY2(x, y) = 0 Then PreviousCometY2(x, y) = 1 ' when prev Y = 1 then comet heading back towards sun
                    If DistanceFromSun > PreviousCometX2(x, y) And PreviousCometY2(x, y) = 1 And PreviousCometX2(x, y) < 1.5 * 150000000 Then PreviousCometY2(x, y) = 0 ' when prev Y = 1 then comet heading back towards sun

                    If Sqr(CometX(x, y) ^ 2 + CometY(x, y) ^ 2 + CometZ(x, y) ^ 2) > 20000000000 Then CometMass(x, y) = 0: CometSpeedX(x, y) = 0: CometSpeedY(x, y) = 0: AccX = 0: AccY = 0 ' if more than 20,000,000,000 km away, then off to space and not of concern
                    If RemoveNonEarthCrossing$ = "Yes" Then ' Calculate if debris orbits are no longer Earth Crossing and remove if that is true
                        If PreviousCometY2(x, y) = 1 And PreviousCometX2(x, y) < DistanceFromSun Then ' if never got close to sun then not on Earth Crossing Orbit of 150,000,000 km distance from sun
                            If PreviousCometX2(x, y) > 1.5 * 150000000 Then CometMass(x, y) = 0: CometSpeedX(x, y) = 0: CometSpeedY(x, y) = 0: AccX = 0: AccY = 0
                        End If
                    End If
                Case Else ' Something is wrong it should never get here!!
                    CometX(x, y) = CometX(x, y) + CometSpeedX(x, y) * SpeedUpFactor
                    CometY(x, y) = CometY(x, y) + CometSpeedY(x, y) * SpeedUpFactor
                    CometZ(x, y) = CometZ(x, y) + CometSpeedZ(x, y) * SpeedUpFactor
                    Circle (CometX(x, y), CometY(x, y)), 40, _RGB(255, 0, 0) 'CometColor(x, y)
            End Select

            If CometMass(x, y) >= 1 Then
                CometParticlesColor = CometColor(x, y)
                If MonoColor$ <> "No" Then CometParticlesColor = PresentMonoColor
                If Scene$ = "Encke" And CometY(x, y) > 0 Then
                    Select Case CometParticlesColor
                        Case _RGB(255, 0, 0): CometParticlesColor = _RGB(190, 0, 0) ' Red
                        Case _RGB(0, 255, 0): CometParticlesColor = _RGB(0, 190, 0) ' Green
                        Case _RGB(0, 0, 255): CometParticlesColor = _RGB(0, 0, 190) ' Blue
                        Case _RGB(255, 100, 0): CometParticlesColor = _RGB(190, 75, 0) ' Mars Orange
                        Case _RGB(255, 255, 0): CometParticlesColor = _RGB(200, 200, 0)
                        Case _RGB(255, 0, 255): CometParticlesColor = _RGB(190, 0, 190)
                        Case _RGB(0, 255, 255): CometParticlesColor = _RGB(0, 190, 190)
                        Case _RGB(255, 255, 255): CometParticlesColor = _RGB(190, 190, 190)
                    End Select
                End If
                If Scene$ = "Encke" And CometY(x, y) > 150000000 Then
                    Select Case CometParticlesColor
                        Case _RGB(255, 0, 0): CometParticlesColor = _RGB(150, 0, 0) ' Red
                        Case _RGB(0, 255, 0): CometParticlesColor = _RGB(0, 150, 0) ' Green
                        Case _RGB(0, 0, 255): CometParticlesColor = _RGB(0, 0, 150) ' Blue
                        Case _RGB(255, 100, 0): CometParticlesColor = _RGB(150, 60, 0) ' Mars Orange
                        Case _RGB(255, 255, 0): CometParticlesColor = _RGB(150, 150, 0)
                        Case _RGB(255, 0, 255): CometParticlesColor = _RGB(150, 0, 150)
                        Case _RGB(0, 255, 255): CometParticlesColor = _RGB(0, 150, 150)
                        Case _RGB(255, 255, 255): CometParticlesColor = _RGB(150, 150, 150)
                    End Select
                End If
                Select Case SwiftView$
                    Case "Top"
                        If AutoRotate$ = "On" Or AutoRotate$ = "Hold" Then
                            PSet (CometX(x, y), CometY(x, y) * Sin(Radian(ViewAngle)) + CometZ(x, y) * Cos(Radian(ViewAngle))), CometParticlesColor
                        Else
                            PSet (CometX(x, y), CometY(x, y)), CometParticlesColor
                        End If
                    Case "Front": PSet (CometX(x, y), CometZ(x, y)), CometParticlesColor
                    Case "Bottom": PSet (CometX(x, y), -CometY(x, y)), CometParticlesColor
                    Case "Back": PSet (CometX(x, y), -CometZ(x, y)), CometParticlesColor
                    Case "LeftSide": PSet (CometZ(x, y), CometY(x, y)), CometParticlesColor
                    Case "RightSide": PSet (-CometZ(x, y), CometY(x, y)), CometParticlesColor
                    Case "Trio"
                        PSet (CometX(x, y), CometY(x, y) + 200000000), CometParticlesColor ' Top
                        PSet (CometX(x, y), CometZ(x, y) - 200000000), CometParticlesColor ' Front
                        PSet (-CometZ(x, y) - 500000000, CometY(x, y) + 200000000), CometParticlesColor ' Right
                    Case Else: PSet (CometX(x, y), CometY(x, y)), CometParticlesColor
                End Select
            End If

        Next y
    Next x



    '    DistanceFromSun = Sqr(CometX(150, 150) ^ 2 + CometY(150, 150) ^ 2 + CometZ(150, 150) ^ 2)
    '    If PreviousCometX2(150, 150) > DistanceFromSun Then MovingTowardsSun = 1: MovingAwaySun = 0
    '    If PreviousCometX2(150, 150) < DistanceFromSun Then MovingAwaySun = 1
    '    If MovingTowardsSun = 1 And MovingAwaySun = 1 Then ' Closest Approach
    '    Locate 30, 10: Print "Comet X:", CometX(150, 150)
    '    Locate 31, 10: Print "Comet Y:", CometY(150, 150)
    '    Locate 32, 10: Print "Comet Z:", CometZ(150, 150)
    '    Locate 34, 10: Print "CometTime: ", CometTime
    '    Locate 40, 10: Print "Comet prev Distance:", PreviousCometX2(150, 150)
    '    Locate 42, 10: Print "Comet Distance:", DistanceFromSun
    '    MovingTowardsSun = 0
    '        Beep: Beep: Beep
    '    End If
    '    Locate 42, 10: Print "Comet Distance:", DistanceFromSun


    '      startpoint for Jupiter:   JupiterCenterX = 778,000,000: JupiterCenterY = 0: JupiterCenterZ = 0 So if X <= 7780000000 then comet within Jupiter's orbit distance from sun and should begin outgassing
    '      startpoint for Uranus:   UranusCenterX = 2,800,000,000: UranusCenterY = 0: UranusCenterZ = 0 So if X <= 2,800,000,000 then comet within Uranus's orbit distance from sun and should begin outgassing

    '          Uranus orbit radius = 2875000000,      SaturnCenterX = 1433530000, so outgass from Saturn's orbit, and less


    ' Outgassing should add about 1 - 10 m/s speed to particles with larger particles moving slower than smaller ones
    'According to "A Survey of Debris Trails from Comets - W. Reach 2007"
    ' the ejection speed is related to size according to the formula: V eject = 1/SQRT(B/s) with s=particle radius in microns,
    '                                                                             B = radiation pressure which is 0.57/(radius of particle in microns) = .57/5000 for a 1 cm diameter particle = .0001; .57/500 for 1 mm diameter = .001
    '            B = ratio of radiation pressure relative to gravity, so radiation is 1/1000 gravity for 1 cm particle
    '                                                                 V eject = 1/SQRT(B/R) km/s with R = distance from Sun in AU. At 1 AU (Earth orbit) V eject = 1/SQRT(10^-4/1) = 10^-2 = .01 km/s = 10 m/sec
    '                                                                                                                              At 5.2 AU (Jupiter orbit) V eject = 1/SQRT(10^-4/5.2) = .0045 = .0045 km/s = 4.5 m/sec

    If Scene$ = "SwiftTuttle Impact at Start" Or Scene$ = "SwiftTuttle Orbit, outgassing along the orbit" Then
        If OutGassing$ = "Yes" And CometX(150, 150) < 3000000000 Then
            If Int(CometTime / 100) * 100 = CometTime Then '   Increase number of particles emitted   $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
                If OutGasOnOrbit$ = "Yes" Then
                    '  Add random outgasing as it moves around Earth
                    StartHere = 150 - CometRadius * 1.5: If StartHere < 1 Then StartHere = 1 ' limit how many new points will be added
                    EndHere = 150 + CometRadius * 1.5: If EndHere > 300 Then EndHere = 300 ' limit how many new points will be added
                    For x = StartHere To EndHere
                        For y = StartHere To EndHere
                            If CometMass(x, y) = 0 Then
                                If x <> 150 And y <> 150 Then ' do not add random speed to center point
                                    ' original number used to reduce frequency of ejecting particles:   aca = INT(RND(32) * 1800)
                                    aca = Int(Rnd(32) * 1400)
                                    If CometX(150, 150) < 100000000 Then aca = Int(Rnd(32) * 400)
                                    If x = aca Or y = aca Then '  seldom select a point
                                        CometX(x, y) = CometX(150, 150): CometY(x, y) = CometY(150, 150): CometZ(x, y) = CometZ(150, 150)
                                        CometSpeedX(x, y) = CometSpeedX(150, 150) + 100 * (Rnd(32) - .5) * Rnd(33) ' X is less than Y to allow for added speed from comet body's spin
                                        '  CometSpeedY(x, y) = CometSpeedY(150, 150) + 120 * (Rnd(32) - .5) * Rnd(33) ' 120 or 100 makes NO DIFFERENCE AT ALL - identical results in 435 years.
                                        CometSpeedY(x, y) = CometSpeedY(150, 150) + 100 * (Rnd(32) - .5) * Rnd(33) ' add up to 0.100km/sec = 100 m/sec ejection speed. Exaggerated to show distribution more clearly.
                                        CometSpeedZ(x, y) = CometSpeedZ(150, 150) + 100 * (Rnd(32) - .5) * Rnd(33)
                                        CometMass(x, y) = 1.2: CometColor(x, y) = _RGB(255, 255, 0) ' Yellow
                                    End If
                                End If
                            End If
                        Next y
                    Next x
                End If
            End If
        End If
    End If


    If OutGassing$ = "Yes" And Scene$ = "Encke" Then
        '  Add random outgasing as it moves around Sun
        EnckeFreq = 100
        DistanceFromSun = Sqr(CometX(x, y) ^ 2 + CometY(x, y) ^ 2 + CometZ(x, y) ^ 2)
        If DistanceFromSun < 300000000 Then EnckeFreq = 50
        If DistanceFromSun < 150000000 Then EnckeFreq = 25
        If EnckeDebrisCount > 0 Then EnckeFreq = 4
        If Int(CometTime / EnckeFreq) * EnckeFreq = CometTime Then ' just add another point every ten calculations
            EnckeTimeY = EnckeTimeY + 1
            If EnckeTimeY > 300 Then
                EnckeTimeX = EnckeTimeX + 1
                '                If EnckeTimeX > 20 + EnckeStartTime Then
                If EnckeTimeX > 20 + EnckeStartTime Then
                    EnckeStartTime = EnckeStartTime + 1
                    '                    EnckeStartTime = 1 ' This limits it to 3000 points total
                    If EnckeStartTime > 40 Then EnckeStartTime = 1 ' Limits it to 12,000 points. If > 300 then used all particles, need to restart or crash system
                    EnckeTimeX = EnckeStartTime
                End If
                EnckeTimeY = 1
            End If
            x = EnckeTimeX: If x = 150 Then x = 151
            y = EnckeTimeY: If y = 150 Then y = 151
            CometX(x, y) = CometX(150, 150)
            CometY(x, y) = CometY(150, 150)
            CometZ(x, y) = CometZ(150, 150)
            CometSpeedX(x, y) = CometSpeedX(150, 150) + 300 * (Rnd(32) - .5) * Rnd(33) ' add up to 0.30 km/sec = 300 m/sec. NOTE: Higher ejection rates lead to les well defined horns as the comet appoaches its farthest distance.
            '            CometSpeedY(x, y) = CometSpeedY(150, 150) + 500 * (Rnd(32) - .5) * Rnd(33)  ' the difference with Y larger is better, noticable, but very small and not worth the nuisance of explaining it.
            CometSpeedY(x, y) = CometSpeedY(150, 150) + 300 * (Rnd(32) - .5) * Rnd(33)
            CometSpeedZ(x, y) = CometSpeedZ(150, 150) + 300 * (Rnd(32) - .5) * Rnd(33)
            CometMass(x, y) = 1.2: CometColor(x, y) = _RGB(255, 255, 0) ' Yellow
            If EnckeDebrisCount > 0 Then EnckeDebrisCount = EnckeDebrisCount - 1: CometColor(x, y) = _RGB(255, 0, 255)
        End If
        '        For x = 1 To EnckeStartTime
        '            For y = 1 To 300
        '                CometColor(x, y) = _RGB(0, 255, 0) ' Green
        '            Next y
        '        Next x


    End If



    ' draw main comet    ********************************************************************************  DrawCometItself



    If OutGassing$ = "Yes" Or Scene$ = "SwiftTuttle Impact at Start" Or Scene$ = "SwiftTuttle Orbit, outgassing along the orbit" Or Scene$ = "Encke" Then

        PlanetIColor = _RGB(255, 0, 0)
        PlanetISize = 3000000: PlanetScale = 3000000
        If Scene$ = "Encke" Then PlanetISize = 0: PlanetScale = 400000

        For PJ = 1 To 5
            Select Case SwiftView$ ' Draw Comet Itself
                Case "Top"
                    If AutoRotate$ = "On" Or AutoRotate$ = "Hold" Then
                        Circle (CometX(150, 150), CometY(150, 150) * Sin(Radian(ViewAngle)) + CometZ(150, 150) * Cos(Radian(ViewAngle))), PlanetISize + PJ * PlanetScale, PlanetIColor
                        If PJ = 5 Then Circle (CometX(150, 150), CometY(150, 150) * Sin(Radian(ViewAngle)) + CometZ(150, 150) * Cos(Radian(ViewAngle))), PlanetISize + PJ * PlanetScale, _RGB(255, 255, 255)
                    Else
                        Circle (CometX(150, 150), CometY(150, 150)), PlanetISize + PJ * PlanetScale, PlanetIColor
                        If PJ = 5 Then Circle (CometX(150, 150), CometY(150, 150)), PlanetISize + PJ * PlanetScale, _RGB(255, 255, 255)
                    End If
                Case "Front"
                    Circle (CometX(150, 150), CometZ(150, 150)), PlanetISize + PJ * PlanetScale, PlanetIColor
                    If PJ = 5 Then Circle (CometX(150, 150), CometZ(150, 150)), PlanetISize + PJ * PlanetScale, _RGB(255, 255, 255)
                Case "Bottom"
                    Circle (CometX(150, 150), -CometY(150, 150)), PlanetISize + PJ * PlanetScale, PlanetIColor
                    If PJ = 5 Then Circle (CometX(150, 150), -CometY(150, 150)), PlanetISize + PJ * PlanetScale, _RGB(255, 255, 255)
                Case "Back"
                    Circle (CometX(150, 150), -CometZ(150, 150)), PlanetISize + PJ * PlanetScale, PlanetIColor
                    If PJ = 5 Then Circle (CometX(150, 150), -CometZ(150, 150)), PlanetISize + PJ * PlanetScale, _RGB(255, 255, 255)
                Case "RightSide"
                    Circle (-CometZ(150, 150), CometY(150, 150)), PlanetISize + PJ * PlanetScale, PlanetIColor
                    If PJ = 5 Then Circle (-CometZ(150, 150), CometY(150, 150)), PlanetISize + PJ * PlanetScale, _RGB(255, 255, 255)
                Case "LeftSide"
                    Circle (CometZ(150, 150), CometY(150, 150)), PlanetISize + PJ * PlanetScale, PlanetIColor
                    If PJ = 5 Then Circle (CometZ(150, 150), CometY(150, 150)), PlanetISize + PJ * PlanetScale, _RGB(255, 255, 255)
                Case "Trio"
                    Circle (CometX(150, 150), CometY(150, 150) + 200000000), PlanetISize + PJ * PlanetScale, PlanetIColor
                    If PJ = 5 Then Circle (CometX(150, 150), CometY(150, 150) + 200000000), PlanetISize + PJ * PlanetScale, _RGB(255, 255, 255)
                    Circle (CometX(150, 150), CometZ(150, 150) - 200000000), PlanetISize + PJ * PlanetScale, PlanetIColor
                    If PJ = 5 Then Circle (CometX(150, 150), CometZ(150, 150) - 200000000), PlanetISize + PJ * PlanetScale, _RGB(255, 255, 255)
                    Circle (-CometZ(150, 150) - 500000000, CometY(150, 150) + 200000000), PlanetISize + PJ * PlanetScale, PlanetIColor
                    If PJ = 5 Then Circle (-CometZ(150, 150) - 500000000, CometY(150, 150) + 200000000), PlanetISize + PJ * PlanetScale, _RGB(255, 255, 255)

                Case Else
                    Circle (CometX(150, 150), CometY(150, 150)), PlanetISize + PJ * PlanetScale, PlanetIColor
            End Select
        Next PJ
    End If

    If InStr(Scene$, "Jupiter") > 0 Then
        RadiusOfCometDrawing = 1000000
        If HitEarth$ = "Yes" Then RadiusOfCometDrawing = RadiusOfCometDrawing / 1.3
        If HitJupiter$ = "Done" Then RadiusOfCometDrawing = RadiusOfCometDrawing / 1.3
        Circle (CometX(150, 150), CometY(150, 150)), RadiusOfCometDrawing, _RGB(255, 0, 0)
        Circle (CometX(150, 150), CometY(150, 150)), RadiusOfCometDrawing * 2, _RGB(255, 0, 0)
        Circle (CometX(150, 150), CometY(150, 150)), RadiusOfCometDrawing * 3, _RGB(255, 0, 0)
        Circle (CometX(150, 150), CometY(150, 150)), RadiusOfCometDrawing * 4, _RGB(255, 0, 0)
        Circle (CometX(150, 150), CometY(150, 150)), RadiusOfCometDrawing * 5, _RGB(255, 0, 0)
        Circle (CometX(150, 150), CometY(150, 150)), RadiusOfCometDrawing * 6, _RGB(255, 255, 0)
    End If




    If InStr(Scene$, "Sun out") = 0 And InStr(Scene$, "Jupiter") = 0 And Scene$ <> "SwiftTuttle Impact at Start" And Scene$ <> "SwiftTuttle Orbit, outgassing along the orbit" And Scene$ <> "Encke" Then
        ' Move Earth Particles
        For i = 1 To 6300
            For j = 7 To 1 Step -1
                If EarthSpeedX(i, j) <> 0 Then
                    Call CalEarthParticlesGravity(i, j, AccX, AccY)
                    EarthSpeedX(i, j) = EarthSpeedX(i, j) + AccX
                    EarthSpeedY(i, j) = EarthSpeedY(i, j) + AccY
                    EarthX(i, j) = EarthX(i, j) + EarthSpeedX(i, j)
                    EarthY(i, j) = EarthY(i, j) + EarthSpeedY(i, j)
                    Circle (EarthX(i, j), EarthY(i, j)), 10, EarthColor(i, j)
                Else
                    Circle (EarthX(i, j), EarthY(i, j)), 10, EarthColor(i, j)
                End If
            Next j
        Next i
    End If



    '    GOTO Skipheader


    DrawHeader:

    ' Print HEADER - Locate details in menu bar area
    HeaderDepth = ZoomWindow4 - (ZoomWindow4 - ZoomWindow2) * .02
    HeaderDepth2 = (ZoomWindow4 - ZoomWindow2) * .0008
    Line (ZoomWindow1, ZoomWindow4)-(ZoomWindow3, HeaderDepth), _RGB(215, 215, 215), BF
    Line (ZoomWindow1, HeaderDepth)-(ZoomWindow3, HeaderDepth - HeaderDepth2), _RGB(100, 100, 100), BF
    Line (ZoomWindow1, HeaderDepth - HeaderDepth2)-(ZoomWindow3, HeaderDepth - HeaderDepth2 * 1.5), _RGB(220, 220, 220), BF
    Color _RGB(0, 0, 0), _RGB(215, 215, 215)
    ScenePrint$ = Scene$
    If Scene$ = "Swift Tuttle from above at 66.55 degrees after impact - Relative Speed 42 km/s" Then ScenePrint$ = "Swift Tuttle from above at 66.55 degrees after impact"
    CometActualSpeed = Sqr(CometSpeedX(CometCenterX, CometCenterY) ^ 2 + CometSpeedY(CometCenterX, CometCenterY) ^ 2 + CometSpeedZ(CometCenterX, CometCenterY) ^ 2)
    If OutGassing$ = "Yes" Then If InStr(Scene$, "Sun out") > 0 Or Scene$ = "SwiftTuttle Impact at Start" Or Scene$ = "SwiftTuttle Orbit, outgassing along the orbit" Then CometActualSpeed = CometActualSpeed / 1000
    If InStr(Scene$, "Impact Jupiter") > 0 Then CometActualSpeed = CometActualSpeed / 1000
    If InStr(Scene$, "Impact Earth not Jupiter") > 0 Then CometActualSpeed = CometActualSpeed / 1000
    If Scene$ = "Encke" Then CometActualSpeed = CometActualSpeed / 1020 ' Showing a bit fast so 1040 instead of 1000
    If CometActualSpeed > 10 Then AA$ = Left$(Str$(CometActualSpeed), 6) Else AA$ = Left$(Str$(CometActualSpeed), 4)
    '                         ****************************@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*********************************

    CometTime150 = CometTime / 175.56
    If Scene$ = "Encke" Then
        CometTime150 = 5 * (2023.8) + CometTime / 175.56 '  2023.8 is starting date for Encke simulation     CometTime/175.5474 = 0.2 years for Encke Calculations or 877.737 cometime per Earth Year = 10 hour interval calculations     ****************************@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*********************************
        If RunReverse$ = "Yes" Then
            CometTime150 = 5 * (2023.8) - CometTime / 175.56 '  2023.8 is starting date for Encke simulation     CometTime/175.5474 = 0.2 years for Encke Calculations or 877.737 cometime per Earth Year      ****************************@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*********************************
        End If
    End If

    If Int(CometTime / 20) * 20 = CometTime Then
        CometAngle = Sqr(CometSpeedX(150, 150) ^ 2 + CometSpeedY(150, 150) ^ 2 + CometSpeedZ(150, 150) ^ 2)
        CometAngle = 90 - ARCSIN(CometSpeedX(150, 150) / CometAngle) * 180 / pi
    End If



    Select Case Scene$
        Case "SwiftTuttle Orbit, outgassing along the orbit", "Encke"
            _PrintString (10, 3), "Swift Tuttle Orbit, Outgas along orbit"
            If Scene$ = "Encke" Then _PrintString (10, 3), "       Encke Orbit, Outgas along orbit"
            If Scene$ = "Encke" Then
                If CometTime > 10 And Int(CometTime / 50) * 50 = CometTime Then
                    PointCount = 0
                    For x = 1 To 300
                        For y = 1 To 300
                            If CometMass(x, y) > 0 Then PointCount = PointCount + 1
                        Next y
                    Next x
                End If
            Else
                If CometTime > 10 And Int(CometTime / 50) * 50 = CometTime Then
                    PointCount = 0
                    For x = 1 To 400
                        For y = 1 To 400
                            If CometMass(x, y) > 0 Then PointCount = PointCount + 1
                        Next y
                    Next x
                End If
            End If

            _PrintString (390, 3), "Points displayed: " + Str$(Int(PointCount / 25) * 25) + "  "
            _PrintString (650, 3), "Speed: " + AA$ + " Km/s"
            _PrintString (850, 3), "Angle:" + Left$(Str$(CometAngle), 6)
            TimetobePrinted = Int(CometTime150 * 10) / 10
            If SimulationSlowFactor > 1 Then TimetobePrinted = Int((CometTime150 / SimulationSlowFactor) * 10) / 10
            _PrintString (1600, 3), "TIME: " + Str$(TimetobePrinted) + "  "
            _PrintString (1720, 3), "Years"

            '            If Scene$ = "Encke" And CometFileName$ <> "D:/CometEnckeImages/" Then
            '                CometParticlesColor2 = _RGB(255, 255, 0)
            '                Locate 47, 10: Print "EnckeTimeX", EnckeTimeX
            '                Locate 48, 10: Print "EnckeTimeY", EnckeTimeY
            '                Locate 49, 10: Print "EnckeStartTime", EnckeStartTime
            '            End If


            If Scene$ = "Encke" Then
                Select Case EnckeGravity$
                    Case "On": _PrintString (1000, 3), "This Simulation IS calculatiing the Gravitational effects of planets       ":
                    Case "MVEM": _PrintString (1000, 3), "This Simulation is Only calculatiing Gravity of Mercury, Venus, Earth, Mars   "
                    Case Else: _PrintString (1000, 3), "This Simulation is NOT calculatiing the Gravitational effects of planets       "
                End Select
            Else
                If EarthGravity$ <> "On" And MarsGravity$ <> "On" And JupiterGravity$ <> "On" And SaturnGravity$ <> "On" And UranusNeptuneGravity$ <> "On" Then
                    _PrintString (1000, 3), "This Simulation is NOT calculatiing the Gravitational effects of planets       "
                Else
                    If EarthGravity$ = "On" Then GravityOn$ = "Earth  " Else GravityOn$ = "       "
                    If MarsGravity$ = "On" Then GravityOn$ = GravityOn$ + "Mars  " Else GravityOn$ = GravityOn$ + "      "
                    If JupiterGravity$ = "On" Then GravityOn$ = GravityOn$ + "Jupiter  " Else GravityOn$ = GravityOn$ + "         "
                    If SaturnGravity$ = "On" Then GravityOn$ = GravityOn$ + "Saturn  " Else GravityOn$ = GravityOn$ + "        "
                    If UranusNeptuneGravity$ = "On" Then GravityOn$ = GravityOn$ + "Uranus Neptune" Else GravityOn$ = GravityOn$ + "              "
                    _PrintString (1000, 3), "Gravity ON for: " + GravityOn$
                End If
            End If


        Case "SwiftTuttle Impact at Start"
            If OutGassing$ = "Yes" Then
                _PrintString (10, 3), "Swift Tuttle Impact at Start, Then Outgas"
            Else
                _PrintString (10, 3), "Swift Tuttle Impact at Start"
            End If
            If CometTime > 10 And Int(CometTime / 200) * 200 = CometTime Then
                PointCount = 0
                For x = 1 To 400
                    For y = 1 To 400
                        If CometMass(x, y) > 0 Then PointCount = PointCount + 1
                    Next y
                Next x
            End If
            _PrintString (390, 3), "Points displayed: " + Str$(Int(PointCount / 50) * 50) + "  "
            _PrintString (650, 3), "Speed: " + AA$ + " Km/s"
            _PrintString (850, 3), "Angle:" + Left$(Str$(CometAngle), 6)

            If EarthGravity$ <> "On" And MarsGravity$ <> "On" And JupiterGravity$ <> "On" And SaturnGravity$ <> "On" And UranusNeptuneGravity$ <> "On" Then
                _PrintString (1000, 3), "This Simulation is NOT calculatiing the Gravitational effects of planets       "
            Else
                If EarthGravity$ = "On" Then GravityOn$ = "Earth  " Else GravityOn$ = "       "
                If MarsGravity$ = "On" Then GravityOn$ = GravityOn$ + "Mars  " Else GravityOn$ = GravityOn$ + "      "
                If JupiterGravity$ = "On" Then GravityOn$ = GravityOn$ + "Jupiter  " Else GravityOn$ = GravityOn$ + "         "
                If SaturnGravity$ = "On" Then GravityOn$ = GravityOn$ + "Saturn  " Else GravityOn$ = GravityOn$ + "        "
                If UranusNeptuneGravity$ = "On" Then GravityOn$ = GravityOn$ + "Uranus Neptune" Else GravityOn$ = GravityOn$ + "              "
                _PrintString (1000, 3), "Gravity ON for: " + GravityOn$
            End If
            _PrintString (1600, 3), "TIME: " + Str$(CometTime150) + "  Years"
        Case "Impact Jupiter then Earth twice at 1.5 and 1.6 years later", "Impact Jupiter, near miss Earth, then impact Earth 8.1 years later", "Impact Jupiter then Earth 10.2 years later", "Impact Jupiter then Earth a year later", "Impact Earth not Jupiter"
            _PrintString (10, 3), "Simulation:   " + ScenePrint$
            _PrintString (700, 3), "Comet Diameter: " + Str$(CometRadius * 2) + " Km"
            _PrintString (950, 3), "Angle:" + Left$(Str$(CometAngle), 6)
            _PrintString (1100, 3), "Speed: " + AA$ + " Km/s"
            CometTimeIJ = CometTime / 833
            If CometTimeIJ > 10 Then AA$ = Str$(Int(CometTimeIJ * 10) / 10) Else AA$ = Str$(Int(CometTimeIJ * 100) / 100)
            _PrintString (1550, 3), "TIME: " + AA$
            _PrintString (1670, 3), "Years"

        Case Else
            _PrintString (10, 3), "Simulation:   " + ScenePrint$
            If InStr(Scene$, "Sun out") = 0 Then _PrintString (1360, 3), "Earth Tilt:" + Str$(TiltofEarth) + "        "
            _PrintString (700, 3), "Comet Diameter: " + Str$(CometRadius * 2) + " Km"
            _PrintString (940, 3), "Speed: " + AA$ + " Km/s"
            If Scene$ <> "Demonstration of impact probabilities" Then
                _PrintString (1140, 3), "Angle:" + Left$(Str$(CometAngle), 6)
            End If
            _PrintString (1600, 3), "TIME: " + LTrim$(Str$(CometTime))
    End Select





    'Locate function key reminders in bottom menu bar
    HeaderDepth = ZoomWindow2 + (ZoomWindow4 - ZoomWindow2) * .02
    HeaderDepth2 = (ZoomWindow4 - ZoomWindow2) * .0008
    Color _RGB(55, 55, 55), _RGB(215, 215, 185)
    Line (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, HeaderDepth), _RGB(215, 215, 185), BF
    'HeaderDepth - HeaderDepth2 * 2)-(ZoomWindow3, HeaderDepth - HeaderDepth2 * 3), _RGB(255, 0, 0), BF
    _PrintString (10, 982), "Space Bar:Pause  Stop Program:'Esc'"
    Select Case Scene$
        Case "Encke"
            _PrintString (305, 982), "F1-F5:New Scenes  F6:Outgasing is ON  F7:Path  F8:Boost Debris  F9:Planets' Gravity ON  F10:Show orbits  F11:AutoRotate   F12:Show Paths"
            Color _RGB(5, 5, 255), _RGB(215, 215, 185)
            If OutGassing$ = "No" Then _PrintString (577, 982), "OFF"
            If EnckeDebrisCount > 1 Then _PrintString (705, 982), "Debris Boosting"
            If EnckeGravity$ = "Off" Then _PrintString (910, 982), "Gravity OFF"
            If EnckeGravity$ = "MVEM" Then _PrintString (910, 982), "Gravity MVEM"
            If AutoRotate$ = "On" Then _PrintString (1177, 982), "AutoRotating"
            Color _RGB(250, 250, 0), _RGB(150, 150, 150)
            If AutoRotate$ = "Hold" Then _PrintString (1177, 982), "HoldRotating"
            Color _RGB(55, 55, 55), _RGB(215, 215, 185)
            _PrintString (1412, 982), "Cursor Keys: Zoom, View."
        Case "SwiftTuttle Impact at Start", "SwiftTuttle Orbit, outgassing along the orbit"
            _PrintString (305, 982), "F1-F5:New Scenes  F6:Outgasing is ON  F7:Path  F8:Earth Gravity F9:Planets' Gravity ON  F10:Show orbits  F11:AutoRotate   F12:Show Paths"
            If OutGassing$ = "No" Then _PrintString (577, 982), "OFF"
            If RemoveNonEarthCrossing$ = "Yes" Then Color _RGB(0, 0, 255): _PrintString (1410, 982), "Removing Non Earth-Crossing particles": Color _RGB(55, 55, 55), _RGB(215, 215, 185)
            If MarsGravity$ = "Off" Then _PrintString (912, 982), "Gravity OFF"
            If AutoRotate$ = "On" Then _PrintString (1177, 982), "AutoRotating"
            Color _RGB(250, 250, 0), _RGB(150, 150, 150)
            If AutoRotate$ = "Hold" Then _PrintString (1177, 982), "HoldRotating"
            Color _RGB(55, 55, 55), _RGB(215, 215, 185)
            _PrintString (1412, 982), "Cursor Keys: Zoom, View."
        Case "Impact Jupiter then Earth twice at 1.5 and 1.6 years later", "Impact Jupiter, near miss Earth, then impact Earth 8.1 years later", "Impact Jupiter then Earth 10.2 years later", "Impact Jupiter then Earth a year later", "Impact Earth not Jupiter"
            _PrintString (370, 982), "Cursor Keys: Zoom, View     F1-F5, Ctrl Q-Y, A, S: New Scenes      F6:Comet Radius       F7:Path    "
        Case Else
            _PrintString (370, 982), "F1-F5: New Scenes   F6:Comet Radius   F7:Path   F8-F10:Tilt   F11:North America   F12:Auto Zoom"
            _PrintString (1280, 982), "Cursor Keys: Zoom, View.   'S', 'L' Screen size"
    End Select

    If SaveTheImage > 0 Then
        SaveNumFactor = SaveOneInTen: If SaveNumFactor = 0 Then SaveNumFactor = 1
        If SaveOneInTen = 0 Or Int(CometTime / SaveNumFactor) * SaveNumFactor = CometTime Then
            Color _RGB(255, 0, 0): _PrintString (1610, 982), " SAVING SCREEN " + Str$(SaveTheImage)
        Else
            Color _RGB(100, 0, 0): _PrintString (1610, 982), " SAVING SCREEN " + Str$(SaveTheImage)
        End If
    Else _PrintString (1610, 982), " 'P' Save Screen"
    End If

    Color _RGB(255, 255, 255), _RGB(0, 0, 0)

    _Display

    '   *************************************************  END OF MAIN ROUTINES OTHER THAN READING KEY PRESSES    *******************************************************



    If Scene$ = "Encke" Then
        If CometFileName$ = "D:/CometEnckeImages3/" Or CometFileName$ = "D:/CometEnckeImages2/" Or CometFileName$ = "D:/CometEnckeImages1/" Then
            TimetobePrinted = Int(CometTime150 * 10) / 10
            If SimulationSlowFactor > 1 Then TimetobePrinted = Int((CometTime150 / SimulationSlowFactor) * 10) / 10

            If Int(TimetobePrinted / 25) * 25 = TimetobePrinted And PreviousTimetobePrinted <> TimetobePrinted Then ' Print screen every 25 years, with 1 year = 877.737 comet time counts
                PreviousTimetobePrinted = TimetobePrinted
                '            If Int(CometTime / (21943)) * 21943 = CometTime Then ' Print screen every 25 years, with 1 year = 877.737 comet time counts
                '        SimulationSlowFactor divides the time by itself, so for Encke, its 877.737*100 to get 100 years
                Color _RGB(100, 0, 0): _PrintString (1610, 982), " SAVING SCREEN " + Str$(SaveTheImage)
                Beep
                desktop& = _ScreenImage(2, 2, 1777, 999) ' Co-ordinates relate to image on computer monitor not to coordinates in QB64 window.
                CometFileNameNow$ = CometFileName$ + LTrim$(Str$(CometTime))
                SaveImage desktop&, CometFileNameNow$ 'saves entire program screen as "screenshot.bmp"
                _FreeImage desktop&
            End If
        End If
    End If

    If SaveTheImage > 0 Then
        SaveNumFactor = SaveOneInTen: If SaveNumFactor = 0 Then SaveNumFactor = 1
        If SaveOneInTen = 0 Or Int(CometTime / SaveNumFactor) * SaveNumFactor = CometTime Then
            SaveTheImage = SaveTheImage - 1
            desktop& = _ScreenImage(2, 2, 1777, 999) ' Co-ordinates relate to image on computer monitor not to coordinates in QB64 window.
            CometFileNameNow$ = CometFileName$ + LTrim$(Str$(CometTime))
            SaveImage desktop&, CometFileNameNow$ 'saves entire program screen as "screenshot.bmp"
            _FreeImage desktop&
        End If
    End If


    Skipheader:

    ' PAUSE AND RESTART DIFFERENT SCENE and move ZOOM with cursor keys
    RunProgram2$ = InKey$


    CheckKeyBoard:

    If RunProgram2$ <> "" Then
        A$ = RunProgram2$

        Call CheckifChangeScene(A$, RunProgram$)
        If RunProgram$ = "StartOver" Then GoTo BeginProgram
        If RunProgram$ = "StartOverMenu" Then GoTo DisplayMenu
        RunProgram$ = RunProgram2$
        ascii2byte = 0
        asciinumber = Asc(RunProgram$)
        If Len(RunProgram$) > 1 Then ascii2byte = Asc(RunProgram$, 2) ' read second character of 2 byte codes such as function keys and cursor keys


        If ascii2byte <> 0 Then
            Select Case ascii2byte
                Case 82: RemoveNonEarthCrossing$ = "No" ' Stop Removing all non-Earth Crossing particles if INS key pressed
                Case 83: If RemoveNonEarthCrossing$ <> "Yes" Then RemoveNonEarthCrossing$ = "Yes" Else RemoveNonEarthCrossing$ = "No" ' Toggle Removing all non-Earth Crossing particles if DEL key pressed
                    A$ = "": RunProgram2$ = ""
                Case Else: Call CheckFunctionandCursorKeys(ascii2byte, Scene$, RunProgram$) ' function and cursor keys
                    If RunProgram$ = "StartOver" Then Cls: GoTo BeginProgram
                    If RunProgram$ = "StartOverMenu" Then GoTo DisplayMenu
            End Select
        End If

        If Scene$ = "SwiftTuttle Impact at Start" Then
            If CometTime < 20000 Then '  prevent accidental re-start by pressing the number keys after 100 years of simulation. Approx 200 comettimes per year = 200*100 = 20,000 comettimes for 100 years.
                Select Case asciinumber
                    Case 48: MaxYNumber = 16.67: RunProgram$ = "StartOver": GoTo BeginProgram ' 0 pressed
                    Case 49: MaxYNumber = 33.34: RunProgram$ = "StartOver": GoTo BeginProgram ' 1 pressed
                    Case 50: MaxYNumber = 66.67: RunProgram$ = "StartOver": GoTo BeginProgram ' 2 pressed
                    Case 51: MaxYNumber = 100: RunProgram$ = "StartOver": GoTo BeginProgram ' 3 pressed
                    Case 52: MaxYNumber = 133.34: RunProgram$ = "StartOver": GoTo BeginProgram ' 4 pressed
                    Case 53: MaxYNumber = 166.67: RunProgram$ = "StartOver": GoTo BeginProgram ' 5 pressed
                    Case 54: MaxYNumber = 200: RunProgram$ = "StartOver": GoTo BeginProgram ' 6 pressed
                    Case 55: MaxYNumber = 233.34: RunProgram$ = "StartOver": GoTo BeginProgram ' 7 pressed
                    Case 56: MaxYNumber = 266.676: RunProgram$ = "StartOver": GoTo BeginProgram ' 8 pressed
                    Case 57: MaxYNumber = 300: RunProgram$ = "StartOver": GoTo BeginProgram ' 9 pressed
                End Select
            End If
        End If


        If Scene$ = "SwiftTuttle Impact at Start" Or Scene$ = "SwiftTuttle Orbit, outgassing along the orbit" Or Scene$ = "Encke" Then
            Select Case asciinumber
                Case 24 ' Ctrl X
                    Select Case SwiftView$
                        Case "Top": SwiftView$ = "Trio"
                        Case "Trio": SwiftView$ = "RightSide"
                        Case "RightSide": SwiftView$ = "LeftSide"
                        Case "LeftSide": SwiftView$ = "Back"
                        Case "Back": SwiftView$ = "Bottom"
                        Case "Bottom": SwiftView$ = "Front"
                        Case "Front": SwiftView$ = "Top"
                    End Select
                    ShowPaths$ = "No"
                    GoTo DrawSwiftEnckeCometOrbits
                Case 26 ' Ctrl Z
                    Select Case SwiftView$
                        Case "Top": SwiftView$ = "Front"
                        Case "Front": SwiftView$ = "Bottom"
                        Case "Bottom": SwiftView$ = "Back"
                        Case "Back": SwiftView$ = "LeftSide"
                        Case "LeftSide": SwiftView$ = "RightSide"
                        Case "RightSide": SwiftView$ = "Trio"
                        Case "Trio": SwiftView$ = "Top"
                    End Select
                    ShowPaths$ = "No"
                    GoTo DrawSwiftEnckeCometOrbits
                Case 96: ' Pressing the "~`" key changes the displayed colors
                    Select Case MonoColor$
                        Case "Yellow": MonoColor$ = "Green": PresentMonoColor = _RGB(0, 255, 0)
                        Case "White": MonoColor$ = "Yellow": PresentMonoColor = _RGB(255, 255, 0)
                        Case "No": MonoColor$ = "White": PresentMonoColor = _RGB(255, 255, 255)
                        Case "Green": MonoColor$ = "No"
                    End Select
            End Select
        End If


        Select Case asciinumber
            Case 80, 112 ' P=ASCII 80, p = ASC 112,  Ctrl P + CHR$(16) = Ctrl+ P to save images
                desktop& = _ScreenImage(2, 2, 1777, 999) ' Co-ordinates relate to image on computer monitor not to coordinates in QB64 window.
                Call SaveOptions
                If SaveTheImage > 0 Then
                    SaveTheImage = SaveTheImage - 1
                    CometFileNameNow$ = CometFileName$ + LTrim$(Str$(CometTime))
                    SaveImage desktop&, CometFileNameNow$ 'saves entire program screen as "screenshot.bmp"
                End If
                _FreeImage desktop&
            Case 76, 115: '  Press L to make screen larger
                Select Case SimulationScreenSize
                    Case 2
                        Screen _NewImage(900, 506, 32)
                        SimulationScreenSize = 3
                    Case 3
                        Screen _NewImage(1080, 607, 32)
                        SimulationScreenSize = 4
                    Case 4
                        Screen _NewImage(1200, 675, 32)
                        SimulationScreenSize = 5
                    Case 5
                        Screen _NewImage(1200, 675, 32)
                        SimulationScreenSize = 6
                    Case 6
                        Screen _NewImage(1440, 810, 32)
                        SimulationScreenSize = 7
                    Case 7
                        Screen _NewImage(1600, 900, 32)
                        SimulationScreenSize = 8
                    Case 8
                        Screen _NewImage(1776, 999, 32)
                        SimulationScreenSize = 9
                    Case 9
                        _FullScreen _SquarePixels
                        SimulationScreenSize = 10
                End Select
            Case 83, 108: '  Press S to make screen smaller
                Select Case SimulationScreenSize
                    Case 3
                        Screen _NewImage(800, 450, 32)
                        SimulationScreenSize = 2
                    Case 4
                        Screen _NewImage(900, 506, 32)
                        SimulationScreenSize = 3
                    Case 5
                        Screen _NewImage(1080, 607, 32)
                        SimulationScreenSize = 4
                    Case 6
                        Screen _NewImage(1200, 675, 32)
                        SimulationScreenSize = 5
                    Case 7
                        Screen _NewImage(1200, 675, 32)
                        SimulationScreenSize = 6
                    Case 8
                        Screen _NewImage(1440, 810, 32)
                        SimulationScreenSize = 7
                    Case 9
                        Screen _NewImage(1600, 900, 32)
                        SimulationScreenSize = 8
                    Case 10
                        _FullScreen _Off
                        Screen _NewImage(1776, 999, 32)
                        SimulationScreenSize = 9
                End Select
            Case 32
                Select Case Scene$
                    Case "Impact Jupiter then Earth twice at 1.5 and 1.6 years later", "Impact Jupiter, near miss Earth, then impact Earth 8.1 years later", "Impact Jupiter then Earth 10.2 years later", "Impact Jupiter then Earth a year later", "Impact Earth not Jupiter"
                        A$ = "": While A$ = "": A$ = InKey$: Wend
                        GoTo EndSpaceBArPauseinJupiterScenes
                    Case "Encke" ' Just pause, no writing on screen, but stop rotating if rotating
                        Select Case AutoRotate$
                            Case "On": AutoRotate$ = "Hold"
                            Case "Hold": AutoRotate$ = "On"
                        End Select
                    Case "SwiftTuttle Impact at Start", "SwiftTuttle Orbit, outgassing along the orbit"
                        Select Case AutoRotate$
                            Case "On": AutoRotate$ = "Hold"
                            Case "Hold": AutoRotate$ = "On"
                        End Select

                    Case "SwiftTuttle Impact at Start", "SwiftTuttle Orbit, outgassing along the orbit"
                        _PrintString (100, 40), "Change Simulation:"
                        _PrintString (100, 60), "  F1:  Comet Swift Tuttle skip impact from above at 66.55 degrees after impact - Relative Speed 42 km/s"
                        _PrintString (100, 78), "  F2:  Skip from above at 45 degrees, 40 km/sec"
                        _PrintString (100, 96), "  F3:  Overtaking Earth from behind at 10 km/sec"
                        _PrintString (100, 114), "  F4:  Skip from 100 km comet crossing from Sun, 40 km/sec"
                        _PrintString (100, 132), "  F5:  Skip from head on impact such as Halley's comet would do, 70 km/sec"
                        _PrintString (100, 150), "  Ctrl Q:  Simulation of comet Swift Tuttle Hitting Earth then continuing orbit, outgassing along its orbit"
                        _PrintString (100, 168), "  Ctrl W:  Simulation of comet Swift Tuttle only outgassing along its orbit"
                        _PrintString (100, 186), "  Ctrl E:  Simulation of comet hitting Jupiter then Earth 1.5 and 1.6 years later"
                        _PrintString (100, 204), "  Ctrl R:  Simulation of comet hitting Jupiter then Earth 1 year later"
                        _PrintString (100, 204), "  Ctrl T:  Simulation of comet hitting Jupiter then Earth 8 years later"
                        _PrintString (100, 204), "  Ctrl Y:  Simulation of comet hitting Jupiter then Earth 10 years later"
                        _PrintString (100, 222), "  Ctrl A:  Demonstration of many impact angles for various speeds"
                        _PrintString (100, 240), "  F6:  Toggle ON or OFF Outgassing along orbit"
                        _PrintString (100, 258), "  F7:  Toggle ON or OFF the lines showing the comet's present path and orbital path"
                        _PrintString (100, 276), ""
                        If Scene$ = "Encke" Then
                            _PrintString (100, 294), "  F8:  Boost Debris outgassing for one orbit"
                            _PrintString (100, 312), "  F9:  Toggle ON or OFF all Planets' Gravity"
                            _PrintString (100, 330), "  F10: Toggle ON or OFF Show Orbit Paths"
                            _PrintString (100, 348), "  F11: Toggle ON or OFF Autorotation"
                            _PrintString (100, 370), "  F12: Toggle ON or OFF Show Paths"
                            _PrintString (100, 388), ""
                        Else
                            _PrintString (100, 294), "  F8:  Toggle ON or OFF Earth's Gravity"
                            _PrintString (100, 312), "  F9:  Toggle ON or OFF Mar's Gravity"
                            _PrintString (100, 330), "  F10: Toggle ON or OFF Jupiter and Saturn's Gravity"
                            _PrintString (100, 348), "  F11: Toggle ON or OFF Uranus & Neptune's Gravity"
                            _PrintString (100, 370), "  F12: Toggle ON or OFF Show Paths"
                            _PrintString (100, 388), ""
                        End If
                        _PrintString (100, 424), "  Cursor Keys - Change Viewpoint and Zoom (They work best while the program is running)"
                        _PrintString (100, 455), "  Press 0 - 9 to change density of Swift Tuttle Demo - this is not active after 1st orbit"
                        _PrintString (100, 473), "  ~`:  Change Colors of Swift Tuttle demo"
                        _PrintString (100, 508), "  SAVE SCREEN IMAGE to disk: Ctrl P does an immeadiate screen save. P or p without Ctrl call up a save menu."
                        _PrintString (100, 582), "  Simulation Paused. To continue, press SpaceBar.    To end press 'esc'"
                        _Display
                        View (0, 0)-(1776, 999)
                        Window (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, ZoomWindow4)
                    Case Else
                        _PrintString (100, 40), "Change Simulation:"
                        _PrintString (100, 60), "  F1:  Comet Swift Tuttle skip impact from above at 66.55 degrees after impact - Relative Speed 42 km/s"
                        _PrintString (100, 78), "  F2:  Skip from above at 45 degrees, 40 km/sec"
                        _PrintString (100, 96), "  F3:  Overtaking Earth from behind at 10 km/sec"
                        _PrintString (100, 114), "  F4:  Skip from 100 km comet crossing from Sun, 40 km/sec"
                        _PrintString (100, 132), "  F5:  Skip from head on impact such as Halley's comet would do, 70 km/sec"
                        _PrintString (100, 150), "  Ctrl Q:  Simulation of comet Swift Tuttle Hitting Earth then continuing orbit, outgassing along its orbit"
                        _PrintString (100, 168), "  Ctrl W:  Simulation of comet Swift Tuttle only outgassing along its orbit"
                        _PrintString (100, 186), "  Ctrl E:  Simulation of comet hitting Jupiter then Earth 1.5 and 1.6 years later"
                        _PrintString (100, 204), "  Ctrl R:  Simulation of comet hitting Jupiter then Earth 1 year later"
                        _PrintString (100, 204), "  Ctrl T:  Simulation of comet hitting Jupiter then Earth 8 years later"
                        _PrintString (100, 204), "  Ctrl Y:  Simulation of comet hitting Jupiter then Earth 10 years later"
                        _PrintString (100, 222), "  Ctrl A:  Demonstration of many impact angles for various speeds"
                        _PrintString (100, 240), "  F6:  Toggle Comet Diameter from 50 to 300 in steps of 50"
                        _PrintString (100, 258), "  F7:  Toggle ON or OFF the lines showing the comet's present path and orbital path"
                        _PrintString (100, 276), ""
                        _PrintString (100, 294), "  F8:  Shift Earth Tilt from -23.4 to +23.4"
                        _PrintString (100, 312), "  F9:  Rotate Earth Counter-clockwise"
                        _PrintString (100, 330), "  F10: Rotate Earth Clockwise"
                        _PrintString (100, 348), "  F11: Toggle ON or OFF the lines of latitude on the globe at 23.4 tilt"
                        _PrintString (100, 370), "  F12: Toggle ON or OFF the Auto Zooming"
                        _PrintString (100, 388), "  Cursor Keys - Change Viewpoint and Zoom (They work best while the program is running)"
                        _PrintString (100, 406), "  Rectangles on Planet show the locations of Lake Michigan (Blue)"
                        _PrintString (100, 424), "                   and the locations of the Carolina Bays (Orange)"
                        _PrintString (100, 455), "  The Impacted particles from Earth are white for the first 3 km and yellow for the next 4 km"
                        _PrintString (100, 473), "  Earth Particles are shown larger for clarity but are calculated at the same size as comet particles."
                        _PrintString (100, 508), "  SAVE SCREEN IMAGE to disk: Ctrl P does an immeadiate screen save. P or p without Ctrl call up a save menu."
                        _PrintString (100, 582), "  Simulation Paused. To continue, press SpaceBar.    To end press 'esc'"
                        '  *******************************************************************************************
                        If OutGassing$ <> "Yes" Then
                            _PrintString (1200, 544), " Display of Solar System and orbits of the debris after impact"
                            _PrintString (1200, 564), "Red = Original Comet. Teal = Comet Debris. Yellow = Earth Debris"
                            Call DrawCometOrbits
                        End If
                        '  *******************************************************************************************
                        _Display
                        View (0, 0)-(1776, 999)
                        Window (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, ZoomWindow4)
                End Select

                _Display
                RunProgram$ = ""
                While RunProgram$ <> Chr$(32)
                    RunProgram$ = InKey$
                    If RunProgram$ = Chr$(27) Then End ' end program if "Esc" Pressed
                    If RunProgram$ <> "" Then
                        ascii2byte = 0
                        asciinumber = Asc(RunProgram$)
                        If Len(RunProgram$) = 1 Then
                            Select Case asciinumber
                                Case 80, 112 ' P=ASCII 80, p = ASC 112,  Ctrl P + CHR$(16) = Ctrl+ P to save images
                                    SaveDebrisOrbits$ = "Yes"
                                    _Display
                                    Call DrawCometOrbits
                                    _PrintString (800, 914), " Display of Solar System and orbits of the debris after impact"
                                    _PrintString (800, 934), "Red = Original Comet. Teal = Comet Debris. Yellow = Earth Debris"
                                    _Display
                                    Beep
                                    desktop& = _ScreenImage(2, 2, 1777, 999) ' Co-ordinates relate to image on computer monitor not to coordinates in QB64 window.
                                    CometFileNameNow$ = "D:/CometImages/DebrisImage" + LTrim$(Str$(CometTime))
                                    SaveImage desktop&, CometFileNameNow$ 'saves entire program screen as "screenshot.bmp"
                                    _FreeImage desktop&
                                    SaveDebrisOrbits$ = ""
                            End Select
                        End If
                        If Len(RunProgram$) > 1 Then ascii2byte = Asc(RunProgram$, 2) ' read second character of 2 byte codes such as function keys
                        If ascii2byte <> 0 Then
                            Call CheckFunctionandCursorKeys(ascii2byte, Scene$, RunProgram$) ' function and cursor keys
                            If RunProgram$ = "StartOver" Then GoTo BeginProgram
                            If RunProgram$ = "StartOverMenu" Then GoTo DisplayMenu
                            Window (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, ZoomWindow4) ' ratio of 1.7777 = 1920X1080
                            Cls ' redraw without changing locations

                            'Draw planet Earth on grid:
                            For i = 7 To 6371 Step 5
                                EarthColorization = 255 - 100 * i / 6371
                                EarthColorization2 = 165 - 160 * i / 6371
                                Circle (PlanetCenterX, PlanetCenterY), i, _RGB(EarthColorization2, EarthColorization2, EarthColorization)
                            Next i
                            For i = 1 To 6300 '  draw planet particles
                                For j = 1 To 7
                                    Circle (EarthX(i, j), EarthY(i, j)), 15, EarthColor(i, j)
                                Next j
                            Next i
                            For x = 1 To 400
                                For y = 1 To 400
                                    PSet (CometX(x, y), CometY(x, y)), CometColor(x, y)
                                Next y
                            Next x
                            _Display
                        End If
                    End If
                Wend
        End Select
    End If

    EndSpaceBArPauseinJupiterScenes:
    RunProgram$ = ""

Wend

End






Sub SaveImage (image As Long, filename As String)
    bytesperpixel& = _PixelSize(image&)
    If bytesperpixel& = 0 Then Print "Text modes unsupported!": End
    If bytesperpixel& = 1 Then bpp& = 8 Else bpp& = 24
    x& = _Width(image&)
    y& = _Height(image&)
    b$ = "BM????QB64????" + MKL$(40) + MKL$(x&) + MKL$(y&) + MKI$(1) + MKI$(bpp&) + MKL$(0) + "????" + String$(16, 0) 'partial BMP header info(???? to be filled later)
    If bytesperpixel& = 1 Then
        For c& = 0 To 255 ' read BGR color settings from JPG image + 1 byte spacer(CHR$(0))
            cv& = _PaletteColor(c&, image&) ' color attribute to read.
            b$ = b$ + Chr$(_Blue32(cv&)) + Chr$(_Green32(cv&)) + Chr$(_Red32(cv&)) + Chr$(0) 'spacer byte
        Next
    End If
    Mid$(b$, 11, 4) = MKL$(Len(b$)) ' image pixel data offset(BMP header)
    lastsource& = _Source
    _Source image&
    If ((x& * 3) Mod 4) Then padder$ = String$(4 - ((x& * 3) Mod 4), 0)
    For py& = y& - 1 To 0 Step -1 ' read JPG image pixel color data
        r$ = ""
        For px& = 0 To x& - 1
            c& = Point(px&, py&) 'POINT 32 bit values are large LONG values
            If bytesperpixel& = 1 Then r$ = r$ + Chr$(c&) Else r$ = r$ + Left$(MKL$(c&), 3)
        Next px&
        d$ = d$ + r$ + padder$
    Next py&
    _Source lastsource&
    Mid$(b$, 35, 4) = MKL$(Len(d$)) ' image size(BMP header)
    b$ = b$ + d$ ' total file data bytes to create file
    Mid$(b$, 3, 4) = MKL$(Len(b$)) ' size of data file(BMP header)
    If LCase$(Right$(filename$, 4)) <> ".bmp" Then ext$ = ".bmp"
    f& = FreeFile
    Open filename$ + ext$ For Output As #f&: Close #f& ' erases an existing file
    Open filename$ + ext$ For Binary As #f&
    Put #f&, , b$
    Close #f&
End Sub




Sub Zooming (WhichZoom)
    ZoomWindow1 = ZoomWindow1 + ZoomFactor(1, WhichZoom)
    ZoomWindow2 = ZoomWindow2 + ZoomFactor(2, WhichZoom)
    ZoomWindow3 = ZoomWindow3 + ZoomFactor(3, WhichZoom)
    ZoomWindow4 = ZoomWindow4 + ZoomFactor(4, WhichZoom)
    TestRatio1 = ZoomWindow4 - ZoomWindow2: TestRatio2 = ZoomWindow3 - ZoomWindow1: WindowFactor = TestRatio2 / TestRatio1
    While WindowFactor > 1.77777
        ZoomWindow1 = ZoomWindow1 + 1
        TestRatio2 = ZoomWindow3 - ZoomWindow1: WindowFactor = TestRatio2 / TestRatio1
    Wend
    While WindowFactor < 1.778
        ZoomWindow1 = ZoomWindow1 - 1
        TestRatio2 = ZoomWindow3 - ZoomWindow1: WindowFactor = TestRatio2 / TestRatio1
    Wend

End Sub




Sub CheckFunctionandCursorKeys (ascii2byte, Scene$, Runprogram$)
    If Scene$ = "SwiftTuttle Impact at Start" Or Scene$ = "SwiftTuttle Orbit, outgassing along the orbit" Or Scene$ = "Encke" Then
        Select Case ascii2byte
            Case 66: 'F8 - Toggle Earth's Gravity
                Select Case Scene$
                    Case "Encke"
                        EnckeDebrisCount = 500
                    Case Else
                        If EarthGravity$ = "On" Then EarthGravity$ = "Off" Else EarthGravity$ = "On"
                End Select
            Case 67: 'F9 - Toggle Mar's Gravity
                Select Case Scene$
                    Case "Encke"
                        Select Case EnckeGravity$
                            Case "On": EnckeGravity$ = "Off": JupiterGravity$ = "Off": SaturnGravity$ = "Off": UranusNeptuneGravity$ = "Off"
                            Case "Off": EnckeGravity$ = "MVEM": JupiterGravity$ = "Off": SaturnGravity$ = "Off": UranusNeptuneGravity$ = "Off"
                            Case "MVEM": EnckeGravity$ = "On": JupiterGravity$ = "On": SaturnGravity$ = "On": UranusNeptuneGravity$ = "On"
                        End Select
                    Case Else
                        If MarsGravity$ = "On" Then
                            MarsGravity$ = "Off": JupiterGravity$ = "Off": SaturnGravity$ = "Off": UranusNeptuneGravity$ = "Off"
                        Else MarsGravity$ = "On": JupiterGravity$ = "On": SaturnGravity$ = "On": UranusNeptuneGravity$ = "On"
                        End If
                End Select
            Case 68: 'F10 - Show orbit paths
                If ShowEnckeOrbits$ = "On" Then ShowEnckeOrbits$ = "Off" Else ShowEnckeOrbits$ = "On"
            Case 133: 'F11 - Autorotate on or off
                Select Case AutoRotate$
                    Case "On": AutoRotate$ = "Off"
                    Case "Off": AutoRotate$ = "On"
                    Case "Hold": AutoRotate$ = "Off"
                    Case Else: AutoRotate$ = "On"
                End Select
            Case 134: ' F12 - Toggle show paths on or off
                If ShowPaths$ <> "Yes" Then ShowPaths$ = "Yes" Else ShowPaths$ = "No"
            Case 64 ' F6 = Toggle Outgassing on or off
                If OutGassing$ = "No" Then OutGassing$ = "Yes" Else OutGassing$ = "No"
        End Select
    Else
        Select Case ascii2byte
            Case 66: ' F8 -  go to 23.4 tilt of earth
                If TiltRotation >= 0 Then
                    TiltofEarth = 23.4: TiltRotation = -1
                Else
                    TiltofEarth = -23.4: TiltRotation = 1 ' F8 -  go to -23.4
                End If
            Case 67: 'F9 rotate Earth clockwise
                TiltRotation = 1: If TiltofEarth > 22 Then TiltRotation = .1
                TiltofEarth = TiltofEarth + TiltRotation + .001
                TiltofEarth = Int(TiltofEarth * 10) / 10
                If TiltofEarth > 23.4 Then TiltofEarth = 23.4
            Case 68: 'F10 rotate Earth counter clockwise
                TiltRotation = -1: If TiltofEarth < -22 Then TiltRotation = -.1
                TiltofEarth = TiltofEarth + TiltRotation + .001
                TiltofEarth = Int(TiltofEarth * 10) / 10
                If TiltofEarth < -23.4 Then TiltofEarth = -23.4
            Case 133: If LinesLatitudeOnOff = 0 Then LinesLatitudeOnOff = 1 Else LinesLatitudeOnOff = 0 ' F11
            Case 134: If AutoZoomOnOff = 0 Then AutoZoomOnOff = 1 Else AutoZoomOnOff = 0 ' F12
            Case 64 ' F6 = Toggle Comet Radius Size, reset comet to new size
                If OutGassing$ <> "Yes" Then ' changing radius mid run kills the simulation totally, therefore not allowed for outgassing simulation
                    ' Set comet shape as pixels of a listed Radius
                    ToggleRadius = ToggleRadius + 25
                    If ToggleRadius > 150 Then ToggleRadius = 25
                    CometRadius = ToggleRadius
                    CometInitialSpeedX = CometSpeedX(150, 150)
                    CometInitialSpeedY = CometSpeedY(150, 150)
                    CometInitialSpeedZ = CometSpeedZ(150, 150)
                    CometStartX = CometX(150, 150)
                    CometStartY = CometY(150, 150)
                    CometStartZ = CometZ(150, 150)
                    For x = 1 To 400
                        For y = 1 To 400
                            CometMass(x, y) = 0
                            w = (x - 150) ^ 2 + (y - 150) ^ 2
                            w = Sqr(w)
                            CometX(x, y) = x - 150 + CometStartX
                            CometY(x, y) = y - 150 + CometStartY
                            CometZ(x, y) = z - 150 + CometStartZ
                            If w <= CometRadius Then
                                CometColor(x, y) = _RGB(255, x / 6, y / 3)
                                CometSpeedX(x, y) = CometInitialSpeedX
                                CometSpeedY(x, y) = CometInitialSpeedY
                                CometSpeedZ(x, y) = CometInitialSpeedZ
                                CometMass(x, y) = 1
                            End If
                        Next y
                    Next x
                End If
        End Select
    End If
    If Scene$ = "SwiftTuttle Impact at Start" Or Scene$ = "SwiftTuttle Orbit, outgassing along the orbit" Then '  prevent accidental re-start by pressing the number keys after 100 years of simulation. Approx 200 comettimes per year = 200*100 = 20,000 comettimes for 100 years.
        If CometTime < 20000 Then
            Select Case ascii2byte
                Case 59: Scene$ = "Swift Tuttle from above at 66.55 degrees after impact - Relative Speed 42 km/s": Runprogram$ = "StartOver": Exit Sub '  F1 function pressed
                Case 60: Scene$ = "From Above at 45 degrees - Relative Speed 40 km/s": Runprogram$ = "StartOver": Exit Sub '  F2 function pressed
                Case 61: Scene$ = "Overtaking Earth from behind at 10 km/s": Runprogram$ = "StartOver": Exit Sub '  F3 function pressed
                Case 62: Scene$ = "Crossing from Sun 100km comet - Relative Speed 40 km/s": Runprogram$ = "StartOver": Exit Sub '  F4 function pressed
                Case 63: Scene$ = "Head On Impact as if Halley's comet hit - Relative Speed 70 km/s": Runprogram$ = "StartOver": Exit Sub '  F5 function pressed
                Case 17: Scene$ = "SwiftTuttle Impact at Start": Runprogram$ = "StartOver": Exit Sub '  Ctrl  Q pressed
                Case 23: Scene$ = "SwiftTuttle Orbit, outgassing along the orbit": Runprogram$ = "StartOver": Exit Sub '  Ctrl  W pressed
                Case 134: ' F12 - toggle show displays
                    If ShowPaths$ <> "Yes" Then ShowPaths$ = "Yes" Else ShowPaths$ = "No"
            End Select
        End If
    End If

    If Scene$ <> "SwiftTuttle Impact at Start" And Scene$ <> "SwiftTuttle Orbit, outgassing along the orbit" Then
        Select Case ascii2byte
            Case 59: Scene$ = "Swift Tuttle from above at 66.55 degrees after impact - Relative Speed 42 km/s": Runprogram$ = "StartOver": Exit Sub '  F1 function pressed
            Case 60: Scene$ = "From Above at 45 degrees - Relative Speed 40 km/s": Runprogram$ = "StartOver": Exit Sub '  F2 function pressed
            Case 61: Scene$ = "Overtaking Earth from behind at 10 km/s": Runprogram$ = "StartOver": Exit Sub '  F3 function pressed
            Case 62: Scene$ = "Crossing from Sun 100km comet - Relative Speed 40 km/s": Runprogram$ = "StartOver": Exit Sub '  F4 function pressed
            Case 63: Scene$ = "Head On Impact as if Halley's comet hit - Relative Speed 70 km/s": Runprogram$ = "StartOver": Exit Sub '  F5 function pressed

            Case 17: Scene$ = "SwiftTuttle Impact at Start": Runprogram$ = "StartOver": Exit Sub '  Ctrl  Q pressed
            Case 23: Scene$ = "SwiftTuttle Orbit, outgassing along the orbit": Runprogram$ = "StartOver": Exit Sub '  Ctrl  W pressed
            Case 5: Scene$ = "Impact Jupiter then Earth twice at 1.5 and 1.6 years later": Runprogram$ = "StartOver": Exit Sub '  Ctrl  E pressed
            Case 18: Scene$ = "Impact Jupiter then Earth a year later": Runprogram$ = "StartOver": Exit Sub '  Ctrl  R pressed
            Case 20: Scene$ = "Impact Jupiter, near miss Earth, then impact Earth 8.1 years later": Runprogram$ = "StartOver": Exit Sub ' Ctrl T pressed
            Case 21: Scene$ = "Impact Earth not Jupiter": Runprogram$ = "StartOver": Exit Sub ' Ctrl U pressed
            Case 25: Scene$ = "Impact Jupiter then Earth 10.2 years later": Runprogram$ = "StartOver": Exit Sub ' Ctrl Y pressed
        End Select
    End If

    Select Case ascii2byte
        Case 134: ' F12 - toggle show displays
            If ShowPaths$ <> "Yes" Then ShowPaths$ = "Yes" Else ShowPaths$ = "No"
        Case 65: ' F7 toggle path displays
            If CometPAthOnOff = 0 Then CometPAthOnOff = 1 Else CometPAthOnOff = 0
            If ToggleDrawCometCenterPath = 0 Then ToggleDrawCometCenterPath = 1 Else ToggleDrawCometCenterPath = 0

        Case 71 To 81
            ZoomXDiff = ZoomWindow3 - ZoomWindow1
            ZoomYDiff = ZoomWindow4 - ZoomWindow2
            AutoZoomOnOff = 0
            RunImpactProbabilities$ = ""
            Select Case ascii2byte
                Case 71 '        cursor home
                    ZoomWindow1 = 1440: ZoomWindow2 = -4500: ZoomWindow3 = 28800: ZoomWindow4 = 10890
                    If OutGassing$ = "Yes" Then ZoomWindow1 = -800000000: ZoomWindow2 = -3290000000: ZoomWindow3 = 10000000000: ZoomWindow4 = 3290000000
                    If SkipimpactatStart$ = "Yes" Then ZoomWindow1 = -900000000: ZoomWindow2 = -1940000000: ZoomWindow3 = 9000000000: ZoomWindow4 = 3640000000
                    If Scene$ = "SwiftTuttle Impact at Start" Or Scene$ = "SwiftTuttle Orbit, outgassing along the orbit" Then ZoomWindow1 = -900000000: ZoomWindow2 = -1940000000: ZoomWindow3 = 9000000000: ZoomWindow4 = 3640000000
                    If Scene$ = "Demonstration of impact probabilities" Then ZoomWindow1 = -60500: ZoomWindow2 = -69300: ZoomWindow3 = 206000: ZoomWindow4 = 74580
                    If Scene$ = "Encke" Then ZoomWindow1 = -405000000: ZoomWindow2 = -364500000: ZoomWindow3 = 891000000: ZoomWindow4 = 364500000
                    If Scene$ = "Encke" And SwiftView$ = "Trio" Then ZoomWindow1 = -700000000: ZoomWindow2 = -337400000: ZoomWindow3 = 854000000: ZoomWindow4 = 537400000
                    If InStr(Scene$, "Impact Jupiter") > 0 Then ZoomWindow1 = -4800000000: ZoomWindow2 = -2700000000: ZoomWindow3 = 4800000000: ZoomWindow4 = 2700000000
                    If Scene$ = "Impact Earth not Jupiter" Then ZoomWindow1 = -4800000000: ZoomWindow2 = -2700000000: ZoomWindow3 = 4800000000: ZoomWindow4 = 2700000000
                Case 80 '        cursor key up
                    ZoomWindow4 = ZoomWindow4 + ZoomYDiff * .05
                    ZoomWindow2 = ZoomWindow2 + ZoomYDiff * .05
                Case 73 '        cursor key page up
                    ZoomWindow1 = ZoomWindow1 + ZoomXDiff * .25
                    ZoomWindow2 = ZoomWindow2 + ZoomYDiff * .25
                    ZoomWindow3 = ZoomWindow3 - ZoomXDiff * .25
                    ZoomWindow4 = ZoomWindow4 - ZoomYDiff * .25
                Case 72 '        cursor key down
                    ZoomWindow4 = ZoomWindow4 - ZoomYDiff * .05
                    ZoomWindow2 = ZoomWindow2 - ZoomYDiff * .05
                Case 81 '        cursor key page down
                    ZoomWindow1 = ZoomWindow1 - ZoomXDiff * .25
                    ZoomWindow2 = ZoomWindow2 - ZoomYDiff * .25
                    ZoomWindow3 = ZoomWindow3 + ZoomXDiff * .25
                    ZoomWindow4 = ZoomWindow4 + ZoomYDiff * .25
                Case 75 '        cursor key left
                    ZoomWindow1 = ZoomWindow1 + ZoomXDiff * .05
                    ZoomWindow3 = ZoomWindow3 + ZoomXDiff * .05
                Case 77 '        cursor key left
                    ZoomWindow1 = ZoomWindow1 - ZoomXDiff * .05
                    ZoomWindow3 = ZoomWindow3 - ZoomXDiff * .05
                Case 79 ' Cursor End
                    ZoomWindow1 = -43740: ZoomWindow2 = -132000: ZoomWindow3 = 445477: ZoomWindow4 = 143198
                    If Scene$ = "SwiftTuttle Impact at Start" Or Scene$ = "SwiftTuttle Orbit, outgassing along the orbit" Or Scene$ = "Encke" Then
                        If ZoomedtoComet$ = "No" Then
                            ZoomedtoComet$ = "Yes"
                            Select Case SwiftView$
                                Case "Top"
                                    If AutoRotate$ = "Off" Then
                                        ZoomWindow1 = CometX(150, 150) - 990000000: ZoomWindow2 = CometY(150, 150) - 557000000: ZoomWindow3 = CometX(150, 150) + 990000000: ZoomWindow4 = CometY(150, 150) + 557000000
                                    Else
                                        ZoomWindow1 = CometX(150, 150) - 990000000: ZoomWindow2 = CometY(150, 150) * Sin(Radian(ViewAngle)) + CometZ(150, 150) * Cos(Radian(ViewAngle)) - 557000000
                                        ZoomWindow3 = CometX(150, 150) + 990000000: ZoomWindow4 = CometY(150, 150) * Sin(Radian(ViewAngle)) + CometZ(150, 150) * Cos(Radian(ViewAngle)) + 557000000
                                        ' PSet (startX, startY * Sin(Radian(ViewAngle)) + startZ * Cos(Radian(ViewAngle))), _RGB(0, 255, 0)
                                    End If
                                Case "Front": ZoomWindow1 = CometX(150, 150) - 990000000: ZoomWindow2 = CometZ(150, 150) - 557000000: ZoomWindow3 = CometX(150, 150) + 990000000: ZoomWindow4 = CometZ(150, 150) + 557000000
                                Case "Bottom": ZoomWindow1 = CometX(150, 150) - 990000000: ZoomWindow2 = CometY(150, 150) - 557000000: ZoomWindow3 = CometX(150, 150) + 990000000: ZoomWindow4 = CometY(150, 150) + 557000000
                                Case "Back": ZoomWindow1 = CometX(150, 150) - 990000000: ZoomWindow2 = -CometZ(150, 150) - 557000000: ZoomWindow3 = CometX(150, 150) + 990000000: ZoomWindow4 = -CometZ(150, 150) + 557000000
                                Case "LeftSide": ZoomWindow1 = CometZ(150, 150) - 990000000: ZoomWindow2 = CometY(150, 150) - 557000000: ZoomWindow3 = CometZ(150, 150) + 990000000: ZoomWindow4 = CometY(150, 150) + 557000000
                                Case "RightSide": ZoomWindow1 = -CometZ(150, 150) - 990000000: ZoomWindow2 = CometY(150, 150) - 557000000: ZoomWindow3 = -CometZ(150, 150) + 990000000: ZoomWindow4 = CometY(150, 150) + 557000000
                            End Select
                        Else
                            ZoomWindow1 = -990000000: ZoomWindow2 = -557000000: ZoomWindow3 = 990000000: ZoomWindow4 = 557000000 ' Center on Sun = 0,0 co-ordinates

                            ZoomedtoComet$ = "No"
                            If Scene$ = "Demonstration of impact probabilities" Then ZoomWindow1 = -160000: ZoomWindow2 = -112000: ZoomWindow3 = 256000: ZoomWindow4 = 120080
                        End If
                    End If
                    If InStr(Scene$, "Impact Jupiter") > 0 Or Scene$ = "Impact Earth not Jupiter" Then ZoomWindow1 = -960000000: ZoomWindow2 = -540000000: ZoomWindow3 = 960000000: ZoomWindow4 = 540000000

            End Select
            Cls
    End Select
    Window (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, ZoomWindow4) ' ratio of 1.7777 = 1920X1080
    _Display

End Sub




Sub DrawCometCenterPath
    pointstoDraw = 1
    PointsDrawn = 1

    If Scene$ = "Impact Earth not Jupiter" Then
        'GSun = 6.67408 * 10 ^ -11 * 1.9891 X 10^30  in meters
        'GSun = 6.67408 * 10 ^ -20 * 1.9891 X 10^30  in km
        SunMass = 1.9891 * 10 ^ 30 ' mass of Sun in kg
        GravityConstantHere = 6.67408 * 10 ^ -20 ' km^3/kg s^2     NOTE G is in km here but in meters in the rest of the program
        GSunHere = GravityConstantHere * SunMass

        startX = CometX(150, 150)
        startY = CometY(150, 150)
        startZ = CometZ(150, 150)

        CometPathSpeedX = CometSpeedX(150, 150) / 1000 ' convert to km/s instead of m/s
        CometPathSpeedY = CometSpeedY(150, 150) / 1000
        CometPathSpeedZ = CometSpeedZ(150, 150) / 1000
        PointsTotal = 10000: Pointfreq = 100
        While pointstoDraw < PointsTotal ' all factors are in km here, not Meters
            DistanceC = Sqr(startX ^ 2 + startY ^ 2 + startZ ^ 2)
            EAcc = (GSunHere / (DistanceC ^ 2)) ' EAcc is in km/sec^2
            ' SunZoomFactor changes it from 1 second per calculation to increment in days at a time, not seconds but is assuming the speeds are in m/sec not km/sec so divide by 1000
            CometPathSpeedX = CometPathSpeedX + (EAcc / DistanceC) * (SunCenterX - startX) * SunZoomFactor / 1000
            CometPathSpeedY = CometPathSpeedY + (EAcc / DistanceC) * (SunCenterY - startY) * SunZoomFactor / 1000
            CometPathSpeedZ = CometPathSpeedZ + (EAcc / DistanceC) * (SunCenterZ - startZ) * SunZoomFactor / 1000
            startX = startX + CometPathSpeedX * SpeedUpFactor * 1000
            startY = startY + CometPathSpeedY * SpeedUpFactor * 1000
            startZ = startZ + CometPathSpeedZ * SpeedUpFactor * 1000
            pointstoDraw = pointstoDraw + 1
            If Int(pointstoDraw / Pointfreq) * Pointfreq = pointstoDraw Then Circle (startX, startY), 2000000, _RGB(255, 255, 255)
            '            Locate 10, 10: Print "X: ", startX
            '            Locate 11, 10: Print "Acc:", EAcc
            '            Locate 12, 10: Print "PathSpeedX: ", CometPathSpeedX
            '            Locate 13, 10: Print "GSunHere: ", GSunHere
            '            Locate 14, 10: Print "DistanceC^2: ", DistanceC ^ 2

        Wend
        Exit Sub
    End If



    Select Case InStr(Scene$, "Jupiter")
        Case 0
            startX = DrawPathstartX
            startY = DrawPathstartY
            startZ = DrawPathstartZ
            '            startX = CometX(150, 150)
            '            startY = CometY(150, 150)
            '            startZ = CometZ(150, 150)
            CometPathSpeedX = DrawPathCometSpeedX
            CometPathSpeedY = DrawPathCometSpeedY
            CometPathSpeedZ = DrawPathCometSpeedZ
            '            CometPathSpeedX = CometSpeedX(150, 150)
            '            CometPathSpeedY = CometSpeedY(150, 150)
            '            CometPathSpeedZ = CometSpeedZ(150, 150)
            Select Case Scene$
                Case "Encke", "SwiftTuttle Impact at Start", "SwiftTuttle Orbit, outgassing along the orbit"
                    PointsTotal = 25000: Pointfreq = 10
                    If Scene$ = "Encke" Then PointsTotal = 600: Pointfreq = 4
                    If SimulationSlowFactor > 1 Then PointsTotal = PointsTotal * SimulationSlowFactor: Pointfreq = Pointfreq * SimulationSlowFactor
                    While pointstoDraw < PointsTotal
                        Distance = (startX * startX + startY * startY + startZ * startZ) ^ 0.5
                        SpeedUpPath = 1
                        If Scene$ <> "Encke" Then
                            If Distance > 200000000 Then SpeedUpPath = 2
                            If Distance > 400000000 Then SpeedUpPath = 5
                            SpeedUpPath = 1
                        End If
                        SunAcceleration = (GSun / (Distance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
                        AccX = (SunAcceleration / Distance) * (SunCenterX - startX) * SunZoomFactor * SpeedUpPath ' Force towards Sun = Fg = M1M2G/r^2. Force along X axis = Fg Sin(angle), and Sin (angle) = opposite/hypotenuse   = Length of X component / distance
                        AccY = (SunAcceleration / Distance) * (SunCenterY - startY) * SunZoomFactor * SpeedUpPath
                        AccZ = (SunAcceleration / Distance) * (SunCenterZ - startZ) * SunZoomFactor * SpeedUpPath
                        CometPathSpeedX = CometPathSpeedX + AccX
                        CometPathSpeedY = CometPathSpeedY + AccY
                        CometPathSpeedZ = CometPathSpeedZ + AccZ
                        startX = startX + CometPathSpeedX * SpeedUpFactor * SpeedUpPath
                        startY = startY + CometPathSpeedY * SpeedUpFactor * SpeedUpPath
                        startZ = startZ + CometPathSpeedZ * SpeedUpFactor * SpeedUpPath

                        pointstoDraw = pointstoDraw + 1 * SpeedUpPath
                        PointsDrawn = PointsDrawn + 1
                        PointsDrawnFactor = 30: If Scene$ = "Encke" Then PointsDrawnFactor = 10

                        If Int(PointsDrawn / PointsDrawnFactor) * PointsDrawnFactor = PointsDrawn Then
                            Select Case SwiftView$
                                Case "Top"
                                    If AutoRotate$ = "Off" Then
                                        PSet (startX, startY), _RGB(0, 255, 0): 'Circle (startX, startY), 1000000, _RGB(255, 255, 0)
                                    Else
                                        PSet (startX, startY * Sin(Radian(ViewAngle)) + startZ * Cos(Radian(ViewAngle))), _RGB(0, 255, 0)
                                    End If
                                Case "Front": PSet (startX, startZ), _RGB(0, 255, 0)
                                Case "Bottom": PSet (startX, -startY), _RGB(0, 255, 0)
                                Case "Back": PSet (startX, -startZ), _RGB(0, 255, 0)
                                Case "LeftSide": PSet (startZ, startY), _RGB(0, 255, 0)
                                Case "RightSide": PSet (-startZ, startY), _RGB(0, 255, 0)
                                Case "Trio"
                                    PSet (startX, startY + 200000000), _RGB(0, 255, 0): 'Circle (startX, startY), 1000000, _RGB(255, 255, 0)
                                    PSet (startX, startZ - 200000000), _RGB(0, 255, 0)
                                    PSet (-startZ - 500000000, startY + 200000000), _RGB(0, 255, 0)
                            End Select
                        End If

                    Wend

                Case Else
                    PointsTotal = 4000: Pointfreq = 10
                    If OutGassing$ = "Yes" Then PointsTotal = 50000: Pointfreq = 100
                    While pointstoDraw < PointsTotal
                        Distance = Sqr((startX - PlanetCenterX) ^ 2 + (startY - PlanetCenterY) ^ 2)
                        EAcc = (GEarth / (Distance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
                        EAcc = EAcc * SunZoomFactor
                        CometPathSpeedX = CometPathSpeedX + (EAcc / Distance) * (PlanetCenterX - startX)
                        CometPathSpeedY = CometPathSpeedY + (EAcc / Distance) * (PlanetCenterY - startY)
                        CometPathSpeedZ = CometPathSpeedZ + (EAcc / Distance) * (PlanetCenterZ - startZ)
                        startX = startX + CometPathSpeedX * SpeedUpFactor
                        startY = startY + CometPathSpeedY * SpeedUpFactor
                        startZ = startZ + CometPathSpeedZ * SpeedUpFactor
                        startRotate = startY * Sin(Radian(ViewAngle) + startZ * Cos(Radian(ViewAngle)))
                        pointstoDraw = pointstoDraw + 1

                        If Int(pointstoDraw / Pointfreq) * Pointfreq = pointstoDraw Then
                            Select Case SwiftView$
                                Case "Top"
                                    If AutoRotate$ = "Off" Then
                                        PSet (startX, startY), _RGB(0, 255, 0): 'Circle (startX, startY), 1000000, _RGB(255, 255, 0)
                                    Else
                                        PSet (startX, startRotate), _RGB(0, 255, 0) 'Circle (startX, startY), 1000000, _RGB(255, 255, 0)
                                    End If
                                Case "Front": PSet (startX, startZ), _RGB(0, 255, 0)
                                Case "Bottom": PSet (startX, -startY), _RGB(0, 255, 0)
                                Case "Back": PSet (startX, -startZ), _RGB(0, 255, 0)
                                Case "LeftSide": PSet (startZ, startY), _RGB(0, 255, 0)
                                Case "RightSide": PSet (-startZ, startY), _RGB(0, 255, 0)
                                Case "Trio"
                                    PSet (startX, startY + 200000000), _RGB(0, 255, 0): 'Circle (startX, startY), 1000000, _RGB(255, 255, 0)
                                    PSet (startX, startZ - 200000000), _RGB(0, 255, 0)
                                    PSet (-startZ - 500000000, startY + 200000000), _RGB(0, 255, 0)
                                Case Else: PSet (startX, startY), _RGB(0, 255, 0)
                            End Select
                        End If
                    Wend
            End Select
        Case Else '  Jupiter calculations
            startX = CometX(150, 150)
            startY = CometY(150, 150)
            startZ = CometZ(150, 150)

            CometPathSpeedX = CometSpeedX(150, 150)
            CometPathSpeedY = CometSpeedY(150, 150)
            CometPathSpeedZ = CometSpeedZ(150, 150)
            PointsTotal = 10000: Pointfreq = 100
            While pointstoDraw < PointsTotal
                Distance = Sqr((startX - SunCenterX) ^ 2 + (startY - SunCenterY) ^ 2)
                EAcc = (GSun / (Distance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
                EAcc = EAcc * SunZoomFactor
                CometPathSpeedX = CometPathSpeedX + (EAcc / Distance) * (SunCenterX - startX)
                CometPathSpeedY = CometPathSpeedY + (EAcc / Distance) * (SunCenterY - startY)
                CometPathSpeedZ = CometPathSpeedZ + (EAcc / Distance) * (SunCenterZ - startZ)
                startX = startX + CometPathSpeedX * SpeedUpFactor
                startY = startY + CometPathSpeedY * SpeedUpFactor
                startZ = startZ + CometPathSpeedZ * SpeedUpFactor
                pointstoDraw = pointstoDraw + 1
                If Int(pointstoDraw / Pointfreq) * Pointfreq = pointstoDraw Then Circle (startX, startY), 2000000, _RGB(255, 255, 255)
            Wend
    End Select
End Sub



' SIN(Radian(degrees)) ranges from -1 to +1 with 0 at zero and 180 angle, 1 at 90 degrees, -1 at 270 degrees


Function Degree (radians)
    Degree = radians * 180 / (4 * Atn(1))
End Function

Function Radian (degrees)
    Radian = degrees * (4 * Atn(1)) / 180
End Function


Function ARCCOT (x) ' Inverse CoTangent
    ARCCOT = (2 * Atn(1)) - Atn(x)
End Function

'       SIN (function) returns the sine of a radian angle.
'The TAN function returns the ratio of SINe to COSine or tangent value of an angle measured in radians.
'Syntax:
'             tangent! = TAN(radian_angle!)


Function ARCSIN (x) 'Inverse Sine
    If Abs(x) = 1 Then ARCSIN = 1.57079633: Exit Function
    If Abs(x) < 1 Then ARCSIN = Atn(x / Sqr(1 - (x * x))) Else ARCSIN = 0
End Function

Function ARCCOS (x) ' Inverse Cosine
    If Abs(x) = 1 Then ARCCOS = 3.141592654: Exit Function ' Pi
    If Abs(x) < 1 Then ARCCOS = (2 * Atn(1)) - Atn(x / Sqr(1 - x * x)) Else Beep
End Function



Sub DrawCometOrbits ' For F1 to F5 displays when space bar prssed to show debris orbits
    Dim Vector As Double
    If SaveDebrisOrbits$ <> "Yes" Then
        View (1150, 200)-(1750, 537), _RGB(0, 0, 0), _RGB(100, 100, 50)
        Window (-1400000, -300000)-(400000, 300000)
    Else
        View (0, 0)-(1776, 999), _RGB(0, 0, 0), _RGB(100, 100, 50)
        Window (-1400000, -300000)-(400000, 300000)
        Cls ' redraw without changing locations
        _Display
    End If
    '    CIRCLE (-350000, 0), 500000, _RGB(0, 0, 255), , , .25 ' similar to a comet
    '    CIRCLE (-350000, 0), 500000, _RGB(250, 255, 0), , , 5.25 ' vertical
    '   CIRCLE (-350000, 0), 500000, _RGB(0, 255, 0), , , 0 ' horizontal

    ' CIRCLE [STEP](column, row), radius%, [drawColor%][, startRadian!, stopRadian!] [, aspect!]
    '    FOR i = 0 TO 100
    '        CIRCLE (PlanetCenterX, PlanetCenterY), 149600, _RGB(0, 255, 0), , , i / 8
    '    NEXT i

    ' CometOrbitSemiMajor = (GSun / ((GSun2 / 149.6) - ((29.79 + EarthSpeedX(i, j)) * 1000) ^ 2)) * 1000 ' the 1000 is to scale this to the present window settings in millions of km
    ' Calculate speed of comet based on its semi major axis.  Units used in this program for convienence are a mix of meters, km and millions of km
    ' v = SQR((GM/A)(2A/R-1)  with M=mass of sun, R=distance from sun, A= semi major axis.
    ' so revising that, one gets that A = GM/(2GM/R - V^2)
    '   GSun = 6.67408 * 1.9891 * 10 ^ 10 ' expressed in km
    '   GSun2 = 2 * GSun
    '   V is in METERS not km for the above formula
    '   Earth Orbit, Comet and EarthSpeeds are in km/s and needs to be uped by 1000
    '   Resulting number is related to Earth orbit radius of 149.6 which is in millions of km and needs to be upped bny 1000 for ploting on grid
    '
    ' Distance and velocity change depending on impact scene
    ' so A = GSun / (GSun2/R - V^2)
    HowManyToShow = 8
    Select Case Scene$
        Case "Overtaking Earth from behind at 10 km/s" '  Main change is forward speed, distance from sun remains at Earth orbit  VIEW FROM ABOVE
            HowManyToShow = 8
        Case "From Above at 45 degrees - Relative Speed 40 km/s"
            HowManyToShow = 4
        Case "Head On Impact as if Halley's comet hit - Relative Speed 70 km/s"
            HowManyToShow = 4
        Case "Crossing from Sun 100km comet - Relative Speed 40 km/s"
            HowManyToShow = 8
        Case "Swift Tuttle from above at 66.55 degrees after impact - Relative Speed 42 km/s"
            HowManyToShow = 4
    End Select


    'DRAW COMET ORBIT

    DisplayEarthBits:
    CometDisplayNumber = 0
    For i = 1 To 7000
        For j = 1 To 7
            If EarthSpeedX(i, j) > 0 Then
                CometDisplayNumber = CometDisplayNumber + 1
                If CometDisplayNumber = HowManyToShow Then
                    CometDisplayNumber = 0
                    Select Case Scene$
                        Case "Overtaking Earth from behind at 10 km/s", "Head On Impact as if Halley's comet hit - Relative Speed 70 km/s" '  Main change is forward speed, distance from sun remains at Earth orbit  VIEW FROM ABOVE
                            CometOrbitSemiMajor = (GSun / ((GSun2 / 149.6) - ((29.79 + EarthSpeedX(i, j)) * 1000) ^ 2)) * 1000 ' the 1000 is to scale this to the present window settings
                            ShiftAxis = -CometOrbitSemiMajor + 149600
                            If CometOrbitSemiMajor > 0 Then Circle (ShiftAxis, 0), CometOrbitSemiMajor, _RGB(155, 155, 0), , , .5
                        Case "Crossing from Sun 100km comet - Relative Speed 40 km/s"
                            Vector = Sqr(EarthSpeedX(i, j) ^ 2 + 29.79 ^ 2 + EarthSpeedY(i, j) ^ 2)
                            CometOrbitSemiMajor = (GSun / ((GSun2 / 149.6) - (Vector * 1000) ^ 2)) * 1000 ' the 1000 is to scale this to the present window settings
                            ShiftFactor = 0.4
                            If CometOrbitSemiMajor > 1000000 Then ShiftFactor = ShiftFactor * 1000000 / CometOrbitSemiMajor
                            ShiftAxis = -CometOrbitSemiMajor * ShiftFactor + 10000 ' shift to Earth's orbit on this image which is left and down
                            ShiftUp = -CometOrbitSemiMajor * .29 + 100000 * ShiftFactor
                            If CometOrbitSemiMajor > 0 And CometOrbitSemiMajor < 5000000 Then Circle (ShiftAxis, ShiftUp), CometOrbitSemiMajor, _RGB(155, 155, 0), , , .5
                        Case "Swift Tuttle from above at 66.55 degrees after impact - Relative Speed 42 km/s", "From Above at 45 degrees - Relative Speed 40 km/s"
                            Vector = Sqr(EarthSpeedX(i, j) ^ 2 + EarthSpeedY(i, j) ^ 2 + 29.79 ^ 2)
                            CometOrbitSemiMajor = (GSun / ((GSun2 / 149.6) - (Vector * 1000) ^ 2)) * 1000 ' the 1000 is to scale this to the present window settings
                            ShiftAxis = -CometOrbitSemiMajor + 149600
                            If CometOrbitSemiMajor > 0 Then Circle (ShiftAxis, 0), CometOrbitSemiMajor, _RGB(155, 155, 0), , , .5
                    End Select
                End If
            End If
        Next j
    Next i


    DisplayCometBits:
    CometDisplayNumber = 0
    For i = 1 To 400
        For j = 1 To 400
            If CometMass(i, j) > 1 Then
                CometDisplayNumber = CometDisplayNumber + 1
                If CometDisplayNumber = 2 Then
                    CometDisplayNumber = 0
                    Select Case Scene$
                        Case "SwiftTuttle Impact at Start", "SwiftTuttle Orbit, outgassing along the orbit", "Encke"
                            CometOrbitSemiMajor = (GSun / ((GSun2 / 149.6) - ((29.79 + CometSpeedX(i, j)) * 1000) ^ 2)) * 1000 ' the 1000 is to scale this to the present window settings
                            ShiftAxis = -CometOrbitSemiMajor + 149600
                            If CometOrbitSemiMajor > 0 Then Circle (ShiftAxis, 0), CometOrbitSemiMajor, _RGB(0, 155, 0), , , .5
                        Case "Overtaking Earth from behind at 10 km/s", "Head On Impact as if Halley's comet hit - Relative Speed 70 km/s" '  Main change is forward speed, distance from sun remains at Earth orbit  VIEW FROM ABOVE
                            CometOrbitSemiMajor = (GSun / ((GSun2 / 149.6) - ((29.79 + CometSpeedX(i, j)) * 1000) ^ 2)) * 1000 ' the 1000 is to scale this to the present window settings
                            ShiftAxis = -CometOrbitSemiMajor + 149600
                            If CometOrbitSemiMajor > 0 Then Circle (ShiftAxis, 0), CometOrbitSemiMajor, _RGB(0, 155, 0), , , .5
                        Case "Crossing from Sun 100km comet - Relative Speed 40 km/s"
                            Vector = Sqr(CometSpeedX(i, j) ^ 2 + CometSpeedY(i, j) ^ 2 + 29.79 ^ 2)
                            CometOrbitSemiMajor = (GSun / ((GSun2 / 149.6) - (Vector * 1000) ^ 2)) * 1000 ' the 1000 is to scale this to the present window settings
                            ShiftFactor = 0.4
                            If CometOrbitSemiMajor > 1000000 Then ShiftFactor = ShiftFactor * 1000000 / CometOrbitSemiMajor
                            ShiftAxis = -CometOrbitSemiMajor * ShiftFactor + 10000 ' shift to Earth's orbit on this image which is left and down
                            ShiftUp = -CometOrbitSemiMajor * .29 + 100000 * ShiftFactor
                            If CometOrbitSemiMajor > 0 And CometOrbitSemiMajor < 5000000 Then Circle (ShiftAxis, ShiftUp), CometOrbitSemiMajor, _RGB(0, 155, 155), , , .5
                        Case "Swift Tuttle from above at 66.55 degrees after impact - Relative Speed 42 km/s", "From Above at 45 degrees - Relative Speed 40 km/s"
                            Vector = Sqr(CometSpeedX(i, j) ^ 2 + CometSpeedY(i, j) ^ 2 + 29.79 ^ 2)
                            CometOrbitSemiMajor = (GSun / ((GSun2 / 149.6) - (Vector * 1000) ^ 2)) * 1000 ' the 1000 is to scale this to the present window settings
                            ShiftAxis = -CometOrbitSemiMajor + 149600
                            If CometOrbitSemiMajor > 0 Then Circle (ShiftAxis, 0), CometOrbitSemiMajor, _RGB(0, 155, 155), , , .5
                    End Select
                End If
            End If
        Next j
    Next i


    DisplayEndBits:

    Select Case Scene$
        Case "SwiftTuttle Impact at Start", "SwiftTuttle Orbit, outgassing along the orbit", "Encke"
            Circle (0, 0), 10000, _RGB(0, 255, 255) '  Earth
            CometOrbitSemiMajor = (GSun / ((GSun2 / 149.6) - ((29.79 + CometSpeedX(150, 150)) * 1000) ^ 2)) * 1000 ' the 1000 is to scale this to the present window settings
            ShiftAxis = -CometOrbitSemiMajor + 149600
            Circle (ShiftAxis, 0), CometOrbitSemiMajor, _RGB(255, 0, 0), , , .5 ' Comet

        Case "Overtaking Earth from behind at 10 km/s", "Head On Impact as if Halley's comet hit - Relative Speed 70 km/s" '  Main change is forward speed, distance from sun remains at Earth orbit  VIEW FROM ABOVE
            Circle (0, 0), 5000, _RGB(255, 255, 0) '  SUN
            Circle (0, 0), 57910, _RGB(150, 50, 55) ' Mercury orbit
            Circle (0, 0), 108200, _RGB(150, 150, 155) ' Venus orbit
            Circle (0, 0), 149600, _RGB(0, 0, 255) ' Earth orbit
            Circle (0, 0), 228000, _RGB(255, 100, 100) ' Mars orbit
            Circle (0, 0), 778000, _RGB(100, 255, 100) ' Jupiter orbit
            Circle (-730000, 160000), 28000, _RGB(100, 100, 100), , , .1 ' Jupiter
            Circle (-730000, 160000), 28000, _RGB(255, 100, 100), , , .3 ' Jupiter
            Circle (-730000, 160000), 28000, _RGB(200, 200, 100), , , .5 ' Jupiter
            Circle (-730000, 160000), 28000, _RGB(255, 100, 100), , , .8 ' Jupiter
            Circle (-730000, 160000), 28000, _RGB(255, 255, 100) ' Jupiter
            Circle (0, 0), 1434000, _RGB(100, 185, 100) ' Saturn orbit
            Circle (-1360000, 270000), 5000, _RGB(255, 255, 100) ' Saturn
            Circle (-1360000, 270000), 10000, _RGB(255, 255, 100) ' Saturn
            Circle (-1360000, 270000), 15000, _RGB(255, 255, 100) ' Saturn
            Circle (-1360000, 270000), 20000, _RGB(255, 255, 100) ' Saturn
            Circle (-1360000, 270000), 40000, _RGB(100, 255, 100), , , .2 ' Saturn
            CometOrbitSemiMajor = (GSun / ((GSun2 / 149.6) - ((29.79 + CometSpeedX(150, 150)) * 1000) ^ 2)) * 1000 ' the 1000 is to scale this to the present window settings
            ShiftAxis = -CometOrbitSemiMajor + 149600
            Circle (ShiftAxis, 0), CometOrbitSemiMajor, _RGB(255, 0, 0), , , .5 ' Comet
            Circle (ShiftAxis, 0), CometOrbitSemiMajor + 1500, _RGB(255, 0, 0), , , .5 ' Comet
            Circle (ShiftAxis, 0), CometOrbitSemiMajor - 1500, _RGB(255, 0, 0), , , .5 ' Comet

        Case "Crossing from Sun 100km comet - Relative Speed 40 km/s"
            Circle (0, 0), 5000, _RGB(255, 255, 0) '  SUN
            Circle (0, 0), 57910, _RGB(150, 50, 55) ' Mercury orbit
            Circle (0, 0), 108200, _RGB(150, 150, 155) ' Venus orbit
            Circle (0, 0), 149600, _RGB(0, 0, 255) ' Earth orbit
            Circle (0, 0), 228000, _RGB(255, 100, 100) ' Mars orbit
            Circle (0, 0), 778000, _RGB(100, 255, 100) ' Jupiter orbit
            Circle (-730000, 160000), 28000, _RGB(100, 100, 100), , , .1 ' Jupiter
            Circle (-730000, 160000), 28000, _RGB(255, 100, 100), , , .3 ' Jupiter
            Circle (-730000, 160000), 28000, _RGB(200, 200, 100), , , .5 ' Jupiter
            Circle (-730000, 160000), 28000, _RGB(255, 100, 100), , , .8 ' Jupiter
            Circle (-730000, 160000), 28000, _RGB(255, 255, 100) ' Jupiter
            Circle (0, 0), 1434000, _RGB(100, 185, 100) ' Saturn orbit
            Circle (-1360000, 270000), 5000, _RGB(255, 255, 100) ' Saturn
            Circle (-1360000, 270000), 10000, _RGB(255, 255, 100) ' Saturn
            Circle (-1360000, 270000), 15000, _RGB(255, 255, 100) ' Saturn
            Circle (-1360000, 270000), 20000, _RGB(255, 255, 100) ' Saturn
            Circle (-1360000, 270000), 40000, _RGB(100, 255, 100), , , .2 ' Saturn
            Vector = Sqr(CometSpeedX(150, 150) ^ 2 + CometSpeedY(150, 150) ^ 2)
            CometOrbitSemiMajor = (GSun / ((GSun2 / 149.6) - (Vector * 1000) ^ 2)) * 1000 ' the 1000 is to scale this to the present window settings
            ShiftFactor = 0.4
            If CometOrbitSemiMajor > 1000000 Then ShiftFactor = ShiftFactor * 1000000 / CometOrbitSemiMajor
            ShiftAxis = -CometOrbitSemiMajor * ShiftFactor + 10000 ' shift to Earth's orbit on this image which is left and down
            ShiftUp = -CometOrbitSemiMajor * .29 + 100000 * ShiftFactor
            If CometOrbitSemiMajor > 0 And CometOrbitSemiMajor < 5000000 Then Circle (ShiftAxis, ShiftUp), CometOrbitSemiMajor, _RGB(255, 0, 0), , , .5
            If CometOrbitSemiMajor > 0 And CometOrbitSemiMajor < 5000000 Then Circle (ShiftAxis, ShiftUp), CometOrbitSemiMajor + 1500, _RGB(255, 0, 0), , , .5
            If CometOrbitSemiMajor > 0 And CometOrbitSemiMajor < 5000000 Then Circle (ShiftAxis, ShiftUp), CometOrbitSemiMajor - 1500, _RGB(255, 0, 0), , , .5



        Case "Swift Tuttle from above at 66.55 degrees after impact - Relative Speed 42 km/s", "From Above at 45 degrees - Relative Speed 40 km/s"
            Circle (0, 0), 5000, _RGB(255, 255, 0), , , .1 '  SUN
            Circle (0, 0), 57910, _RGB(150, 50, 55), , , .1 ' Mercury orbit
            Circle (0, 0), 108200, _RGB(150, 150, 155), , , .1 ' Venus orbit
            Circle (0, 0), 149600, _RGB(0, 0, 255), , , .1 ' Earth orbit
            Circle (0, 0), 228000, _RGB(255, 100, 100), , , .1 ' Mars orbit
            Circle (0, 0), 778000, _RGB(100, 255, 100), , , .1 ' Jupiter orbit
            Circle (-630000, 30000), 25000, _RGB(100, 100, 100), , , .1 ' Jupiter
            Circle (-630000, 30000), 25000, _RGB(255, 100, 100), , , .3 ' Jupiter
            Circle (-630000, 30000), 25000, _RGB(200, 200, 100), , , .5 ' Jupiter
            Circle (-630000, 30000), 25000, _RGB(255, 100, 100), , , .8 ' Jupiter
            Circle (-630000, 30000), 25000, _RGB(255, 255, 100) ' Jupiter
            Circle (0, 0), 1434000, _RGB(100, 185, 100), , , .1 ' Saturn orbit
            Circle (-1060000, 65000), 5000, _RGB(255, 255, 100) ' Saturn
            Circle (-1060000, 65000), 10000, _RGB(255, 255, 100) ' Saturn
            Circle (-1060000, 65000), 15000, _RGB(255, 255, 100) ' Saturn
            Circle (-1060000, 65000), 20000, _RGB(255, 255, 100) ' Saturn
            Circle (-1060000, 65000), 40000, _RGB(100, 255, 100), , , .2 ' Saturn
            Vector = Sqr(CometSpeedX(150, 150) ^ 2 + CometSpeedY(150, 150) ^ 2) ' Note that Earth speed not added in for original comet
            If Vector > 42 Then Vector = 42.1 ' faster than 42.3 is escape from Sun and hyperbolic orbits
            CometOrbitSemiMajor = ((GSun / ((GSun2 / 149.6) - (Vector * 1000) ^ 2)) * 1000) ' the 1000 is to scale this to the present window settings
            ShiftAxis = -CometOrbitSemiMajor + 149600
            '            LOCATE 33, 150 ' far right, near 2/3 down
            '            PRINT CometOrbitSemiMajor / 1000
            Circle (ShiftAxis, 0), CometOrbitSemiMajor, _RGB(255, 0, 0), , , .5 ' Comet
            Circle (ShiftAxis, 0), CometOrbitSemiMajor + 1500, _RGB(255, 0, 0), , , .5 ' Comet
            Circle (ShiftAxis, 0), CometOrbitSemiMajor - 1500, _RGB(255, 0, 0), , , .5 ' Comet

    End Select


End Sub






Sub CalXYAcc (AccX, AccY, AccZ)
    ' NOTE   EGAD!!!  The Earthlocations are always X distance out from the center of the planet for j, so ANY Comet particle hitting earth does so with Comet X -planetcenter = Earth X
    ' SO WE ONLY NEED TO ASSUME THAT EARTH X is the same as comet x and there is nothing to search for to see what was hit.
    '    IF Distance < PlanetRadius + 1 AND CometX(CometCenterX, CometCenterY) < TestCometDistance THEN   Impact Earth
    'acc = G M1 M2 / R^2 = GEarth * Comet mass / distance^2
    ' Distance must be in METERS not Km

    B = 1
    A = 0.8 + Rnd(B) * .5 ' between 0.8 and 1.3
    C = Rnd(B) + .3 '  C is between 0.3 and 1.3
    AccZ = 0
    If x > 300 Or x < 1 Then Exit Sub

    If Scene$ = "Impact Earth not Jupiter" Then
        'GSun = 6.67408 * 10 ^ -11 * 1.9891 X 10^30  in meters
        'GSun = 6.67408 * 10 ^ -20 * 1.9891 X 10^30  in km
        SunMass = 1.9891 * 10 ^ 30 ' mass of Sun in kg
        GravityConstantHere = 6.67408 * 10 ^ -20 ' km^3/kg s^2     NOTE G is in km here but in meters in the rest of the program
        GSunHere = GravityConstantHere * SunMass

        startX = CometX(150, 150)
        startY = CometY(150, 150)
        startZ = CometZ(150, 150)

        CometPathSpeedX = CometSpeedX(150, 150) / 1000 ' convert to km/s instead of m/s
        CometPathSpeedY = CometSpeedY(150, 150) / 1000
        CometPathSpeedZ = CometSpeedZ(150, 150) / 1000
        PointsTotal = 10000: Pointfreq = 100
        While pointstoDraw < PointsTotal ' all factors are in km here, not Meters
            DistanceC = Sqr(startX ^ 2 + startY ^ 2 + startZ ^ 2)
            EAcc = (GSunHere / (DistanceC ^ 2)) ' EAcc is in km/sec^2
            ' SunZoomFactor changes it from 1 second per calculation to increment in days at a time, not seconds but is assuming the speeds are in m/sec not km/sec so divide by 1000
            CometPathSpeedX = CometPathSpeedX + (EAcc / DistanceC) * (SunCenterX - startX) * SunZoomFactor / 1000
            CometPathSpeedY = CometPathSpeedY + (EAcc / DistanceC) * (SunCenterY - startY) * SunZoomFactor / 1000
            CometPathSpeedZ = CometPathSpeedZ + (EAcc / DistanceC) * (SunCenterZ - startZ) * SunZoomFactor / 1000
            startX = startX + CometPathSpeedX * SpeedUpFactor * 1000
            startY = startY + CometPathSpeedY * SpeedUpFactor * 1000
            startZ = startZ + CometPathSpeedZ * SpeedUpFactor * 1000
            pointstoDraw = pointstoDraw + 1
            If Int(pointstoDraw / Pointfreq) * Pointfreq = pointstoDraw Then Circle (startX, startY), 2000000, _RGB(255, 255, 255)
            '            Locate 10, 10: Print "X: ", startX
            '            Locate 11, 10: Print "Acc:", EAcc
            '            Locate 12, 10: Print "PathSpeedX: ", CometPathSpeedX
            '            Locate 13, 10: Print "GSunHere: ", GSunHere
            '            Locate 14, 10: Print "DistanceC^2: ", DistanceC ^ 2

        Wend
        Exit Sub
    End If


    Select Case Scene$

        Case "Impact Earth not Jupiter"

            Distance = Sqr((CometX(x, y) - SunCenterX) ^ 2 + (CometY(x, y) - SunCenterY) ^ 2 + (CometZ(x, y) - SunCenterZ) ^ 2) ' Distance is distance fom planet center to the comet particle in Kilometers
            '        ************************************** close to the sun kill the particle
            If Distance < 5000000 Then AccX = 0: AccY = 0: AccZ = 0: CometSpeedX(x, y) = 0: CometSpeedY(x, y) = 0: CometSpeedZ(x, y) = 0: CometMass(x, y) = 0: Exit Sub ' impacted Sun and stoped


            Earth002Distance = Sqr((CometX(x, y) - Earth002CenterX) ^ 2 + (CometY(x, y) - Earth002CenterY) ^ 2 + (CometZ(x, y) - Earth002CenterZ) ^ 2) ' Earth002Distance is distance fom Earth002 center to the comet particle
            MarsDistance = Sqr((CometX(x, y) - MarsCenterX) ^ 2 + (CometY(x, y) - MarsCenterY) ^ 2 + (CometZ(x, y) - MarsCenterZ) ^ 2)
            JupiterDistance = Sqr((CometX(x, y) - JupiterCenterX) ^ 2 + (CometY(x, y) - JupiterCenterY) ^ 2 + (CometZ(x, y) - JupiterCenterZ) ^ 2)

            ' Acceleration = GravityConstant * SunMass * CometMass(x, y) / (SunScale * Distance) ^ 2
            ' Acceleration will be in METERS per second
            SunAcceleration = (GSun / (Distance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
            AccX = (SunAcceleration / Distance) * (SunCenterX - CometX(x, y)) * SunZoomFactor ' SunZoomFactor moves it form one calculation per second to one per day or week or hour depending
            AccY = (SunAcceleration / Distance) * (SunCenterY - CometY(x, y)) * SunZoomFactor
            AccZ = (SunAcceleration / Distance) * (SunCenterZ - CometZ(x, y)) * SunZoomFactor

            Earth002Acceleration = (GEarth002 / (Earth002Distance ^ 2)) / 1000 ^ 3 '
            AccX = AccX + (Earth002Acceleration / Earth002Distance) * (Earth002CenterX - CometX(x, y)) * SunZoomFactor
            AccY = AccY + (Earth002Acceleration / Earth002Distance) * (Earth002CenterY - CometY(x, y)) * SunZoomFactor
            AccZ = AccZ + (Earth002Acceleration / Earth002Distance) * (Earth002CenterZ - CometZ(x, y)) * SunZoomFactor
            PrevAA = AA
            AA = Earth002Distance / Earth002Radius
            If AA > PrevAA And PrevAA > 0 Then AA = PrevAA
            If Earth002Distance < Earth002Radius * 1000 And x = 150 And y = 150 Then Locate 10, 30: Print "Earth Distance ", AA
            If Earth002Distance < Earth002Radius * 200 And x = 150 And y = 150 And HitEarth$ <> "Yes" Then HitEarth$ = "Yes": Call DemoExplosion: HitEarthBefore$ = "Yes"
            If HitEarth$ = "Yes" Then If Earth002Distance > Earth002Radius * 200 And x = 150 And y = 150 Then HitEarth$ = "No"

            If MarsDistance < 15000000 And Abs(MarsCenterX) > 170000000 And x <> 150 And y <> 150 Then
                MarsAcceleration = (GMars / (MarsDistance ^ 2)) / 1000 ^ 3 '
                AccX = AccX + (MarsAcceleration / MarsDistance) * (MarsCenterX - CometX(x, y)) * SunZoomFactor
                AccY = AccY + (MarsAcceleration / MarsDistance) * (MarsCenterY - CometY(x, y)) * SunZoomFactor
                AccZ = AccZ + (MarsAcceleration / MarsDistance) * (MarsCenterZ - CometZ(x, y)) * SunZoomFactor
                If MarsDistance < MarsRadius * 2 Then AccX = 0: AccY = 0: AccZ = 0: CometSpeedX(x, y) = 0: CometSpeedY(x, y) = 0: CometSpeedZ(x, y) = 0: CometMass(x, y) = 0 ' impacted and stoped
            End If

            JupiterAcceleration = ((GJupiter) / (JupiterDistance ^ 2)) / 1000 ^ 3 '
            AccX = AccX + (JupiterAcceleration / JupiterDistance) * (JupiterCenterX - CometX(x, y)) * SunZoomFactor
            AccY = AccY + (JupiterAcceleration / JupiterDistance) * (JupiterCenterY - CometY(x, y)) * SunZoomFactor
            AccZ = AccZ + (JupiterAcceleration / JupiterDistance) * (JupiterCenterZ - CometZ(x, y)) * SunZoomFactor
            If JupiterDistance < 15000000 Then CometColor(x, y) = _RGB(255, 255, 0)
            If HitJupiter$ = "No" And x = 150 And y = 150 Then
                If JupiterDistance < JupiterRadius * 100 Then HitJupiter$ = "Yes": 'LOCATE 10, 10: PRINT "Hit Jupiter": LOCATE 10, 100: PRINT USING " #,###,###,###"; JupiterDistance
            End If

            Exit Sub

        Case "Impact Jupiter then Earth a year later", "Impact Jupiter then Earth twice at 1.5 and 1.6 years later", "Impact Jupiter, near miss Earth, then impact Earth 8.1 years later", "Impact Jupiter then Earth 10.2 years later"

            Distance = Sqr((CometX(x, y) - SunCenterX) ^ 2 + (CometY(x, y) - SunCenterY) ^ 2 + (CometZ(x, y) - SunCenterZ) ^ 2) ' Distance is distance fom planet center to the comet particle
            '            TestCometDistance = 1000000 ' ************************************** close to the sun kill the particle
            If Distance < 5000000 Then AccX = 0: AccY = 0: AccZ = 0: CometSpeedX(x, y) = 0: CometSpeedY(x, y) = 0: CometSpeedZ(x, y) = 0: CometMass(x, y) = 0: Exit Sub ' impacted Sun and stoped


            Earth002Distance = Sqr((CometX(x, y) - Earth002CenterX) ^ 2 + (CometY(x, y) - Earth002CenterY) ^ 2 + (CometZ(x, y) - Earth002CenterZ) ^ 2) ' Earth002Distance is distance fom Earth002 center to the comet particle
            MarsDistance = Sqr((CometX(x, y) - MarsCenterX) ^ 2 + (CometY(x, y) - MarsCenterY) ^ 2 + (CometZ(x, y) - MarsCenterZ) ^ 2)
            JupiterDistance = Sqr((CometX(x, y) - JupiterCenterX) ^ 2 + (CometY(x, y) - JupiterCenterY) ^ 2 + (CometZ(x, y) - JupiterCenterZ) ^ 2)

            ' Acceleration = GravityConstant * SunMass * CometMass(x, y) / (SunScale * Distance) ^ 2
            ' Acceleration will be in METERS per second
            SunAcceleration = (GSun / (Distance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
            AccX = (SunAcceleration / Distance) * (SunCenterX - CometX(x, y)) * SunZoomFactor
            AccY = (SunAcceleration / Distance) * (SunCenterY - CometY(x, y)) * SunZoomFactor
            AccZ = (SunAcceleration / Distance) * (SunCenterZ - CometZ(x, y)) * SunZoomFactor

            Earth002Acceleration = 100 * (GEarth002 / (Earth002Distance ^ 2)) / 1000 ^ 3 '
            AccX = AccX + (Earth002Acceleration / Earth002Distance) * (Earth002CenterX - CometX(x, y)) * SunZoomFactor
            AccY = AccY + (Earth002Acceleration / Earth002Distance) * (Earth002CenterY - CometY(x, y)) * SunZoomFactor
            AccZ = AccZ + (Earth002Acceleration / Earth002Distance) * (Earth002CenterZ - CometZ(x, y)) * SunZoomFactor
            PrevAA = AA
            AA = Earth002Distance / Earth002Radius
            If AA > PrevAA And PrevAA > 0 Then AA = PrevAA
            If Earth002Distance < Earth002Radius * 1000 And x = 150 And y = 150 Then Locate 10, 30: Print "Earth Distance ", AA
            If Earth002Distance < Earth002Radius * 200 And x = 150 And y = 150 And HitEarth$ <> "Yes" Then HitEarth$ = "Yes": Call DemoExplosion: HitEarthBefore$ = "Yes"
            If HitEarth$ = "Yes" Then If Earth002Distance > Earth002Radius * 200 And x = 150 And y = 150 Then HitEarth$ = "No"

            If MarsDistance < 15000000 And Abs(MarsCenterX) > 170000000 And x <> 150 And y <> 150 Then
                MarsAcceleration = (GMars / (MarsDistance ^ 2)) / 1000 ^ 3 '
                AccX = AccX + (MarsAcceleration / MarsDistance) * (MarsCenterX - CometX(x, y)) * SunZoomFactor
                AccY = AccY + (MarsAcceleration / MarsDistance) * (MarsCenterY - CometY(x, y)) * SunZoomFactor
                AccZ = AccZ + (MarsAcceleration / MarsDistance) * (MarsCenterZ - CometZ(x, y)) * SunZoomFactor
                If MarsDistance < MarsRadius * 2 Then AccX = 0: AccY = 0: AccZ = 0: CometSpeedX(x, y) = 0: CometSpeedY(x, y) = 0: CometSpeedZ(x, y) = 0: CometMass(x, y) = 0 ' impacted and stoped
            End If

            JupiterAcceleration = ((GJupiter) / (JupiterDistance ^ 2)) / 1000 ^ 3 '
            AccX = AccX + (JupiterAcceleration / JupiterDistance) * (JupiterCenterX - CometX(x, y)) * SunZoomFactor
            AccY = AccY + (JupiterAcceleration / JupiterDistance) * (JupiterCenterY - CometY(x, y)) * SunZoomFactor
            AccZ = AccZ + (JupiterAcceleration / JupiterDistance) * (JupiterCenterZ - CometZ(x, y)) * SunZoomFactor
            If JupiterDistance < 15000000 Then CometColor(x, y) = _RGB(255, 255, 0)
            If HitJupiter$ = "No" And x = 150 And y = 150 Then
                If JupiterDistance < JupiterRadius * 100 Then HitJupiter$ = "Yes": 'LOCATE 10, 10: PRINT "Hit Jupiter": LOCATE 10, 100: PRINT USING " #,###,###,###"; JupiterDistance
            End If

            Exit Sub


            '   **************************************************

        Case "Encke", "SwiftTuttle Impact at Start", "SwiftTuttle Orbit, outgassing along the orbit" ' ALWAYS ADD GRAVITY EFFECTS FROM PLANETS for ENCKE

            Distance = Sqr((CometX(x, y) - 0) ^ 2 + (CometY(x, y) - 0) ^ 2 + (CometZ(x, y) - 0) ^ 2) ' Distance is distance from Sun center (0,0,0) to the comet particle
            TestCometDistance = 1000000 ' ************************************** close to the sun kill the particle

            If Distance < 35000000 And x <> 150 And y <> 150 And CometTime > 5 Then '   Impact Sun
                AccX = 0: AccY = 0: AccZ = 0: CometSpeedX(x, y) = 0: CometSpeedY(x, y) = 0: CometSpeedZ(x, y) = 0: CometMass(x, y) = 0: Exit Sub ' impacted and stoped
            End If
            SunAcceleration = (GSun / (Distance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
            AccX = (SunAcceleration / Distance) * (SunCenterX - CometX(x, y)) * SunZoomFactor
            AccY = (SunAcceleration / Distance) * (SunCenterY - CometY(x, y)) * SunZoomFactor
            AccZ = (SunAcceleration / Distance) * (SunCenterZ - CometZ(x, y)) * SunZoomFactor


            If Scene$ = "Encke" And EnckeGravity$ = "Off" Then Exit Sub

            '            If x <> 150 And y <> 150 And CometTime > 100 Then ' Calculate sunlight pressure on dust
            '                SunPressure = (GSun / (Distance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
            '                AccX = AccX - (SunPressure / Distance) * (SunCenterX - CometX(x, y)) * SunZoomFactor * .002
            '                AccY = AccY - (SunPressure / Distance) * (SunCenterY - CometY(x, y)) * SunZoomFactor * .002
            '                AccZ = AccZ - (SunPressure / Distance) * (SunCenterZ - CometZ(x, y)) * SunZoomFactor * .002
            '            End If
            '            If x <> 150 And y <> 150 And CometTime > 100 Then ' Ignore effect of planets until system is in process and comet far from starting point of planets.

            MercuryDistance = Sqr((CometX(x, y) - MercuryCenterX) ^ 2 + (CometY(x, y) - MercuryCenterY) ^ 2 + (CometZ(x, y) - MercuryCenterZ) ^ 2)
            VenusDistance = Sqr((CometX(x, y) - VenusCenterX) ^ 2 + (CometY(x, y) - VenusCenterY) ^ 2 + (CometZ(x, y) - VenusCenterZ) ^ 2)
            Earth002Distance = Sqr((CometX(x, y) - Earth002CenterX) ^ 2 + (CometY(x, y) - Earth002CenterY) ^ 2 + (CometZ(x, y) - Earth002CenterZ) ^ 2) ' Earth002Distance is distance fom Earth002 center to the comet particle
            MarsDistance = Sqr((CometX(x, y) - MarsCenterX) ^ 2 + (CometY(x, y) - MarsCenterY) ^ 2 + (CometZ(x, y) - MarsCenterZ) ^ 2)
            JupiterDistance = Sqr((CometX(x, y) - JupiterCenterX) ^ 2 + (CometY(x, y) - JupiterCenterY) ^ 2 + (CometZ(x, y) - JupiterCenterZ) ^ 2)
            SaturnDistance = Sqr((CometX(x, y) - SaturnCenterX) ^ 2 + (CometY(x, y) - SaturnCenterY) ^ 2 + (CometZ(x, y) - SaturnCenterZ) ^ 2)
            UranusDistance = Sqr((CometX(x, y) - UranusCenterX) ^ 2 + (CometY(x, y) - UranusCenterY) ^ 2 + (CometZ(x, y) - UranusCenterZ) ^ 2)
            NeptuneDistance = Sqr((CometX(x, y) - NeptuneCenterX) ^ 2 + (CometY(x, y) - NeptuneCenterY) ^ 2 + (CometZ(x, y) - NeptuneCenterZ) ^ 2)

            If CometTime < 10 Then Exit Sub ' Ignore effect of planets until system is in process and comet far from starting point of planets.

            If Scene$ = "Encke" Or MarsGravity$ = "On" Then
                MercuryAcceleration = (GMercury / (MercuryDistance ^ 2)) / 1000 ^ 3 '
                AccX = AccX + (MercuryAcceleration / MercuryDistance) * (MercuryCenterX - CometX(x, y)) * SunZoomFactor
                AccY = AccY + (MercuryAcceleration / MercuryDistance) * (MercuryCenterY - CometY(x, y)) * SunZoomFactor
                AccZ = AccZ + (MercuryAcceleration / MercuryDistance) * (MercuryCenterZ - CometZ(x, y)) * SunZoomFactor
                If MercuryDistance < MercuryRadius * 1.2 Then ' Hit Mercury
                    CometColor(x, y) = _RGB(250, 0, 0) ' Hit Mercury
                    PSet (CometX(x, y), CometY(x, y)), _RGB(255, 0, 0)
                    Circle (CometX(x, y), CometY(x, y)), 5000000, _RGB(255, 0, 0)
                    AccX = 0: AccY = 0: AccZ = 0: CometSpeedX(x, y) = 0: CometSpeedY(x, y) = 0: CometSpeedZ(x, y) = 0: CometMass(x, y) = 0: Exit Sub ' impacted and stoped
                End If
                '            If MercuryDistance < 4000000 Then CometColor(x, y) = _RGB(250, 0, 0) ' Red
                If MercuryDistance < MercuryRadius * 1.2 Then AccX = 0: AccY = 0: AccZ = 0: CometSpeedX(x, y) = 0: CometSpeedY(x, y) = 0: CometSpeedZ(x, y) = 0: CometMass(x, y) = 0: Exit Sub ' impacted and stoped

                VenusAcceleration = (GVenus / (VenusDistance ^ 2)) / 1000 ^ 3 '
                AccX = AccX + (VenusAcceleration / VenusDistance) * (VenusCenterX - CometX(x, y)) * SunZoomFactor
                AccY = AccY + (VenusAcceleration / VenusDistance) * (VenusCenterY - CometY(x, y)) * SunZoomFactor
                AccZ = AccZ + (VenusAcceleration / VenusDistance) * (VenusCenterZ - CometZ(x, y)) * SunZoomFactor
                '                If VenusDistance < 5000000 Then CometColor(x, y) = _RGB(255, 255, 255) ' White
                If VenusDistance < VenusRadius * 1.2 Then AccX = 0: AccY = 0: AccZ = 0: CometSpeedX(x, y) = 0: CometSpeedY(x, y) = 0: CometSpeedZ(x, y) = 0: CometMass(x, y) = 0: Exit Sub ' impacted and stoped
            End If
            If Scene$ = "Encke" Or EarthGravity$ = "On" Then
                Earth002Acceleration = (GEarth002 / (Earth002Distance ^ 2)) / 1000 ^ 3
                AccX = AccX + (Earth002Acceleration / Earth002Distance) * (Earth002CenterX - CometX(x, y)) * SunZoomFactor
                AccY = AccY + (Earth002Acceleration / Earth002Distance) * (Earth002CenterY - CometY(x, y)) * SunZoomFactor
                AccZ = AccZ + (Earth002Acceleration / Earth002Distance) * (Earth002CenterZ - CometZ(x, y)) * SunZoomFactor
                '     Circle (0, 0), 149000000, _RGB(0, 255, 255), , , OrbitAspect ' Earth Orbit
                '          EarthRadius = 6371 'Earth Radius in Km
                If Earth002Distance < 4000000 Then CometColor(x, y) = _RGB(0, 255, 255) ' Cyan for particles within 10X Earth-Moon distance of 384,000 km, or 4,000,000 km
                If Earth002Distance < Earth002Radius * 1.4 Then AccX = 0: AccY = 0: CometSpeedX(x, y) = 0: CometSpeedY(x, y) = 0: CometMass(x, y) = 0: Exit Sub ' impacted and stoped
            End If

            If Scene$ <> "Encke" And MarsGravity$ <> "On" Then Exit Sub

            MarsAcceleration = (GMars / (MarsDistance ^ 2)) / 1000 ^ 3 '
            AccX = AccX + (MarsAcceleration / MarsDistance) * (MarsCenterX - CometX(x, y)) * SunZoomFactor
            AccY = AccY + (MarsAcceleration / MarsDistance) * (MarsCenterY - CometY(x, y)) * SunZoomFactor
            AccZ = AccZ + (MarsAcceleration / MarsDistance) * (MarsCenterZ - CometZ(x, y)) * SunZoomFactor
            '           If MarsDistance < 4000000 Then CometColor(x, y) = _RGB(255, 0, 0) '  Red
            If MarsDistance < MarsRadius * 1.4 Then AccX = 0: AccY = 0: CometSpeedX(x, y) = 0: CometSpeedY(x, y) = 0: CometMass(x, y) = 0: Exit Sub ' impacted and stoped

            If Scene$ = "Encke" And EnckeGravity$ = "MVEM" Then Exit Sub ' Skip calculating Jupiter, Saturn, Neptune and Uranus

            JupiterAcceleration = ((GJupiter) / (JupiterDistance ^ 2)) / 1000 ^ 3 '
            AccX = AccX + (JupiterAcceleration / JupiterDistance) * (JupiterCenterX - CometX(x, y)) * SunZoomFactor
            AccY = AccY + (JupiterAcceleration / JupiterDistance) * (JupiterCenterY - CometY(x, y)) * SunZoomFactor
            AccZ = AccZ + (JupiterAcceleration / JupiterDistance) * (JupiterCenterZ - CometZ(x, y)) * SunZoomFactor
            If JupiterDistance < 70000000 Then CometColor(x, y) = _RGB(255, 125, 0) '  Orange
            If JupiterDistance < JupiterRadius * 1.4 Then AccX = 0: AccY = 0: CometSpeedX(x, y) = 0: CometSpeedY(x, y) = 0: CometMass(x, y) = 0: Exit Sub ' impacted and stoped


            SaturnAcceleration = (GSaturn / (SaturnDistance ^ 2)) / 1000 ^ 3 '
            AccX = AccX + (SaturnAcceleration / SaturnDistance) * (SaturnCenterX - CometX(x, y)) * SunZoomFactor
            AccY = AccY + (SaturnAcceleration / SaturnDistance) * (SaturnCenterY - CometY(x, y)) * SunZoomFactor
            AccZ = AccZ + (SaturnAcceleration / SaturnDistance) * (SaturnCenterZ - CometZ(x, y)) * SunZoomFactor
            If SaturnDistance < 70000000 Then CometColor(x, y) = _RGB(50, 255, 255)
            If SaturnDistance < SaturnRadius * 1.4 Then AccX = 0: AccY = 0: CometSpeedX(x, y) = 0: CometSpeedY(x, y) = 0: CometMass(x, y) = 0: Exit Sub ' impacted and stoped

            UranusAcceleration = (GUranus / (UranusDistance ^ 2)) / 1000 ^ 3 '
            AccX = AccX + (UranusAcceleration / UranusDistance) * (UranusCenterX - CometX(x, y)) * SunZoomFactor
            AccY = AccY + (UranusAcceleration / UranusDistance) * (UranusCenterY - CometY(x, y)) * SunZoomFactor
            AccZ = AccZ + (UranusAcceleration / UranusDistance) * (UranusCenterZ - CometZ(x, y)) * SunZoomFactor
            If UranusDistance < 70000000 Then CometColor(x, y) = _RGB(100, 255, 100)
            If UranusDistance < UranusRadius * 1.4 Then AccX = 0: AccY = 0: CometSpeedX(x, y) = 0: CometSpeedY(x, y) = 0: CometMass(x, y) = 0: Exit Sub ' impacted and stoped

            NeptuneAcceleration = (GNeptune / (NeptuneDistance ^ 2)) / 1000 ^ 3 '
            AccX = AccX + (NeptuneAcceleration / NeptuneDistance) * (NeptuneCenterX - CometX(x, y)) * SunZoomFactor
            AccY = AccY + (NeptuneAcceleration / NeptuneDistance) * (NeptuneCenterY - CometY(x, y)) * SunZoomFactor
            AccZ = AccZ + (NeptuneAcceleration / NeptuneDistance) * (NeptuneCenterZ - CometZ(x, y)) * SunZoomFactor
            If NeptuneDistance < 70000000 Then CometColor(x, y) = _RGB(150, 25, 50) ' Orange
            If NeptuneDistance < NeptuneRadius * 1.4 Then AccX = 0: AccY = 0: CometSpeedX(x, y) = 0: CometSpeedY(x, y) = 0: CometMass(x, y) = 0: Exit Sub ' impacted and stoped

            Exit Sub


            '   **************************************************







        Case Else
            CDistance = Sqr((CometX(CometCenterX, CometCenterY) - PlanetCenterX) ^ 2 + (CometY(CometCenterX, CometCenterY) - PlanetCenterY) ^ 2) ' CDistance is distance from comet center to planet center
            Distance = Sqr((CometX(x, y) - PlanetCenterX) ^ 2 + (CometY(x, y) - PlanetCenterY) ^ 2) ' Distance is distance fom planet center to the comet particle
            TestCometDistance = PlanetRadius + CometRadius * 2 ' **************************************
            'SunRadius = 695700 ' Sun Radius in Km

            If Distance > PlanetRadius Then ' Anything not being impacted is acted on by Earth's gravity only
                ' Acceleration will be in METERS per second
                EarthAcceleration = (GEarth / (Distance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
                ' Next calculate x,y portions of acceleration - trigometric calculation = RATIO of lengths of triangle
                AccX = (EarthAcceleration / Distance) * (PlanetCenterX - CometX(x, y)) * SunZoomFactor
                AccY = (EarthAcceleration / Distance) * (PlanetCenterY - CometY(x, y)) * SunZoomFactor
                'Earth Distance from Sun = 149,600,000,000 m =  = 149,600,000 km
                'SunRadius = 695700000 ' Sun Radius in Meters (695,700 km)
                Exit Sub
            End If


            ' stop motion if a particle falls back to earth and comet not presently impacting
            If CDistance >= TestCometDistance Then
                CometMass(x, y) = CometMass(x, y) - .2 ' Allows for some particles landing mid earth - looks more 3D
                AccX = (EarthAcceleration / Distance) * (PlanetCenterX - CometX(x, y))
                AccY = (EarthAcceleration / Distance) * (PlanetCenterY - CometY(x, y))
                If CometMass(x, y) < 1.1 Then AccX = 0: AccY = 0: CometSpeedX(x, y) = 0: CometSpeedY(x, y) = 0 ' impacted and stoped
                Exit Sub
            End If


            k = CometX(x, y) - PlanetCenterX ' k is the earth particle location being hit by the comet particle
            If k < 1 Then k = 1
            If k > 7500 Then k = 7500

            ' Change comet speeds here

            PresentCometSpeed = Sqr(CometSpeedX(150, 150) ^ 2 + CometSpeedY(150, 150) ^ 2)
            PresentCometFactor = 2.5 * (Rnd(B) + .5)

            ' Totally Random speeds to start, both postive and negative +/- 0.5 speed of the comet
            CometSpeedX(x, y) = PresentCometSpeed * (Rnd(B) - .5) * Rnd(32) ' single random number leaves a hard end at 0.5.  Adding a second random factor makes the end number be random instead of a fixed maximum
            CometSpeedY(x, y) = PresentCometSpeed * (Rnd(B) - .5) * Rnd(32)

            ' Then Add in some of the comet's speed and direction ONLY positive
            CometSpeedX(x, y) = CometSpeedX(x, y) + CometSpeedX(150, 150) * (Rnd(B) + .5) * (Rnd(32) + .5) / 1.5 ' at 2.25 factor no particles would go faster than the comet
            CometSpeedY(x, y) = CometSpeedY(x, y) + CometSpeedY(150, 150) * (Rnd(B) + .5) * (Rnd(32) + .5) / 1.5


            ' check that the random numbers are giving speeds of not more than 5X comet speed NOTE: RARELY HAPPENS except in 70 km/s horizontal impacts and then it applies often for Y axis
            testspX = Abs(CometSpeedX(150, 150)) * 6: testspY = Abs(CometSpeedY(150, 150)) * 6
            If Abs(CometSpeedX(x, y)) > testspX Then CometSpeedX(x, y) = CometSpeedX(150, 150) * randomnumber * 2.5
            If Abs(CometSpeedY(x, y)) > testspY Then CometSpeedY(x, y) = CometSpeedY(150, 150) * randomnumber2 * 2.5


            'Assign color to speed of comet particle
            If CometSpeedX(x, y) > 0 Or CometSpeedY(x, y) > 0 Then
                ab = Sqr(CometSpeedX(x, y) ^ 2 + CometSpeedY(x, y) ^ 2)
                ColorofSpeed = (ab - 11.2) * 10
                CometColor(x, y) = _RGB(0, 0, 255) ' blue
                If ab > 11.2 Then CometColor(x, y) = _RGB(255, ColorofSpeed, ColorofSpeed / 5) 'Red to Yellow
            End If

            ' comet speed changes are done and should not add more acc to them now
            AccX = 0: AccY = 0



            If EarthSpeedX(k, 1) > 0 Then Exit Sub ' Only add speed to particles not in motion already


            CometMass(x, y) = CometMass(x, y) + .1 ' count how many times a comet particle hits Earth
            If CometMass(x, y) >= 3.5 Then AccX = 0: AccY = 0: CometSpeedX(x, y) = 0: CometSpeedY(x, y) = 0: CometMass(x, y) = 0: CometColor(x, y) = _RGB(0, 0, 255): Exit Sub ' after many hits, it would lose energy and stop



            For l = 1 To 7
                randomnumber = 1 + (Rnd(D) - .5) ' Range is 0.5 to 1.5
                randomnumber2 = 1 + (Rnd(D) - .5) ' Range is 0.5 to 1.5
                RandomNumberX = 1: If Rnd(D) < .5 Then RandomNumberX = -1 ' half are positive and half negative for slower direction only
                If Abs(CometSpeedX(150, 150)) > 20 Then RandomNumberX = 1 ' do not switch direction if rapidly moving forward
                RandomNumberY = 1: If Rnd(D) < .5 Then RandomNumberY = -1
                If Abs(CometSpeedY(150, 150)) > 20 Then RandomNumberY = 1 ' do not switch direction if rapidly moving down

                ' Explosion event - totally random motion in all directions based on incoming speed
                SpofComet = Sqr(CometSpeedX(150, 150) ^ 2 + CometSpeedY(150, 150) ^ 2)
                EarthSpeedX(k, l) = CometSpeedX(x, y) * (Rnd(B) - .5) * 1.5
                EarthSpeedY(k, l) = CometSpeedY(x, y) * (Rnd(B) - .5) * 1.5

                If Rnd(D) - .3 < 0 Then ' do something different for each third one - two different methods to add comet direction to particles
                    SpofComet = Sqr(CometSpeedX(150, 150) ^ 2 + CometSpeedY(150, 150) ^ 2)
                    angofcometX = CometSpeedX(x, y) / SpofComet
                    angofcometY = CometSpeedY(x, y) / SpofComet
                    EarthSpeedX(k, l) = EarthSpeedX(k, l) + 1 + CometSpeedX(x, y) * (Rnd(B) - .3) * angofcometY 'RND(B) is between 0.3 and 1.3.  NOTE Intentional switching of X and Y factors to spread out particles when X,Y are far apart
                    EarthSpeedY(k, l) = EarthSpeedY(k, l) + 1 + CometSpeedY(x, y) * (Rnd(B) - .3) * angofcometX 'RND(B) is between 0.3 and 1.3
                    If EarthSpeedY(k, l) < -12 Then EarthSpeedX(k, l) = EarthSpeedX(k, l) * (Rnd(B) + 1)
                    If Abs(CometSpeedX(x, y)) > Abs(CometSpeedY(x, y)) Then EarthSpeedX(k, l) = EarthSpeedX(k, l) + CometSpeedX(x, y) * (Rnd(B) + .5) Else EarthSpeedY(k, l) = EarthSpeedY(k, l) + CometSpeedY(x, y) * (Rnd(B) + .5)
                    If Abs(EarthSpeedX(k, l)) > 2.5 * Abs(CometSpeedX(x, y)) Then EarthSpeedX(k, l) = CometSpeedX(x, y) * randomnumber * 2.5
                    If Abs(EarthSpeedY(k, l)) > 2.5 * Abs(CometSpeedY(x, y)) Then EarthSpeedY(k, l) = CometSpeedY(x, y) * randomnumber2 * 2.5
                    '                        EarthColor(k, l) = _RGB(255, 0, 0)
                Else ' 2/3 treated here
                    EarthSpeedX(k, l) = EarthSpeedX(k, l) + 1 + CometSpeedX(x, y) * (Rnd(B) + .3) 'RND(B) is between 0.3 and 1.3
                    EarthSpeedY(k, l) = EarthSpeedY(k, l) + 1 + CometSpeedY(x, y) * (Rnd(B) + .3) 'RND(B) is between 0.3 and 1.3
                    '                        IF EarthSpeedY(k, l) < -12 THEN EarthSpeedX(k, l) = EarthSpeedX(k, l) * (RND(B) + 1)
                    If Abs(EarthSpeedX(k, l)) > 2.5 * Abs(CometSpeedX(x, y)) Then EarthSpeedX(k, l) = CometSpeedX(x, y) * randomnumber * 2.5
                    If Abs(EarthSpeedY(k, l)) > 2.5 * Abs(CometSpeedY(x, y)) Then EarthSpeedY(k, l) = CometSpeedY(x, y) * randomnumber2 * 2.5
                    '                       EarthColor(k, l) = _RGB(0, 255, 0)
                End If
            Next l
    End Select


End Sub





Sub CalEarthParticlesGravity (i, j, AccX, AccY)
    Distance = Sqr((EarthX(i, j) - PlanetCenterX) ^ 2 + (EarthY(i, j) - PlanetCenterY) ^ 2)
    If CometSpeedX(150, 150) > 15 Then Factor = .95 Else Factor = .98
    If Distance < 1 Then Distance = 1
    If Distance < PlanetRadius Then
        EarthSpeedX(i, j) = EarthSpeedX(i, j) * Factor
        EarthSpeedY(i, j) = EarthSpeedY(i, j) * Factor
        If EndImpactTime > 0 And CometTime - EndImpactTime > 10 Then EarthSpeedX(i, j) = EarthSpeedX(i, j) * Factor * .9: EarthSpeedY(i, j) = EarthSpeedY(i, j) * Factor * .9 '  note that these are culmutatiive
        If EndImpactTime > 0 And CometTime - EndImpactTime > 20 Then EarthSpeedX(i, j) = EarthSpeedX(i, j) * Factor * .8: EarthSpeedY(i, j) = EarthSpeedY(i, j) * Factor * .8
        If EndImpactTime > 0 And CometTime - EndImpactTime > 50 Then EarthSpeedX(i, j) = EarthSpeedX(i, j) * Factor * .8: EarthSpeedY(i, j) = EarthSpeedY(i, j) * Factor * .8
        If EndImpactTime > 0 And CometTime - EndImpactTime > 100 Then
            AccX = 0: AccY = 0: EarthSpeedX(i, j) = 0: EarthSpeedY(i, j) = 0
            Exit Sub
        End If
        '        _PRINTSTRING (900, 650), "slowing earth particles now:    Distance" + STR$(PlanetRadius - Distance)
    End If
    Distance = 1000 * Distance ' convert distance from km to meters
    ' Acceleration will be in METERS per second
    EarthAcceleration = GEarth / (Distance ^ 2) / 1000 ' /1000 converts acc to km per sec
    ' Next calculate x,y portions of acceleration - trigometric calculation = RATIO of lengths of triangle
    Distance = Distance / 1000 ' convert distance back to km
    AccX = (EarthAcceleration / Distance) * (PlanetCenterX - EarthX(i, j))
    AccY = (EarthAcceleration / Distance) * (PlanetCenterY - EarthY(i, j))

End Sub



Sub CalEarthParticlesGravity2 (i, j, AccX, AccY)
    Distance = Sqr((EarthX(i, j) - PlanetCenterX) ^ 2 + (EarthY(i, j) - PlanetCenterY) ^ 2)
    If Distance < 1 Then Distance = 1

    If Distance < PlanetRadius Then
        AccX = 0: AccY = 0:
        Select Case CometTime
            Case Is < 1100
                If CometSpeedX(150, 150) > 15 Then Factor = .95 Else Factor = .98
                EarthSpeedX(i, j) = EarthSpeedX(i, j) * Factor
                EarthSpeedY(i, j) = EarthSpeedY(i, j) * Factor
                If EndImpactTime > 0 And CometTime - EndImpactTime > 10 Then EarthSpeedX(i, j) = EarthSpeedX(i, j) * Factor * .9: EarthSpeedY(i, j) = EarthSpeedY(i, j) * Factor * .9 '  note that these are culmutatiive
                If EndImpactTime > 0 And CometTime - EndImpactTime > 20 Then EarthSpeedX(i, j) = EarthSpeedX(i, j) * Factor * .8: EarthSpeedY(i, j) = EarthSpeedY(i, j) * Factor * .8
                If EndImpactTime > 0 And CometTime - EndImpactTime > 50 Then EarthSpeedX(i, j) = EarthSpeedX(i, j) * Factor * .8: EarthSpeedY(i, j) = EarthSpeedY(i, j) * Factor * .8
                If EndImpactTime > 0 And CometTime - EndImpactTime > 100 And CometTime - EndImpactTime < 500 Then 'stop early arrivals on edge
                    EarthSpeedX(i, j) = 0: EarthSpeedY(i, j) = 0
                End If
            Case Is >= 1100 ' allow some to stop in mid earth for 3D effect
                Exit Sub
                If EarthSpeedX(i, j) > 0 Or EarthSpeedY(i, j) > 0 Then
                    If EarthX(i, j) > PlanetCenterX Then AccX = -.5 Else AccX = .5
                    If EarthY(i, j) > PlanetCenterY Then AccY = -.5 Else AccY = .5
                    EarthSpeedX(i, j) = EarthSpeedX(i, j) + AccX
                    EarthSpeedY(i, j) = EarthSpeedY(i, j) + AccY
                    EarthColor(i, j) = _RGB(255, 0, 0)
                    If Abs(EarthSpeedX(i, j)) < 0.1 Then EarthSpeedX(i, j) = 0
                    If Abs(EarthSpeedY(i, j)) < 0.1 Then EarthSpeedY(i, j) = 0
                Else EarthSpeedX(i, j) = 0: EarthSpeedY(i, j) = 0
                End If
        End Select
        Exit Sub
    End If


    Distance = 1000 * Distance ' convert distance from km to meters
    ' Acceleration will be in METERS per second
    EarthAcceleration = GEarth / (Distance ^ 2) / 1000 ' /1000 converts acc to km per sec
    ' Next calculate x,y portions of acceleration - trigometric calculation = RATIO of lengths of triangle
    Distance = Distance / 1000 ' convert distance back to km
    AccX = (EarthAcceleration / Distance) * (PlanetCenterX - EarthX(i, j))
    AccY = (EarthAcceleration / Distance) * (PlanetCenterY - EarthY(i, j))

End Sub

Sub SaveOptions
    If Scene$ = "SwiftTuttle Impact at Start" Or Scene$ = "SwiftTuttle Orbit, outgassing along the orbit" Then Exit Sub ' do not try to save option in these scenes

    View (400, 250)-(765, 780), _RGB(0, 0, 0), _RGB(100, 100, 50)
    Window Screen(400, 250)-(765, 780) ' EGAD - you do not match the view to the window
    Line (400, 250)-(765, 780), _RGB(220, 220, 220), BF ' main box
    Line (400, 250)-(765, 270), _RGB(240, 240, 240), BF ' top note

    Line (420, 655)-(730, 675), _RGB(250, 250, 0), BF ' Enter File Name
    Line (400, 739)-(765, 780), _RGB(230, 230, 230), BF ' bottom note

    Color _RGB(0, 0, 0), _RGB(240, 240, 240)
    _PrintString (480, 253), "Comet Skip Impact Image Saving"
    Color _RGB(100, 50, 0), _RGB(220, 220, 220)
    _PrintString (410, 280), "Hitting  Ctrl P  with graphics running will"
    _PrintString (410, 300), "do an immeadiate Save & end multiple saving."

    aMouse = _MouseInput ' clear MouseInput
    aMouse = _MouseInput ' clear MouseInput
    aMouse = _MouseInput ' clear MouseInput

    SaveTheImage = 1: ButtonNumber = 1
    OriginalCometFileName$ = CometFileName$

    '    CometFileName$ = "D:/CometImages/CometSim" ' Need something to start
    '    CometFileNameNow$ = CometFileName$ + LTrim$(Str$(CometTime))

    Call ShowImageSaveOptions


    KeyPressed$ = ""
    While KeyPressed$ = ""
        KeyPressed$ = InKey$
        If _MouseInput = -1 Then
            xx& = _MouseX
            yy& = _MouseY
            Mousex = xx&
            Mousey = yy&
            ButtonClicked = _MouseButton(1)
            '    VIEW (400, 250)-(765, 780), _RGB(0, 0, 0), _RGB(100, 100, 50)
            Select Case Mousex
                Case 420 To 720 '  in Button area
                    Select Case Mousey ' which row?
                        Case 348 To 368: If Mousex > 440 And Mousex < 650 Then ButtonNumber = 1
                        Case 384 To 404: If Mousex > 440 And Mousex < 650 Then ButtonNumber = 2
                        Case 420 To 440: If Mousex > 440 And Mousex < 650 Then ButtonNumber = 3
                        Case 456 To 476: If Mousex > 440 And Mousex < 650 Then ButtonNumber = 4
                        Case 492 To 512: If Mousex > 440 And Mousex < 650 Then ButtonNumber = 5
                        Case 528 To 548: If Mousex > 440 And Mousex < 650 Then ButtonNumber = 6
                        Case 585 To 625
                            Select Case Mousex
                                Case 421 To 441: ButtonNumber = 7
                                Case 470 To 490: ButtonNumber = 8
                                Case 520 To 540: ButtonNumber = 9
                                Case 565 To 585: ButtonNumber = 10
                                Case 615 To 635: ButtonNumber = 11
                                Case 663 To 683: ButtonNumber = 12
                                Case 710 To 730: ButtonNumber = 13
                            End Select
                        Case 640 To 680: If Mousex > 420 And Mousex < 740 Then ButtonNumber = 14
                        Case 700 To 725
                            If Mousex > 420 And Mousex < 535 Then ButtonNumber = 15
                            If Mousex > 535 And Mousex < 735 Then ButtonNumber = 16
                    End Select
            End Select
            Select Case ButtonClicked
                Case -1
                    Select Case Mousey
                        Case 348 To 368: If ButtonNumber = 1 Then SaveTheImage = 1
                        Case 384 To 404: If ButtonNumber = 2 Then SaveTheImage = 50
                        Case 420 To 440: If ButtonNumber = 3 Then SaveTheImage = 100
                        Case 456 To 476: If ButtonNumber = 4 Then SaveTheImage = 500
                        Case 492 To 512: If ButtonNumber = 5 Then SaveTheImage = 1000
                        Case 528 To 548: If ButtonNumber = 6 Then SaveTheImage = 10000
                        Case 585 To 625
                            Select Case Mousex
                                Case 421 To 441: SaveOneInTen = 1
                                Case 470 To 490: SaveOneInTen = 5
                                Case 520 To 540: SaveOneInTen = 10
                                Case 565 To 585: SaveOneInTen = 100
                                Case 615 To 635: SaveOneInTen = 500
                                Case 663 To 683: SaveOneInTen = 1000
                                Case 710 To 730: SaveOneInTen = 2000
                            End Select
                        Case 640 To 680: If Mousex > 420 And Mousex < 740 Then ButtonNumber = 14
                        Case 698 To 725
                            If Mousex > 420 And Mousex < 535 Then ' Cancel Button
                                SaveTheImage = 0: SaveOneInTen = 0
                                CometFileName$ = OriginalCometFileName$
                                Cls
                                View (0, 0)-(1776, 999)
                                Window (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, ZoomWindow4)
                                Color _RGB(255, 255, 255), _RGB(0, 0, 0)
                                Exit Sub
                            End If
                            If Mousex > 570 And Mousex < 740 Then ' Begin Saving button
                                Cls
                                View (0, 0)-(1776, 999)
                                Window (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, ZoomWindow4)
                                Color _RGB(255, 255, 255), _RGB(0, 0, 0)
                                Exit Sub
                            End If
                    End Select
                    '                    _PRINTSTRING (500, 400), "Mouse:  " + STR$(Mousex) + "   " + STR$(Mousey) + "   "
            End Select
            KeyPressed$ = ""
            Call ShowImageSaveOptions
        End If


        If KeyPressed$ <> "" Then
            If ButtonNumber = 14 And Len(KeyPressed$) = 1 Then 'enter new file name for CometFileName$
                TestKey = Asc(KeyPressed$)
                Select Case TestKey
                    Case 27: CometFileName$ = OriginalCometFileName$ ' esc goes back to original
                    Case 8: CometFileName$ = Left$(CometFileName$, Len(CometFileName$) - 1)
                    Case 32, 43 To 57, 65 To 122: CometFileName$ = CometFileName$ + KeyPressed$
                End Select
                KeyPressed$ = "*"
            End If

            If Len(KeyPressed$) > 1 Then TestKey = Asc(Right$(KeyPressed$, 1)) Else TestKey = Asc(KeyPressed$)

            Select Case TestKey

                Case 71 '        cursor home
                    ButtonNumber = 1
                Case 72, 73, 75 '        cursor key up and page up and left
                    If ButtonNumber = 2 Then ButtonNumber = 1
                    If ButtonNumber = 3 Then ButtonNumber = 2
                    If ButtonNumber = 4 Then ButtonNumber = 3
                    If ButtonNumber = 5 Then ButtonNumber = 4
                    If ButtonNumber = 6 Then ButtonNumber = 5
                    If ButtonNumber = 7 Then ButtonNumber = 6
                    If ButtonNumber = 8 Then ButtonNumber = 7
                    If ButtonNumber = 9 Then ButtonNumber = 8
                    If ButtonNumber = 10 Then ButtonNumber = 9
                    If ButtonNumber = 11 Then ButtonNumber = 10
                    If ButtonNumber = 12 Then ButtonNumber = 11
                    If ButtonNumber = 13 Then ButtonNumber = 12
                    If ButtonNumber = 14 Then ButtonNumber = 13
                    If ButtonNumber = 15 Then ButtonNumber = 14
                    If ButtonNumber = 16 Then ButtonNumber = 15
                Case 80, 81, 77 '        cursor key down and page down and right
                    If ButtonNumber = 15 Then ButtonNumber = 16
                    If ButtonNumber = 14 Then ButtonNumber = 15
                    If ButtonNumber = 13 Then ButtonNumber = 14
                    If ButtonNumber = 12 Then ButtonNumber = 13
                    If ButtonNumber = 11 Then ButtonNumber = 12
                    If ButtonNumber = 10 Then ButtonNumber = 11
                    If ButtonNumber = 9 Then ButtonNumber = 10
                    If ButtonNumber = 8 Then ButtonNumber = 9
                    If ButtonNumber = 7 Then ButtonNumber = 8
                    If ButtonNumber = 6 Then ButtonNumber = 7
                    If ButtonNumber = 5 Then ButtonNumber = 6
                    If ButtonNumber = 4 Then ButtonNumber = 5
                    If ButtonNumber = 3 Then ButtonNumber = 4
                    If ButtonNumber = 2 Then ButtonNumber = 3
                    If ButtonNumber = 1 Then ButtonNumber = 2
                Case 79 ' Cursor End
                    ButtonNumber = 16
                Case 32 ' space bar
                    Select Case ButtonNumber
                        Case 1: SaveTheImage = 1
                        Case 2: SaveTheImage = 50
                        Case 3: SaveTheImage = 100
                        Case 4: SaveTheImage = 500
                        Case 5: SaveTheImage = 1000
                        Case 6: SaveTheImage = 10000
                        Case 7: SaveOneInTen = 1
                        Case 8: SaveOneInTen = 5
                        Case 9: SaveOneInTen = 10
                        Case 10: SaveOneInTen = 100
                        Case 11: SaveOneInTen = 500
                        Case 12: SaveOneInTen = 1000
                        Case 13: SaveOneInTen = 2000
                        Case 15
                            SaveTheImage = 0: SaveOneInTen = 0
                            CometFileName$ = OriginalCometFileName$
                            Cls
                            View (0, 0)-(1776, 999)
                            Window (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, ZoomWindow4)
                            Color _RGB(255, 255, 255), _RGB(0, 0, 0)
                            Exit Sub
                        Case 16
                            Cls
                            View (0, 0)-(1776, 999)
                            Window (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, ZoomWindow4)
                            Color _RGB(255, 255, 255), _RGB(0, 0, 0)
                            Exit Sub
                    End Select
                Case 27, 13 ' Return or Esc - menu is done, things selected for return, cleared if esc
                    If TestKey = 27 Then SaveTheImage = 0
                    If ButtonNumber = 15 Then SaveTheImage = 0
                    Cls
                    View (0, 0)-(1776, 999)
                    Window (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, ZoomWindow4)
                    Color _RGB(255, 255, 255), _RGB(0, 0, 0)
                    Exit Sub
            End Select
            KeyPressed$ = ""
            Call ShowImageSaveOptions
        End If
    Wend

    View (0, 0)-(1776, 999)
    Window (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, ZoomWindow4)
    Color _RGB(255, 255, 255), _RGB(0, 0, 0)

End Sub

Sub ShowImageSaveOptions
    '    VIEW (400, 250)-(765, 780), _RGB(0, 0, 0), _RGB(100, 100, 50)
    '_printstring(x,y) X ranges from 400 most left to 765 most right - tied to VIEW, not window
    '_printstring(x,y) Y ranges from 250 most top to 780 most bottom
    Color _RGB(0, 0, 0), _RGB(230, 230, 230)
    _PrintString (410, 740), "Use cursors to move    Space Bar to select"
    _PrintString (410, 760), "   Esc cancels    Return starts saving"


    i = 465: k = 110: J1 = 350: JStep = 36
    j = J1
    If SaveTheImage = 1 Then StatusOfButton$ = "Yes" Else StatusOfButton$ = ""
    Call DrawOnOffButton(i, j, StatusOfButton$)
    If ButtonNumber = 1 Then Color _RGB(145, 100, 0), _RGB(210, 210, 210)
    _PrintString (i + 15, j), " Save Next Image Only "

    j = J1 + JStep
    If SaveTheImage = 50 Then StatusOfButton$ = "Yes" Else StatusOfButton$ = ""
    Call DrawOnOffButton(i, j, StatusOfButton$)
    If ButtonNumber = 2 Then Color _RGB(145, 100, 0), _RGB(210, 210, 210)
    _PrintString (i + 15, j), " Save 50 images "

    j = J1 + JStep * 2
    If SaveTheImage = 100 Then StatusOfButton$ = "Yes" Else StatusOfButton$ = ""
    Call DrawOnOffButton(i, j, StatusOfButton$)
    If ButtonNumber = 3 Then Color _RGB(145, 100, 0), _RGB(210, 210, 210)
    _PrintString (i + 15, j), " Save 100 images "

    j = J1 + JStep * 3
    If SaveTheImage = 500 Then StatusOfButton$ = "Yes" Else StatusOfButton$ = ""
    Call DrawOnOffButton(i, j, StatusOfButton$)
    If ButtonNumber = 4 Then Color _RGB(145, 100, 0), _RGB(210, 210, 210)
    _PrintString (i + 15, j), " Save 500 images "


    j = J1 + JStep * 4
    If SaveTheImage = 1000 Then StatusOfButton$ = "Yes" Else StatusOfButton$ = ""
    Call DrawOnOffButton(i, j, StatusOfButton$)
    If ButtonNumber = 5 Then Color _RGB(145, 100, 0), _RGB(210, 210, 210)
    _PrintString (i + 15, j), " Save 1,000 images "

    j = J1 + JStep * 5
    If SaveTheImage = 10000 Then StatusOfButton$ = "Yes" Else StatusOfButton$ = ""
    Call DrawOnOffButton(i, j, StatusOfButton$)
    If ButtonNumber = 6 Then Color _RGB(145, 100, 0), _RGB(210, 210, 210)
    _PrintString (i + 15, j), " Save 10,000 images "


    j = J1 + JStep * 7 ' Buttons 7 to 13
    I2 = 448
    Color _RGB(0, 0, 0), _RGB(220, 220, 220)
    If ButtonNumber >= 7 And ButtonNumber <= 13 Then Color _RGB(175, 120, 0), _RGB(210, 210, 210)
    _PrintString (465, j - 38), " How Many Seconds Between Saves "
    For m = 7 To 13
        i = I2 + 48 * (m - 7)
        Color _RGB(0, 0, 0), _RGB(220, 220, 220)
        Call DrawOnOffButton(i, j, "")
        Select Case m
            Case 7:
                If ButtonNumber = 7 Then Color _RGB(255, 0, 0), _RGB(220, 220, 220)
                _PrintString (i - 20, j - 20), "1"
                Color _RGB(0, 255, 0), _RGB(220, 220, 220)
                If SaveOneInTen = 1 Then _PrintString (i - 20, j + 1.5), "X"
            Case 8:
                If ButtonNumber = 8 Then Color _RGB(255, 0, 0), _RGB(220, 220, 220)
                _PrintString (i - 23, j - 20), "5"
                Color _RGB(0, 255, 0), _RGB(220, 220, 220)
                If SaveOneInTen = 5 Then _PrintString (i - 20, j + 1.5), "X"
            Case 9:
                If ButtonNumber = 9 Then Color _RGB(255, 0, 0), _RGB(220, 220, 220)
                _PrintString (i - 24, j - 20), "10"
                Color _RGB(0, 255, 0), _RGB(220, 220, 220)
                If SaveOneInTen = 10 Then _PrintString (i - 20, j + 1.5), "X"
            Case 10:
                If ButtonNumber = 10 Then Color _RGB(255, 0, 0), _RGB(220, 220, 220)
                _PrintString (i - 29, j - 20), "100"
                Color _RGB(0, 255, 0), _RGB(220, 220, 220)
                If SaveOneInTen = 100 Then _PrintString (i - 20, j + 1.5), "X"
            Case 11:
                If ButtonNumber = 11 Then Color _RGB(255, 0, 0), _RGB(220, 220, 220)
                _PrintString (i - 29, j - 20), "500"
                Color _RGB(0, 255, 0), _RGB(220, 220, 220)
                If SaveOneInTen = 500 Then _PrintString (i - 20, j + 1.5), "X"
            Case 12:
                If ButtonNumber = 12 Then Color _RGB(255, 0, 0), _RGB(220, 220, 220)
                _PrintString (i - 31, j - 20), "1000"
                Color _RGB(0, 255, 0), _RGB(220, 220, 220)
                If SaveOneInTen = 1000 Then _PrintString (i - 20, j + 1.5), "X"
            Case 13:
                If ButtonNumber = 13 Then Color _RGB(255, 0, 0), _RGB(220, 220, 220)
                _PrintString (i - 30, j - 20), "2000 "
                Color _RGB(0, 255, 0), _RGB(220, 220, 220)
                If SaveOneInTen = 2000 Then _PrintString (i - 20, j + 1.5), "X"
        End Select
    Next m


    j = J1 + JStep * 8
    i = 465
    Color _RGB(0, 0, 0), _RGB(220, 220, 220): If ButtonNumber = 14 Then Color _RGB(145, 100, 0), _RGB(210, 210, 210)
    _PrintString (i - 35, j), " Change File name "

    Line (420, 655)-(730, 675), _RGB(250, 250, 250), BF ' Enter File Name
    j = J1 + JStep * 8.5
    If ButtonNumber = 14 Then
        Line (400, 739)-(765, 780), _RGB(230, 230, 230), BF ' bottom note
        Color _RGB(145, 100, 0), _RGB(230, 230, 230)
        _PrintString (410, 760), "  Esc restores file name to original"
        Color _RGB(145, 100, 0), _RGB(150, 150, 150)
        _PrintString (i - 40, j), CometFileName$ + " "
    End If
    Color _RGB(0, 0, 0), _RGB(255, 255, 255)
    _PrintString (i - 40, j), CometFileName$

    i = 420: k = 125
    j = J1 + JStep * 9.8
    Call DrawButton(i, j, k)
    Color _RGB(125, 25, 25), _RGB(220, 220, 220): If ButtonNumber = 15 Then Color _RGB(125, 25, 25), _RGB(190, 190, 190)
    _PrintString (i + 9, j), "Cancel Saving"

    i = 570: k = 170
    Call DrawButton(i, j, k)
    Color _RGB(25, 125, 25), _RGB(220, 220, 220): If ButtonNumber = 16 Then Color _RGB(25, 125, 25), _RGB(190, 190, 190)
    _PrintString (i + 11, j), "Begin Saving Images"


    Color _RGB(25, 125, 25), _RGB(220, 220, 220)
    _Display

End Sub


Sub DrawButton (i, j, k)
    Line (i - 3, j - 7)-(i + k + 3, j + 21), _RGB(0, 0, 0), BF
    Line (i - 2, j - 6)-(i + k + 2, j + 20), _RGB(110, 110, 0), BF
    Line (i - 1, j - 5)-(i + k + 1, j + 19), _RGB(200, 180, 180), BF
    Line (i - 0, j - 4)-(i + k + 0, j + 18), _RGB(220, 220, 220), BF
End Sub


Sub DrawOnOffButton (i, j, Status$)
    Line (i - 24, j - 1)-(i - 8, j + 17), _RGB(0, 0, 0), BF
    Line (i - 23, j)-(i - 9, j + 16), _RGB(240, 240, 240), BF
    Color _RGB(0, 255, 0), _RGB(240, 240, 240)
    If Status$ = "Yes" Then _PrintString (i - 19, j + 1.5), "X"
    Color _RGB(0, 0, 0), _RGB(220, 220, 220)
End Sub

Sub DemoExplosion
    PresentCometSpeed = Sqr(CometSpeedX(150, 150) ^ 2 + CometSpeedY(150, 150) ^ 2)
    Select Case HitEarthBefore$
        Case "Yes"
            For x = 220 To 290
                For y = 220 To 290
                    CometX(x, y) = CometX(150, 150): CometY(x, y) = CometY(150, 150)
                    ' Totally Random speeds to start, both postive and negative +/- 02.5 speed of the comet
                    CometSpeedX(x, y) = 0.25 * PresentCometSpeed * (Rnd(B) - .5) * Rnd(32) ' single random number leaves a hard end at 0.5.  Adding a second random factor makes the end number be random instead of a fixed maximum
                    CometSpeedY(x, y) = 0.25 * PresentCometSpeed * (Rnd(B) - .5) * Rnd(32)

                    ' Then Add in some of the comet's speed and direction ONLY positive
                    CometSpeedX(x, y) = CometSpeedX(x, y) + .1 * Earth002SpeedX * (Rnd(B) + .5) * (Rnd(32) + .5) ' at 2.25 factor no particles would go faster than the comet
                    CometSpeedY(x, y) = CometSpeedY(x, y) + .1 * Earth002SpeedY * (Rnd(B) + .5) * (Rnd(32) + .5)
                    CometSpeedX(x, y) = CometSpeedX(x, y) + 1 * CometSpeedX(150, 150) * (Rnd(B) + .5) * (Rnd(32) + .5) ' at 2.25 factor no particles would go faster than the comet
                    CometSpeedY(x, y) = CometSpeedY(x, y) + 1 * CometSpeedY(150, 150) * (Rnd(B) + .5) * (Rnd(32) + .5)
                    CometMass(x, y) = 1.2
                    CometColor(x, y) = _RGB(150, 150, 255) ' Blue
                Next y
            Next x
        Case Else
            For x = 120 To 220
                For y = 160 To 260
                    CometX(x, y) = CometX(150, 150): CometY(x, y) = CometY(150, 150)
                    ' Totally Random speeds to start, both postive and negative +/- 02.5 speed of the comet
                    CometSpeedX(x, y) = 0.25 * PresentCometSpeed * (Rnd(B) - .5) * Rnd(32) ' single random number leaves a hard end at 0.5.  Adding a second random factor makes the end number be random instead of a fixed maximum
                    CometSpeedY(x, y) = 0.25 * PresentCometSpeed * (Rnd(B) - .5) * Rnd(32)

                    ' Then Add in some of the comet's speed and direction ONLY positive
                    CometSpeedX(x, y) = CometSpeedX(x, y) + .1 * Earth002SpeedX * (Rnd(B) + .5) * (Rnd(32) + .5) ' at 2.25 factor no particles would go faster than the comet
                    CometSpeedY(x, y) = CometSpeedY(x, y) + .1 * Earth002SpeedY * (Rnd(B) + .5) * (Rnd(32) + .5)
                    CometSpeedX(x, y) = CometSpeedX(x, y) + 1 * CometSpeedX(150, 150) * (Rnd(B) + .5) * (Rnd(32) + .5) ' at 2.25 factor no particles would go faster than the comet
                    CometSpeedY(x, y) = CometSpeedY(x, y) + 1 * CometSpeedY(150, 150) * (Rnd(B) + .5) * (Rnd(32) + .5)
                    CometMass(x, y) = 1.2
                    CometColor(x, y) = _RGB(150, 255, 150) ' green
                Next y
            Next x
    End Select
End Sub


Sub DemoExplosionSwiftTuttle


    '    CometInitialSpeedX = -7740 ' km/sec
    '    CometInitialSpeedY = -500 ' m/sec   ' Range from 39660 to 42860 fits orbits in 0.1 - 2 X 133 year orbits if X = 0  at start - above 43000 it leaves sun orbit range
    '    CometInitialSpeedZ = -42137 ' m/sec   ' Range from 39660 to 42860 fits orbits in 0.1 - 2 X 133 year orbits if X = 0  at start - above 43000 it leaves sun orbit range

    ' May 2023 version with full 3D calculations
    ' Y Speed can only be negative. Positive Y leads to impacting planet Earth
    For x = 1 To 400
        For y = 1 To MaxYNumber
            CometColor(x, y) = _RGB(255, (255 * y / MaxYNumber), 0)
            CometMass(x, y) = 1.2
            CometX(x, y) = CometX(150, 150): CometY(x, y) = CometY(150, 150): CometZ(x, y) = CometZ(150, 150)
            Call RandomNumbersFewNearZero ' Do  not use for -.5 group or none will be negative.
            If y <> 150 Then
                CometSpeedZ(x, y) = CometInitialSpeedZ + (20000 - 10000 * y / MaxYNumber) * (Rnd(32) - .5) * RB ' smaller random numbers keep particles closer to the comet
                CometSpeedY(x, y) = CometInitialSpeedY + 10000 * (Rnd(44) - .65) * RD ' Bias to relate to impact not sending bits out to space if impacted with Earth first
                CometSpeedX(x, y) = CometInitialSpeedX + (25000 - 15000 * y / MaxYNumber) * (Rnd(98) - .5) * RF
            End If
        Next y
    Next x
    Exit Sub

End Sub


Sub DemoExplosionJupiter
    PresentCometSpeed = Sqr(CometSpeedX(150, 150) ^ 2 + CometSpeedY(150, 150) ^ 2)
    PresentJupiterSpeed = Sqr(JupiterSpeedX ^ 2 + JupiterSpeedY ^ 2)
    B = 29

    Select Case Scene$
        Case "Impact Jupiter, near miss Earth, then impact Earth 8.1 years later", "Impact Earth not Jupiter" ' Comet is moving very slowly so increase factors for energy transferred to debris
            For x = 1 To 70
                For y = 1 To 70
                    If x <> 150 Or y <> 150 Then ' no random speed to center point
                        Impactcount = Impactcount + 1: If Impactcount > 6 Then Impactcount = 1
                        Select Case Impactcount
                            Case 1
                                CometX(x, y) = (JupiterCenterX + CometX(150, 150)) / 2: CometY(x, y) = (JupiterCenterY + CometY(150, 150)) / 2
                                CometSpeedX(x, y) = 5 * PresentJupiterSpeed * (Rnd(B) - .5) * Rnd(32) ' single random number leaves a hard end at 0.5.  Adding a second random factor makes the end number be random instead of a fixed maximum
                                CometSpeedY(x, y) = 5 * PresentJupiterSpeed * (Rnd(B) - .5) * Rnd(32)
                            Case 2, 3, 4, 5, 6
                                CometX(x, y) = CometX(150, 150): CometY(x, y) = CometY(150, 150)
                                CometSpeedX(x, y) = 20 * PresentCometSpeed * (Rnd(B) - .5) * Rnd(32) ' single random number leaves a hard end at 0.5.  Adding a second random factor makes the end number be random instead of a fixed maximum
                                CometSpeedY(x, y) = 6 * PresentCometSpeed * (Rnd(B) - .5) * Rnd(32)
                        End Select

                        ' Totally Random speeds to start, both postive and negative +/- 0.5 speed of the comet
                        '                        CometSpeedX(x, y) = 12 * PresentCometSpeed * (RND(B) - .5) * RND(32) ' single random number leaves a hard end at 0.5.  Adding a second random factor makes the end number be random instead of a fixed maximum
                        '                        CometSpeedY(x, y) = 5 * PresentCometSpeed * (RND(B) - .5) * RND(32)

                        ' Then Add in some of the comet's speed and direction ONLY positive
                        CometSpeedX(x, y) = CometSpeedX(x, y) + .5 * JupiterSpeedX * (Rnd(B) + .5) * (Rnd(32) + .5)
                        CometSpeedY(x, y) = CometSpeedY(x, y) + .5 * JupiterSpeedY * (Rnd(B) + .5) * (Rnd(32) + .5)
                        CometSpeedX(x, y) = CometSpeedX(x, y) + 5 * CometSpeedX(150, 150) * (Rnd(B) + .5) * (Rnd(32) + .5) ' if divided by 2.25 factor no particles would go faster than the comet
                        CometSpeedY(x, y) = CometSpeedY(x, y) + 1.5 * CometSpeedY(150, 150) * (Rnd(B) + .5) * (Rnd(32) + .5)

                    End If
                    CometMass(x, y) = 1.2
                    CometColor(x, y) = _RGB(0, 255, 0) ' green
                Next y
            Next x


        Case Else
            For x = 1 To 70
                For y = 1 To 70
                    Impactcount = Impactcount + 1: If Impactcount > 6 Then Impactcount = 1
                    Select Case Impactcount
                        Case 1
                            CometX(x, y) = (JupiterCenterX + CometX(150, 150)) / 2: CometY(x, y) = (JupiterCenterY + CometY(150, 150)) / 2
                            CometSpeedX(x, y) = .5 * PresentCometSpeed * (Rnd(B) - .5) * Rnd(32) ' single random number leaves a hard end at 0.5.  Adding a second random factor makes the end number be random instead of a fixed maximum
                            CometSpeedY(x, y) = .5 * PresentCometSpeed * (Rnd(B) - .5) * Rnd(32)
                        Case 2, 3, 4, 5, 6
                            CometX(x, y) = CometX(150, 150): CometY(x, y) = CometY(150, 150)
                            CometSpeedX(x, y) = 1.5 * PresentCometSpeed * (Rnd(B) - .5) * Rnd(32) ' single random number leaves a hard end at 0.5.  Adding a second random factor makes the end number be random instead of a fixed maximum
                            CometSpeedY(x, y) = 1.5 * PresentCometSpeed * (Rnd(B) - .5) * Rnd(32)
                    End Select
                    ' Totally Random speeds to start, both postive and negative +/- 0.5 speed of the comet

                    ' Then Add in some of the comet's speed and direction ONLY positive
                    CometSpeedX(x, y) = CometSpeedX(x, y) + .5 * JupiterSpeedX * (Rnd(B) + .5) * (Rnd(32) + .5)
                    CometSpeedY(x, y) = CometSpeedY(x, y) + .5 * JupiterSpeedY * (Rnd(B) + .5) * (Rnd(32) + .5)
                    CometSpeedX(x, y) = CometSpeedX(x, y) + 1.25 * CometSpeedX(150, 150) * (Rnd(B) + .5) * (Rnd(32) + .5)
                    CometSpeedY(x, y) = CometSpeedY(x, y) + 1.25 * CometSpeedY(150, 150) * (Rnd(B) + .5) * (Rnd(32) + .5)
                    CometMass(x, y) = 1.2
                    CometColor(x, y) = _RGB(0, 255, 0) ' green
                Next y
            Next x
    End Select

End Sub

Sub RandomNumbers
    RA = Rnd(10)
    If RA < 0.3 Then RA = Rnd(10) ' reduce the number of low numbers
    If RA < 0.15 Then RA = Rnd(10) ' reduce the number of low numbers
    RB = Rnd(10)
    If RB < 0.3 Then RB = Rnd(10) ' reduce the number of low numbers
    If RB < 0.15 Then RB = Rnd(10) ' reduce the number of low numbers
    RC = Rnd(10)
    If RC < 0.3 Then RC = Rnd(10) ' reduce the number of low numbers
    If RC < 0.15 Then RC = Rnd(10) ' reduce the number of low numbers
    RD = Rnd(10)
    If RD < 0.3 Then RD = Rnd(10) ' reduce the number of low numbers
    If RD < 0.15 Then RD = Rnd(10) ' reduce the number of low numbers
    RE = Rnd(10)
    If RE < 0.3 Then RE = Rnd(10) ' reduce the number of low numbers
    If RE < 0.15 Then RE = Rnd(10) ' reduce the number of low numbers
    RF = Rnd(10)
    If RF < 0.3 Then RF = Rnd(10) ' reduce the number of low numbers
    If RF < 0.15 Then RF = Rnd(10) ' reduce the number of low numbers
End Sub

Sub RandomNumbersFewNearZero
    RA = Rnd(10)
    If RA < 0.3 Then RA = Rnd(10) ' reduce the number of low numbers
    If RA < 0.15 Then RA = Rnd(10) ' reduce the number of low numbers
    RB = Rnd(11)
    If RB < 0.3 Then RB = Rnd(10) ' reduce the number of low numbers
    If RB < 0.15 Then RB = Rnd(10) ' reduce the number of low numbers
    RC = Rnd(12)
    If RC < 0.3 Then RC = Rnd(10) ' reduce the number of low numbers
    If RC < 0.15 Then RC = Rnd(10) ' reduce the number of low numbers
    RD = Rnd(13)
    If RD < 0.3 Then RD = Rnd(10) ' reduce the number of low numbers
    If RD < 0.15 Then RD = Rnd(10) ' reduce the number of low numbers
    RE = Rnd(14)
    If RE < 0.3 Then RE = Rnd(10) ' reduce the number of low numbers
    If RE < 0.15 Then RE = Rnd(10) ' reduce the number of low numbers
    RF = Rnd(15)
    If RF < 0.3 Then RF = Rnd(10) ' reduce the number of low numbers
    If RF < 0.15 Then RF = Rnd(10) ' reduce the number of low numbers
    While RB < RD / 1.5: RB = Rnd(10): Wend ' thicken the part in line with the comet's direction by reducing the nunmber of random numbers near zero for X or Y and high for Y or X
    While RD < RB / 1.5: RD = Rnd(10): Wend
    While RE < RC / 1.5: RE = Rnd(10): Wend
    While RF < RE / 1.5: RF = Rnd(10): Wend
    While RA < RE / 1.5: RA = Rnd(10): Wend

End Sub

Sub DrawPlanetsSwiftTuttle

    ' Calculate the motion of the plantes

    ' Mercury           *****************************************************************************************************************************************************

    MercuryDistance = Sqr((MercuryCenterX - PlanetCenterX) ^ 2 + (MercuryCenterY - PlanetCenterY) ^ 2 + (MercuryCenterZ - PlanetCenterZ) ^ 2) ' Distance is distance fom planet center to Sun center
    If MercuryDistance < 1000 Then MercuryDistance = 1000
    MercuryAcceleration = (GSun / (MercuryDistance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
    MercurySpeedX = MercurySpeedX + ((MercuryAcceleration / MercuryDistance) * (PlanetCenterX - MercuryCenterX)) * SunZoomFactor
    MercurySpeedY = MercurySpeedY + ((MercuryAcceleration / MercuryDistance) * (PlanetCenterY - MercuryCenterY)) * SunZoomFactor
    MercurySpeedZ = MercurySpeedZ + ((MercuryAcceleration / MercuryDistance) * (PlanetCenterZ - MercuryCenterZ)) * SunZoomFactor
    MercuryCenterX = MercuryCenterX + MercurySpeedX * SpeedUpFactor
    MercuryCenterY = MercuryCenterY + MercurySpeedY * SpeedUpFactor
    MercuryCenterZ = MercuryCenterZ + MercurySpeedZ * SpeedUpFactor

    '    Locate 30, 10: Print "Mercury X", MercuryCenterX
    '    Locate 31, 10: Print "Mercury Y", MercuryCenterY
    '    Locate 32, 10: Print "Mercury Z", MercuryCenterZ
    '    Locate 33, 10: Print "Mercury Speed X", MercurySpeedX
    '    Locate 34, 10: Print "Mercury Speed Y", MercurySpeedY
    '    Locate 35, 10: Print "Mercury Speed Z", MercurySpeedZ

    '    If PreviousY < 0 And Earth002CenterY > 0 Then
    '        PreviousDif = CometTime - PreviousCT
    '        PreviousCT = CometTime
    '        CometYears = CometYears + 1
    '    End If
    '    Locate 36, 10: Print "CometTime: ", CometTime
    '    Locate 37, 10: Print "Comet Years: ", CometYears
    '    Locate 38, 10: Print "Comet Year Difference: ", PreviousDif
    '    PreviousY = Earth002CenterY




    ' Venus                *****************************************************************************************************************************************************

    VenusDistance = Sqr((VenusCenterX - PlanetCenterX) ^ 2 + (VenusCenterY - PlanetCenterY) ^ 2 + (VenusCenterZ - PlanetCenterZ) ^ 2) ' Distance is distance fom planet center to Sun center
    If VenusDistance < 1000 Then VenusDistance = 1000
    VenusAcceleration = (GSun / (VenusDistance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
    VenusSpeedX = VenusSpeedX + ((VenusAcceleration / VenusDistance) * (PlanetCenterX - VenusCenterX)) * SunZoomFactor
    VenusSpeedY = VenusSpeedY + ((VenusAcceleration / VenusDistance) * (PlanetCenterY - VenusCenterY)) * SunZoomFactor
    VenusSpeedZ = VenusSpeedZ + ((VenusAcceleration / VenusDistance) * (PlanetCenterZ - VenusCenterZ)) * SunZoomFactor
    VenusCenterX = VenusCenterX + VenusSpeedX * SpeedUpFactor
    VenusCenterY = VenusCenterY + VenusSpeedY * SpeedUpFactor
    VenusCenterZ = VenusCenterZ + VenusSpeedZ * SpeedUpFactor

    '    Locate 30, 10: Print "Venus X", VenusCenterX
    '    Locate 31, 10: Print "Venus Y", VenusCenterY
    '    Locate 32, 10: Print "Venus Z", VenusCenterZ
    '    Locate 33, 10: Print "Venus Speed X", VenusSpeedX
    '    Locate 34, 10: Print "Venus Speed Y", VenusSpeedY
    '    Locate 35, 10: Print "Venus Speed Z", VenusSpeedZ



    ' Earth002                *****************************************************************************************************************************************************

    Earth002Distance = Sqr((Earth002CenterX - PlanetCenterX) ^ 2 + (Earth002CenterY - PlanetCenterY) ^ 2 + (Earth002CenterZ - PlanetCenterZ) ^ 2) ' Distance is distance fom planet center to Sun center
    If Earth002Distance < 1000 Then Earth002Distance = 1000
    Earth002Acceleration = (GSun / (Earth002Distance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
    Earth002SpeedX = Earth002SpeedX + ((Earth002Acceleration / Earth002Distance) * (PlanetCenterX - Earth002CenterX)) * SunZoomFactor
    Earth002SpeedY = Earth002SpeedY + ((Earth002Acceleration / Earth002Distance) * (PlanetCenterY - Earth002CenterY)) * SunZoomFactor
    Earth002SpeedZ = Earth002SpeedZ + ((Earth002Acceleration / Earth002Distance) * (PlanetCenterZ - Earth002CenterZ)) * SunZoomFactor
    Earth002CenterX = Earth002CenterX + Earth002SpeedX * SpeedUpFactor
    Earth002CenterY = Earth002CenterY + Earth002SpeedY * SpeedUpFactor
    Earth002CenterZ = Earth002CenterZ + Earth002SpeedZ * SpeedUpFactor


    ' Mars                *****************************************************************************************************************************************************

    MarsDistance = Sqr((MarsCenterX - PlanetCenterX) ^ 2 + (MarsCenterY - PlanetCenterY) ^ 2 + (MarsCenterZ - PlanetCenterZ) ^ 2) ' Distance is distance fom planet center to Sun center
    If MarsDistance < 1000 Then MarsDistance = 1000
    MarsAcceleration = (GSun / (MarsDistance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
    MarsSpeedX = MarsSpeedX + ((MarsAcceleration / MarsDistance) * (PlanetCenterX - MarsCenterX)) * SunZoomFactor
    MarsSpeedY = MarsSpeedY + ((MarsAcceleration / MarsDistance) * (PlanetCenterY - MarsCenterY)) * SunZoomFactor
    MarsSpeedZ = MarsSpeedZ + ((MarsAcceleration / MarsDistance) * (PlanetCenterZ - MarsCenterZ)) * SunZoomFactor
    MarsCenterX = MarsCenterX + MarsSpeedX * SpeedUpFactor
    MarsCenterY = MarsCenterY + MarsSpeedY * SpeedUpFactor
    MarsCenterZ = MarsCenterZ + MarsSpeedZ * SpeedUpFactor

    '    Locate 30, 10: Print "Mars X", MarsCenterX
    '    Locate 31, 10: Print "Mars Y", MarsCenterY
    '    Locate 32, 10: Print "Mars Z", MarsCenterZ
    '    Locate 33, 10: Print "Mars Speed X", MarsSpeedX
    '    Locate 34, 10: Print "Mars Speed Y", MarsSpeedY
    '    Locate 35, 10: Print "Mars Speed Z", MarsSpeedZ


    ' Jupiter                *****************************************************************************************************************************************************

    JupiterDistance = Sqr((JupiterCenterX - PlanetCenterX) ^ 2 + (JupiterCenterY - PlanetCenterY) ^ 2 + (JupiterCenterZ - PlanetCenterZ) ^ 2) ' Distance is distance fom planet center to Sun center
    If JupiterDistance < 1000 Then JupiterDistance = 1000
    JupiterAcceleration = (GSun / (JupiterDistance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
    JupiterSpeedX = JupiterSpeedX + ((JupiterAcceleration / JupiterDistance) * (PlanetCenterX - JupiterCenterX)) * SunZoomFactor
    JupiterSpeedY = JupiterSpeedY + ((JupiterAcceleration / JupiterDistance) * (PlanetCenterY - JupiterCenterY)) * SunZoomFactor
    JupiterSpeedZ = JupiterSpeedZ + ((JupiterAcceleration / JupiterDistance) * (PlanetCenterZ - JupiterCenterZ)) * SunZoomFactor
    JupiterCenterX = JupiterCenterX + JupiterSpeedX * SpeedUpFactor
    JupiterCenterY = JupiterCenterY + JupiterSpeedY * SpeedUpFactor
    JupiterCenterZ = JupiterCenterZ + JupiterSpeedZ * SpeedUpFactor



    ' Saturn                *****************************************************************************************************************************************************

    SaturnDistance = Sqr((SaturnCenterX - PlanetCenterX) ^ 2 + (SaturnCenterY - PlanetCenterY) ^ 2 + (SaturnCenterZ - PlanetCenterZ) ^ 2) ' Distance is distance fom planet center to Sun center
    If SaturnDistance < 1000 Then SaturnDistance = 1000
    SaturnAcceleration = (GSun / (SaturnDistance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
    SaturnSpeedX = SaturnSpeedX + ((SaturnAcceleration / SaturnDistance) * (PlanetCenterX - SaturnCenterX)) * SunZoomFactor
    SaturnSpeedY = SaturnSpeedY + ((SaturnAcceleration / SaturnDistance) * (PlanetCenterY - SaturnCenterY)) * SunZoomFactor
    SaturnSpeedZ = SaturnSpeedZ + ((SaturnAcceleration / SaturnDistance) * (PlanetCenterZ - SaturnCenterZ)) * SunZoomFactor
    SaturnCenterX = SaturnCenterX + SaturnSpeedX * SpeedUpFactor
    SaturnCenterY = SaturnCenterY + SaturnSpeedY * SpeedUpFactor
    SaturnCenterZ = SaturnCenterZ + SaturnSpeedZ * SpeedUpFactor

    ' Uranus               *****************************************************************************************************************************************************

    UranusDistance = Sqr((UranusCenterX - PlanetCenterX) ^ 2 + (UranusCenterY - PlanetCenterY) ^ 2 + (UranusCenterZ - PlanetCenterZ) ^ 2) ' Distance is distance fom planet center to Sun center
    If UranusDistance < 1000 Then UranusDistance = 1000
    UranusAcceleration = (GSun / (UranusDistance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
    UranusSpeedX = UranusSpeedX + ((UranusAcceleration / UranusDistance) * (PlanetCenterX - UranusCenterX)) * SunZoomFactor
    UranusSpeedY = UranusSpeedY + ((UranusAcceleration / UranusDistance) * (PlanetCenterY - UranusCenterY)) * SunZoomFactor
    UranusSpeedZ = UranusSpeedZ + ((UranusAcceleration / UranusDistance) * (PlanetCenterZ - UranusCenterZ)) * SunZoomFactor
    UranusCenterX = UranusCenterX + UranusSpeedX * SpeedUpFactor
    UranusCenterY = UranusCenterY + UranusSpeedY * SpeedUpFactor
    UranusCenterZ = UranusCenterZ + UranusSpeedZ * SpeedUpFactor

    ' Neptune               *****************************************************************************************************************************************************

    NeptuneDistance = Sqr((NeptuneCenterX - PlanetCenterX) ^ 2 + (NeptuneCenterY - PlanetCenterY) ^ 2 + (NeptuneCenterZ - PlanetCenterZ) ^ 2) ' Distance is distance fom planet center to Sun center
    If NeptuneDistance < 1000 Then NeptuneDistance = 1000
    NeptuneAcceleration = (GSun / (NeptuneDistance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
    NeptuneSpeedX = NeptuneSpeedX + ((NeptuneAcceleration / NeptuneDistance) * (PlanetCenterX - NeptuneCenterX)) * SunZoomFactor
    NeptuneSpeedY = NeptuneSpeedY + ((NeptuneAcceleration / NeptuneDistance) * (PlanetCenterY - NeptuneCenterY)) * SunZoomFactor
    NeptuneSpeedZ = NeptuneSpeedZ + ((NeptuneAcceleration / NeptuneDistance) * (PlanetCenterZ - NeptuneCenterZ)) * SunZoomFactor
    NeptuneCenterX = NeptuneCenterX + NeptuneSpeedX * SpeedUpFactor
    NeptuneCenterY = NeptuneCenterY + NeptuneSpeedY * SpeedUpFactor
    NeptuneCenterZ = NeptuneCenterZ + NeptuneSpeedZ * SpeedUpFactor


    For Pli = 1 To 8 ' Set parameters for actual drawing of planets with minimal repeating of commands
        Select Case Pli
            Case 1: 'Mercury
                PlanetIA = MercuryCenterX: PlanetIB = MercuryCenterY: PlanetIC = MercuryCenterZ
                PlanetISize = 0
                PlanetScale = 1000000
                PlanetIColor = _RGB(250, 0, 0)
            Case 2: 'Venus
                PlanetIA = VenusCenterX: PlanetIB = VenusCenterY: PlanetIC = VenusCenterZ
                PlanetISize = 3000000
                If Scene$ = "Encke" Then PlanetISize = 300000
                PlanetScale = 1000000
                PlanetIColor = _RGB(255, 255, 255)
            Case 3: 'Earth
                PlanetIA = Earth002CenterX: PlanetIB = Earth002CenterY: PlanetIC = Earth002CenterZ
                PlanetISize = 4000000
                If Scene$ = "Encke" Then PlanetISize = 400000
                PlanetScale = 1000000
                PlanetIColor = _RGB(0, 255, 0)
            Case 4: 'Mars
                PlanetIA = MarsCenterX: PlanetIB = MarsCenterY: PlanetIC = MarsCenterZ
                PlanetISize = 2000000
                If Scene$ = "Encke" Then PlanetISize = 200000
                PlanetScale = 1000000
                PlanetIColor = _RGB(255, 0, 0)
            Case 5: 'Jupiter
                PlanetIA = JupiterCenterX: PlanetIB = JupiterCenterY: PlanetIC = JupiterCenterZ
                PlanetISize = 10000000
                If Scene$ = "Encke" Then PlanetISize = 1000000
                PlanetScale = 2500000
                PlanetIColor = _RGB(255, 125, 0) ' Orange
                If Scene$ = "Encke" And CometFileName$ = "D:/CometEnckeImages3/" Then PlanetIColor = _RGB(80, 40, 0) ' Light Orange
                If Scene$ = "Encke" And CometFileName$ = "D:/CometEnckeImages2/" Then PlanetIColor = _RGB(80, 40, 0) ' Light Orange
                If Scene$ = "Encke" And CometFileName$ = "D:/CometEnckeImages1/" Then PlanetIColor = _RGB(80, 40, 0) ' Light Orange
                If Scene$ = "Encke" And SwiftView$ = "Trio" Then PlanetIColor = _RGB(80, 40, 0) ' Light Orange
            Case 6: 'Saturn
                PlanetIA = SaturnCenterX: PlanetIB = SaturnCenterY: PlanetIC = SaturnCenterZ
                PlanetISize = 2000000
                If Scene$ = "Encke" Then PlanetISize = 750000
                PlanetScale = 2000000
                PlanetIColor = _RGB(50, 255, 255) ' Cyan
                If Scene$ = "Encke" And CometFileName$ = "D:/CometEnckeImages3/" Then PlanetIColor = _RGB(0, 80, 80) ' Cyan
                If Scene$ = "Encke" And CometFileName$ = "D:/CometEnckeImages2/" Then PlanetIColor = _RGB(0, 80, 80) ' Cyan
                If Scene$ = "Encke" And CometFileName$ = "D:/CometEnckeImages1/" Then PlanetIColor = _RGB(0, 80, 80) ' Cyan
                If Scene$ = "Encke" And SwiftView$ = "Trio" Then PlanetIColor = _RGB(0, 80, 80) ' Cyan
            Case 7: 'Uranus
                PlanetIA = UranusCenterX: PlanetIB = UranusCenterY: PlanetIC = UranusCenterZ
                PlanetISize = 7500000
                PlanetScale = 2500000
                PlanetIColor = _RGB(100, 255, 100) ' Bright Green
                If Scene$ = "Encke" Then PlanetIColor = _RGB(20, 50, 20) ' Almost Black and not seen in the images
            Case 8: 'Neptune
                PlanetIA = NeptuneCenterX: PlanetIB = NeptuneCenterY: PlanetIC = NeptuneCenterZ
                PlanetISize = 7500000
                PlanetScale = 2500000
                PlanetIColor = _RGB(150, 255, 50) ' Orange
                If Scene$ = "Encke" Then PlanetIColor = _RGB(30, 50, 10) ' Almost Black and not seen in the images
        End Select

        Select Case SwiftView$ ' Draw planets
            Case "Top"
                If AutoRotate$ = "On" Or AutoRotate$ = "Hold" Then
                    For PJ = 1 To 3
                        Circle (PlanetIA, PlanetIB * Sin(Radian(ViewAngle)) + PlanetIC * Cos(Radian(ViewAngle))), PlanetISize + PJ * PlanetScale, PlanetIColor
                    Next PJ
                    If Pli = 6 Then Circle (PlanetIA, PlanetIB * Sin(Radian(ViewAngle)) + PlanetIC * Cos(Radian(ViewAngle))), PlanetISize + PJ * PlanetScale * 1.3, _RGB(255, 250, 0): Circle (PlanetIA, PlanetIB * Sin(Radian(ViewAngle)) + PlanetIC * Cos(Radian(ViewAngle))), PlanetISize + PJ * PlanetScale * 1.6, _RGB(255, 250, 0) ' rings of Saturn
                Else
                    For PJ = 1 To 3
                        Circle (PlanetIA, PlanetIB), PlanetISize + PJ * PlanetScale, PlanetIColor
                    Next PJ
                    If Pli = 6 Then Circle (PlanetIA, PlanetIB), PlanetISize + PJ * PlanetScale * 1.3, _RGB(255, 250, 0): Circle (PlanetIA, PlanetIB), PlanetISize + PJ * PlanetScale * 1.6, _RGB(255, 250, 0) ' rings of Saturn
                End If

            Case "Front"
                For PJ = 1 To 3
                    Circle (PlanetIA, PlanetIC), PlanetISize + PJ * PlanetScale, PlanetIColor
                Next PJ
            Case "Bottom"
                For PJ = 1 To 3
                    Circle (PlanetIA, -PlanetIB), PlanetISize + PJ * PlanetScale, PlanetIColor
                Next PJ
                If Pli = 6 Then Circle (PlanetIA, -PlanetIB), PlanetISize + PJ * PlanetScale * 1.3, _RGB(255, 250, 0): Circle (PlanetIA, -PlanetIB), PlanetISize + PJ * PlanetScale * 1.6, _RGB(255, 250, 0) ' rings of Saturn
            Case "Back"
                For PJ = 1 To 3
                    Circle (PlanetIA, -PlanetIC), PlanetISize + PJ * PlanetScale, PlanetIColor
                Next PJ
            Case "LeftSide"
                For PJ = 1 To 3
                    Circle (PlanetIC, PlanetIB), PlanetISize + PJ * PlanetScale, PlanetIColor
                Next PJ
            Case "RightSide"
                For PJ = 1 To 3
                    Circle (-PlanetIC, PlanetIB), PlanetISize + PJ * PlanetScale, PlanetIColor
                Next PJ
            Case "Trio"
                For PJ = 1 To 3 ' Top
                    Circle (PlanetIA, PlanetIB + 200000000), PlanetISize + PJ * PlanetScale, PlanetIColor
                Next PJ
                For PJ = 1 To 3 ' Front
                    Circle (PlanetIA, PlanetIC - 200000000), PlanetISize + PJ * PlanetScale, PlanetIColor
                Next PJ
                For PJ = 1 To 3 ' Right
                    Circle (-PlanetIC - 500000000, PlanetIB + 200000000), PlanetISize + PJ * PlanetScale, PlanetIColor
                Next PJ

        End Select




    Next Pli

    Exit Sub

    'Draw Ganymede                *****************************************************************************************************************************************************
    GanymedeDistance = Sqr((GanymedeCenterX - SunCenterX) ^ 2 + (GanymedeCenterY - SunCenterY) ^ 2) ' Distance is distance fom Ganymede center to Jupiter Center
    If GanymedeDistance < 1000 Then GanymedeDistance = 1000
    GanymedeAcceleration = (GSun / (GanymedeDistance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
    GanymedeSpeedX = GanymedeSpeedX + ((GanymedeAcceleration / GanymedeDistance) * (SunCenterX - GanymedeCenterX)) * SunZoomFactor
    GanymedeSpeedY = GanymedeSpeedY + ((GanymedeAcceleration / GanymedeDistance) * (SunCenterY - GanymedeCenterY)) * SunZoomFactor
    GanymedeCenterX = GanymedeCenterX + GanymedeSpeedX * SpeedUpFactor
    GanymedeCenterY = GanymedeCenterY + GanymedeSpeedY * SpeedUpFact
    GanymedeDistance = Sqr((GanymedeCenterX - JupiterCenterX) ^ 2 + (GanymedeCenterY - JupiterCenterY) ^ 2) ' Distance is distance fom Ganymede center to Jupiter Center
    If GanymedeDistance < 1000 Then GanymedeDistance = 1000
    GanymedeAcceleration = (GJupiter / (GanymedeDistance ^ 2)) / 1000 ^ 3 '
    GanymedeSpeedX = GanymedeSpeedX + (GanymedeAcceleration / GanymedeDistance) * (JupiterCenterX - GanymedeCenterX) * SunZoomFactor
    GanymedeSpeedY = GanymedeSpeedY + (GanymedeAcceleration / GanymedeDistance) * (JupiterCenterY - GanymedeCenterY) * SunZoomFactor
    GanymedeCenterX = GanymedeCenterX + GanymedeSpeedX * SpeedUpFactor
    GanymedeCenterY = GanymedeCenterY + GanymedeSpeedY * SpeedUpFactor

    Circle (GanymedeCenterX, GanymedeCenterY), 250000, _RGB(255, 155, 255)
    Circle (GanymedeCenterX, GanymedeCenterY), 300000, _RGB(255, 155, 255)
    Circle (GanymedeCenterX, GanymedeCenterY), 350000, _RGB(255, 255, 255)


End Sub
Sub DrawPlanets2SwiftTuttle
    Exit Sub
    If Earth002SpeedX > 0 Then
        Circle (Earth002CenterX, Earth002CenterZ / 10), 5000000, _RGB(0, 255, 255)
        Circle (Earth002CenterX, Earth002CenterZ / 10), 6000000, _RGB(0, 255, 255)
        Circle (Earth002CenterX, Earth002CenterZ / 10), 7000000, _RGB(0, 255, 255)
    End If
    If MarsSpeedX > 0 Then
        Circle (MarsCenterX, MarsCenterZ / 10), 3000000, _RGB(255, 0, 0)
        Circle (MarsCenterX, MarsCenterZ / 10), 4000000, _RGB(255, 0, 0)
        Circle (MarsCenterX, MarsCenterZ / 10), 5000000, _RGB(255, 0, 0)
    End If

End Sub

Sub RandomizeCometBibts (FirstX, FirstY, LastX, LastY)

    For x = FirstX To LastX
        For y = FirstY To LastY
            If x <> 150 Or y <> 150 Then ' no random speed to center point
                '                    CometSpeedX(x, y) = CometSpeedX(x, y) + 14500 * (RND(32) - .5) * RND(33) ' add up to 14500 m/sec = which X 2^.5 = total from X and Y, = ~ 20000 m/sec. Most are slower.
                '                    CometSpeedY(x, y) = CometSpeedY(x, y) + 14500 * (RND(32) - .5) * RND(33)
                ARandom = Rnd(32) - .5
                '                    ARandom = ARandom * 2 'random - .5 = range from -.5 to +.5, need -1 to +1
                CometSpeedX(x, y) = CometSpeedX(x, y) + 145 * ARandom
                '                    CometSpeedX(x, y) = CometSpeedX(x, y) * RND(33) + 20000 * ARandom ' add up to 14500 m/sec = which X 2^.5 = total from X and Y, = ~ 20000 m/sec. Most are slower.
                ARandom = Rnd(32) - .5
                '                   ARandom = ARandom * 2 'random - .5 = range from -.5 to +.5, need -1 to +1
                CometSpeedY(x, y) = CometSpeedY(x, y) + 145 * ARandom
                ARandom = Rnd(32) - .5
                '                   ARandom = ARandom * 2 'random - .5 = range from -.5 to +.5, need -1 to +1
                CometSpeedZ(x, y) = CometSpeedZ(x, y) + 145 * ARandom
                CometMass(x, y) = 1.2
                CometColor(x, y) = _RGB(255, 255, 0)
            End If
        Next y
    Next x


End Sub


Sub ImpactProbabilities
    ' 3D version
    ' Planet Center = 0,0,0

    '    CometInitialSpeedX = -2.861 ' km/sec - ALL Impact, None miss  for 500 points, with X start at  100,000 km
    '    CometRadius = 10

    '        PlanetCenterY = 0  replace planetCenterX and Y with 0 in the routine
    '        PlanetCenterX = 0
    PlanetRadius = 6371
    CometInitialSpeedX = -30 ' km/sec
    CometInitialSpeedY = 0 ' km/sec
    CometInitialSpeedZ = 0 ' km/sec
    ImpactProbView$ = "Top"
    Call WorldCoordinates

    '    CometStartY = PlanetCenterY - 250 + 25250 ' 1000 of 50 km diameter comets is sufficient for this demo
    '    CometStartY = 25000 ' 1000 of 50 km diameter comets is sufficient for this demo
    '    CometStartY = CometRadius * NumPointsToCalculate * 4 * 0.5


    '    ZoomWindow1 = -29700: ZoomWindow2 = -16710: ZoomWindow3 = 29700: ZoomWindow4 = 16710 ' Center on Earth = 0,0 co-ordinates =  same as pressing End key
    ZoomWindow1 = -14850: ZoomWindow2 = -9355: ZoomWindow3 = 14850: ZoomWindow4 = 7355 ' Center on Earth = 0,0 co-ordinates =  same as pressing End key plus Page Up


    '  *********************************  @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@   ***********************************************

    BeginImpactProbabilities:
    For Cii = 0 To 400
        For Cjj = 0 To 300
            CometX(Cii, Cjj) = 0: CometY(Cii, Cjj) = 0: CometZ(Cii, Cjj) = 0
            CometMass(Cii, Cjj) = 0: CometSize(Cii, Cjj) = 0
            CometColor(Cii, Cjj) = _RGB(0, 0, 0)
        Next Cjj
    Next Cii


    If ToggleRadius = 0 Then CometRadius = 30 Else CometRadius = ToggleRadius 'Comet diameter = 2 X CometRadius, with 1 pixel = 1 km size

    For i = 0 To 100: ImpactAngleProbs(i) = 0: ImpactAngleProbPercents(i) = 0: Next i ' set ImpactAngleProbs(0) as misses, ImpactAngleProbs(1) for 0-5 degrees, ImpactAngleProbs(2) as 5 to 10 etc.
    RunImpactProbabilities$ = ""
    NumPointsHitting = 0
    TotalPointsCalculated = 0
    CometStartX = 160000

    '**************************************
    NumPointsToCalculate = 1500
    '**************************************

    CometStartY = CometRadius * NumPointsToCalculate * 2
    CometStartZ = CometRadius * NumPointsToCalculate * 2
    DrawPathstartX = CometStartX

    Select Case Abs(CometInitialSpeedX)
        Case Is < 1.1: PointsTotal = 200000
        Case 1.1 To 5: PointsTotal = 2000000
        Case 5 To 10: PointsTotal = 2000000
        Case 10 To 50: PointsTotal = 800000
        Case Else: PointsTotal = 10000
    End Select


    '    A$ = "": WHILE A$ = "": A$ = INKEY$: WEND

    ' ********************  Draw Mini 2D version   *************************************************      ********************  Draw Mini 2D version   *************************************************
    ' ********************  Draw Mini 2D version   *************************************************      ********************  Draw Mini 2D version   *************************************************
    ' ********************  Draw Mini 2D version   *************************************************      ********************  Draw Mini 2D version   *************************************************

    Window (-800000, -500000)-(200000, 60000)
    Cls ' redraw without changing locations
    '  Calculate number of points to draw so that few miss planet

    For i = 7 To 6371 Step 10
        EarthColorization = 255 - 100 * i / 6371
        EarthColorization2 = 165 - 160 * i / 6371
        Circle (0, 0), i, _RGB(EarthColorization2, EarthColorization2, EarthColorization)
    Next i

    For Y1 = NumPointsToCalculate / 2 To NumPointsToCalculate Step 10
        DrawPathstartY = CometStartY - CometRadius * Y1 * 4
        pointstoDraw = 1
        startX = DrawPathstartX
        startY = DrawPathstartY
        CometPathSpeedX = CometInitialSpeedX
        CometPathSpeedY = CometInitialSpeedY

        While pointstoDraw < PointsTotal
            Distance = Sqr(startX ^ 2 + startY ^ 2)
            If Distance < PlanetRadius + CometRadius Then pointstoDraw = PointsTotal
            EAcc = (GEarth / (Distance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
            CometPathSpeedX = CometPathSpeedX + (EAcc / Distance) * (0 - startX) * 1
            CometPathSpeedY = CometPathSpeedY + (EAcc / Distance) * (0 - startY) * 1
            startX = startX + CometPathSpeedX
            startY = startY + CometPathSpeedY
            pointstoDraw = pointstoDraw + 1

            If startX < -120000 Then pointstoDraw = PointsTotal
            If startX > 170000 Then pointstoDraw = PointsTotal
            If startY < -140000 Then pointstoDraw = PointsTotal
            If startY > 140000 Then pointstoDraw = PointsTotal
        Wend
        If Abs(Distance) > PlanetRadius + CometRadius Then ' Missed Planet for HALF of the points, need to double number of points removed
            aTemp = NumPointsToCalculate: NumPointsToCalculate = (Y1 - NumPointsToCalculate / 2) * 2 + 2: Y1 = aTemp + 1
            CometStartY = CometRadius * NumPointsToCalculate * 2
            CometStartZ = CometRadius * NumPointsToCalculate * 2
            DrawPathstartX = CometStartX
            '            _PRINTSTRING (320, 40), "  Num Points  " + STR$(NumPointsToCalculate) + "  "
        End If
    Next Y1


    Select Case Abs(CometInitialSpeedX)
        Case Is <= 2: YStep = 14: ZStep = 5
        Case Is <= 5: YStep = 10: ZStep = 4
        Case Is <= 10: YStep = 6: ZStep = 3
        Case Else: YStep = 4: ZStep = 1
    End Select

    If Int(1 + NumPointsToCalculate / ZStep) * Int(1 + NumPointsToCalculate / YStep) > 30000 Then ZStep = ZStep + 15: YStep = YStep + 10

    While Int(1 + NumPointsToCalculate / ZStep) * Int(1 + NumPointsToCalculate / YStep) > 30000
        ZStep = ZStep + 2
        YStep = YStep + 1
        NumPointsToCalculate = Int(NumPointsToCalculate * .95)
    Wend

    For i = 7 To 6371 Step 10
        EarthColorization = 255 - 100 * i / 6371
        EarthColorization2 = 165 - 160 * i / 6371
        Circle (0, 0), i, _RGB(EarthColorization2, EarthColorization2, EarthColorization)
    Next i

    For Y1 = 0 To NumPointsToCalculate Step 20
        DrawPathstartY = CometStartY - CometRadius * Y1 * 4
        pointstoDraw = 1
        startX = DrawPathstartX
        startY = DrawPathstartY
        CometPathSpeedX = CometInitialSpeedX
        CometPathSpeedY = CometInitialSpeedY

        While pointstoDraw < PointsTotal
            Distance = Sqr(startX ^ 2 + startY ^ 2)
            If Distance < PlanetRadius + CometRadius Then pointstoDraw = PointsTotal
            EAcc = (GEarth / (Distance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
            CometPathSpeedX = CometPathSpeedX + (EAcc / Distance) * (0 - startX) * 1
            CometPathSpeedY = CometPathSpeedY + (EAcc / Distance) * (0 - startY) * 1
            startX = startX + CometPathSpeedX
            startY = startY + CometPathSpeedY
            pointstoDraw = pointstoDraw + 1

            If Int(pointstoDraw / 10) * 10 = pointstoDraw Then
                PSet (startX, startY), _RGB(0, 0, 255)
                If Int(Y1 / 50) * 50 = Y1 Then
                    If Int(Y1 / 100) * 100 = Y1 Then
                        PSet (startX, startY), _RGB(0, 0, 255)
                    Else
                        PSet (startX, startY), _RGB(55, 55, 55)
                    End If
                Else
                    PSet (startX, startY), _RGB(Y1 * .5, 255, 0)
                End If
            End If
            If startX < -120000 Then pointstoDraw = PointsTotal
            If startX > 170000 Then pointstoDraw = PointsTotal
            If startY < -140000 Then pointstoDraw = PointsTotal
            If startY > 140000 Then pointstoDraw = PointsTotal
        Wend
        If Distance > PlanetRadius + CometRadius Then aTemp = NumPointsToCalculate: NumPointsToCalculate = Y1 + YStep * 2: NumPointsToCalculate = aTemp

        Circle (DrawPathstartX, DrawPathstartY), CometRadius * 5, _RGB(255, 0, 0)

    Next Y1



    For i = 7 To 6371 Step 10
        EarthColorization = 255 - 100 * i / 6371
        EarthColorization2 = 165 - 160 * i / 6371
        Circle (0, 0), i, _RGB(EarthColorization2, EarthColorization2, EarthColorization)
    Next i

    _Display

    ' ********************  Finish Draw Mini 2D version   *************************************************
    ' ********************  Finish Draw Mini 2D version   *************************************************
    ' ********************  Finish Draw Mini 2D version   *************************************************

    Window (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, ZoomWindow4)
    ' ************************ HEADER *************************************
    HeaderDepth = ZoomWindow4 - (ZoomWindow4 - ZoomWindow2) * .02
    HeaderDepth2 = (ZoomWindow4 - ZoomWindow2) * .0008
    Line (ZoomWindow1, ZoomWindow4)-(ZoomWindow3, HeaderDepth), _RGB(215, 215, 215), BF
    Line (ZoomWindow1, HeaderDepth)-(ZoomWindow3, HeaderDepth - HeaderDepth2), _RGB(100, 100, 100), BF
    Line (ZoomWindow1, HeaderDepth - HeaderDepth2)-(ZoomWindow3, HeaderDepth - HeaderDepth2 * 1.5), _RGB(220, 220, 220), BF
    Color _RGB(0, 0, 0), _RGB(215, 215, 215)

    _PrintString (10, 3), " Comet Diameter: " + Left$(Str$(CometRadius * 2), 6) + " km "
    _PrintString (260, 3), "Initial Speed: " + Left$(Str$(Abs(CometInitialSpeedX)), 6) + "  km/s"
    Color _RGB(255, 0, 0), _RGB(0, 0, 0)
    Color _RGB(0, 0, 0), _RGB(215, 215, 215)
    'Locate function key reminders in bottom menu bar
    HeaderDepth = ZoomWindow2 + (ZoomWindow4 - ZoomWindow2) * .02
    HeaderDepth2 = (ZoomWindow4 - ZoomWindow2) * .0008
    Color _RGB(55, 55, 55), _RGB(215, 215, 185)
    Line (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, HeaderDepth), _RGB(215, 215, 185), BF
    _PrintString (10, 982), "Space Bar: Pause   Stop Program: 'Esc'     F1-F5: New Scenes     F6:Comet Radius       F7:Turn comet paths on/off       0-9 keys:Comet speed         Cursor Keys: Zoom, View "

    Color _RGB(255, 255, 255), _RGB(0, 0, 0)



    ' ************************ END HEADER *************************************


    For i = 7 To 6371 Step 10 ' Draw Earth
        EarthColorization = 255 - 100 * i / 6371
        EarthColorization2 = 165 - 160 * i / 6371
        Circle (0, 0), i, _RGB(EarthColorization2 / 1.5, EarthColorization2 / 1.5, EarthColorization / 1.5)
    Next i
    IntervalForCometPaths = 1
    If Abs(CometInitialSpeedX) > 0 Then IntervalForCometPaths = Int(400 / CometInitialSpeedX)

    Cii = 1: Cjj = 0: CometIIcount = 0

    For Z1 = 1 To NumPointsToCalculate Step ZStep
        DrawPathstartZ = CometStartZ - CometRadius * Z1 * 4
        For Y1 = 1 To NumPointsToCalculate Step YStep
            CometContinuing = 0
            TotalPointsCalculated = TotalPointsCalculated + 1
            '            CometStartY = CometRadius * NumPointsToCalculate * 2
            DrawPathstartY = CometStartY - CometRadius * Y1 * 4

            Circle (DrawPathstartX - CometRadius * Z1, CometStartY - CometRadius * Y1 * 4), CometRadius * 5, _RGB(0, 255, 0) ' start point of comet path line
            pointstoDraw = 1
            startX = DrawPathstartX
            startY = DrawPathstartY
            startZ = DrawPathstartZ
            CometPathSpeedX = CometInitialSpeedX
            CometPathSpeedY = CometInitialSpeedY
            CometPathSpeedZ = CometInitialSpeedZ
            PreviousImpactThickness = 0
            ItHasImpactedOnBottom = 0

            While pointstoDraw < PointsTotal
                Distance = Sqr(startX ^ 2 + startY ^ 2 + startZ ^ 2)
                If Distance < PlanetRadius + CometRadius Then '  BOTTOM of comet is hitting  ************************
                    DotXY = (PreviousX * (startX - PreviousX) + PreviousY * (startY - PreviousY) + PreviousZ * (startZ - PreviousZ))
                    XYMagnitude = ((startX - PreviousX) ^ 2 + (startY - PreviousY) ^ 2 + (startZ - PreviousZ) ^ 2) ^ 0.5 * (startX ^ 2 + startY ^ 2 + startZ ^ 2) ^ 0.5

                    Checkangle = 1
                    If Abs(XYMagnitude) > .0000001 Then Checkangle = DotXY / XYMagnitude
                    If Abs(Checkangle) > 1 Then Checkangle = 1
                    AngleofImpact = ARCCOS(Checkangle) * 180 / pi '   or 90 degrees minus that
                    CombinedAngle = AngleofImpact - 90

                    ItHasImpactedOnBottom = 1
                    ImpactThickness = PlanetRadius + CometRadius - Distance

                    Cjj = Cjj + 1: If Cjj > 300 Then Cjj = 1: Cii = Cii + 1: CometIIcount = CometIIcount + 1: If CometIIcount > 400 Then CometIIcount = 400
                    If Cii > 400 Then Cii = 400
                    CometX(Cii, Cjj) = startX: CometY(Cii, Cjj) = startY: CometZ(Cii, Cjj) = startZ
                    CometMass(Cii, Cjj) = 1

                    If ImpactThickness > PreviousImpactThickness Then '  if less then its leaving the planet surface not still impacting
                        If ImpactThickness <= CometRadius * 2 Then
                            If ImpactThickness <= CometRadius Then
                                CircleRad = Sqr(CometRadius ^ 2 - (CometRadius - ImpactThickness) ^ 2)
                            Else
                                CircleRad = Sqr(CometRadius ^ 2 - (ImpactThickness - CometRadius) ^ 2)
                            End If
                        End If
                        CometSize(Cii, Cjj) = CircleRad * 4

                        Circle (startX, startY), CircleRad * 2 * 2, _RGB(0, 155, 155) '  a crater should be about 10X the comet diameter but only add 2X
                        CometColor(Cii, Cjj) = _RGB(0, 155, 155)
                        If CombinedAngle < 15 Then Circle (startX, startY), CircleRad * 2 * 2, _RGB(155, 155, 255): CometColor(Cii, Cjj) = _RGB(155, 155, 255)
                        If CombinedAngle < 10 Then Circle (startX, startY), CircleRad * 2 * 2, _RGB(255, 255, 155): CometColor(Cii, Cjj) = _RGB(255, 255, 155)
                        If CombinedAngle < 5 Then Circle (startX, startY), CircleRad * 2 * 2, _RGB(255, 155, 155): CometColor(Cii, Cjj) = _RGB(255, 155, 155)
                        If CombinedAngle < 2 Then Circle (startX, startY), CircleRad * 2 * 2, _RGB(255, 0, 0): CometColor(Cii, Cjj) = _RGB(255, 0, 0)
                        If CombinedAngle > 40 And CombinedAngle < 50 Then Circle (startX, startY), CircleRad * 2 * 2, _RGB(0, 205, 155): CometColor(Cii, Cjj) = _RGB(0, 205, 155)
                        If CombinedAngle >= 80 Then Circle (startX, startY), CircleRad * 2 * 2, _RGB(0, 255, 255): CometColor(Cii, Cjj) = _RGB(0, 255, 255)
                        PreviousImpactThickness = ImpactThickness
                    End If



                End If
                If Distance < PlanetRadius - CometRadius Then '********************************* HIT PLANET by TOP of comet *************************************************************************************
                    CometSpeedAtImpact = Sqr(CometPathSpeedX ^ 2 + CometPathSpeedY ^ 2 + CometPathSpeedZ ^ 2)
                    '  Angle = arccos(A.X/|a| |x|) =  Cos-1[(x*a+y*b+z*c)/(Sqrt(x^2+y^2+z^2) * Sqrt(a^2+b^2+c^2))]    Scalar Law - https://en.wikipedia.org/wiki/Dot_product
                    '  a=startx, b=starty, c=startz
                    '  x=PreviousX, y=PreviousY, z=PreviousZ
                    '  Angle between incoming comet and earth is then:
                    '  Vector of earth radius =(0,0,0)-(a,b,c); Vector of incoming comet = (0,0,0)-(x-a,y-b,z-c) with x,y,z = PreviousX,Y,Z; a,b,c=startX,Starty,startz
                    '  DotXY = (PreviousX*(startX-PreviousX)  + PreviousY*(startY-PreviousY)  + PreviousZ*(startZ-PreviousZ))
                    '  XYMagnitude = ((startX-PreviousX)^2 + (startY-PreviousY)^2 + (startZ-PreviousZ)^2)^0.5 * (startx^2 + starty^2 + startz ^2)^0.5
                    '  Angle of Impact then = Arccos (DotXY/XYMagnitude) * 180 / pi    or 90 degrees minus that
                    '  ***************    NOTE: ARCOS (x) needs X <=1  **************************        IF x < 1 THEN ARCCOS = (2 * ATN(1)) - ATN(x / SQR(1 - x * x)) ELSE BEEP

                    DotXY = (PreviousX * (startX - PreviousX) + PreviousY * (startY - PreviousY) + PreviousZ * (startZ - PreviousZ))
                    XYMagnitude = ((startX - PreviousX) ^ 2 + (startY - PreviousY) ^ 2 + (startZ - PreviousZ) ^ 2) ^ 0.5 * (startX ^ 2 + startY ^ 2 + startZ ^ 2) ^ 0.5

                    Checkangle = 1
                    If Abs(XYMagnitude) > .0000001 Then Checkangle = DotXY / XYMagnitude
                    If Abs(Checkangle) > 1 Then Checkangle = 1
                    AngleofImpact = ARCCOS(Checkangle) * 180 / pi '   or 90 degrees minus that
                    CombinedAngle = AngleofImpact - 90


                    Color _RGB(0, 0, 0), _RGB(215, 215, 215)
                    _PrintString (800, 3), " Impact Speed:  " + Left$(Str$(CometSpeedAtImpact), 6) + "  km/s"
                    _PrintString (1100, 3), " Impact Angle:  " + Left$(Str$(CombinedAngle), 6) + "   "
                    Color _RGB(255, 255, 255), _RGB(0, 0, 0)

                    I9 = Int(CombinedAngle / 5 - .0001) + 1 ' 1 for 0-5, 2 for 5.0001 to 10 etc
                    If I9 < 0 Then I9 = 0
                    If I9 > 20 Then I9 = 20
                    ImpactAngleProbs(I9) = ImpactAngleProbs(I9) + 1
                    ImpactAngleProbPercents(I9) = 100 * ImpactAngleProbs(I9) / TotalPointsCalculated
                    NumPointsHitting = NumPointsHitting + 1
                    pointstoDraw = PointsTotal

                    If Z1 <= NumPointsToCalculate / 2 Then
                        Circle (startX, startY), CometRadius * 1.5, _RGB(200, 200, 200) '  DRAW COMET at its actual diameter (Radius X 2) at point of comet's top impacting less a bit for distance
                    Else
                        Circle (startX, startY), CometRadius * 2, _RGB(255, 255, 150) '  DRAW COMET at its actual diameter (Radius X 2) at point of comet's top impacting
                    End If
                    Cjj = Cjj + 1: If Cjj > 300 Then Cjj = 1: Cii = Cii + 1: CometIIcount = CometIIcount + 1: If CometIIcount > 400 Then CometIIcount = 400
                    If Cii > 400 Then Cii = 400
                    CometX(Cii, Cjj) = startX: CometY(Cii, Cjj) = startY: CometZ(Cii, Cjj) = startZ
                    CometMass(Cii, Cjj) = 1
                    CometSize(Cii, Cjj) = CometRadius * 1.2
                    CometColor(Cii, Cjj) = _RGB(255, 255, 150)
                End If


                EAcc = (GEarth / (Distance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
                CometPathSpeedX = CometPathSpeedX + (EAcc / Distance) * (0 - startX) * 1
                CometPathSpeedY = CometPathSpeedY + (EAcc / Distance) * (0 - startY) * 1
                CometPathSpeedZ = CometPathSpeedZ + (EAcc / Distance) * (0 - startZ) * 1
                PreviousX = startX
                PreviousY = startY
                PreviousZ = startZ
                startX = startX + CometPathSpeedX
                startY = startY + CometPathSpeedY
                startZ = startZ + CometPathSpeedZ
                pointstoDraw = pointstoDraw + 1

                '                GOTO skiplines
                Select Case ToggleDrawCometCenterPath
                    Case 0
                    Case 1
                        If Int(pointstoDraw / 10) * 10 = pointstoDraw Then
                            PSet (startX, startY), _RGB(0, 0, 255)
                            If Int(Y1 / 50) * 50 = Y1 Then
                                If Int(Y1 / 100) * 100 = Y1 Then
                                    PSet (startX, startY), _RGB(0, 0, 255)
                                Else
                                    PSet (startX, startY), _RGB(55, 55, 55)
                                End If
                            Else
                                PSet (startX, startY), _RGB(Y1 * .5, 255, 0)
                            End If
                        End If
                    Case 2 '                    IntervalForCometPaths = INT(400 / CometInitialSpeedX)
                        If Int(pointstoDraw / IntervalForCometPaths) * IntervalForCometPaths = pointstoDraw Then
                            If NumPointsHitting = 0 Then
                                If Distance >= PlanetRadius + CometRadius And Sqr(startX ^ 2 + startY ^ 2) > PlanetRadius Then ' missed planet
                                    PSet (startX, startY), _RGB(255, 255, 0)
                                End If
                            End If
                        End If
                End Select

                skiplines:
                If startX < -120000 Then pointstoDraw = PointsTotal
                If startX > 170000 Then pointstoDraw = PointsTotal
                If startY < -140000 Then pointstoDraw = PointsTotal
                If startY > 140000 Then pointstoDraw = PointsTotal
                If startZ < -140000 Then pointstoDraw = PointsTotal
                If startZ > 140000 Then pointstoDraw = PointsTotal
            Wend

            If Distance >= PlanetRadius + CometRadius Then ' missed planet
                If ItHasImpactedOnBottom = 1 Then ' hit at bottom but not at top
                    ImpactAngleProbs(1) = ImpactAngleProbs(1) + 1
                    ImpactAngleProbPercents(1) = 100 * ImpactAngleProbs(1) / TotalPointsCalculated
                    NumPointsHitting = NumPointsHitting + 1
                Else ' Missed totally
                    ImpactAngleProbs(0) = ImpactAngleProbs(0) + 1
                    ImpactAngleProbPercents(0) = 100 * ImpactAngleProbs(0) / TotalPointsCalculated
                End If
            End If

            If Z1 <= NumPointsToCalculate / 2 Then
                Circle (DrawPathstartX - CometRadius * Z1, DrawPathstartY), CometRadius * 2, _RGB(0, 255, 0)
                Circle (DrawPathstartX - CometRadius * Z1, CometStartY - (CometStartY - CometRadius * Y1 * (4 * Z1 / NumPointsToCalculate))), CometRadius * 4, _RGB(255, 0, 255)
                Circle (DrawPathstartX - CometRadius * Z1, CometStartY), CometRadius * 12, _RGB(255, 255, 255)
            Else
                Circle (DrawPathstartX - CometRadius * Z1, DrawPathstartY), CometRadius * 5, _RGB(255, 0, 0)
            End If


            Color _RGB(0, 0, 0), _RGB(215, 215, 215)
            _PrintString (520, 3), " Total # calculated: " + Left$(Str$(TotalPointsCalculated), 6) + "     "

            HeaderDepth = ZoomWindow2 + (ZoomWindow4 - ZoomWindow2) * .15
            HeaderDepth2 = ZoomWindow2 + (ZoomWindow4 - ZoomWindow2) * .021
            Line (ZoomWindow1, HeaderDepth2)-(ZoomWindow3, HeaderDepth), _RGB(50, 50, 100), BF
            Line (ZoomWindow1, HeaderDepth)-(ZoomWindow3, HeaderDepth + (ZoomWindow4 - ZoomWindow2) * .0002), _RGB(0, 0, 200), BF

            TotalPercent = 0
            Color _RGB(200, 200, 200), _RGB(50, 50, 100)
            _PrintString (190, 865), "           Skip       Elliptical            Slightly Elliptical                Near Circular                      Circular                                                               "
            _PrintString (190, 889), " Missed    0-5      5-10    10-15    15-20    20-25    25-30    30-35    35-40    40-45    45-50    50-55    55-60    60-65    65-70    70-75    75-80    80-85    85-90       Totals"
            _PrintString (90, 910), "# Impacts"
            _PrintString (85, 930), "  % Missed"
            _PrintString (90, 950), "% Impacted"

            Line (ZoomWindow1, HeaderDepth - (ZoomWindow4 - ZoomWindow2) * .0352)-(ZoomWindow3, HeaderDepth - (ZoomWindow4 - ZoomWindow2) * .035), _RGB(100, 100, 0), BF

            Color _RGB(255, 255, 155), _RGB(50, 50, 100)
            For i8 = 0 To 18
                If i8 = 0 Then
                    _PrintString (198, 910), Left$(Str$(ImpactAngleProbs(i8)), 7) + "      "
                    _PrintString (199, 930), Left$(Str$(ImpactAngleProbPercents(i8)), 6) + "       "
                End If
                If i8 > 0 Then _PrintString (200 + i8 * 72, 910), Left$(Str$(ImpactAngleProbs(i8)), 5) + "           "
                '                _PRINTSTRING (200 + i8 * 72, 920), LEFT$(STR$(ImpactAngleProbPercents(i8)), 6) + "     "
                ImpactAngleProbPercents(i8 + 20) = 100 * ImpactAngleProbs(i8) / NumPointsHitting
                If i8 > 0 Then _PrintString (200 + i8 * 72, 950), Left$(Str$(ImpactAngleProbPercents(i8 + 20)), 4) + "            "
                '                TotalPercent = TotalPercent + ImpactAngleProbPercents(i8)
            Next i8
            Color _RGB(200, 200, 200), _RGB(50, 50, 100)
            _PrintString (1600, 910), Left$(Str$(TotalPointsCalculated), 7) + "   # calculated"
            _PrintString (1600, 950), Left$(Str$(NumPointsHitting), 7) + "   # Impacting"
            Color _RGB(255, 255, 255), _RGB(0, 0, 0)
            _Display



            CheckFunctionKeysHere:
            If RunImpactProbabilities$ = "" Then RunImpactProbabilities$ = InKey$
            If Len(RunImpactProbabilities$) = 1 Then
                Call CheckifChangeScene(RunImpactProbabilities$, RunProgram$): If RunProgram$ = "StartOver" Or RunProgram$ = "StartOverMenu" Then Exit Sub
                asciinumber = Asc(RunImpactProbabilities$)
                Select Case asciinumber
                    Case 16: RunImpactProbabilities$ = "" ' Ctrl P = Print screen, which is in the general change scenes subroutine
                    Case 32:
                        AA$ = "": While AA$ = "": AA$ = InKey$: Wend
                        RunImpactProbabilities$ = ""
                    Case 48: CometInitialSpeedX = 0: GoTo BeginImpactProbabilities ' 0 pressed
                    Case 49: CometInitialSpeedX = -1: GoTo BeginImpactProbabilities ' 1 pressed
                    Case 50: CometInitialSpeedX = -2: GoTo BeginImpactProbabilities ' 2 pressed
                    Case 51: CometInitialSpeedX = -3: GoTo BeginImpactProbabilities ' 3 pressed
                    Case 52: CometInitialSpeedX = -5: GoTo BeginImpactProbabilities ' 4 pressed
                    Case 53: CometInitialSpeedX = -10: GoTo BeginImpactProbabilities ' 5 pressed
                    Case 54: CometInitialSpeedX = -20: GoTo BeginImpactProbabilities ' 6 pressed
                    Case 55: CometInitialSpeedX = -40: GoTo BeginImpactProbabilities ' 7 pressed
                    Case 56: CometInitialSpeedX = -60: GoTo BeginImpactProbabilities ' 8 pressed
                    Case 57: CometInitialSpeedX = -80: GoTo BeginImpactProbabilities ' 9 pressed
                End Select
            End If

            If RunImpactProbabilities$ <> "" Then
                ascii2byte = 0
                If Len(RunImpactProbabilities$) > 1 Then ascii2byte = Asc(RunImpactProbabilities$, 2) ' read second character of 2 byte codes such as function keys and cursor keys
                If ascii2byte <> 0 Then
                    ZoomXDiff = ZoomWindow3 - ZoomWindow1
                    ZoomYDiff = ZoomWindow4 - ZoomWindow2
                    Select Case ascii2byte
                        Case 64 ' F6 = Toggle Comet Radius Size, reset comet to new size
                            If ToggleRadius = 0 Then CometRadius = 20 Else CometRadius = ToggleRadius 'Comet diameter = 2 X CometRadius, with 1 pixel = 1 km size
                            Select Case ToggleRadius
                                Case 0 To 15: ToggleRadius = ToggleRadius + 5
                                Case 20 To 50: ToggleRadius = ToggleRadius + 10
                                Case 50 To 150: ToggleRadius = ToggleRadius + 25
                                Case Else: ToggleRadius = 5
                            End Select
                            CometRadius = ToggleRadius
                            _PrintString (220, 25), " Comet Diameter  " + Left$(Str$(CometRadius * 2), 6) + "     "
                            _Display
                            GoTo BeginImpactProbabilities
                        Case 65: ' F7 toggle path displays
                            If ToggleDrawCometCenterPath = 0 Then ToggleDrawCometCenterPath = 1 Else ToggleDrawCometCenterPath = ToggleDrawCometCenterPath + 1
                            If ToggleDrawCometCenterPath = 3 Then ToggleDrawCometCenterPath = 0
                            GoTo BeginImpactProbabilities
                        Case 71 '        cursor home
                            ImpactProbView$ = "Top"
                            ZoomWindow1 = -14850: ZoomWindow2 = -9355: ZoomWindow3 = 14850: ZoomWindow4 = 7355
                            GoTo BeginImpactProbabilities
                        Case 80 '        cursor key up
                            ZoomWindow4 = ZoomWindow4 + ZoomYDiff * .02
                            ZoomWindow2 = ZoomWindow2 + ZoomYDiff * .02
                            GoTo BeginImpactProbabilities
                        Case 73 '        cursor key page up
                            ZoomWindow1 = ZoomWindow1 + ZoomXDiff * .25
                            ZoomWindow2 = ZoomWindow2 + ZoomYDiff * .25
                            ZoomWindow3 = ZoomWindow3 - ZoomXDiff * .25
                            ZoomWindow4 = ZoomWindow4 - ZoomYDiff * .25
                            GoTo BeginImpactProbabilities
                        Case 72 '        cursor key down
                            ZoomWindow4 = ZoomWindow4 - ZoomYDiff * .02
                            ZoomWindow2 = ZoomWindow2 - ZoomYDiff * .02
                            GoTo BeginImpactProbabilities
                        Case 81 '        cursor key page down
                            ZoomWindow1 = ZoomWindow1 - ZoomXDiff * .25
                            ZoomWindow2 = ZoomWindow2 - ZoomYDiff * .25
                            ZoomWindow3 = ZoomWindow3 + ZoomXDiff * .25
                            ZoomWindow4 = ZoomWindow4 + ZoomYDiff * .25
                            GoTo BeginImpactProbabilities
                        Case 75 '        cursor key left
                            ZoomWindow1 = ZoomWindow1 + ZoomXDiff * .02
                            ZoomWindow3 = ZoomWindow3 + ZoomXDiff * .02
                            GoTo BeginImpactProbabilities
                        Case 77 '        cursor key left
                            ZoomWindow1 = ZoomWindow1 - ZoomXDiff * .02
                            ZoomWindow3 = ZoomWindow3 - ZoomXDiff * .02
                            GoTo BeginImpactProbabilities
                        Case 79 ' Cursor End key
                            ZoomWindow1 = -14850: ZoomWindow2 = -9355: ZoomWindow3 = 14850: ZoomWindow4 = 7355 ' Center on Earth = 0,0 co-ordinates =  same as pressing End key plus Page Up
                            GoTo BeginImpactProbabilities
                        Case Else
                            Call CheckFunctionandCursorKeys(ascii2byte, Scene$, RunProgram$) ' function and cursor keys
                            If RunProgram$ = "StartOver" Or RunProgram$ = "StartOverMenu" Then RunImpactProbabilities$ = "StartOver": CometPAthOnOff = 1: ToggleDrawCometCenterPath = 1: Exit Sub
                    End Select
                End If
                Exit Sub
            End If
        Next Y1


        ' ************************ HEADER *************************************
        HeaderDepth = ZoomWindow4 - (ZoomWindow4 - ZoomWindow2) * .02
        HeaderDepth2 = (ZoomWindow4 - ZoomWindow2) * .0008
        Line (ZoomWindow1, ZoomWindow4)-(ZoomWindow3, HeaderDepth), _RGB(215, 215, 215), BF
        Line (ZoomWindow1, HeaderDepth)-(ZoomWindow3, HeaderDepth - HeaderDepth2), _RGB(100, 100, 100), BF
        Line (ZoomWindow1, HeaderDepth - HeaderDepth2)-(ZoomWindow3, HeaderDepth - HeaderDepth2 * 1.5), _RGB(220, 220, 220), BF
        Color _RGB(0, 0, 0), _RGB(215, 215, 215)

        _PrintString (10, 3), " Comet Diameter: " + Left$(Str$(CometRadius * 2), 6) + " km "
        _PrintString (260, 3), "Initial Speed: " + Left$(Str$(Abs(CometInitialSpeedX)), 6) + "  km/s"
        _PrintString (800, 3), " Impact Speed:  " + Left$(Str$(CometSpeedAtImpact), 6) + "  km/s"
        _PrintString (1350, 3), " approx # Comets in Calculation  " + Str$(Int(1 + NumPointsToCalculate / ZStep) * Int(1 + NumPointsToCalculate / YStep)) + "   "

        'Locate function key reminders in bottom menu bar
        HeaderDepth = ZoomWindow2 + (ZoomWindow4 - ZoomWindow2) * .02
        HeaderDepth2 = (ZoomWindow4 - ZoomWindow2) * .0008
        Color _RGB(55, 55, 55), _RGB(215, 215, 185)
        Line (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, HeaderDepth), _RGB(215, 215, 185), BF
        _PrintString (10, 982), "Space Bar: Pause   Stop Program: 'Esc'     F1-F5: New Scenes     F6:Comet Radius       F7:Turn comet paths on/off       0-9 keys:Comet speed         Cursor Keys: Zoom, View "

        Circle (startX, startY), CircleRad * 2 * 2, _RGB(0, 155, 155) '  a crater should be about 10X the comet diameter but only add 2X
        If ToggleDrawCometCenterPath < 3 Then
            If CombinedAngle < 15 Then Circle (startX, startY), CircleRad * 2 * 2, _RGB(155, 155, 255)
            If CombinedAngle < 10 Then Circle (startX, startY), CircleRad * 2 * 2, _RGB(255, 255, 155)
            If CombinedAngle < 5 Then Circle (startX, startY), CircleRad * 2 * 2, _RGB(255, 155, 155)
            If CombinedAngle < 2 Then Circle (startX, startY), CircleRad * 2 * 2, _RGB(255, 0, 0)
            If CombinedAngle > 40 And CombinedAngle < 50 Then Circle (startX, startY), CircleRad * 2 * 2, _RGB(0, 205, 155)
            If CombinedAngle >= 80 Then Circle (startX, startY), CircleRad * 2 * 2, _RGB(0, 255, 255)
        End If

        Color _RGB(255, 255, 255), _RGB(0, 0, 0)
        If ToggleDrawCometCenterPath < 3 Then
            _PrintString (20, 100), " Impact Angles ": Color _RGB(255, 0, 0)
            _PrintString (20, 120), "    0 - 2  ": Color _RGB(255, 155, 155)
            _PrintString (20, 140), "    2 - 5  ": Color _RGB(255, 255, 155)
            _PrintString (20, 160), "    5 - 10 ": Color _RGB(155, 155, 255)
            _PrintString (20, 180), "   10 - 15 ": Color _RGB(0, 155, 155)
            _PrintString (20, 200), "   15 - 20 "
            _PrintString (20, 220), "   20 - 30 "
            _PrintString (20, 240), "   30 - 40 ": Color _RGB(0, 205, 155)
            _PrintString (20, 260), "   40 - 50 ": Color _RGB(0, 155, 155)
            _PrintString (20, 280), "   50 - 60 "
            _PrintString (20, 300), "   60 - 70 "
            _PrintString (20, 320), "   70 - 80 ": Color _RGB(0, 255, 255)
            _PrintString (20, 340), "   80 - 90 "
        End If
        Select Case startZ
            Case Is > 0: Color _RGB(0, 255, 255): _PrintString (20, 822), "  Changing zoom or viewpoint during calculations re-starts the calculation. Please wait.": _PrintString (20, 700), "  Calculating Southern Hemisphere Impacts "
            Case Else: Color _RGB(255, 255, 0): _PrintString (20, 822), "  Changing zoom or viewpoint during calculations re-starts the calculation. Please wait.": _PrintString (20, 700), "  Calculating Northern Hemisphere Impacts   "
        End Select
        Color _RGB(0, 255, 255)
        If Abs(CometInitialSpeedX) < 10 Then
            _PrintString (20, 720), "  Sorry - slower comet speeds take longer to calculate."
        End If
        If Abs(CometInitialSpeedX) <= 2 Then
            _PrintString (20, 760), "  Final impact speed is less than 11.2 km/s escape velocity"
            _PrintString (20, 780), "  due to start distance being only 160,000 km from Earth "
        End If

        Color _RGB(255, 155, 0), _RGB(0, 0, 0)
        If CometIIcount >= 400 Then _PrintString (20, 822), "  Numbers of comet impact details exceeds 120,000 (each individual impact has more than 1 detail). Different viewpoints are limited to 120,000. Some impacts will not be shown when rotating globe."

        Color _RGB(255, 255, 255), _RGB(0, 0, 0)
        _Display

        ' ************************ END HEADER *************************************

    Next Z1



    ' ##########################################   Display calculated impacts    ######################################################
    ReDisplayImpactProbs: ' ********************************************   Allow multiple view angles *******************************************************************************

    Window (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, ZoomWindow4)
    HeaderDepth = ZoomWindow4 - (ZoomWindow4 - ZoomWindow2) * .02 - (ZoomWindow4 - ZoomWindow2) * .0012
    HeaderDepth3 = ZoomWindow2 + (ZoomWindow4 - ZoomWindow2) * .15

    Line (ZoomWindow1, HeaderDepth)-(ZoomWindow3, HeaderDepth3), _RGB(0, 0, 0), BF '  Clear previous drawing but leave headers visible.

    Color _RGB(255, 255, 255), _RGB(0, 0, 0)
    If ToggleDrawCometCenterPath < 3 Then
        _PrintString (20, 100), " Impact Angles ": Color _RGB(255, 0, 0)
        _PrintString (20, 120), "    0 - 2  ": Color _RGB(255, 155, 155)
        _PrintString (20, 140), "    2 - 5  ": Color _RGB(255, 255, 155)
        _PrintString (20, 160), "    5 - 10 ": Color _RGB(155, 155, 255)
        _PrintString (20, 180), "   10 - 15 ": Color _RGB(0, 155, 155)
        _PrintString (20, 200), "   15 - 20 "
        _PrintString (20, 220), "   20 - 30 "
        _PrintString (20, 240), "   30 - 40 ": Color _RGB(0, 205, 155)
        _PrintString (20, 260), "   40 - 50 ": Color _RGB(0, 155, 155)
        _PrintString (20, 280), "   50 - 60 "
        _PrintString (20, 300), "   60 - 70 "
        _PrintString (20, 320), "   70 - 80 ": Color _RGB(0, 255, 255)
        _PrintString (20, 340), "   80 - 90 "
    End If
    Color _RGB(255, 255, 255), _RGB(0, 0, 0)


    For i = 7 To 6371 Step 10
        EarthColorization = 255 - 100 * i / 6371
        EarthColorization2 = 165 - 160 * i / 6371
        Circle (0, 0), i, _RGB(EarthColorization2 / 1.5, EarthColorization2 / 1.5, EarthColorization / 1.5)
    Next i


    For ii = 1 To 1100
        skip = 0
        Select Case ImpactProbView$
            Case "Top"
                If WorldZ(ii) > 0 Then
                    If (WorldX(ii) = 0 And WorldY(ii) = 0) Then skip = 1
                    If (WorldX(ii + 1) = 0 And WorldY(ii + 1) = 0) Then skip = 1
                    If skip = 0 Then Line (WorldX(ii), WorldY(ii))-(WorldX(ii + 1), WorldY(ii + 1)), _RGB(255, 255, 255)
                End If
            Case "Bottom"
                If WorldZ(ii) < 0 Then
                    If (WorldX(ii) = 0 And WorldY(ii) = 0) Then skip = 1
                    If (WorldX(ii + 1) = 0 And WorldY(ii + 1) = 0) Then skip = 1
                    If skip = 0 Then Line (-1 * WorldX(ii), WorldY(ii))-(-1 * WorldX(ii + 1), WorldY(ii + 1)), _RGB(255, 255, 255)
                End If
            Case "Back"
                If WorldX(ii) > 0 Then
                    If (WorldX(ii) = 0 And WorldY(ii) = 0) Then skip = 1
                    If (WorldX(ii + 1) = 0 And WorldY(ii + 1) = 0) Then skip = 1
                    If skip = 0 Then Line (WorldY(ii), WorldZ(ii))-(WorldY(ii + 1), WorldZ(ii + 1)), _RGB(255, 255, 255)
                End If
            Case "Front"
                If WorldX(ii) < 0 Then
                    If (WorldX(ii) = 0 And WorldY(ii) = 0) Then skip = 1
                    If (WorldX(ii + 1) = 0 And WorldY(ii + 1) = 0) Then skip = 1
                    If skip = 0 Then Line (-1 * WorldY(ii), WorldZ(ii))-(-1 * WorldY(ii + 1), WorldZ(ii + 1)), _RGB(255, 255, 255)
                End If
            Case "LeftSide"
                If WorldY(ii) <= 0 Then
                    If (WorldX(ii) = 0 And WorldY(ii) = 0) Then skip = 1
                    If (WorldX(ii + 1) = 0 And WorldY(ii + 1) = 0) Then skip = 1
                    If skip = 0 Then Line (WorldX(ii), WorldZ(ii))-(WorldX(ii + 1), WorldZ(ii + 1)), _RGB(255, 255, 255)
                End If
            Case "RightSide"
                If WorldY(ii) >= 0 Then
                    If (WorldX(ii) = 0 And WorldY(ii) = 0) Then skip = 1
                    If (WorldX(ii + 1) = 0 And WorldY(ii + 1) = 0) Then skip = 1
                    If skip = 0 Then Line (-1 * WorldX(ii), WorldZ(ii))-(-1 * WorldX(ii + 1), WorldZ(ii + 1)), _RGB(255, 255, 255)
                End If
        End Select
    Next ii


    If CometIIcount > 400 Then CometIIcount = 400
    For ii = 1 To CometIIcount
        For jj = 1 To 300 '   ################################################################################################################
            If CometMass(ii, jj) = 1 Then '     Has Hit Earth
                Select Case ImpactProbView$
                    Case "Top":
                        If CometZ(ii, jj) >= 0 Then Circle (CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj), CometColor(ii, jj)
                    Case "Bottom":
                        If CometZ(ii, jj) <= 0 Then Circle (-1 * CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj), CometColor(ii, jj)
                    Case "Back"
                        If CometX(ii, jj) >= 0 Then Circle (CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj), CometColor(ii, jj)
                    Case "Front"
                        If CometX(ii, jj) <= 0 Then Circle (-1 * CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj), CometColor(ii, jj)
                    Case "LeftSide"
                        If CometY(ii, jj) <= 0 Then Circle (CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj), CometColor(ii, jj)
                    Case "RightSide"
                        If CometY(ii, jj) >= 0 Then Circle (-1 * CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj), CometColor(ii, jj)
                End Select
            End If
        Next jj
    Next ii

    Color _RGB(0, 0, 0), _RGB(215, 215, 215)
    _PrintString (520, 3), " Total # calculated: " + Left$(Str$(TotalPointsCalculated), 6) + "     "

    HeaderDepth = ZoomWindow2 + (ZoomWindow4 - ZoomWindow2) * .15
    HeaderDepth2 = ZoomWindow2 + (ZoomWindow4 - ZoomWindow2) * .021
    Line (ZoomWindow1, HeaderDepth2)-(ZoomWindow3, HeaderDepth), _RGB(50, 50, 100), BF
    Line (ZoomWindow1, HeaderDepth)-(ZoomWindow3, HeaderDepth + (ZoomWindow4 - ZoomWindow2) * .0002), _RGB(0, 0, 200), BF

    TotalPercent = 0
    Color _RGB(200, 200, 200), _RGB(50, 50, 100)
    _PrintString (190, 865), "           Skip       Elliptical            Slightly Elliptical                Near Circular                      Circular                                                               "
    _PrintString (190, 889), " Missed    0-5      5-10    10-15    15-20    20-25    25-30    30-35    35-40    40-45    45-50    50-55    55-60    60-65    65-70    70-75    75-80    80-85    85-90       Totals"
    _PrintString (90, 910), "# Impacts"
    _PrintString (85, 930), "  % Missed"
    _PrintString (90, 950), "% Impacted"

    Line (ZoomWindow1, HeaderDepth - (ZoomWindow4 - ZoomWindow2) * .0352)-(ZoomWindow3, HeaderDepth - (ZoomWindow4 - ZoomWindow2) * .035), _RGB(100, 100, 0), BF

    Color _RGB(255, 255, 155), _RGB(50, 50, 100)
    For i8 = 0 To 18
        If i8 = 0 Then
            _PrintString (198, 910), Left$(Str$(ImpactAngleProbs(i8)), 7) + "      "
            _PrintString (199, 930), Left$(Str$(ImpactAngleProbPercents(i8)), 6) + "       "
        End If
        If i8 > 0 Then _PrintString (200 + i8 * 72, 910), Left$(Str$(ImpactAngleProbs(i8)), 5) + "           "
        '                _PRINTSTRING (200 + i8 * 72, 920), LEFT$(STR$(ImpactAngleProbPercents(i8)), 6) + "     "
        ImpactAngleProbPercents(i8 + 20) = 100 * ImpactAngleProbs(i8) / NumPointsHitting
        If i8 > 0 Then _PrintString (200 + i8 * 72, 950), Left$(Str$(ImpactAngleProbPercents(i8 + 20)), 4) + "            "
        '                TotalPercent = TotalPercent + ImpactAngleProbPercents(i8)
    Next i8
    Color _RGB(200, 200, 200), _RGB(50, 50, 100)
    _PrintString (1600, 910), Left$(Str$(TotalPointsCalculated), 7) + "   # calculated"
    _PrintString (1600, 950), Left$(Str$(NumPointsHitting), 7) + "   # Impacting"


    HeaderDepth = ZoomWindow4 - (ZoomWindow4 - ZoomWindow2) * .02
    HeaderDepth2 = (ZoomWindow4 - ZoomWindow2) * .0008
    Line (ZoomWindow1, ZoomWindow4)-(ZoomWindow3, HeaderDepth), _RGB(215, 215, 215), BF
    Line (ZoomWindow1, HeaderDepth)-(ZoomWindow3, HeaderDepth - HeaderDepth2), _RGB(100, 100, 100), BF
    Line (ZoomWindow1, HeaderDepth - HeaderDepth2)-(ZoomWindow3, HeaderDepth - HeaderDepth2 * 1.5), _RGB(220, 220, 220), BF
    Color _RGB(0, 0, 0), _RGB(215, 215, 215)

    _PrintString (10, 3), " Comet Diameter: " + Left$(Str$(CometRadius * 2), 6) + " km "
    _PrintString (260, 3), "Initial Speed: " + Left$(Str$(Abs(CometInitialSpeedX)), 6) + "  km/s"
    _PrintString (800, 3), " Impact Speed:  " + Left$(Str$(CometSpeedAtImpact), 6) + "  km/s"
    _PrintString (1350, 3), " approx # Comets in Calculation  " + Str$(Int(1 + NumPointsToCalculate / ZStep) * Int(1 + NumPointsToCalculate / YStep)) + "   "
    HeaderDepth = ZoomWindow2 + (ZoomWindow4 - ZoomWindow2) * .02
    HeaderDepth2 = (ZoomWindow4 - ZoomWindow2) * .0008
    Color _RGB(55, 55, 55), _RGB(215, 215, 185)
    Line (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, HeaderDepth), _RGB(215, 215, 185), BF
    _PrintString (10, 982), "Space Bar: Pause   Stop Program: 'Esc'     F1-F5: New Scenes     F6:Comet Radius       F7:Turn comet paths on/off      0-9 keys:Comet speed      Cursor Keys: Zoom, View       Ctrl Z, X - Change view angle"

    Color _RGB(255, 255, 255), _RGB(0, 0, 0)
    _Display

    A$ = "": While A$ = "": A$ = InKey$: Wend

    CheckIfKeysPressed:
    If KeyPressedInRoutine$ <> "" Then A$ = KeyPressedInRoutine$
    If A$ <> "" Then
        asciibyte = Asc(A$)
        Select Case asciibyte
            Case 32 ' space bar
                A$ = "": While A$ = "": A$ = InKey$: Wend
            Case 16 ' Ctrl P = immeadiate screen save to pre-determined folder with predetermined names
                desktop& = _ScreenImage(2, 2, 1777, 999) ' Co-ordinates relate to image on computer monitor not to coordinates in QB64 window.
                t$ = Time$: t2$ = Date$: FileName3D$ = "SkipImpact" + Mid$(t2$, 7, 4) + "-" + Mid$(t2$, 1, 2) + "-" + Mid$(t2$, 4, 2) + "-" + Mid$(t$, 1, 2) + Mid$(t$, 4, 2) + Mid$(t$, 7, 2)
                SaveImage desktop&, CometFileName$ + FileName3D$ 'saves entire program screen as "CometSim.bmp"
                _FreeImage desktop&
                Beep
                GoTo ReDisplayImpactProbs
            Case 24 ' Ctrl X
                Select Case ImpactProbView$
                    Case "Top": ImpactProbView$ = "Bottom"
                    Case "LeftSide": ImpactProbView$ = "Top"
                    Case "Front": ImpactProbView$ = "LeftSide"
                    Case "RightSide": ImpactProbView$ = "Front"
                    Case "Back": ImpactProbView$ = "RightSide"
                    Case "Bottom": ImpactProbView$ = "Back"
                End Select
                GoTo ReDisplayImpactProbs
            Case 26 ' Ctrl Z
                Select Case ImpactProbView$
                    Case "Top": ImpactProbView$ = "LeftSide"
                    Case "LeftSide": ImpactProbView$ = "Front"
                    Case "Front": ImpactProbView$ = "RightSide"
                    Case "RightSide": ImpactProbView$ = "Back"
                    Case "Back": ImpactProbView$ = "Bottom"
                    Case "Bottom": ImpactProbView$ = "Top"
                End Select
                GoTo ReDisplayImpactProbs
            Case 27: End
            Case 96: ' Pressing the "~`" key changes the displayed colors
                Select Case MonoColor$
                    Case "Yellow": MonoColor$ = "Green": PresentMonoColor = _RGB(0, 255, 0)
                    Case "White": MonoColor$ = "Yellow": PresentMonoColor = _RGB(255, 255, 0)
                    Case "No": MonoColor$ = "White": PresentMonoColor = _RGB(255, 255, 255)
                    Case "Green": MonoColor$ = "No"
                End Select
                GoTo ReDisplayImpactProbs
        End Select
    End If




    CheckFunctionKeysHere2:
    If RunImpactProbabilities$ = "" Then RunImpactProbabilities$ = InKey$
    If RunImpactProbabilities$ <> "" Then Call CheckifChangeScene(RunImpactProbabilities$, RunProgram$): If RunProgram$ = "StartOver" Or RunProgram$ = "StartOverMenu" Then Exit Sub
    If Len(RunImpactProbabilities$) = 1 Then
        Select Case Asc(RunImpactProbabilities$)
            Case 32:
                AA$ = "": While AA$ = "": AA$ = InKey$: Wend
                RunImpactProbabilities$ = ""
            Case 48: CometInitialSpeedX = 0: GoTo BeginImpactProbabilities ' 0 pressed
            Case 49: CometInitialSpeedX = -1: GoTo BeginImpactProbabilities ' 1 pressed
            Case 50: CometInitialSpeedX = -2: GoTo BeginImpactProbabilities ' 2 pressed
            Case 51: CometInitialSpeedX = -3: GoTo BeginImpactProbabilities ' 3 pressed
            Case 52: CometInitialSpeedX = -5: GoTo BeginImpactProbabilities ' 4 pressed
            Case 53: CometInitialSpeedX = -10: GoTo BeginImpactProbabilities ' 5 pressed
            Case 54: CometInitialSpeedX = -20: GoTo BeginImpactProbabilities ' 6 pressed
            Case 55: CometInitialSpeedX = -40: GoTo BeginImpactProbabilities ' 7 pressed
            Case 56: CometInitialSpeedX = -60: GoTo BeginImpactProbabilities ' 8 pressed
            Case 57: CometInitialSpeedX = -80: GoTo BeginImpactProbabilities ' 9 pressed
            Case 96: ' Pressing the "~`" key changes the displayed colors
                CometInitialSpeedX = -1.80 ' km/sec
                Select Case MonoColor$
                    Case "Yellow": MonoColor$ = "Green": PresentMonoColor = _RGB(0, 255, 0)
                    Case "White": MonoColor$ = "Yellow": PresentMonoColor = _RGB(255, 255, 0)
                    Case "No": MonoColor$ = "White": PresentMonoColor = _RGB(255, 255, 255)
                    Case "Green": MonoColor$ = "No"
                End Select
                GoTo ReDisplayImpactProbs
        End Select
    End If

    If RunImpactProbabilities$ <> "" Then
        RunProgram$ = RunImpactProbabilities$
        RunImpactProbabilities$ = ""
        ascii2byte = 0

        If Len(RunProgram$) > 1 Then ascii2byte = Asc(RunProgram$, 2) ' read second character of 2 byte codes such as function keys and cursor keys
        If ascii2byte <> 0 Then
            ZoomXDiff = ZoomWindow3 - ZoomWindow1
            ZoomYDiff = ZoomWindow4 - ZoomWindow2
            Select Case ascii2byte
                Case 64 ' F6 = Toggle Comet Radius Size, reset comet to new size
                    If ToggleRadius = 0 Then CometRadius = 20 Else CometRadius = ToggleRadius 'Comet diameter = 2 X CometRadius, with 1 pixel = 1 km size
                    Select Case ToggleRadius
                        Case 0 To 15: ToggleRadius = ToggleRadius + 5
                        Case 20 To 50: ToggleRadius = ToggleRadius + 10
                        Case 50 To 150: ToggleRadius = ToggleRadius + 25
                        Case Else: ToggleRadius = 5
                    End Select
                    CometRadius = ToggleRadius
                    _PrintString (220, 25), " Comet Diameter  " + Left$(Str$(CometRadius * 2), 6) + "     "
                    _Display
                    GoTo BeginImpactProbabilities
                Case 71 '        cursor home
                    ImpactProbView$ = "Top"
                    ZoomWindow1 = -14850: ZoomWindow2 = -9355: ZoomWindow3 = 14850: ZoomWindow4 = 7355
                    GoTo ReDisplayImpactProbs
                Case 80 '        cursor key up
                    ZoomWindow4 = ZoomWindow4 + ZoomYDiff * .02
                    ZoomWindow2 = ZoomWindow2 + ZoomYDiff * .02
                    GoTo ReDisplayImpactProbs
                Case 73 '        cursor key page up
                    ZoomWindow1 = ZoomWindow1 + ZoomXDiff * .25
                    ZoomWindow2 = ZoomWindow2 + ZoomYDiff * .25
                    ZoomWindow3 = ZoomWindow3 - ZoomXDiff * .25
                    ZoomWindow4 = ZoomWindow4 - ZoomYDiff * .25
                    GoTo ReDisplayImpactProbs
                Case 72 '        cursor key down
                    ZoomWindow4 = ZoomWindow4 - ZoomYDiff * .02
                    ZoomWindow2 = ZoomWindow2 - ZoomYDiff * .02
                    GoTo ReDisplayImpactProbs
                Case 81 '        cursor key page down
                    ZoomWindow1 = ZoomWindow1 - ZoomXDiff * .25
                    ZoomWindow2 = ZoomWindow2 - ZoomYDiff * .25
                    ZoomWindow3 = ZoomWindow3 + ZoomXDiff * .25
                    ZoomWindow4 = ZoomWindow4 + ZoomYDiff * .25
                    GoTo ReDisplayImpactProbs
                Case 75 '        cursor key left
                    ZoomWindow1 = ZoomWindow1 + ZoomXDiff * .02
                    ZoomWindow3 = ZoomWindow3 + ZoomXDiff * .02
                    GoTo ReDisplayImpactProbs
                Case 77 '        cursor key left
                    ZoomWindow1 = ZoomWindow1 - ZoomXDiff * .02
                    ZoomWindow3 = ZoomWindow3 - ZoomXDiff * .02
                    GoTo ReDisplayImpactProbs
                Case 79 ' Cursor End key
                    ZoomWindow1 = -14850: ZoomWindow2 = -9355: ZoomWindow3 = 14850: ZoomWindow4 = 7355 ' Center on Earth = 0,0 co-ordinates =  same as pressing End key plus Page Up
                    GoTo ReDisplayImpactProbs
                Case Else
                    Call CheckFunctionandCursorKeys(ascii2byte, Scene$, RunProgram$) ' function and cursor keys
                    If RunProgram$ = "StartOver" Or RunProgram$ = "StartOverMenu" Then RunImpactProbabilities$ = "StartOver": CometPAthOnOff = 1: ToggleDrawCometCenterPath = 1: Exit Sub
            End Select
        End If
        Exit Sub
    End If




    RunImpactProbabilities$ = A$
    GoTo CheckFunctionKeysHere2

End Sub



Sub AssignAirScatterPoints (Z1, Distance, startx, starty, startz)
    DistanceFromEarth = Int(Distance - PlanetRadius) / 10 ' must be between 0 and 250 / 10 = 0 to 25
    ii1 = 176 - DistanceFromEarth '  Aiming to 74 have these in ii = 151 to ii = 175
    ii2 = ii1 + Z1 + 3
    jj2 = 60 - DistanceFromEarth * 2 + (60 - DistanceFromEarth * 2) * Z1
    For ii = ii1 To ii2
        For jj = 1 To jj2
            If CometMass(ii, jj) = 0 Then
                CometX(ii, jj) = startx
                CometY(ii, jj) = starty
                CometZ(ii, jj) = startz
                CometSpeedX(ii, jj) = (25 - DistanceFromEarth) * (Rnd(99) - .5) * Rnd(98) * .2
                CometSpeedY(ii, jj) = (25 - DistanceFromEarth) * (Rnd(99) - .2) * Rnd(98) * .25
                CometSpeedZ(ii, jj) = (25 - DistanceFromEarth) * (Rnd(99) - .5) * Rnd(98) * .2 + .6
                CometSize(ii, jj) = (26 - DistanceFromEarth) * Rnd(99) * 2.5 + 2 ' min size 3 meters radius
                CometMass(ii, jj) = 1.2
                CometColor(ii, jj) = _RGB(255, 255, 255)
                CometColor(ii, jj) = _RGB(155, 85, 85)
            End If
        Next jj
    Next ii
End Sub


Sub AssignExplosionPoints (Z1, ImpactThickness, startx, starty, startz, CometPathSpeedX, CometPathSpeedY, CometPathSpeedZ)


    PresentCometSpeed = Sqr(CometPathSpeedX ^ 2 + CometPathSpeedY ^ 2 + CometPathSpeedZ ^ 2)
    XXFactor = PresentCometSpeed * (ii + 200) / 2000
    Select Case Z1 ' Too slow due to too many points if we use all 300 potential points
        Case 0: ii1 = 1: ii2 = 75: NextCometColor = _RGB(0, 255, 0): If Scene$ = "Saginaw 2" Then NextCometColor = _RGB(255, 255, 0)
        Case 1: ii1 = 76: ii2 = 95: NextCometColor = _RGB(255, 0, 0): If Scene$ = "Saginaw 2" Then NextCometColor = _RGB(0, 255, 0)
        Case 2: ii1 = 96: ii2 = 110: NextCometColor = _RGB(0, 0, 255): If Scene$ = "Saginaw 2" Then NextCometColor = _RGB(0, 255, 0)
        Case 3: ii1 = 111: ii2 = 125: NextCometColor = _RGB(255, 255, 255): If Scene$ = "Saginaw 2" Then NextCometColor = _RGB(0, 255, 0)
        Case 4: ii1 = 126: ii2 = 150: NextCometColor = _RGB(255, 255, 0): If Scene$ = "Saginaw 2" Then NextCometColor = _RGB(255, 255, 0)
    End Select

    If Scene$ = "Egypt" Then NextCometColor = _RGB(255, 0, 0)
    If Scene$ = "Saginaw 1" Then NextCometColor = _RGB(255, 255, 0)
    If Scene$ = "MARS" Then NextCometColor = _RGB(200, 200, 200)

    If Scene$ = "ChesapeakeBay" Then ' create a narrow plume for tekite field
        For ii = ii1 To ii2
            For jj = 1 To 150
                If CometMass(ii, jj) = 2 Then
                    '                    CometColor(ii, jj) = _RGB(255, 0, 0)
                    CometColor(ii, jj) = NextCometColor

                    CometX(ii, jj) = startx: CometY(ii, jj) = starty: CometZ(ii, jj) = startz
                    While Sqr(CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2) < PlanetRadius + CometRadius * .5: CometX(ii, jj) = CometX(ii, jj) * 1.001: CometY(ii, jj) = CometY(ii, jj) * 1.001: CometZ(i, jj) = CometZ(ii, jj) * 1.001: Wend

                    '                    CALL RandomNumbersFewNearZero
                    Call RandomNumbers
                    '                    CometSpeedY(ii, jj) = -2.2 + 3.5 * (RE - .5) * RD ' Range = - 3.95 to - 0.45
                    '                    CometSpeedZ(ii, jj) = 3.5 + 1.5 * RND(99) * RC ' Range =  3.5 to 5.0
                    '                    CometSpeedX(ii, jj) = -7 + 2 * (RND(98) - .2) ' Range = - 7.4 to -5.4

                    Temp = (7.5 - jj / 50) * RB + jj / 50 ' jj/50 = max 3, effectly adds a few more higher speed points
                    CometSpeedX(ii, jj) = -Temp + 2 * (Rnd(29) - .2) * RA * Temp / 8
                    If (Rnd(94) - .5) < 0 Then '  Spread plume wider by having two Y factors. Necessary to get the observed range of tekites from Barbadoes to Texas
                        CometSpeedY(ii, jj) = -Temp * .33 + 4 * (RE - .5) * RD * Temp / 8 ' Range = - 3.95 to - 0.45
                    Else
                        CometSpeedY(ii, jj) = -Temp * .2 + 4.5 * (RE - .5) * RD * Temp / 8 ' Range = - 3.95 to - 0.45
                    End If
                    CometSpeedZ(ii, jj) = Temp * .55 + 1.5 * (Rnd(99) - .5) * RC * Temp / 8

                    If EarthRotation$ = "Yes" Then CometSpeedY(ii, jj) = CometSpeedY(ii, jj) - .5 ' - .5 is earth rotation
                    CometSize(ii, jj) = 4.5 * RB + .5 ' min size .5 meters radius, max 5
                    CometMass(ii, jj) = 1.2
                End If
            Next jj
        Next ii
        Exit Sub
    End If

    '   GOTO skipthistoo33 ' extra lines for experiments and helping setup splash routines

    jjcount = 300 * ImpactThickness / (CometRadius * 2)
    If jjcount > 300 Then jjcount = 300

    If Scene$ <> "Egypt" And AddMorePoints$ <> "No" Then
        Select Case AddMorePoints$
            Case "200": StartII = Int(150 + ii1 / 3): EndII = Int(150 + ii2 / 3)
            Case "250": StartII = Int(150 + ii1 / 1.5): EndII = Int(150 + ii2 / 1.5)
            Case "300": StartII = Int(150 + ii1): EndII = Int(150 + ii2)
        End Select

        For ii = StartII To EndII
            For jj = 1 To jjcount
                If CometMass(ii, jj) = 2 Or CometMass(ii, jj) = 0 Then
                    CometColor(ii, jj) = NextCometColor
                    If ImpactThickness < CometRadius Then
                        CometX(ii, jj) = startx - ImpactThickness
                        If Int(jj / 2) * 2 = jj Then CometY(ii, jj) = starty + ImpactThickness Else CometY(ii, jj) = starty - ImpactThickness
                        CometZ(ii, jj) = startz - ImpactThickness
                    Else
                        CometX(ii, jj) = startx - CometRadius * 2 + ImpactThickness
                        If Int(jj / 2) * 2 = jj Then CometY(ii, jj) = starty + CometRadius * 2 - ImpactThickness Else CometY(ii, jj) = starty - (CometRadius * 2 - ImpactThickness)
                        CometZ(ii, jj) = startz - CometRadius * 2 + ImpactThickness
                    End If
                    If Int(jj / 2) * 2 = jj Then CometY(ii, jj) = starty + ImpactThickness Else CometY(ii, jj) = starty - ImpactThickness

                    If Scene$ = "Saginaw 1" Or Scene$ = "Saginaw 2" Or Scene$ = "ChesapeakeBay" Then CometY(ii, jj) = starty: CometX(ii, jj) = startx: CometZ(ii, jj) = startz

                    While Sqr(CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2) < PlanetRadius + CometRadius * .5: CometX(ii, jj) = CometX(ii, jj) * 1.001: CometY(ii, jj) = CometY(ii, jj) * 1.001: CometZ(i, jj) = CometZ(ii, jj) * 1.001: Wend

                    CometColor(ii, jj) = _RGB(255, 0, 0)
                    Call RandomNumbersFewNearZero
                    CometSpeedX(ii, jj) = -20 * RC * RE + (Rnd(34) - .5) * 8 * Rnd(43)
                    CometSpeedY(ii, jj) = -1 + RE * Rnd(55) * 6
                    If (Rnd(21) - .5) < 0 Then CometSpeedY(ii, jj) = -CometSpeedY(ii, jj)
                    CometSpeedZ(ii, jj) = -CometSpeedX(ii, jj) * (Rnd(82) + .2) * (CometSpeedX(ii, jj) / 6) + (Rnd(72) - .5) * 2

                    CX = CometX(ii, jj): CY = CometY(ii, jj): CZ = CometZ(ii, jj)
                    LOOPCOUNT = 0
                    distance = 0
                    While LOOPCOUNT < 5 And distance < PlanetRadius + 2
                        CXS = CometSpeedX(ii, jj): CYS = CometSpeedY(ii, jj): CZS = CometSpeedZ(ii, jj)
                        For KK = 1 To 100
                            distance = Sqr(CX ^ 2 + CY ^ 2 + CZ ^ 2)
                            EAcc = (GEarth / (distance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
                            CXS = CXS + (EAcc / distance) * -CX
                            CYS = CYS + (EAcc / distance) * -CY
                            CZS = CZS + (EAcc / distance) * -CZ
                            CX = CX + CXS
                            CY = CY + CYS
                            CZ = CZ + CZS
                        Next KK
                        distance = Sqr(CX ^ 2 + CY ^ 2 + CZ ^ 2)
                        If distance < PlanetRadius + 2 Then

                            '                CometItselfSpeedX(Z1) = -25.2 ' km/sec = Carolina Bay start velocities
                            '                CometItselfSpeedY(Z1) = 0 ' km/sec
                            '                CometItselfSpeedZ(Z1) = -34.05 ' km/sec

                            Call RandomNumbers
                            CometSpeedX(ii, jj) = -5 + (Rnd(34) - .5) * 8 * Rnd(43)
                            CometSpeedZ(ii, jj) = -4 + (Rnd(34) - .5) * 8 * Rnd(44)
                            CometSpeedY(ii, jj) = 2 + (RE - .5) * Rnd(55) * 5
                            If (Rnd(21) - .5) < 0 Then CometSpeedY(ii, jj) = -CometSpeedY(ii, jj)
                            distance = 0
                            CX = CometX(ii, jj): CY = CometY(ii, jj): CZ = CometZ(ii, jj)
                            '                        CometColor(ii, jj) = _RGB(0, 255, 255)
                        End If
                        LOOPCOUNT = LOOPCOUNT + 1
                    Wend

                    If EarthRotation$ = "Yes" Then CometSpeedY(ii, jj) = CometSpeedY(ii, jj) - .5 ' - .5 is earth rotation
                    CXS = CometSpeedX(ii, jj): CYS = CometSpeedY(ii, jj): CZS = CometSpeedZ(ii, jj)
                    speed = Sqr(CXS ^ 2 + CYS ^ 2 + CZS ^ 2): If speed < 0.1 Then speed = .1
                    Call RandomNumbersFewNearZero
                    CometSize(ii, jj) = 230 * RB + 20 ' min size 20 meters radius
                    If CometSize(ii, jj) > 200 * (2 / speed) Then CometSize(ii, jj) = 230 * RD + 20 ' minimize over 200 m radius and relate it to speed - higher speed = smaller on average pieces.
                    CometMass(ii, jj) = 1.2

                    If Scene$ = "Saginaw 1" Or Scene$ = "Saginaw 2" Then
                        ' Rotate about Y axis: (rotate from Michigan to Equator ~ 44 degrees)
                        '   X = X * cosTheta + z * sinTheta;  Cos 44 = .7193, Sin 44 = .6946; cos 60 = .5, sin 60 = .866
                        '   Z = z * cosTheta - x * sinTheta;  Cos -45 = .7, Sin -45 = -.7; cos -60 = .5, sin -60 = -.866
                        aaa = CometSpeedX(ii, jj)
                        CometSpeedX(ii, jj) = .719 * CometSpeedX(ii, jj) - .6946 * CometSpeedZ(ii, jj)
                        CometSpeedZ(ii, jj) = .719 * CometSpeedZ(ii, jj) + .6946 * aaa
                        ' Rotate about X axis: (angle ~42 degreees to match impact direction)
                        '   Y = y * cosTheta - z * sinTheta;  Cos 42 = .743, Sin 42 = .669
                        '   Z = z * cosTheta + y * sinTheta;
                        aaa = CometSpeedY(ii, jj)
                        CometSpeedY(ii, jj) = .743 * CometSpeedY(ii, jj) - .669 * CometSpeedZ(ii, jj)
                        CometSpeedZ(ii, jj) = .743 * CometSpeedZ(ii, jj) + .669 * aaa
                        ' Rotate back about Y axis: (rotate from Equator to Michigan ~ 45 degrees)
                        '   X = X * cosTheta + z * sinTheta;  Cos 45 = .7, Sin 45 = .7; cos 60 = .5, sin 60 = .866
                        '   Z = z * cosTheta - x * sinTheta;  Cos -45 = .7, Sin -45 = -.7; cos -60 = .5, sin -60 = -.866
                        aaa = CometSpeedX(ii, jj)
                        CometSpeedX(ii, jj) = .719 * CometSpeedX(ii, jj) + .6946 * CometSpeedZ(ii, jj)
                        CometSpeedZ(ii, jj) = .719 * CometSpeedZ(ii, jj) - .6946 * aaa
                    End If
                    If Scene$ = "MARS" Then
                        ' Rotate about Y axis: (rotate Orcus Patera ~15 degrees north of the equator)
                        '   X = X * cosTheta + z * sinTheta;  Cos 15 = .9659, Sin 15 = .2588
                        '   Z = z * cosTheta - x * sinTheta;  Cos -15 = .9659, Sin -15 = -.2588
                        aaa = CometSpeedX(ii, jj)
                        CometSpeedX(ii, jj) = .9659 * CometSpeedX(ii, jj) - .2588 * CometSpeedZ(ii, jj)
                        CometSpeedZ(ii, jj) = .9659 * CometSpeedZ(ii, jj) + .2588 * aaa
                        ' Rotate about X axis: (angle ~17 degreees to match impact direction)
                        '   Y = y * cosTheta - z * sinTheta;  Cos 17 = .9563, Sin 42 = .2924
                        '   Z = z * cosTheta + y * sinTheta;
                        aaa = CometSpeedY(ii, jj)
                        CometSpeedY(ii, jj) = .9563 * CometSpeedY(ii, jj) - .2924 * CometSpeedZ(ii, jj)
                        CometSpeedZ(ii, jj) = .9563 * CometSpeedZ(ii, jj) + .2924 * aaa
                        ' Rotate back about Y axis: (rotate from Equator to Michigan ~ 45 degrees)
                        '   X = X * cosTheta + z * sinTheta;  Cos 45 = .7, Sin 45 = .7; cos 60 = .5, sin 60 = .866
                        '   Z = z * cosTheta - x * sinTheta;  Cos -45 = .7, Sin -45 = -.7; cos -60 = .5, sin -60 = -.866
                        aaa = CometSpeedX(ii, jj)
                        CometSpeedX(ii, jj) = .9659 * CometSpeedX(ii, jj) + .2588 * CometSpeedZ(ii, jj)
                        CometSpeedZ(ii, jj) = .9659 * CometSpeedZ(ii, jj) - .2588 * aaa
                    End If
                End If
            Next jj
        Next ii
        '    EXIT SUB
    End If

    skipthistoo33:

    jjcount = 50 * ImpactThickness / (CometRadius * 2)
    If jjcount > 50 Then jjcount = 50

    For ii = ii1 To ii2 '         First 50 layer is assigned random higher speed particles = Push forward part of debris cloud
        XXFactor = PresentCometSpeed * (ii + 200) / 2000
        For jj = 1 To jjcount
            If CometMass(ii, jj) = 2 Then
                CometColor(ii, jj) = NextCometColor
                If ImpactThickness < CometRadius Then
                    CometX(ii, jj) = startx - ImpactThickness
                    If Int(jj / 2) * 2 = jj Then CometY(ii, jj) = starty + ImpactThickness Else CometY(ii, jj) = starty - ImpactThickness
                    CometZ(ii, jj) = startz - ImpactThickness
                Else
                    CometX(ii, jj) = startx - CometRadius * 2 - ImpactThickness
                    If Int(jj / 2) * 2 = jj Then CometY(ii, jj) = starty + CometRadius * 2 - ImpactThickness Else CometY(ii, jj) = starty - (CometRadius * 2 - ImpactThickness)
                    CometZ(ii, jj) = startz - CometRadius * 2 + ImpactThickness
                End If

                While Sqr(CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2) < PlanetRadius + CometRadius * .5: CometX(ii, jj) = CometX(ii, jj) * 1.001: CometY(ii, jj) = CometY(ii, jj) * 1.001: CometZ(i, jj) = CometZ(ii, jj) * 1.001: Wend

                Call RandomNumbersFewNearZero
                CometSpeedX(ii, jj) = CometPathSpeedX * RC * RE * 2.5 + XXFactor * (RB - .5) * RC
                CometSpeedY(ii, jj) = CometPathSpeedY * RE * RD * .94 + XXFactor * (Rnd(77) - .5) * RC * 4
                CometSpeedZ(ii, jj) = CometPathSpeedZ * RB * RC * 1.25 + XXFactor * (RA - .5) * RF

                If Scene$ = "Egypt" Then
                    CometSpeedY(ii, jj) = CometPathSpeedY * RE * RD * 1.25 + XXFactor * (Rnd(77) - .5) * RC * 4
                    CometSpeedZ(ii, jj) = 10 * (Rnd(99) - .5) + XXFactor * (RA - .5) * RF
                    CometSpeedX(ii, jj) = (CometSpeedZ(ii, jj) - 5) * (Rnd(96) - .5) + XXFactor * (RE - .5) * RF
                    '    CometColor(ii, jj) = _RGB(255, 255, 255)
                End If

                If Scene$ <> "Egypt" And Scene$ <> "ChesapeakeBay" Then
                    CX = CometX(ii, jj): CY = CometY(ii, jj): CZ = CometZ(ii, jj) ' Minimize numbers hitting ground near comet impact area - Those that hit in 20 seconds are recalculated
                    CXS = CometSpeedX(ii, jj): CYS = CometSpeedY(ii, jj): CZS = CometSpeedZ(ii, jj)
                    For KK = 1 To 20
                        distance = Sqr(CX ^ 2 + CY ^ 2 + CZ ^ 2)
                        EAcc = (GEarth / (distance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
                        CXS = CXS + (EAcc / distance) * (0 - CX)
                        CYS = CYS + (EAcc / distance) * (0 - CY)
                        CZS = CZS + (EAcc / distance) * (0 - CZ)
                        CX = CX + CXS
                        CY = CY + CYS
                        CZ = CZ + CZS
                    Next KK
                    distance = Sqr(CX ^ 2 + CY ^ 2 + CZ ^ 2)
                    CX = CometX(ii, jj): CY = CometY(ii, jj): CZ = CometZ(ii, jj)
                    LOOPCOUNT = 0
                    While LOOPCOUNT < 3 And distance < PlanetRadius
                        CXS = CometSpeedX(ii, jj): CYS = CometSpeedY(ii, jj): CZS = CometSpeedZ(ii, jj)
                        For KK = 1 To 20
                            distance = Sqr(CX ^ 2 + CY ^ 2 + CZ ^ 2)
                            EAcc = (GEarth / (distance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
                            CXS = CXS + (EAcc / distance) * (0 - CX)
                            CYS = CYS + (EAcc / distance) * (0 - CY)
                            CZS = CZS + (EAcc / distance) * (0 - CZ)
                            CX = CX + CXS
                            CY = CY + CYS
                            CZ = CZ + CZS
                        Next KK
                        distance = Sqr(CX ^ 2 + CY ^ 2 + CZ ^ 2)
                        If distance < PlanetRadius Then
                            '                        CometColor(ii, jj) = _RGB(255, 0, 0)
                            Call RandomNumbersFewNearZero
                            CometSpeedX(ii, jj) = CometPathSpeedX * RC * RE * 2.5 + XXFactor * (RB - .5) * RC
                            CometSpeedY(ii, jj) = CometPathSpeedY * RE * RD * .94 + XXFactor * (Rnd(77) - .5) * RC * 4
                            CometSpeedZ(ii, jj) = CometPathSpeedZ * RB * RC * 1.25 + XXFactor * (RA - .5) * RF
                            distance = 0
                            CX = CometX(ii, jj): CY = CometY(ii, jj): CZ = CometZ(ii, jj)
                        End If
                        LOOPCOUNT = LOOPCOUNT + 1
                    Wend

                End If
                If EarthRotation$ = "Yes" Then CometSpeedY(ii, jj) = CometSpeedY(ii, jj) - .5 ' - .5 is earth rotation
                CXS = CometSpeedX(ii, jj): CYS = CometSpeedY(ii, jj): CZS = CometSpeedZ(ii, jj)
                speed = Sqr(CXS ^ 2 + CYS ^ 2 + CZS ^ 2): If speed < 0.1 Then speed = .1
                Call RandomNumbersFewNearZero
                CometSize(ii, jj) = 230 * RB + 20 ' min size 20 meters radius
                If CometSize(ii, jj) > 200 * (2 / speed) Then CometSize(ii, jj) = 250 * RD ' minimize over 200 m radius and relate it to speed - higher speed = smaller on average pieces.
                CometMass(ii, jj) = 1.2
            End If
        Next jj
    Next ii



    If Scene$ <> "Egypt" And Scene$ <> "MARS" Then
        For ii = 1 To 5 ' Hoba Meteorite falling scene - a few partciles in space dropping slowly to earth over the pacific
            For jj = 1 To 5
                CometX(ii, jj) = -500 + jj * 10
                CometY(ii, jj) = 10000 + ii * 10
                CometZ(ii, jj) = 500 + jj * 10 + ii * 20
                CometSpeedX(ii, jj) = .4
                CometSpeedY(ii, jj) = 0
                CometSpeedZ(ii, jj) = -.4
                Select Case ii
                    Case 1: CometSize(ii, jj) = jj * 0.1 ' (0.1 to 0.5)(= 0.1 m to 0.5 m since CometSize is in METERS not km)
                    Case 2: CometSize(ii, jj) = jj * 0.5 ' (0.5 to 2.5)
                    Case 3: CometSize(ii, jj) = jj * 2 ' (2 to 10)
                    Case 4: CometSize(ii, jj) = jj * 5 ' (5 to 25)
                    Case 5: CometSize(ii, jj) = jj * 25 ' (25 to 125)
                End Select
                CometMass(ii, jj) = 1.2
                CometColor(ii, jj) = _RGB(255, 255, 0)
            Next jj
        Next ii
    End If

    skipthistoo22:


    jjcount = 200 * ImpactThickness / (CometRadius * 2) '  Add in more slower particles than normal since they are what we are trying to show.
    If jjcount > 200 Then jjcount = 200
    jjcount = jjcount + 50 ' Should range from 50 to 250




    For ii = ii1 To ii2 ' Main toss sideways / Bow Wave
        XXFactor = PresentCometSpeed * (ii + 200) / 2000
        For jj = 51 To jjcount
            If CometMass(ii, jj) = 2 Then
                CometColor(ii, jj) = NextCometColor
                If ImpactThickness < CometRadius Then
                    CometX(ii, jj) = startx - ImpactThickness
                    If Int(jj / 2) * 2 = jj Then CometY(ii, jj) = starty + ImpactThickness Else CometY(ii, jj) = starty - ImpactThickness
                    CometZ(ii, jj) = startz - ImpactThickness
                Else
                    CometX(ii, jj) = startx - CometRadius * 2 + ImpactThickness
                    If Int(jj / 2) * 2 = jj Then CometY(ii, jj) = starty + CometRadius * 2 - ImpactThickness Else CometY(ii, jj) = starty - (CometRadius * 2 - ImpactThickness)
                    CometZ(ii, jj) = startz - CometRadius * 2 + ImpactThickness
                End If
                ' can't eject from below ground level
                While Sqr(CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2) < PlanetRadius + CometRadius * .5: CometX(ii, jj) = CometX(ii, jj) * 1.001: CometY(ii, jj) = CometY(ii, jj) * 1.001: CometZ(i, jj) = CometZ(ii, jj) * 1.001: Wend


                Call RandomNumbers
                CometSpeedY(ii, jj) = 5 * RE * RD
                CometSpeedZ(ii, jj) = CometPathSpeedZ * RB * RC * .2 + XXFactor * (Rnd(77) - .5) * Rnd(22)
                CometSpeedX(ii, jj) = CometPathSpeedX * RC * RE * .5 + XXFactor * (RA - .5) * RF
                If (Rnd(56) - .5) < 0 Then CometSpeedY(ii, jj) = -CometSpeedY(ii, jj) ' flip Y for 1/2 the points

                If Scene$ = "Egypt" Then
                    CometSpeedX(ii, jj) = CometPathSpeedX * RC * RE * 3 + XXFactor * (RA - .5) * RF
                    CometSpeedY(ii, jj) = 5 * RE * (RD - .5)
                    CometSpeedZ(ii, jj) = CometPathSpeedZ * RB * RC * 1.2 + XXFactor * (Rnd(77) - .5) * Rnd(22)
                    GoTo SkipNonEgypt
                End If

                If Scene$ <> "Egypt" And Int(jj / 4) * 4 = jj Then ' bias a 1/4 of the points to land nearer to the USA east coast for Lake Michigan impact
                    Call RandomNumbersFewNearZero
                    CometSpeedY(ii, jj) = -4. * RA * RE - .6 ' set Y = - .6 to -4.6  for Saginaw scene
                    If (Rnd(48) - .5) < 0 Then CometSpeedY(ii, jj) = -CometSpeedY(ii, jj)
                    CometSpeedZ(ii, jj) = -1.5 + (RC + .2) * (RD - .5) * 1.2
                    CometSpeedX(ii, jj) = -3.75 + Abs(CometSpeedY(ii, jj)) * .38
                    '                    CometColor(ii, jj) = _RGB(255, 0, 255)
                End If

                If Int(jj / 3) * 3 = jj Then ' 1/3 ideal for Sagniaw scene, rest random sideways splash
                    ' Ideal sideways motion for Saginaw Scene:
                    '                CometSpeedX(ii, jj) = -1.3
                    '                CometSpeedZ(ii, jj) = 0
                    '                CometSpeedY(ii, jj) = -4
                    CometSpeedY(ii, jj) = -4 + 2.5 * (Rnd(34) - .5) * Rnd(43) ' Set Y =  -2.75 to -4
                    CometSpeedX(ii, jj) = -1.3 + 4 * (Rnd(34) - .5) * Rnd(43)
                    CometSpeedZ(ii, jj) = 1 + 1 * (Rnd(75) - .5) + CometSpeedX(ii, jj) ' : IF CometSpeedZ(ii, jj) > 0 AND CometSpeedX(ii, jj) > -1.3 THEN CometColor(ii, jj) = _RGB(255, 0, 0)
                    If (Rnd(21) - .5) < 0 Then CometSpeedY(ii, jj) = -CometSpeedY(ii, jj)
                    '                    CometColor(ii, jj) = _RGB(255, 0, 0)
                End If

                If Int(jj / 4) * 4 <> jj Then ' minimize numbers hitting ground beside the crater
                    CX = CometX(ii, jj): CY = CometY(ii, jj): CZ = CometZ(ii, jj)
                    LOOPCOUNT = 0
                    distance = 0
                    While LOOPCOUNT < 5 And distance < PlanetRadius + 2
                        CXS = CometSpeedX(ii, jj): CYS = CometSpeedY(ii, jj): CZS = CometSpeedZ(ii, jj)
                        For KK = 1 To 100
                            distance = Sqr(CX ^ 2 + CY ^ 2 + CZ ^ 2)
                            EAcc = (GEarth / (distance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
                            CXS = CXS + (EAcc / distance) * (0 - CX)
                            CYS = CYS + (EAcc / distance) * (0 - CY)
                            CZS = CZS + (EAcc / distance) * (0 - CZ)
                            CX = CX + CXS
                            CY = CY + CYS
                            CZ = CZ + CZS
                        Next KK
                        distance = Sqr(CX ^ 2 + CY ^ 2 + CZ ^ 2)
                        If distance < PlanetRadius + 2 Then
                            Call RandomNumbers
                            If Int(jj / 2) * 2 = jj Then
                                CometSpeedY(ii, jj) = 5 * RE * RD
                                CometSpeedZ(ii, jj) = CometPathSpeedZ * RB * RC * .2 + XXFactor * (Rnd(77) - .5) * Rnd(22)
                                CometSpeedX(ii, jj) = CometPathSpeedX * RC * RE * .5 + XXFactor * (RA - .5) * RF
                            Else
                                CometSpeedY(ii, jj) = -5 * RE * RD
                                CometSpeedZ(ii, jj) = CometPathSpeedZ * RB * RC * .2 + XXFactor * (Rnd(77) - .5) * Rnd(22)
                                CometSpeedX(ii, jj) = CometPathSpeedX * RC * RE * .5 + XXFactor * (RA - .5) * RF
                            End If
                            distance = 0
                            CX = CometX(ii, jj): CY = CometY(ii, jj): CZ = CometZ(ii, jj)
                        End If
                        LOOPCOUNT = LOOPCOUNT + 1
                    Wend
                End If

                SkipNonEgypt:
                If Scene$ = "Egypt" Then
                    ' Rotate about Y axis: (rotate from Michigan to Equator ~ 45 degrees)
                    '   X = X * cosTheta + z * sinTheta;  Cos 45 = .7, Sin 45 = .7; cos 60 = .5, sin 60 = .866
                    '   Z = z * cosTheta - x * sinTheta;  Cos -45 = .7, Sin -45 = -.7; cos -60 = .5, sin -60 = -.866
                    aaa = CometSpeedX(ii, jj)
                    CometSpeedX(ii, jj) = .7 * CometSpeedX(ii, jj) - .7 * CometSpeedZ(ii, jj)
                    CometSpeedZ(ii, jj) = .7 * CometSpeedZ(ii, jj) + .7 * aaa
                    ' Rotate about X axis: (angle ~90 degreees to match impact direction)
                    '   Y = y * cosTheta - z * sinTheta;  Cos -90 = 0, Sin -90 = -1
                    '   Z = z * cosTheta + y * sinTheta;
                    aaa = CometSpeedY(ii, jj)
                    CometSpeedY(ii, jj) = 0 * CometSpeedY(ii, jj) + 1 * CometSpeedZ(ii, jj)
                    CometSpeedZ(ii, jj) = 0 * CometSpeedZ(ii, jj) - 1 * aaa
                    ' Rotate back about Y axis: (rotate from Equator to Qattara ~ 30 degrees)
                    '   X = X * cosTheta + z * sinTheta;  Cos 30 = .866, Sin 30 = .5
                    '   Z = z * cosTheta - x * sinTheta
                    aaa = CometSpeedX(ii, jj)
                    CometSpeedX(ii, jj) = .866 * CometSpeedX(ii, jj) + .5 * CometSpeedZ(ii, jj)
                    CometSpeedZ(ii, jj) = .866 * CometSpeedZ(ii, jj) - .5 * aaa
                End If



                If Scene$ = "Saginaw 1" Or Scene$ = "Saginaw 2" Then
                    ' Rotate about Y axis: (rotate from Michigan to Equator ~ 45 degrees)
                    '   X = X * cosTheta + z * sinTheta;  Cos 45 = .7, Sin 45 = .7; cos 60 = .5, sin 60 = .866
                    '   Z = z * cosTheta - x * sinTheta;  Cos -45 = .7, Sin -45 = -.7; cos -60 = .5, sin -60 = -.866
                    aaa = CometSpeedX(ii, jj)
                    CometSpeedX(ii, jj) = .7 * CometSpeedX(ii, jj) - .7 * CometSpeedZ(ii, jj)
                    CometSpeedZ(ii, jj) = .7 * CometSpeedZ(ii, jj) + .7 * aaa

                    ' Rotate about Z axis:  2 degrees (rotate from vertical to slightly up to the north when finally rotated)
                    '   X = X * cosTheta - Y * sinTheta
                    '   Y = Y * cosTheta + X * sinTheta
                    aaa = CometSpeedX(ii, jj)
                    CometSpeedX(ii, jj) = .99939 * CometSpeedX(ii, jj) - .0349 * CometSpeedY(ii, jj)
                    CometSpeedY(ii, jj) = .99939 * CometSpeedY(ii, jj) + .0349 * aaa

                    ' Rotate about X axis: (angle ~42 degreees to match impact direction)
                    '   Y = y * cosTheta - z * sinTheta;  Cos 42 = .743, Sin 42 = .669
                    '   Z = z * cosTheta + y * sinTheta;
                    aaa = CometSpeedY(ii, jj)
                    CometSpeedY(ii, jj) = .743 * CometSpeedY(ii, jj) - .669 * CometSpeedZ(ii, jj)
                    CometSpeedZ(ii, jj) = .743 * CometSpeedZ(ii, jj) + .669 * aaa
                    ' Rotate back about Y axis: (rotate from Equator to Michigan ~ 45 degrees)
                    '   X = X * cosTheta + z * sinTheta;  Cos 45 = .7, Sin 45 = .7; cos 60 = .5, sin 60 = .866
                    '   Z = z * cosTheta - x * sinTheta;  Cos -45 = .7, Sin -45 = -.7; cos -60 = .5, sin -60 = -.866
                    aaa = CometSpeedX(ii, jj)
                    CometSpeedX(ii, jj) = .7 * CometSpeedX(ii, jj) + .7 * CometSpeedZ(ii, jj)
                    CometSpeedZ(ii, jj) = .7 * CometSpeedZ(ii, jj) - .7 * aaa
                End If

                If Scene$ = "MARS" Then
                    ' Rotate about Y axis: (rotate Orcus Patera ~15 degrees north of the equator)
                    '   X = X * cosTheta + z * sinTheta;  Cos 15 = .9659, Sin 15 = .2588
                    '   Z = z * cosTheta - x * sinTheta;  Cos -15 = .9659, Sin -15 = -.2588
                    aaa = CometSpeedX(ii, jj)
                    CometSpeedX(ii, jj) = .9659 * CometSpeedX(ii, jj) - .2588 * CometSpeedZ(ii, jj)
                    CometSpeedZ(ii, jj) = .9659 * CometSpeedZ(ii, jj) + .2588 * aaa
                    ' Rotate about X axis: (angle ~17 degreees to match impact direction)
                    '   Y = y * cosTheta - z * sinTheta;  Cos 17 = .9563, Sin 42 = .2924
                    '   Z = z * cosTheta + y * sinTheta;
                    aaa = CometSpeedY(ii, jj)
                    CometSpeedY(ii, jj) = .9563 * CometSpeedY(ii, jj) - .2924 * CometSpeedZ(ii, jj)
                    CometSpeedZ(ii, jj) = .9563 * CometSpeedZ(ii, jj) + .2924 * aaa
                    ' Rotate back about Y axis: (rotate from Equator to Orcus Patera ~ 15 degrees)
                    '   X = X * cosTheta + z * sinTheta;  Cos 45 = .7, Sin 45 = .7; cos 60 = .5, sin 60 = .866
                    '   Z = z * cosTheta - x * sinTheta;  Cos -45 = .7, Sin -45 = -.7; cos -60 = .5, sin -60 = -.866
                    aaa = CometSpeedX(ii, jj)
                    CometSpeedX(ii, jj) = .9659 * CometSpeedX(ii, jj) + .2588 * CometSpeedZ(ii, jj)
                    CometSpeedZ(ii, jj) = .9659 * CometSpeedZ(ii, jj) - .2588 * aaa
                End If


                If EarthRotation$ = "Yes" Then CometSpeedY(ii, jj) = CometSpeedY(ii, jj) - .5 ' - .5 is earth rotation
                CometMass(ii, jj) = 1.2
                CXS = CometSpeedX(ii, jj): CYS = CometSpeedY(ii, jj): CZS = CometSpeedZ(ii, jj)
                speed = Sqr(CXS ^ 2 + CYS ^ 2 + CZS ^ 2): If speed < 0.1 Then speed = .1
                Call RandomNumbersFewNearZero
                CometSize(ii, jj) = 230 * RB + 20 ' min size 20 meters radius
                If CometSize(ii, jj) > 200 * (2 / speed) Then CometSize(ii, jj) = 230 * RD + 20 ' minimize over 200 m radius and relate it to speed - higher speed = smaller on average pieces.
            End If
        Next jj
    Next ii





    If Scene$ = "Egypt" Then NextCometColor = _RGB(0, 0, 255): GoTo skipthistoo99

    jjcount = 50 * ImpactThickness / (CometRadius * 2)
    If jjcount > 50 Then jjcount = 50
    jjcount = jjcount + 250 ' Should range from 250 to 300

    For ii = ii1 To ii2 ' Back Splash
        XXFactor = PresentCometSpeed * (ii + 200) / 2000
        For jj = 251 To jjcount
            If CometMass(ii, jj) = 2 Then
                CometColor(ii, jj) = NextCometColor
                If ImpactThickness < CometRadius Then
                    CometX(ii, jj) = startx - ImpactThickness
                    If Int(jj / 2) * 2 = jj Then CometY(ii, jj) = starty + ImpactThickness Else CometY(ii, jj) = starty - ImpactThickness
                    CometZ(ii, jj) = startz - ImpactThickness
                Else
                    CometX(ii, jj) = startx - CometRadius * 2 + ImpactThickness
                    If Int(jj / 2) * 2 = jj Then CometY(ii, jj) = starty + CometRadius * 2 - ImpactThickness Else CometY(ii, jj) = starty - (CometRadius * 2 - ImpactThickness)
                    CometZ(ii, jj) = startz - CometRadius * 2 + ImpactThickness
                End If
                If Int(jj / 2) * 2 = jj Then CometY(ii, jj) = starty + ImpactThickness Else CometY(ii, jj) = starty - ImpactThickness

                If Scene$ = "Saginaw 1" Or Scene$ = "Saginaw 2" Then CometY(ii, jj) = starty: CometX(ii, jj) = startx: CometZ(ii, jj) = startz

                distance = Sqr(CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2)
                While distance <= PlanetRadius
                    CometX(ii, jj) = CometX(ii, jj) * 1.01: CometY(ii, jj) = CometY(ii, jj) * 1.01: CometZ(ii, jj) = CometZ(ii, jj) * 1.01
                    distance = Sqr(CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2)
                Wend

                If Int(jj / 3) * 3 = jj Then ' 1/3 ideal for Sagniaw scene, rest random sideways splash
                    ' Ideal sideways motion for Saginaw Scene:
                    '                CometSpeedX(ii, jj) = -1.3
                    '                CometSpeedZ(ii, jj) = 0
                    '                CometSpeedY(ii, jj) = -4
                    CometSpeedY(ii, jj) = -4 + 2.5 * (Rnd(34) - .5) * Rnd(43)
                    CometSpeedX(ii, jj) = -1.3 + 4 * (Rnd(34) - .5) * Rnd(43)
                    CometSpeedZ(ii, jj) = 1 + 1 * (Rnd(75) - .5) + CometSpeedX(ii, jj) ' : IF CometSpeedZ(ii, jj) > 0 AND CometSpeedX(ii, jj) > -1.3 THEN CometColor(ii, jj) = _RGB(255, 0, 0)
                    If (Rnd(21) - .5) < 0 Then CometSpeedY(ii, jj) = -CometSpeedY(ii, jj)
                    '                    CometColor(ii, jj) = _RGB(255, 0, 0)
                Else
                    Call RandomNumbers
                    CometSpeedX(ii, jj) = 0 + (Rnd(34) - .5) * 10 * Rnd(43)
                    CometSpeedZ(ii, jj) = 0 + (Rnd(34) - .5) * 10 * Rnd(44)
                    CometSpeedY(ii, jj) = 2 + (RE - .5) * RD * 3
                    If (Rnd(21) - .5) < 0 Then CometSpeedY(ii, jj) = -CometSpeedY(ii, jj)

                    CX = CometX(ii, jj): CY = CometY(ii, jj): CZ = CometZ(ii, jj)
                    LOOPCOUNT = 0
                    distance = 0
                    While LOOPCOUNT < 5 And distance < PlanetRadius + 2
                        CXS = CometSpeedX(ii, jj): CYS = CometSpeedY(ii, jj): CZS = CometSpeedZ(ii, jj)
                        For KK = 1 To 100
                            distance = Sqr(CX ^ 2 + CY ^ 2 + CZ ^ 2)
                            EAcc = (GEarth / (distance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
                            CXS = CXS + (EAcc / distance) * (0 - CX)
                            CYS = CYS + (EAcc / distance) * (0 - CY)
                            CZS = CZS + (EAcc / distance) * (0 - CZ)
                            CX = CX + CXS
                            CY = CY + CYS
                            CZ = CZ + CZS
                        Next KK
                        distance = Sqr(CX ^ 2 + CY ^ 2 + CZ ^ 2)
                        If distance < PlanetRadius + 2 Then
                            Call RandomNumbers
                            CometSpeedX(ii, jj) = 0 + (Rnd(34) - .5) * 10 * Rnd(43)
                            CometSpeedZ(ii, jj) = 0 + (Rnd(34) - .5) * 10 * Rnd(44)
                            If Int(jj / 2) * 2 = jj Then CometSpeedY(ii, jj) = 2 + (RE - .5) * RD * 3 Else CometSpeedY(ii, jj) = -2 - (RE - .5) * RD * 3
                            distance = 0
                            CX = CometX(ii, jj): CY = CometY(ii, jj): CZ = CometZ(ii, jj)
                        End If
                        LOOPCOUNT = LOOPCOUNT + 1
                    Wend
                End If

                If Scene$ = "Egypt" Then
                    ' Rotate about Y axis: (rotate from Michigan to Equator ~ 45 degrees)
                    '   X = X * cosTheta + z * sinTheta;  Cos 45 = .7, Sin 45 = .7; cos 60 = .5, sin 60 = .866
                    '   Z = z * cosTheta - x * sinTheta;  Cos -45 = .7, Sin -45 = -.7; cos -60 = .5, sin -60 = -.866
                    aaa = CometSpeedX(ii, jj)
                    CometSpeedX(ii, jj) = .7 * CometSpeedX(ii, jj) - .7 * CometSpeedZ(ii, jj)
                    CometSpeedZ(ii, jj) = .7 * CometSpeedZ(ii, jj) + .7 * aaa
                    ' Rotate about X axis: (angle ~90 degreees to match impact direction)
                    '   Y = y * cosTheta - z * sinTheta;  Cos -90 = 0, Sin -90 = -1
                    '   Z = z * cosTheta + y * sinTheta;
                    aaa = CometSpeedY(ii, jj)
                    CometSpeedY(ii, jj) = 0 * CometSpeedY(ii, jj) + 1 * CometSpeedZ(ii, jj)
                    CometSpeedZ(ii, jj) = 0 * CometSpeedZ(ii, jj) - 1 * aaa
                    ' Rotate back about Y axis: (rotate from Equator to Qattara ~ 30 degrees)
                    '   X = X * cosTheta + z * sinTheta;  Cos 30 = .866, Sin 30 = .5
                    '   Z = z * cosTheta - x * sinTheta
                    aaa = CometSpeedX(ii, jj)
                    CometSpeedX(ii, jj) = .866 * CometSpeedX(ii, jj) + .5 * CometSpeedZ(ii, jj)
                    CometSpeedZ(ii, jj) = .866 * CometSpeedZ(ii, jj) - .5 * aaa
                End If

                If Scene$ = "Saginaw 1" Or Scene$ = "Saginaw 2" Then
                    ' Rotate about Y axis: (rotate from Michigan to Equator ~ 45 degrees)
                    '   X = X * cosTheta + z * sinTheta;  Cos 45 = .7, Sin 45 = .7; cos 60 = .5, sin 60 = .866
                    '   Z = z * cosTheta - x * sinTheta;  Cos -45 = .7, Sin -45 = -.7; cos -60 = .5, sin -60 = -.866
                    aaa = CometSpeedX(ii, jj)
                    CometSpeedX(ii, jj) = .7 * CometSpeedX(ii, jj) - .7 * CometSpeedZ(ii, jj)
                    CometSpeedZ(ii, jj) = .7 * CometSpeedZ(ii, jj) + .7 * aaa
                    ' Rotate about X axis: (angle ~42 degreees to match impact direction)
                    '   Y = y * cosTheta - z * sinTheta;  Cos 42 = .743, Sin 42 = .669
                    '   Z = z * cosTheta + y * sinTheta;
                    aaa = CometSpeedY(ii, jj)
                    CometSpeedY(ii, jj) = .743 * CometSpeedY(ii, jj) - .669 * CometSpeedZ(ii, jj)
                    CometSpeedZ(ii, jj) = .743 * CometSpeedZ(ii, jj) + .669 * aaa
                    ' Rotate back about Y axis: (rotate from Equator to Michigan ~ 45 degrees)
                    '   X = X * cosTheta + z * sinTheta;  Cos 45 = .7, Sin 45 = .7; cos 60 = .5, sin 60 = .866
                    '   Z = z * cosTheta - x * sinTheta;  Cos -45 = .7, Sin -45 = -.7; cos -60 = .5, sin -60 = -.866
                    aaa = CometSpeedX(ii, jj)
                    CometSpeedX(ii, jj) = .7 * CometSpeedX(ii, jj) + .7 * CometSpeedZ(ii, jj)
                    CometSpeedZ(ii, jj) = .7 * CometSpeedZ(ii, jj) - .7 * aaa
                End If

                If Scene$ = "MARS" Then
                    ' Rotate about Y axis: (rotate Orcus Patera ~15 degrees north of the equator)
                    '   X = X * cosTheta + z * sinTheta;  Cos 15 = .9659, Sin 15 = .2588
                    '   Z = z * cosTheta - x * sinTheta;  Cos -15 = .9659, Sin -15 = -.2588
                    aaa = CometSpeedX(ii, jj)
                    CometSpeedX(ii, jj) = .9659 * CometSpeedX(ii, jj) - .2588 * CometSpeedZ(ii, jj)
                    CometSpeedZ(ii, jj) = .9659 * CometSpeedZ(ii, jj) + .2588 * aaa
                    ' Rotate about X axis: (angle ~17 degreees to match impact direction)
                    '   Y = y * cosTheta - z * sinTheta;  Cos 17 = .9563, Sin 42 = .2924
                    '   Z = z * cosTheta + y * sinTheta;
                    aaa = CometSpeedY(ii, jj)
                    CometSpeedY(ii, jj) = .9563 * CometSpeedY(ii, jj) - .2924 * CometSpeedZ(ii, jj)
                    CometSpeedZ(ii, jj) = .9563 * CometSpeedZ(ii, jj) + .2924 * aaa
                    ' Rotate back about Y axis: (rotate from Equator to Orcus Patera ~ 15 degrees)
                    '   X = X * cosTheta + z * sinTheta;  Cos 45 = .7, Sin 45 = .7; cos 60 = .5, sin 60 = .866
                    '   Z = z * cosTheta - x * sinTheta;  Cos -45 = .7, Sin -45 = -.7; cos -60 = .5, sin -60 = -.866
                    aaa = CometSpeedX(ii, jj)
                    CometSpeedX(ii, jj) = .9659 * CometSpeedX(ii, jj) + .2588 * CometSpeedZ(ii, jj)
                    CometSpeedZ(ii, jj) = .9659 * CometSpeedZ(ii, jj) - .2588 * aaa
                End If

                If EarthRotation$ = "Yes" Then CometSpeedY(ii, jj) = CometSpeedY(ii, jj) - .5 ' - .5 is earth rotation

                CometMass(ii, jj) = 1.2
                '                IF Scene$ = "Saginaw 1" OR Scene$ = "Saginaw 2" THEN CometColor(ii, jj) = _RGB(0, 0, 255)
                CXS = CometSpeedX(ii, jj): CYS = CometSpeedY(ii, jj): CZS = CometSpeedZ(ii, jj)
                speed = Sqr(CXS ^ 2 + CYS ^ 2 + CZS ^ 2): If speed < 0.1 Then speed = .1
                Call RandomNumbersFewNearZero
                CometSize(ii, jj) = 230 * RB + 20 ' min size 20 meters radius
                If CometSize(ii, jj) > 200 * (2 / speed) Then CometSize(ii, jj) = 230 * RD + 20 ' minimize over 200 m radius and relate it to speed - higher speed = smaller on average pieces.
                CometMass(ii, jj) = 1.2
            End If
        Next jj
    Next ii

    skipthistoo99:

    Exit Sub



End Sub


Sub WorldCoordinates

    filename$ = "WorldOutlineData.dat"
    If Scene$ = "MARS" Then filename$ = "MarsOutlineData.dat"

    If _FileExists(filename$) Then
        Locate 20, 20: Print "Word Data File found"
    Else
        Locate 20, 20: Print "Word Data File NOT found"
        _Display
        Beep
        Exit Sub
    End If

    '    OPEN filename$ FOR OUTPUT AS #1 'opens and clears an existing file or creates new empty file
    '    WRITE #1, x, y, z$
    '    CLOSE #1
    ii = 0
    Open filename$ For Input As #2 'opens a file to read it
    While Not EOF(2) And ii < 1100
        Line Input #2, AA$
        '        LOCATE 15, 20: PRINT AA$
        If AA$ <> "" Then
            If InStr(AA$, ",") > 0 Then ' ignore comments and blank lines
                ii = ii + 1
                WorldX(ii) = Val(Left$(AA$, InStr(AA$, ",")))
                AA$ = Right$(AA$, Len(AA$) - InStr(AA$, ","))
                '                LOCATE 16, 20: PRINT AA$
                WorldY(ii) = Val(Left$(AA$, InStr(AA$, ",")))
                AA$ = Right$(AA$, Len(AA$) - InStr(AA$, ","))
                '                LOCATE 17, 20: PRINT AA$
                WorldZ(ii) = Val(AA$)
            End If
            '            LOCATE 20, 20: PRINT ii, WorldX(ii), WorldY(ii), WorldZ(ii)
            '            _DISPLAY
            '            A$ = "": WHILE A$ = "": A$ = INKEY$: WEND
        End If
    Wend
    Close #2


End Sub


Sub CarolinaBaysDemo
    ' 3D  version
    ' Planet Center = 0,0,0
    PlanetRadius = 6371 ' Earth
    If Scene$ = "MARS" Then PlanetRadius = 3396
    If Scene$ = "Venus and Encke" Then PlanetRadius = 6052
    If Scene$ = "Mercury and Encke" Then PlanetRadius = 2439.7
    For x = 1 To 300
        For y = 1 To 300
            CometX(x, y) = 0: CometY(x, y) = 0: CometZ(x, y) = 0
            CometSpeedX(x, y) = 0
            CometSpeedY(x, y) = 0
            CometSpeedZ(x, y) = 0
            CometMass(x, y) = 0
            CometColor(x, y) = _RGB(0, 0, 0)
        Next y
    Next x
    For ii = 0 To 100 ' Initialize Lake Michigan impact locations
        For jj = 0 To 15
            LakeMichLocX(ii, jj) = 0: LakeMichLocY(ii, jj) = 0: LakeMichLocZ(ii, jj) = 0: LakeMichLocRad(ii, jj) = 0
        Next jj
    Next ii


    ZoomWindow1 = -29700: ZoomWindow2 = -16710: ZoomWindow3 = 29700: ZoomWindow4 = 16710 ' Center on Earth = 0,0 co-ordinates =  same as pressing End key
    ZoomXDiff = 59400: ZoomYDiff = 33420
    ZoomWindow1 = ZoomWindow1 + ZoomXDiff * .25
    ZoomWindow2 = ZoomWindow2 + ZoomYDiff * .25
    ZoomWindow3 = ZoomWindow3 - ZoomXDiff * .25
    ZoomWindow4 = ZoomWindow4 - ZoomYDiff * .25 '  Same as pressing Page Up after End key


    '  *********************************  @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@   ***********************************************
    CBayBeginImpactProbabilities:

    If ToggleRadius = 0 Then CometRadius = 30 Else CometRadius = ToggleRadius 'Comet diameter = 2 X CometRadius, with 1 pixel = 1 km size

    For i = 0 To 100: ImpactAngleProbs(i) = 0: ImpactAngleProbPercents(i) = 0: Next i ' set ImpactAngleProbs(0) as misses, ImpactAngleProbs(1) for 0-5 degrees, ImpactAngleProbs(2) as 5 to 10 etc.
    RunImpactProbabilities$ = ""
    NumPointsHitting = 0
    TotalPointsCalculated = 0

    '**************************************
    NumPointsToCalculate = 1500
    '**************************************

    CometStartY = CometRadius * NumPointsToCalculate * 2
    CometStartZ = CometRadius * NumPointsToCalculate * 2

    Select Case Abs(CometInitialSpeedX)
        Case Is < 1.1: PointsTotal = 200000
        Case 1.1 To 5: PointsTotal = 2000000
        Case 5 To 10: PointsTotal = 2000000
        Case 10 To 50: PointsTotal = 800000
        Case Else: PointsTotal = 800000
    End Select


    Window (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, ZoomWindow4)
    Cls
    _Display

    If Scene$ = "MARS" Then
        For i = 6 To 3396 Step 10
            EarthColorization = 255 - 100 * i / 6371
            EarthColorization2 = 165 - 160 * i / 6371
            Circle (0, 0), i, _RGB(EarthColorization / 1.5, EarthColorization2 / 1.5, EarthColorization2 / 1.5)
        Next i
    Else
        For i = 7 To 6371 Step 10
            EarthColorization = 255 - 100 * i / 6371
            EarthColorization2 = 165 - 160 * i / 6371
            Circle (0, 0), i, _RGB(EarthColorization2 / 1.5, EarthColorization2 / 1.5, EarthColorization / 1.5)
        Next i
    End If



    Locate 17, 90: Print " Calculating for 5 seconds. Please Wait"
    _Display



    CometRadius = 30
    LakeMichCount = 0
    MaxZ1 = 7

    For Z1 = 0 To 7
        Select Case Scene$
            Case "Egypt" ' Fast impact
                CometItselfSpeedX(Z1) = 1 ' km/sec
                CometItselfSpeedY(Z1) = 60 ' km/sec
                CometItselfSpeedZ(Z1) = 4 ' km/sec

                CometItselfRadius(0) = 10: CometItselfX(0) = -5820: CometItselfY(0) = -18500: CometItselfZ(0) = 2130: CometItselfColor(0) = _RGB(0, 255, 0) ' GREEN
                CometItselfRadius(1) = 20: CometItselfX(1) = -5710: CometItselfY(1) = -18000: CometItselfZ(1) = 2325: CometItselfColor(1) = _RGB(255, 0, 0) ' RED
                CometItselfRadius(2) = 5: CometItselfX(2) = -5690: CometItselfY(2) = -18000: CometItselfZ(2) = 2325: CometItselfColor(2) = _RGB(0, 255, 0) ' BLUE
                CometItselfRadius(3) = 3: CometItselfX(3) = -5665: CometItselfY(3) = -18000: CometItselfZ(3) = 2370: CometItselfColor(3) = _RGB(255, 255, 255) ' White
                CometItselfRadius(4) = 3: CometItselfX(4) = -5748.5: CometItselfY(4) = -18200: CometItselfZ(4) = 2240: CometItselfColor(4) = _RGB(255, 255, 0) ' Yellow
                If Z1 = 5 Then Z1 = 10
                MaxZ1 = 4

            Case "Saginaw 1", "Saginaw 2" '  Saginaw Crater - 15-20 degrees, but not quite the correct angle of 222 degrees but close. 222 degrees ratios are tan (42) = y/z = 0.9 so for 34 km/s z, need y = 30.6; for z = 228295, need y = 205465
                CometItselfSpeedX(Z1) = -15.9 ' km/sec
                CometItselfSpeedY(Z1) = 30.69 ' km/sec
                CometItselfSpeedZ(Z1) = -34.14 ' km/sec

                CometItselfRadius(0) = 15: CometItselfX(0) = 249: CometItselfY(0) = -9701: CometItselfZ(0) = 14949: CometItselfColor(0) = _RGB(255, 255, 0) ' Yellow
                CometItselfRadius(1) = 15: CometItselfX(1) = 248.4: CometItselfY(1) = -9246: CometItselfZ(1) = 14947: CometItselfColor(1) = _RGB(0, 255, 0) ' Yellow
                CometItselfRadius(2) = 15: CometItselfX(2) = 248.4: CometItselfY(2) = -9246: CometItselfZ(2) = 14947: CometItselfColor(2) = _RGB(0, 255, 0) ' Yellow
                CometItselfRadius(3) = 15: CometItselfX(3) = 248.4: CometItselfY(3) = -9246: CometItselfZ(3) = 14947: CometItselfColor(3) = _RGB(0, 255, 0) ' Yellow
                CometItselfRadius(4) = 15: CometItselfX(4) = 249: CometItselfY(4) = -9701: CometItselfZ(4) = 14949: CometItselfColor(4) = _RGB(255, 255, 0) ' Yellow

                If Scene$ = "Saginaw 1" Then
                    CometItselfRadius(1) = 15: CometItselfX(1) = 249: CometItselfY(1) = -9701: CometItselfZ(1) = 14949: CometItselfColor(1) = _RGB(255, 255, 0) ' Yellow
                    CometItselfRadius(2) = 15: CometItselfX(2) = 249: CometItselfY(2) = -9701: CometItselfZ(2) = 14949: CometItselfColor(2) = _RGB(255, 255, 0) ' Yellow
                    CometItselfRadius(3) = 15: CometItselfX(3) = 249: CometItselfY(3) = -9701: CometItselfZ(3) = 14949: CometItselfColor(3) = _RGB(255, 255, 0) ' Yellow
                End If
                If Z1 = 5 Then Z1 = 10
                MaxZ1 = 4

            Case "Mercury and Encke"
                CometItselfSpeedX(Z1) = 0 ' km/sec
                CometItselfSpeedY(Z1) = -19.1 ' km/sec
                CometItselfSpeedZ(Z1) = 0 ' km/sec
                CometItselfRadius(Z1) = 40
                CometItselfX(0) = -3000: CometItselfY(0) = 65000: CometItselfZ(0) = 0: CometItselfColor(0) = _RGB(0, 255, 0) ' Green
                CometItselfX(1) = -2439: CometItselfY(1) = 65000: CometItselfZ(1) = 0: CometItselfColor(1) = _RGB(255, 0, 0) ' Red
                CometItselfX(2) = 6800: CometItselfY(2) = 65000: CometItselfZ(2) = 1500: CometItselfColor(2) = _RGB(0, 0, 255) ' Blue
                CometItselfSpeedX(2) = -2.6: CometItselfSpeedY(2) = -19.1: CometItselfSpeedZ(2) = 0
                CometItselfX(3) = -1745: CometItselfY(3) = 65000: CometItselfZ(3) = 1745: CometItselfColor(3) = _RGB(255, 255, 255) ' White
                CometItselfX(4) = -1774: CometItselfY(4) = 65000: CometItselfZ(4) = 1774: CometItselfColor(4) = _RGB(255, 255, 0) ' Yellow
                MaxZ1 = 4


            Case "Venus and Encke"
                CometItselfSpeedX(Z1) = 0 ' km/sec
                CometItselfSpeedY(Z1) = -13 ' km/sec
                CometItselfSpeedZ(Z1) = 0 ' km/sec
                CometItselfRadius(Z1) = 40
                CometItselfX(0) = -6880: CometItselfY(0) = 65000: CometItselfZ(0) = 0: CometItselfColor(0) = _RGB(0, 255, 255) ' Cyan
                CometItselfX(1) = -6900: CometItselfY(2) = 65000: CometItselfZ(2) = 4400: CometItselfColor(2) = _RGB(0, 255, 255) ' Cyan

                CometItselfX(2) = 55000: CometItselfY(2) = -4200: CometItselfZ(2) = 0: CometItselfColor(2) = _RGB(0, 0, 255) ' Blue
                CometItselfSpeedX(2) = -31.2: CometItselfSpeedY(2) = -1.2: CometItselfSpeedZ(2) = 0

                CometItselfSpeedX(3) = 32: CometItselfSpeedY(3) = -1.21
                CometItselfX(3) = -80000: CometItselfY(3) = -3300: CometItselfZ(3) = 0: CometItselfColor(3) = _RGB(255, 255, 0) ' Yellow
                CometItselfSpeedX(4) = 32: CometItselfSpeedY(4) = -1.4
                CometItselfX(4) = -55000: CometItselfY(4) = -3900: CometItselfZ(4) = 0: CometItselfColor(4) = _RGB(0, 255, 0) ' Green
                CometItselfSpeedX(5) = -32: CometItselfSpeedY(5) = -1.4: CometItselfSpeedZ(5) = 0
                CometItselfX(5) = 55000: CometItselfY(5) = -3900: CometItselfZ(5) = 0: CometItselfColor(5) = _RGB(255, 0, 255) ' Purple
                CometItselfSpeedX(6) = -31.8: CometItselfSpeedY(6) = -1.2
                CometItselfX(6) = 55000: CometItselfY(6) = -4230: CometItselfZ(6) = 0: CometItselfColor(6) = _RGB(255, 255, 255) ' White


            Case "Earth and ST" '  - Aug 14 crossing, comet hits from above, nearly 45 degrees from straight down."
                '                CSpeedX = CometItselfSpeedX(ii) + 17.0811 ' add in Earth's orbital speed with Earth at August 14 position, or 55 degrees from June 21 = Cos(55) of full Earth Orbit speed
                '                CSpeedY = CometItselfSpeedY(ii) - 24.3943 ' add in Earth's orbital speed with Earth at August 14 position, or 55 degrees from June 21 = Sin(55) of full Earth Orbit speed

                '                CometItselfRadius(1) = 40: CometItselfX(1) = 54200: CometItselfY(1) = -113900: CometItselfZ(1) = 150000: CometItselfColor(1) = _RGB(255, 255, 0) ' Yellow - reverse of Swift Tuttle orbit. Passes Earth at 56.1 km/sec
                '                CometItselfSpeedX(1) = -15: CometItselfSpeedY(1) = 33.4: CometItselfSpeedZ(1) = -41
                '
                CometItselfRadius(0) = 30: CometItselfX(0) = 51270: CometItselfY(0) = -77950: CometItselfZ(0) = 74500: CometItselfColor(0) = _RGB(0, 0, 255) ' Blue - hits 90 degrees side of Earth
                CometItselfSpeedX(0) = -25.2: CometItselfSpeedY(0) = 35.5: CometItselfSpeedZ(0) = -38.2

                CometItselfRadius(1) = 30: CometItselfX(1) = 66200: CometItselfY(1) = -87950: CometItselfZ(1) = 89000: CometItselfColor(1) = _RGB(255, 255, 255) ' White - hits opposide side of Earth
                CometItselfSpeedX(1) = -25.2: CometItselfSpeedY(1) = 35.5: CometItselfSpeedZ(1) = -38.2

                CometItselfRadius(2) = 40: CometItselfX(2) = 57000: CometItselfY(2) = -128900: CometItselfZ(2) = 150000: CometItselfColor(2) = _RGB(255, 0, 0) ' Red - reverse of Swift Tuttle orbit. Passes Earth at 56.1 km/sec
                CometItselfSpeedX(2) = -17: CometItselfSpeedY(2) = 35.5: CometItselfSpeedZ(2) = -40

                CometItselfRadius(3) = 30: CometItselfX(3) = 43480: CometItselfY(3) = -78150: CometItselfZ(3) = 90400: CometItselfColor(3) = _RGB(255, 0, 255) ' Purple. Passes Earth at 56.8 km/sec
                CometItselfSpeedX(3) = -21.6: CometItselfSpeedY(3) = 35.5: CometItselfSpeedZ(3) = -38.73

                CometItselfRadius(4) = 30: CometItselfX(4) = 51270: CometItselfY(4) = -77950: CometItselfZ(4) = 89000: CometItselfColor(4) = _RGB(0, 255, 0) ' Green - Larger X but similar resulting orbit. Passes Earth at 57.9 km/sec
                CometItselfSpeedX(4) = -25.2: CometItselfSpeedY(4) = 35.5: CometItselfSpeedZ(4) = -38.2

                MaxZ1 = 4


            Case "Earth and Encke Nov" '  - Nov 7 crossing, comet hits at 45 degrees relative to Earth path."
                CometItselfRadius(0) = 20: CometItselfX(0) = -64000: CometItselfY(0) = -80200: CometItselfZ(0) = -5500: CometItselfColor(0) = _RGB(255, 0, 0) ' Red
                CometItselfSpeedX(0) = 19: CometItselfSpeedY(0) = 22.1: CometItselfSpeedZ(0) = 0

                CometItselfRadius(1) = 40: CometItselfX(1) = -64000: CometItselfY(1) = -80000: CometItselfZ(1) = 3000: CometItselfColor(1) = _RGB(255, 0, 255) ' Purple
                CometItselfSpeedX(1) = 19: CometItselfSpeedY(1) = 22.1: CometItselfSpeedZ(1) = -3

                CometItselfRadius(2) = 40: CometItselfX(2) = -70000: CometItselfY(2) = -95000: CometItselfZ(2) = 0: CometItselfColor(2) = _RGB(0, 255, 0) ' Green = Encke Orbit that moves out to Saturn's orbit
                CometItselfSpeedX(2) = 15.8: CometItselfSpeedY(2) = 24.15: CometItselfSpeedZ(2) = 0

                CometItselfRadius(3) = 40: CometItselfX(3) = -61000: CometItselfY(3) = -80000: CometItselfZ(3) = 0: CometItselfColor(3) = _RGB(255, 255, 0) ' Yellow = Saturn Orbit that moves to Encke Orbit
                CometItselfSpeedX(3) = 19.3: CometItselfSpeedY(3) = 22.1: CometItselfSpeedZ(3) = 0

                CometItselfRadius(4) = 20: CometItselfX(4) = -61000: CometItselfY(4) = -80000: CometItselfZ(4) = 3070: CometItselfColor(4) = _RGB(0, 255, 255) ' Cyan
                CometItselfSpeedX(4) = 19: CometItselfSpeedY(4) = 22.1: CometItselfSpeedZ(4) = 0

                '                CometItselfRadius(5) = 40: CometItselfX(5) = 20000: CometItselfY(5) = 100000: CometItselfZ(5) = 17900: CometItselfColor(5) = _RGB(0, 0, 255) ' Blue = Lake Michigan possibly
                '                CometItselfSpeedX(5) = -2.3: CometItselfSpeedY(5) = -11: CometItselfSpeedZ(5) = -1

                MaxZ1 = 4

            Case "Earth and Encke July"
                CometItselfRadius(0) = 40: CometItselfX(0) = -14700: CometItselfY(0) = -14950: CometItselfZ(0) = 3880: CometItselfColor(0) = _RGB(255, 0, 255) ' Purple = Lake Ontario, Noon Toronto time, June 21; from West to East
                CometItselfSpeedX(0) = -2: CometItselfSpeedY(0) = 28: CometItselfSpeedZ(0) = 0

                CometItselfRadius(1) = 40: CometItselfX(1) = 13500: CometItselfY(1) = -100000: CometItselfZ(1) = 2400: CometItselfColor(1) = _RGB(255, 0, 0) ' Red
                CometItselfSpeedX(1) = -2: CometItselfSpeedY(1) = 28: CometItselfSpeedZ(1) = 0

                CometItselfRadius(2) = 40: CometItselfX(2) = 5000: CometItselfY(2) = -130000: CometItselfZ(2) = 3000: CometItselfColor(2) = _RGB(0, 255, 0) ' Green
                CometItselfSpeedX(2) = -2.5: CometItselfSpeedY(2) = 29.2: CometItselfSpeedZ(2) = 0

                CometItselfRadius(3) = 40: CometItselfX(3) = 2000: CometItselfY(3) = -70000: CometItselfZ(3) = 8050: CometItselfColor(3) = _RGB(255, 255, 0) ' Yellow = Lake Ontario, Noon Toronto time, June 21, From East to West
                CometItselfSpeedX(3) = 2: CometItselfSpeedY(3) = 30: CometItselfSpeedZ(3) = 0

                CometItselfRadius(4) = 40: CometItselfX(4) = 27000: CometItselfY(4) = -27000: CometItselfZ(4) = 0: CometItselfColor(4) = _RGB(0, 255, 255) ' Cyan
                CometItselfSpeedX(4) = -12: CometItselfSpeedY(4) = 8: CometItselfSpeedZ(4) = 0

                MaxZ1 = 4

            Case "Encke and Swift-Tuttle Origins" ' Origins of Encke and Swift-Tuttle
                '            Select Case Scene$
                '                Case "Mercury and Encke": CSunX = 57910000: GEarth = GravityConstant * 3.3011 * 10 ^ 23 ' mass of Mercury in kg
                '                Case "Venus and Encke": CSunX = 108210000: GEarth = GravityConstant * 4.8675 * 10 ^ 24 ' mass of Venus in kg
                '                Case "Encke and Swift-Tuttle Origins": CSunX = 149760000: GEarth = GravityConstant * 5.972 * 10 ^ 24 ' mass of Earth in kg
                '            End Select

                '                CometItselfSpeedX(0) = -10 ' km/sec
                '                CometItselfSpeedY(0) = 0 ' km/sec
                '                CometItselfSpeedZ(0) = -3.338 ' km/sec

                '                CometItselfSpeedX(Z1) = -10.5 ' km/sec
                '                CometItselfSpeedY(Z1) = 0 ' km/sec
                '                CometItselfSpeedZ(Z1) = -6 ' km/sec
                '                CometItselfRadius(0) = 20: CometItselfX(0) = 18450: CometItselfY(0) = 0: CometItselfZ(0) = 20000: CometItselfColor(0) = _RGB(0, 255, 0) ' GREEN ' Earth Radius = 6371 km
                '                CometItselfRadius(1) = 10: CometItselfX(1) = 18452: CometItselfY(1) = -20: CometItselfZ(1) = 20000: CometItselfColor(1) = _RGB(255, 0, 0) ' RED
                '                CometItselfRadius(2) = 30: CometItselfX(2) = 18448: CometItselfY(2) = 20: CometItselfZ(2) = 20000: CometItselfColor(2) = _RGB(0, 0, 255) ' BLUE
                '                CometItselfRadius(3) = 10: CometItselfX(3) = 18454: CometItselfY(3) = -20: CometItselfZ(3) = 20000: CometItselfColor(3) = _RGB(255, 255, 255) ' White
                '                CometItselfRadius(4) = 10: CometItselfX(4) = 18458: CometItselfY(4) = 0: CometItselfZ(4) = 20000: CometItselfColor(4) = _RGB(255, 255, 0) ' Yellow


                '                CometItselfSpeedX(0) = -.15 ' km/sec
                CometItselfSpeedX(Z1) = 0 ' km/sec
                CometItselfSpeedY(Z1) = -10 ' km/sec
                CometItselfSpeedZ(Z1) = -.15 ' km/sec
                CometItselfSpeedX(8) = -2.626 ' km/sec   Larger X (more positive) hits sooner
                CometItselfSpeedZ(8) = 3 ' km/sec
                '                CometItselfRadius(0) = 20: CometItselfX(0) = -8500: CometItselfY(0) = 85000: CometItselfZ(0) = 10000: CometItselfColor(0) = _RGB(255, 255, 0) ' Yellow
                CometItselfSpeedX(1) = .757147 ' km/sec
                CometItselfSpeedY(1) = -11.5877 ' km/sec
                CometItselfSpeedZ(1) = -.957 ' km/sec

                CometItselfSpeedX(3) = 0 ' km/sec   Larger X (more positive) hits sooner
                CometItselfSpeedY(3) = -12.8 ' km/sec   Earth Average Speed: 29.78 km/s, Swift-Tuttle Max Speed: 42.6 km/s Dfference = 12.8 km/sec   *****  NOTE S-T is not in line with Earth so speed should be a bit slower crossing
                CometItselfSpeedZ(3) = 0 ' km/sec
                CometItselfRadius(3) = 17: CometItselfX(3) = -5550: CometItselfY(3) = 45000: CometItselfZ(3) = 5200: CometItselfColor(3) = _RGB(255, 255, 255) ' White - Lake Ontario West
                ' for 10 km/sec this works                CometItselfRadius(3) = 17: CometItselfX(3) = -6000: CometItselfY(3) = 44000: CometItselfZ(3) = 5600: CometItselfColor(3) = _RGB(255, 255, 255) ' White - Lake Ontario West



                '                CometItselfRadius(1) = 20: CometItselfX(1) = -7691.54: CometItselfY(1) = 9514.38: CometItselfZ(1) = 8037.86: CometItselfColor(1) = _RGB(0, 255, 0) ' GREEN ' Earth Radius = 6371 km


                '                CometItselfRadius(0) = 15: CometItselfX(0) = 5000: CometItselfY(0) = 45000: CometItselfZ(0) = 0: CometItselfColor(0) = _RGB(255, 0, 0) ' Red  - Lake Ontario East
                '                CometItselfSpeedX(1) = -0.23 ' km/sec   Larger X (more positive) hits sooner
                '                CometItselfSpeedZ(1) = 4.673 ' km/sec
                '                CometItselfRadius(1) = 15: CometItselfX(1) = -5000: CometItselfY(1) = 45000: CometItselfZ(1) = -12000: CometItselfColor(1) = _RGB(0, 255, 0) ' Green
                '                CometItselfRadius(1) = 20: CometItselfX(1) = 22000: CometItselfY(1) = 45000: CometItselfZ(1) = 9200: CometItselfColor(1) = _RGB(0, 0, 255) ' Blue
                '                CometItselfSpeedX(1) = -5: CometItselfSpeedY(1) = -11: CometItselfSpeedZ(1) = -.15
                CometItselfRadius(1) = 40: CometItselfX(1) = 20000: CometItselfY(1) = 100000: CometItselfZ(1) = 17900: CometItselfColor(1) = _RGB(0, 0, 255) ' Blue
                CometItselfSpeedX(1) = -2.3: CometItselfSpeedY(1) = -11: CometItselfSpeedZ(1) = -1
                CometItselfRadius(2) = 40: CometItselfX(2) = -80000: CometItselfY(2) = -12350: CometItselfZ(2) = 0: CometItselfColor(2) = _RGB(0, 255, 0) ' Green
                CometItselfSpeedX(2) = 29.06: CometItselfSpeedY(2) = 2.0177: CometItselfSpeedZ(2) = 0

                '                CometItselfRadius(3) = 20: CometItselfX(3) = 150000: CometItselfY(3) = -12470: CometItselfZ(3) = 3880: CometItselfColor(3) = _RGB(255, 255, 0) ' Yellow
                '                CometItselfSpeedX(3) = -29.4: CometItselfSpeedY(3) = 1.2: CometItselfSpeedZ(3) = -.3
                CometItselfRadius(3) = 20: CometItselfX(3) = 143000: CometItselfY(3) = -12500: CometItselfZ(3) = 3880: CometItselfColor(3) = _RGB(255, 255, 0) ' Yellow = Lake Ontario, Noon Toronto time, June 21, From East to West
                CometItselfSpeedX(3) = -28: CometItselfSpeedY(3) = 1.195: CometItselfSpeedZ(3) = -.3
                CometItselfRadius(6) = 100: CometItselfX(6) = -147000: CometItselfY(6) = -14950: CometItselfZ(6) = 3880: CometItselfColor(6) = _RGB(255, 0, 255) ' Purple = Lake Ontario, Noon Toronto time, June 21; from West to East
                CometItselfSpeedX(6) = 28.5: CometItselfSpeedY(6) = 1.6: CometItselfSpeedZ(6) = -.3


                CometItselfRadius(4) = 40: CometItselfX(4) = 150000: CometItselfY(4) = -13500: CometItselfZ(4) = 0: CometItselfColor(4) = _RGB(0, 255, 255) ' Cyan
                CometItselfSpeedX(4) = -30: CometItselfSpeedY(4) = 1.3: CometItselfSpeedZ(4) = 0
                CometItselfRadius(5) = 40: CometItselfX(5) = 150000: CometItselfY(5) = -13810: CometItselfZ(5) = 0: CometItselfColor(5) = _RGB(255, 0, 0) ' Red
                CometItselfSpeedX(5) = -29.2: CometItselfSpeedY(5) = 1.4: CometItselfSpeedZ(5) = 0
                '                CometItselfSpeedX(5) = -30: CometItselfSpeedY(5) = 29.78 - 28.5: CometItselfSpeedZ(5) = 0

                CometItselfRadius(7) = 40: CometItselfX(7) = 150000: CometItselfY(7) = -24400: CometItselfZ(7) = 0: CometItselfColor(7) = _RGB(255, 255, 255) ' White
                CometItselfSpeedX(7) = -28.3: CometItselfSpeedY(7) = 6: CometItselfSpeedZ(7) = 0

                ' Encke Orbit @ -34500 = near Earth by 800 km but then came from Saturn Orbit area:   CometItselfSpeedX(7) = -28.4: CometItselfSpeedY(7) = 6: CometItselfSpeedZ(7) = 0: CometItselfY(7) = -34500
                ' Encke Orbit - Just grazing Earth, from Uranus's orbit area:                CometItselfSpeedX(7) = -28.4: CometItselfSpeedY(7) = 6: CometItselfSpeedZ(7) = 0: CometItselfY(7) = -35300
                ' Encke Orbit:                CometItselfSpeedX(7) = -30: CometItselfSpeedY(7) = 8: CometItselfSpeedZ(7) = 0


                ' Mercury distance to sun 57910000 km  -  Diff from Earth = 14976-5791 =91850000
                ' Venus distance to sun  108210000 km  -  Diff from Earth = 14976-10821 =41550000
                ' Earth Distance to sun  149760000
                '                CometItselfRadius(3) = 17: CometItselfX(3) = -6000: CometItselfY(3) = 45000: CometItselfZ(3) = 6270: CometItselfColor(3) = _RGB(255, 255, 255) ' White - Lake Ontario West


                '                CometItselfRadius(7) = 15: CometItselfX(7) = -5100: CometItselfY(7) = 45000: CometItselfZ(7) = 6400: CometItselfColor(7) = _RGB(255, 0, 0) ' Red  - Lake Ontario East
                '                CometItselfRadius(7) = 15: CometItselfX(7) = -7300: CometItselfY(7) = 45000: CometItselfZ(7) = 6400: CometItselfColor(7) = _RGB(255, 0, 0) ' Red  - Lake Ontario East
                '                CometItselfSpeedX(7) = .2 ' km/sec
                '                CometItselfRadius(7) = 15: CometItselfX(7) = 5000: CometItselfY(7) = 45000: CometItselfZ(7) = 6400: CometItselfColor(7) = _RGB(255, 0, 0) ' Red  - Lake Ontario East
                '                CometItselfSpeedX(7) = -2.6 ' km/sec

                '                CometItselfRadius(5) = 15: CometItselfX(5) = -6150: CometItselfY(5) = 45000: CometItselfZ(5) = 6050: CometItselfColor(5) = _RGB(255, 255, 0) ' Yellow
                '                CometItselfRadius(6) = 15: CometItselfX(6) = -6185: CometItselfY(6) = 45000: CometItselfZ(6) = 5900: CometItselfColor(6) = _RGB(255, 0, 255) ' Purple

                '                CometItselfRadius(8) = 10: CometItselfX(8) = 5000: CometItselfY(8) = 45000: CometItselfZ(8) = -7000: CometItselfColor(8) = _RGB(0, 0, 255) ' Blue

                '                CometItselfSpeedX(9) = -0.305 ' km/sec   Larger X (more positive) hits sooner
                '                CometItselfSpeedZ(9) = 3.145 ' km/sec
                '                CometItselfRadius(9) = 17: CometItselfX(9) = -5000: CometItselfY(9) = 45000: CometItselfZ(9) = -8000: CometItselfColor(9) = _RGB(255, 255, 0) ' Yellow

                '                CometItselfRadius(9) = 20: CometItselfX(9) = 45000: CometItselfY(9) = 0: CometItselfZ(9) = 9205: CometItselfColor(9) = _RGB(255, 255, 0) ' Yellow

                '                CometItselfRadius(3) = 20: CometItselfX(3) = 45000: CometItselfY(3) = 8000: CometItselfZ(3) = 4900: CometItselfColor(3) = _RGB(255, 255, 255) ' White
                '                CometItselfRadius(4) = 20: CometItselfX(4) = 45000: CometItselfY(4) = 9300: CometItselfZ(4) = 0: CometItselfColor(4) = _RGB(255, 255, 0) ' Yellow
                '                CometItselfRadius(5) = 20: CometItselfX(5) = 45000: CometItselfY(5) = 9300: CometItselfZ(5) = 0: CometItselfColor(5) = _RGB(255, 0, 0) ' Red
                '                CometItselfRadius(7) = 20: CometItselfX(7) = 45000: CometItselfY(7) = 300: CometItselfZ(7) = 9205: CometItselfColor(7) = _RGB(0, 255, 255) ' Cyan
                '                CometItselfRadius(10) = 20: CometItselfX(10) = 45000: CometItselfY(10) = 0: CometItselfZ(10) = 9205: CometItselfColor(10) = _RGB(255, 255, 0) ' Yellow
                '                CometItselfRadius(10) = 20: CometItselfX(1) = 0: CometItselfY(1) = 45000: CometItselfZ(1) = 9210: CometItselfColor(1) = _RGB(255, 0, 0) ' RED ' From Above but not quite a Swift Tuttle end due to Earth's motion not being included
                MaxZ1 = Z1


            Case "Carolina Bays" ' Lake Michigan Impact
                CometItselfSpeedX(Z1) = -25.2 ' km/sec
                CometItselfSpeedY(Z1) = 0 ' km/sec
                CometItselfSpeedZ(Z1) = -34.05 ' km/sec

                CometItselfRadius(0) = 25: CometItselfX(0) = 2844: CometItselfY(0) = 0: CometItselfZ(0) = 14622: CometItselfColor(0) = _RGB(0, 255, 0) ' GREEN
                CometItselfRadius(1) = 15: CometItselfX(1) = 3165: CometItselfY(1) = -40: CometItselfZ(1) = 15009: CometItselfColor(1) = _RGB(255, 0, 0) ' RED
                CometItselfRadius(2) = 7: CometItselfX(2) = 3165: CometItselfY(2) = 30: CometItselfZ(2) = 15050: CometItselfColor(2) = _RGB(0, 255, 0) ' BLUE
                CometItselfRadius(3) = 6: CometItselfX(3) = 3165: CometItselfY(3) = -40: CometItselfZ(3) = 15045: CometItselfColor(3) = _RGB(255, 255, 255) ' White
                CometItselfRadius(4) = 14: CometItselfX(4) = 3246: CometItselfY(4) = 0: CometItselfZ(4) = 15050: CometItselfColor(4) = _RGB(255, 255, 0) ' Yellow
                If Z1 = 5 Then Z1 = 10

            Case "MARS"
                CometItselfSpeedX(Z1) = -2.3 ' km/sec  ' Works
                CometItselfSpeedY(Z1) = 8.2 ' km/sec
                CometItselfSpeedZ(Z1) = -26.4 ' km/sec

                CometItselfRadius(2) = 30.5: CometItselfX(2) = -2149: CometItselfY(2) = -4095: CometItselfZ(2) = 14300: CometItselfColor(2) = _RGB(0, 0, 255) ' blue
                CometItselfRadius(3) = 27.5: CometItselfX(3) = -2149: CometItselfY(3) = -4095: CometItselfZ(3) = 14300: CometItselfColor(3) = _RGB(255, 255, 255) ' White
                CometItselfRadius(1) = 30.5: CometItselfX(1) = -2145: CometItselfY(1) = -4095: CometItselfZ(1) = 14300: CometItselfColor(1) = _RGB(255, 0, 0) ' RED


                CometItselfSpeedX(Z1) = -2.3 ' km/sec
                CometItselfSpeedY(Z1) = 8.2 ' km/sec
                CometItselfSpeedZ(Z1) = -26.4 ' km/sec

                CometItselfRadius(0) = 27.5: CometItselfX(0) = -2149: CometItselfY(0) = -4095: CometItselfZ(0) = 14300: CometItselfColor(0) = _RGB(255, 0, 0) ' RED
                CometItselfRadius(1) = 27.5: CometItselfX(1) = -2149: CometItselfY(1) = -4095: CometItselfZ(1) = 14300: CometItselfColor(1) = _RGB(255, 0, 0) ' RED
                CometItselfRadius(2) = 27.5: CometItselfX(2) = -2149: CometItselfY(2) = -4095: CometItselfZ(2) = 14300: CometItselfColor(2) = _RGB(255, 0, 0) ' RED
                CometItselfRadius(3) = 27.5: CometItselfX(3) = -21490: CometItselfY(3) = -4095: CometItselfZ(3) = 14300: CometItselfColor(3) = _RGB(255, 0, 0) ' RED
                CometItselfRadius(4) = 27.5: CometItselfX(4) = -21490: CometItselfY(4) = -4095: CometItselfZ(4) = 14300: CometItselfColor(4) = _RGB(255, 0, 0) ' RED
                If Z1 = 5 Then Z1 = 10

        End Select

        CometRadius = CometItselfRadius(Z1): DrawPathstartX = CometItselfX(Z1): DrawPathstartY = CometItselfY(Z1): DrawPathstartZ = CometItselfZ(Z1)
        CometInitialSpeedX = CometItselfSpeedX(Z1) ' km/sec
        CometInitialSpeedY = CometItselfSpeedY(Z1) ' km/sec
        CometInitialSpeedZ = CometItselfSpeedZ(Z1) ' km/sec

        TotalPointsCalculated = TotalPointsCalculated + 1

        pointstoDraw = 1
        startX = DrawPathstartX
        startY = DrawPathstartY
        startZ = DrawPathstartZ
        CometPathSpeedX = CometInitialSpeedX
        CometPathSpeedY = CometInitialSpeedY
        CometPathSpeedZ = CometInitialSpeedZ
        PreviousImpactThickness = 0
        ItHasImpactedOnBottom = 0

        While pointstoDraw < PointsTotal
            Distance = Sqr(startX ^ 2 + startY ^ 2 + startZ ^ 2)

            If Scene$ = "Egypt" Then
                If Distance > PlanetRadius + CometRadius And Distance < PlanetRadius + 235 Then '  Hitting Atmosphere *******************************************
                    Call AssignAirScatterPoints(Z1, Distance, startX, startY, startZ)
                End If
            End If
            If Distance < PlanetRadius + CometRadius Then '  BOTTOM of comet is hitting  ************************
                If PreviousImpactThickness = 0 Then ' Initialize Comet particles so that some of comet continues on after impact - need present comet location and speeds to do that.
                    Select Case Z1 ' Too many points if we use all 300 potential points
                        Case 0: ii1 = 1: ii2 = 75: NextCometColor = _RGB(0, 255, 0)
                        Case 1: ii1 = 76: ii2 = 95: NextCometColor = _RGB(255, 0, 0)
                        Case 2: ii1 = 96: ii2 = 110: NextCometColor = _RGB(0, 0, 255)
                        Case 3: ii1 = 111: ii2 = 125: NextCometColor = _RGB(255, 255, 255)
                        Case 4: ii1 = 126: ii2 = 150: NextCometColor = _RGB(255, 255, 0)
                    End Select
                    For ii = ii1 To ii2
                        For jj = 1 To 300
                            CometX(ii, jj) = 0
                            CometY(ii, jj) = 0
                            CometZ(ii, jj) = 0
                            CometSpeedX(ii, jj) = 0
                            CometSpeedY(ii, jj) = 0
                            CometSpeedZ(ii, jj) = 0
                            CometMass(ii, jj) = 2
                            CometColor(ii, jj) = _RGB(100, 0, 255)
                        Next jj
                    Next ii
                End If

                DotXY = (PreviousX * (startX - PreviousX) + PreviousY * (startY - PreviousY) + PreviousZ * (startZ - PreviousZ))
                XYMagnitude = ((startX - PreviousX) ^ 2 + (startY - PreviousY) ^ 2 + (startZ - PreviousZ) ^ 2) ^ 0.5 * (startX ^ 2 + startY ^ 2 + startZ ^ 2) ^ 0.5

                Checkangle = 1
                If Abs(XYMagnitude) > .0000001 Then Checkangle = DotXY / XYMagnitude
                If Abs(Checkangle) > 1 Then Checkangle = 1
                AngleofImpact = ARCCOS(Checkangle) * 180 / pi '   or 90 degrees minus that
                CombinedAngle = AngleofImpact - 90

                ItHasImpactedOnBottom = 1
                ImpactThickness = PlanetRadius + CometRadius - Distance

                If ImpactThickness > PreviousImpactThickness Then '  if less then its leaving the planet surface not still impacting
                    If ImpactThickness <= CometRadius * 2 Then
                        If ImpactThickness <= CometRadius Then
                            CircleRad = Sqr(CometRadius ^ 2 - (CometRadius - ImpactThickness) ^ 2)
                        Else
                            CircleRad = Sqr(CometRadius ^ 2 - (ImpactThickness - CometRadius) ^ 2)
                        End If
                    End If
                    Circle (startX, startY), CircleRad * 2 * 2, _RGB(0, 155, 155) '  a crater should be about 10X the comet diameter but only add 2X
                    If CombinedAngle < 15 Then Circle (startX, startY), CircleRad * 2 * 2, _RGB(155, 155, 255)
                    If CombinedAngle < 10 Then Circle (startX, startY), CircleRad * 2 * 2, _RGB(255, 255, 155)
                    If CombinedAngle < 5 Then Circle (startX, startY), CircleRad * 2 * 2, _RGB(255, 155, 155)
                    If CombinedAngle < 2 Then Circle (startX, startY), CircleRad * 2 * 2, _RGB(255, 0, 0)
                    If CombinedAngle > 40 And CombinedAngle < 50 Then Circle (startX, startY), CircleRad * 2 * 2, _RGB(0, 205, 155)
                    If CombinedAngle >= 80 Then Circle (startX, startY), CircleRad * 2 * 2, _RGB(0, 255, 255)
                    PreviousImpactThickness = ImpactThickness

                    LakeMichCount = LakeMichCount + 1: If LakeMichCount > 100 Then LakeMichCount = 100
                    LakeMichLocX(LakeMichCount, Z1) = startX: LakeMichLocY(LakeMichCount, Z1) = startY: LakeMichLocZ(LakeMichCount, Z1) = startZ: LakeMichLocRad(LakeMichCount, Z1) = CircleRad

                    If Scene$ <> "Encke and Swift-Tuttle Origins" And Scene$ <> "Earth and Encke Nov" And Scene$ <> "Earth and Encke July" And Scene$ <> "Earth and ST" And Scene$ <> "Venus and Encke" And Scene$ <> "Mercury and Encke" Then Call AssignExplosionPoints(Z1, ImpactThickness, startX, startY, startZ, CometPathSpeedX, CometPathSpeedY, CometPathSpeedZ)

                End If
            End If
            '               IF Distance < PlanetRadius + CometRadius AND Distance > PlanetRadius + CometRadius * .8 THEN '********************************* HIT PLANET by TOP of comet *************************************************************************************
            '                    CIRCLE (startX, startY), 20, _RGB(255, 0, 0)
            '                END IF
            If Distance < PlanetRadius - CometRadius Then '********************************* HIT PLANET by TOP of comet *************************************************************************************
                CometSpeedAtImpact = Sqr(CometPathSpeedX ^ 2 + CometPathSpeedY ^ 2 + CometPathSpeedZ ^ 2)
                '                    CALL ImpactProbabilitiesPrintResults(PreviousX, startX, PreviousY, startY, PreviousZ, startZ, TotalPointsCalculated, CometSpeedAtImpact)
                '  Angle = arccos(A.X/|a| |x|) =  Cos-1[(x*a+y*b+z*c)/(Sqrt(x^2+y^2+z^2) * Sqrt(a^2+b^2+c^2))]    Scalar Law - https://en.wikipedia.org/wiki/Dot_product
                '  a=startx, b=starty, c=startz
                '  x=PreviousX, y=PreviousY, z=PreviousZ
                '  Angle between incoming comet and earth is then:
                '  Vector of earth radius =(0,0,0)-(a,b,c); Vector of incoming comet = (0,0,0)-(x-a,y-b,z-c) with x,y,z = PreviousX,Y,Z; a,b,c=startX,Starty,startz
                '  DotXY = (PreviousX*(startX-PreviousX)  + PreviousY*(startY-PreviousY)  + PreviousZ*(startZ-PreviousZ))
                '  XYMagnitude = ((startX-PreviousX)^2 + (startY-PreviousY)^2 + (startZ-PreviousZ)^2)^0.5 * (startx^2 + starty^2 + startz ^2)^0.5
                '  Angle of Impact then = Arccos (DotXY/XYMagnitude) * 180 / pi    or 90 degrees minus that
                '  ***************    NOTE: ARCOS (x) needs X <=1  **************************        IF x < 1 THEN ARCCOS = (2 * ATN(1)) - ATN(x / SQR(1 - x * x)) ELSE BEEP

                DotXY = (PreviousX * (startX - PreviousX) + PreviousY * (startY - PreviousY) + PreviousZ * (startZ - PreviousZ))
                XYMagnitude = ((startX - PreviousX) ^ 2 + (startY - PreviousY) ^ 2 + (startZ - PreviousZ) ^ 2) ^ 0.5 * (startX ^ 2 + startY ^ 2 + startZ ^ 2) ^ 0.5

                Checkangle = 1
                If Abs(XYMagnitude) > .0000001 Then Checkangle = DotXY / XYMagnitude
                If Abs(Checkangle) > 1 Then Checkangle = 1
                AngleofImpact = ARCCOS(Checkangle) * 180 / pi '   or 90 degrees minus that
                CombinedAngle = AngleofImpact - 90


                Color _RGB(0, 0, 0), _RGB(215, 215, 215)
                _PrintString (800, 3), " Impact Speed:  " + Left$(Str$(CometSpeedAtImpact), 6) + "  km/s"
                _PrintString (1100, 3), " Impact Angle:  " + Left$(Str$(CombinedAngle), 6) + "   "
                Color _RGB(255, 255, 255), _RGB(0, 0, 0)
                '                _DISPLAY

                I9 = Int(CombinedAngle / 5 - .0001) + 1 ' 1 for 0-5, 2 for 5.0001 to 10 etc
                If I9 < 0 Then I9 = 0
                If I9 > 20 Then I9 = 20
                ImpactAngleProbs(I9) = ImpactAngleProbs(I9) + 1
                ImpactAngleProbPercents(I9) = 100 * ImpactAngleProbs(I9) / TotalPointsCalculated
                NumPointsHitting = NumPointsHitting + 1
                pointstoDraw = PointsTotal


                If Z1 <= NumPointsToCalculate / 2 Then
                    Circle (startX, startY), CometRadius * 1.5, _RGB(200, 200, 200) '  DRAW COMET at its actual diameter (Radius X 2) at point of comet's top impacting less a bit for distance
                Else
                    Circle (startX, startY), CometRadius * 2, _RGB(255, 255, 150) '  DRAW COMET at its actual diameter (Radius X 2) at point of comet's top impacting
                End If
            End If

            EAcc = (GEarth / (Distance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
            CometPathSpeedX = CometPathSpeedX + (EAcc / Distance) * (0 - startX) * 1
            CometPathSpeedY = CometPathSpeedY + (EAcc / Distance) * (0 - startY) * 1
            CometPathSpeedZ = CometPathSpeedZ + (EAcc / Distance) * (0 - startZ) * 1
            PreviousX = startX
            PreviousY = startY
            PreviousZ = startZ
            startX = startX + CometPathSpeedX
            startY = startY + CometPathSpeedY
            startZ = startZ + CometPathSpeedZ
            pointstoDraw = pointstoDraw + 1

            If startX < -250000 Then pointstoDraw = PointsTotal
            If startX > 250000 Then pointstoDraw = PointsTotal
            If startY < -250000 Then pointstoDraw = PointsTotal
            If startY > 250000 Then pointstoDraw = PointsTotal
            If startZ < -250000 Then pointstoDraw = PointsTotal
            If startZ > 250000 Then pointstoDraw = PointsTotal
        Wend


        If Distance >= PlanetRadius + CometRadius Then ' missed planet
            If ItHasImpactedOnBottom = 1 Then ' hit at bottom but not at top
                ImpactAngleProbs(1) = ImpactAngleProbs(1) + 1
                ImpactAngleProbPercents(1) = 100 * ImpactAngleProbs(1) / TotalPointsCalculated
                NumPointsHitting = NumPointsHitting + 1
            Else ' Missed totally
                ImpactAngleProbs(0) = ImpactAngleProbs(0) + 1
                ImpactAngleProbPercents(0) = 100 * ImpactAngleProbs(0) / TotalPointsCalculated
            End If
        End If


        GoTo SkipthisHeader ' The function keys and header here are for debugging not for main running program


        ' this is useful for bug checking but not for running the program

        If Z1 <= NumPointsToCalculate / 2 Then
            Circle (DrawPathstartX - CometRadius * Z1, DrawPathstartY), CometRadius * 2, _RGB(0, 255, 0)
            Circle (DrawPathstartX - CometRadius * Z1, CometStartY), CometRadius * 12, _RGB(255, 255, 255)
        Else
            Circle (DrawPathstartX - CometRadius * Z1, DrawPathstartY), CometRadius * 5, _RGB(255, 0, 0)
        End If

        Color _RGB(0, 0, 0), _RGB(215, 215, 215)
        _PrintString (520, 3), " Total # calculated: " + Left$(Str$(TotalPointsCalculated), 6) + "     "

        HeaderDepth = ZoomWindow2 + (ZoomWindow4 - ZoomWindow2) * .15
        HeaderDepth2 = ZoomWindow2 + (ZoomWindow4 - ZoomWindow2) * .021
        Line (ZoomWindow1, HeaderDepth2)-(ZoomWindow3, HeaderDepth), _RGB(50, 50, 100), BF
        Line (ZoomWindow1, HeaderDepth)-(ZoomWindow3, HeaderDepth + (ZoomWindow4 - ZoomWindow2) * .0002), _RGB(0, 0, 200), BF

        TotalPercent = 0
        Color _RGB(200, 200, 200), _RGB(50, 50, 100)
        _PrintString (190, 865), "           Skip       Elliptical            Slightly Elliptical                Near Circular                      Circular                                                               "
        _PrintString (190, 889), " Missed    0-5      5-10    10-15    15-20    20-25    25-30    30-35    35-40    40-45    45-50    50-55    55-60    60-65    65-70    70-75    75-80    80-85    85-90       Totals"
        _PrintString (90, 910), "# Impacts"
        _PrintString (85, 930), "  % Missed"
        _PrintString (90, 950), "% Impacted"

        Line (ZoomWindow1, HeaderDepth - (ZoomWindow4 - ZoomWindow2) * .0352)-(ZoomWindow3, HeaderDepth - (ZoomWindow4 - ZoomWindow2) * .035), _RGB(100, 100, 0), BF

        Color _RGB(255, 255, 155), _RGB(50, 50, 100)
        For i8 = 0 To 18
            If i8 = 0 Then
                _PrintString (198, 910), Left$(Str$(ImpactAngleProbs(i8)), 7) + "      "
                _PrintString (199, 930), Left$(Str$(ImpactAngleProbPercents(i8)), 6) + "       "
            End If
            If i8 > 0 Then _PrintString (200 + i8 * 72, 910), Left$(Str$(ImpactAngleProbs(i8)), 5) + "           "
            '                _PRINTSTRING (200 + i8 * 72, 920), LEFT$(STR$(ImpactAngleProbPercents(i8)), 6) + "     "
            ImpactAngleProbPercents(i8 + 20) = 100 * ImpactAngleProbs(i8) / NumPointsHitting
            If i8 > 0 Then _PrintString (200 + i8 * 72, 950), Left$(Str$(ImpactAngleProbPercents(i8 + 20)), 4) + "            "
            '                TotalPercent = TotalPercent + ImpactAngleProbPercents(i8)
        Next i8
        Color _RGB(200, 200, 200), _RGB(50, 50, 100)
        _PrintString (1600, 910), Left$(Str$(TotalPointsCalculated), 7) + "   # calculated"
        _PrintString (1600, 950), Left$(Str$(NumPointsHitting), 7) + "   # Impacting"
        Color _RGB(255, 255, 255), _RGB(0, 0, 0)
        '        _DISPLAY




        ' ************************ HEADER *************************************
        HeaderDepth = ZoomWindow4 - (ZoomWindow4 - ZoomWindow2) * .02
        HeaderDepth2 = (ZoomWindow4 - ZoomWindow2) * .0008
        Line (ZoomWindow1, ZoomWindow4)-(ZoomWindow3, HeaderDepth), _RGB(215, 215, 215), BF
        Line (ZoomWindow1, HeaderDepth)-(ZoomWindow3, HeaderDepth - HeaderDepth2), _RGB(100, 100, 100), BF
        Line (ZoomWindow1, HeaderDepth - HeaderDepth2)-(ZoomWindow3, HeaderDepth - HeaderDepth2 * 1.5), _RGB(220, 220, 220), BF
        Color _RGB(0, 0, 0), _RGB(215, 215, 215)

        InitialSpeed = Sqr(CometInitialSpeedX ^ 2 + CometInitialSpeedY ^ 2 + CometInitialSpeedZ ^ 2)
        _PrintString (10, 3), " Comet Diameter: " + Left$(Str$(CometRadius * 2), 6) + " km "
        _PrintString (260, 3), "Initial Speed: " + Left$(Str$(InitialSpeed), 6) + "  km/s"
        _PrintString (800, 3), " Impact Speed:  " + Left$(Str$(CometSpeedAtImpact), 6) + "  km/s"
        _PrintString (1350, 3), " approx # Comets in Calculation  " + Str$(Int(1 + NumPointsToCalculate / ZStep) * Int(1 + NumPointsToCalculate / YStep)) + "   "

        'Locate function key reminders in bottom menu bar
        HeaderDepth = ZoomWindow2 + (ZoomWindow4 - ZoomWindow2) * .02
        HeaderDepth2 = (ZoomWindow4 - ZoomWindow2) * .0008
        Color _RGB(55, 55, 55), _RGB(215, 215, 185)
        Line (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, HeaderDepth), _RGB(215, 215, 185), BF
        _PrintString (10, 982), "Space Bar: Pause   Stop Program: 'Esc'     F1-F5: New Scenes     F6:Comet Radius       F7:Turn comet paths on/off       0-9 keys:Comet speed         Cursor Keys: Zoom, View "



        Circle (startX, startY), CircleRad * 2 * 2, _RGB(0, 155, 155) '  a crater should be about 10X the comet diameter but only add 2X
        If ToggleDrawCometCenterPath < 3 Then
            If CombinedAngle < 15 Then Circle (startX, startY), CircleRad * 2 * 2, _RGB(155, 155, 255)
            If CombinedAngle < 10 Then Circle (startX, startY), CircleRad * 2 * 2, _RGB(255, 255, 155)
            If CombinedAngle < 5 Then Circle (startX, startY), CircleRad * 2 * 2, _RGB(255, 155, 155)
            If CombinedAngle < 2 Then Circle (startX, startY), CircleRad * 2 * 2, _RGB(255, 0, 0)
            If CombinedAngle > 40 And CombinedAngle < 50 Then Circle (startX, startY), CircleRad * 2 * 2, _RGB(0, 205, 155)
            If CombinedAngle >= 80 Then Circle (startX, startY), CircleRad * 2 * 2, _RGB(0, 255, 255)
        End If



        Color _RGB(255, 255, 255), _RGB(0, 0, 0)
        If ToggleDrawCometCenterPath < 3 Then
            If Scene$ = "Mercury and Encke" Then _PrintString (20, 80), "Mercury and Encke Origins": Color _RGB(255, 0, 0)
            If Scene$ = "Venus and Encke" Then _PrintString (20, 80), "Venus and Encke Origins": Color _RGB(255, 0, 0)
            If Scene$ = "Earth and Encke Nov" Then _PrintString (20, 80), "Earth and Encke Origins - November Interaction": Color _RGB(255, 0, 0)
            If Scene$ = "Earth and Encke July" Then _PrintString (20, 80), "Earth and Encke Origins - July Interaction": Color _RGB(255, 0, 0)
            If Scene$ = "Encke and ST" Then _PrintString (20, 80), " Earth and Swift-Tuttle Origins": Color _RGB(255, 0, 0)
            If Scene$ = "Carolina Bays" Then _PrintString (20, 80), " Carolina Bays": Color _RGB(255, 0, 0)
            If Scene$ = "Saginaw 1" Then _PrintString (20, 80), " Saginaw Single Impact": Color _RGB(255, 0, 0)
            If Scene$ = "Saginaw 2" Then _PrintString (20, 80), " Saginaw Double Impact": Color _RGB(255, 0, 0)
            If Scene$ = "Egypt" Then _PrintString (20, 80), " Egypt Impact": Color _RGB(255, 0, 0)
            _PrintString (20, 100), " Impact Angles ": Color _RGB(255, 0, 0)
            _PrintString (20, 120), "    0 - 2  ": Color _RGB(255, 155, 155)
            _PrintString (20, 140), "    2 - 5  ": Color _RGB(255, 255, 155)
            _PrintString (20, 160), "    5 - 10 ": Color _RGB(155, 155, 255)
            _PrintString (20, 180), "   10 - 15 ": Color _RGB(0, 155, 155)
            _PrintString (20, 200), "   15 - 20 "
            _PrintString (20, 220), "   20 - 30 "
            _PrintString (20, 240), "   30 - 40 ": Color _RGB(0, 205, 155)
            _PrintString (20, 260), "   40 - 50 ": Color _RGB(0, 155, 155)
            _PrintString (20, 280), "   50 - 60 "
            _PrintString (20, 300), "   60 - 70 "
            _PrintString (20, 320), "   70 - 80 ": Color _RGB(0, 255, 255)
            _PrintString (20, 340), "   80 - 90 "
        End If
        Color _RGB(255, 255, 255), _RGB(0, 0, 0)
        '        _DISPLAY

        ' ************************ END HEADER *************************************

        SkipthisHeader:

        '        If RunImpactProbabilities$ = "" Then RunImpactProbabilities$ = InKey$
        '        If RunImpactProbabilities$ <> "" And RunImpactProbabilities$ <> Chr$(16) Then
        '            Call CheckifChangeScene(RunImpactProbabilities$, RunProgram$) ' check if someone wants to switch to another scene before the 5 seconds calculations are over
        '            If RunProgram$ = "StartOver" Or RunProgram$ = "StartOverMenu" Then Exit Sub
        '            RunImpactProbabilities$ = ""
        '        End If

    Next Z1



    If Scene$ = "Egypt" Then ' assign Thera explosion points ********** Thera is at X=1950, Y=-4740, Z=3780
        EarthRotation = -1.74 ' 101 Degrees = 2.205 radians rotate about Z axis
        CX = 1950 * Cos(EarthRotation) - (-4740) * Sin(EarthRotation)
        CY = -4740 * Cos(EarthRotation) + 1950 * Sin(EarthRotation)
        CZ = 3780
        EarthRotation = -0.4084 ' 23.4 Degrees - Rotate about X axis
        aaa = CY
        CY = CY * Cos(EarthRotation) - CZ * Sin(EarthRotation)
        CZ = CZ * Cos(EarthRotation) + aaa * Sin(EarthRotation)
        For ii = 176 To 225
            For jj = 1 To 300
                CometX(ii, jj) = CX - 15
                CometY(ii, jj) = CY
                CometZ(ii, jj) = CZ + 6
                Call RandomNumbersFewNearZero
                CometSpeedX(ii, jj) = -7 * Rnd(99) * Rnd(77) + 3
                CometSpeedY(ii, jj) = 7 * (Rnd(88) - .5) * (Rnd(66) + .2) * RB
                CometSpeedZ(ii, jj) = 7 * (Rnd(77) - .5) * RC
                CometMass(ii, jj) = 1.2
                CometSize(ii, jj) = 100 * Rnd(22) + 20
                CometColor(ii, jj) = _RGB(255, 111, 0)
            Next jj
        Next ii
    End If




    GoTo skipmushroom

    ' Draw Mushroom Cloud around comet impact point  *************************
    CometRadius20 = 20
    For ii = 261 To 300
        For jj = 1 To 300
            CometX(ii, jj) = -500 * Rnd(83) - 4170
            CometY(ii, jj) = 500 * (Rnd(87) - .5)
            CometZ(ii, jj) = 500 * Rnd(92) + 4170
            CometX(ii, jj) = -4460
            CometY(ii, jj) = 0
            CometZ(ii, jj) = 4460
            While Sqr(CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2) < PlanetRadius + CometRadius * .5: CometX(ii, jj) = CometX(ii, jj) * 1.001: CometY(ii, jj) = CometY(ii, jj) * 1.001: CometZ(ii, jj) = CometZ(ii, jj) * 1.001: Wend
            CX1 = CometRadius20 * (Rnd(99) - .5)
            CY1 = CometRadius20 * (Rnd(98) - .5)
            CZ1 = CometRadius20 * (Rnd(97) - .5)
            While Sqr(CX1 ^ 2 + CY1 ^ 2 + CZ1 ^ 2) < CometRadius20: CX1 = CX1 * 1.01: CY1 = CY1 * 1.01: CZ1 = CZ1 * 1.01: Wend
            While Sqr(CX1 ^ 2 + CY1 ^ 2 + CZ1 ^ 2) > CometRadius20: CX1 = CX1 * .99: CY1 = CY1 * .99: CZ1 = CZ1 * .99: Wend
            '            WEND
            CometX(ii, jj) = CometX(ii, jj) + CX1
            CometY(ii, jj) = CometY(ii, jj) + CY1
            CometZ(ii, jj) = CometZ(ii, jj) + CZ1

            Call RandomNumbersFewNearZero
            ' Set speed only in line from comet impact point. Should send particles out in a sphere
            Temp = 2 * RB
            CometSpeedX(ii, jj) = (CometX(ii, jj) + 4450) * .12 + 2 ' - 1.5 * (RND(99) + .2)
            CometSpeedY(ii, jj) = (CometY(ii, jj)) * .12 + 4 '+ 2.5 * (RND(99) - .5)
            CometSpeedZ(ii, jj) = (CometZ(ii, jj) - 4450) * .12 - 2 ' + 1.5 * (RND(99) + .2)


            If EarthRotation$ = "Yes" Then CometSpeedY(ii, jj) = CometSpeedY(ii, jj) - .5 ' - .5 is earth rotation
            CometMass(ii, jj) = 1.2
            If Sqr(CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2) < PlanetRadius - CometRadius * .5 Then CometMass(ii, jj) = 0
            ' Removes bottom of sphere of ejecta, otherwise one gets a perfect sphere
            Speed = Sqr(CometSpeedX(ii, jj) ^ 2 + CometSpeedY(ii, jj) ^ 2 + CometSpeedZ(ii, jj) ^ 2)
            '            IF Speed < 8 THEN CometMass(ii, jj) = 0
            '            IF Speed > 10.5 THEN CometMass(ii, jj) = 0
            CometSize(ii, jj) = 100
            CometColor(ii, jj) = _RGB(255 * Speed / 10, 255 - (255 * Speed / 10), 0)
            CometColor(ii, jj) = _RGB(255, 255, 255)
        Next jj
    Next ii

    skipmushroom:


    Cls

    '     ############################################   BEGIN DISPLAY OF CAROLINA BAY SCENES    ###################################################    ##################################    #############################
    '     ############################################   BEGIN DISPLAY OF CAROLINA BAY SCENES    ###################################################    ##################################    #############################

    '    CALL DisplayCarolinaBayImpacts(A$)
    '    IF RunProgram$ = "StartOver" OR RunProgram$ = "StartOverMenu" THEN EXIT SUB
    '    RunImpactProbabilities$ = A$
    '   GOTO CheckFunctionKeysHere
    '
    'END SUB

    'SUB DisplayCarolinaBayImpacts (A$)

    ' Display 3D  Version
    '    EarthRotation$ = "No" We want this to be chosen while running the program. Since it needs the particles to have .5 added to their Y speed, it needs the whole routine to be re-run  is F2, Ctrl S
    CarolinaView$ = "Front"
    If Scene$ = "Encke and Swift-Tuttle Origins" Or Scene$ = "Earth and Encke Nov" Or Scene$ = "Earth and Encke July" Or Scene$ = "Earth and ST" Or Scene$ = "Venus and Encke" Or Scene$ = "Mercury and Encke" Then CarolinaView$ = "Top"

    DrawCraters$ = "Both"
    AtmosphereDrag$ = "Yes"
    HighlightSpeed$ = "Yes"
    RemoveHighSpeed$ = "No"
    CometFiresOn$ = "Yes"
    ShowPaths$ = "No"

    CometFiresOn$ = "No"
    HighlightSpeed$ = "No"
    '    EarthRotation$ = "No" '  ***************** Generally do not have this line here AND it also needs to be in the main calculation section NOT here


    If CarolinaNumbers <> 0 Then
        DrawCraters$ = "Both"
        AtmosphereDrag$ = "Yes"
        HighlightSpeed$ = "No"
        CometFiresOn$ = "No"
        ShowPaths$ = "Yes"
        EarthRotation$ = "No"
        Select Case CarolinaNumbers
            Case 1: StartRemove = 0: EndRemove = 2 ' Show 0-2 km/s
            Case 2: StartRemove = 2: EndRemove = 3: ' Show 2-3 km/s
            Case 3: StartRemove = 3: EndRemove = 4 ' Show 3-4
            Case 4: StartRemove = 4: EndRemove = 5 ' Show 4-5
            Case 5: StartRemove = 5: EndRemove = 6 ' Show 5-6
            Case 6: StartRemove = 6: EndRemove = 7 ' Show 6-7
            Case 7: StartRemove = 7: EndRemove = 8 ' Show 7-8
            Case 8: StartRemove = 8: EndRemove = 10 ' Show 8-10
            Case 9: StartRemove = 0: EndRemove = 10 ' Show 0-10
        End Select
        For ii = 1 To 300
            For jj = 1 To 300
                Speed = Sqr(CometSpeedX(ii, jj) ^ 2 + CometSpeedY(ii, jj) ^ 2 + CometSpeedZ(ii, jj) ^ 2)
                If Speed < StartRemove Or Speed > EndRemove Then CometMass(ii, jj) = 0
            Next jj
        Next ii
    End If

    If LakeMichCount > 100 Then LakeMichCount = 100
    Call WorldCoordinates

    ' Rotate about Z axis:
    '   X = X * cosTheta - Y * sinTheta
    '   Y = Y * cosTheta + X * sinTheta
    ' Rotate about Y axis:
    '   X = X * cosTheta + Z * sinTheta;
    '   Z = Z * cosTheta - X * sinTheta;
    '    aaa = CometSpeedX(ii, jj)
    '    CometSpeedX(ii, jj) = .7 * CometSpeedX(ii, jj) - .7 * CometSpeedZ(ii, jj)
    '    CometSpeedZ(ii, jj) = .7 * CometSpeedZ(ii, jj) + .7 * aaa
    ' Rotate about X axis:
    '   Y = Y * cosTheta - Z * sinTheta;  Cos 42 = .743, Sin 42 = .669
    '   Z = Z * cosTheta + Y * sinTheta;
    '    aaa = CometSpeedY(ii, jj)
    '    CometSpeedY(ii, jj) = .743 * CometSpeedY(ii, jj) - .669 * CometSpeedZ(ii, jj)
    '    CometSpeedZ(ii, jj) = .743 * CometSpeedZ(ii, jj) + .669 * aaa
    ' Rotate back about Y axis: (rotate from Equator to Michigan ~ 45 degrees)
    '   X = X * cosTheta + Z * sinTheta;  Cos 45 = .7, Sin 45 = .7; cos 60 = .5, sin 60 = .866
    '   Z = Z * cosTheta - X * sinTheta;  Cos -45 = .7, Sin -45 = -.7; cos -60 = .5, sin -60 = -.866
    '    aaa = CometSpeedX(ii, jj)
    '    CometSpeedX(ii, jj) = .7 * CometSpeedX(ii, jj) + .7 * CometSpeedZ(ii, jj)
    '    CometSpeedZ(ii, jj) = .7 * CometSpeedZ(ii, jj) - .7 * aaa


    If Scene$ = "Earth and Encke Nov" Or Scene$ = "Earth and Encke July" Or Scene$ = "Earth and ST" Or Scene$ = "Encke and Swift-Tuttle Origins" Then ' rotate to center on Lake Michigan, 90 degrees east = 1.571 radians, then 23.4 degrees = 0.4084 radians
        EarthRotation$ = "No"
        ' If Erath is not rotated at start, then view is looking at 0 meridan, or centered on London UK
        ' If Erath is rotated 80 degrees at start, then view is looking at Lake Ontario, centered on Toronto, Canada at noon, Toronto time, 5 pm UK time, on June 22 which is close to July 1 when Encke passes
        '        EarthRotation = 1.571 ' 90 Degrees = 1.571 radians rotate about Z axis Brings Lake Michigan to center = view from the sun, June 21
        '        For ii = 1 To 1100
        '            aaa = WorldX(ii)
        '            WorldX(ii) = WorldX(ii) * Cos(EarthRotation) - WorldY(ii) * Sin(EarthRotation)
        '            WorldY(ii) = WorldY(ii) * Cos(EarthRotation) + aaa * Sin(EarthRotation)
        '        Next ii

        '        EarthRotation = 1.3964 ' 80 Degrees = 1.3964 radians rotate about Z axis Brings Toronto to center = view from the sun, June 21 at 5 pm UK time or noon Toronto time
        '        EarthRotation = 2.32 ''' puts mid Lake Ontario into comet impact zone that leads to proper encke orbit.
        If Scene$ = "Earth and Encke July" Then EarthRotation = 0 ' 1.571 = 90 degrees
        If Scene$ = "Earth and Encke Nov" Then EarthRotation = 2.315 ''' not 90
        If Scene$ = "Earth and ST" Then EarthRotation = -.47 ' -26.9 degrees

        For ii = 1 To 1100
            aaa = WorldX(ii)
            WorldX(ii) = WorldX(ii) * Cos(EarthRotation) - WorldY(ii) * Sin(EarthRotation)
            WorldY(ii) = WorldY(ii) * Cos(EarthRotation) + aaa * Sin(EarthRotation)
        Next ii

        '        EarthRotation = -1.0473 ' 60 Degrees = 1.0473 radians rotate about Z axis =
        '        For ii = 1 To 1100
        '            aaa = WorldX(ii)
        '            WorldX(ii) = WorldX(ii) * Cos(EarthRotation) - WorldY(ii) * Sin(EarthRotation)
        '            WorldY(ii) = WorldY(ii) * Cos(EarthRotation) + aaa * Sin(EarthRotation)
        '        Next ii
        '        EarthRotation = -.01 ' rotate about Z axis
        '        For ii = 1 To 1100
        '            aaa = WorldX(ii)
        '            WorldX(ii) = WorldX(ii) * Cos(EarthRotation) - WorldY(ii) * Sin(EarthRotation)
        '        WorldY(ii) = WorldY(ii) * Cos(EarthRotation) + aaa * Sin(EarthRotation)
        '        Next ii
        EarthRotation = 0.4084 ' 23.4 Degrees - Rotate about X axis = .4084 radians  -  Rotate forward = June 21 view from the sun
        For ii = 1 To 1100
            aaa = WorldY(ii)
            WorldY(ii) = WorldY(ii) * Cos(EarthRotation) - WorldZ(ii) * Sin(EarthRotation)
            WorldZ(ii) = WorldZ(ii) * Cos(EarthRotation) + aaa * Sin(EarthRotation)
        Next ii
    End If
    If Scene$ = "Egypt" Then ' rotate to center on Egypt, 116 degrees east = 2.025 radians, then 23.4 degrees = 0.4084 radians
        EarthRotation$ = "No"
        EarthRotation = -1.74 ' 101 Degrees = 1.675 radians rotate about Z axis
        For ii = 1 To 1100
            aaa = WorldX(ii)
            WorldX(ii) = WorldX(ii) * Cos(EarthRotation) - WorldY(ii) * Sin(EarthRotation)
            WorldY(ii) = WorldY(ii) * Cos(EarthRotation) + aaa * Sin(EarthRotation)
        Next ii
        EarthRotation = -0.4084 ' 23.4 Degrees - Rotate about X axis = .4084 radians
        For ii = 1 To 1100
            aaa = WorldY(ii)
            WorldY(ii) = WorldY(ii) * Cos(EarthRotation) - WorldZ(ii) * Sin(EarthRotation)
            WorldZ(ii) = WorldZ(ii) * Cos(EarthRotation) + aaa * Sin(EarthRotation)
        Next ii
    End If



    ' EarthRotation = EarthRotation * pi / 180 ' radians of rotation per second
    ' EARTH ROTATES 360/24HOURS/60 MINUTES/60 SECONDS PER SECOND =360/(24*60*60)
    ' Cal rotation in radians = degrees * pi/180
    ' So calculate (360/180)*pi/(86400)
    EarthRotation = 2 * 3.141592654 / (86400) ' radians of rotation per second

    FreshStart:

    BeginSplash$ = "Yes"
    If Scene$ <> "Encke and Swift-Tuttle Origins" And Scene$ <> "Earth and Encke Nov" And Scene$ <> "Earth and Encke July" And Scene$ <> "Earth and ST" And Scene$ <> "Venus and Encke" And Scene$ <> "Mercury and Encke" Then BeginSplash$ = "No"
    TimeCount = 0

    StartDisplayCarolinaBays:
    Cls

    StartDisplayCarolinaBayswithoutCLS:

    KeyPressedInRoutine$ = ""

    A$ = "": While A$ = "": A$ = InKey$
        Window (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, ZoomWindow4)
        TimeCount = TimeCount + 1
        '        IF INT(TimeCount / 10) * 10 = TimeCount THEN a2a$ = "": WHILE a2a$ = "": a2a$ = INKEY$: WEND

        If ShowPaths$ <> "Yes" Then Cls

        If Scene$ = "MARS" Then
            For i = 6 To 3396 Step 10
                EarthColorization = 255 - 100 * i / 6371
                EarthColorization2 = 165 - 160 * i / 6371
                Circle (0, 0), i, _RGB(EarthColorization / 1.5, EarthColorization2 / 1.5, EarthColorization2 / 1.5)
            Next i
        End If

        If Scene$ = "Mercury and Encke" Then
            EarthRotation$ = "No"
            For i = 6 To 2440 Step 10
                EarthColorization = 255 - 100 * i / 6371
                EarthColorization2 = 165 - 160 * i / 6371
                Circle (0, 0), i, _RGB(EarthColorization / 1.5, EarthColorization2 / 1.5, EarthColorization2 / 1.5)
            Next i
        End If

        If Scene$ = "Venus and Encke" Then
            EarthRotation$ = "No"
            For i = 6 To 6052 Step 10
                EarthColorization = 255 - 100 * i / 6371
                Circle (0, 0), i, _RGB(EarthColorization / 1.5, EarthColorization / 1.5, EarthColorization / 1.5)
            Next i
        End If
        If Scene$ <> "MARS" And Scene$ <> "Venus and Encke" And Scene$ <> "Mercury and Encke" Then
            For i = 7 To 6371 Step 10
                EarthColorization = 255 - 100 * i / 6371
                EarthColorization2 = 165 - 160 * i / 6371
                Circle (0, 0), i, _RGB(EarthColorization2 / 1.5, EarthColorization2 / 1.5, EarthColorization / 1.5)
            Next i
        End If

        '        LINE (0, -8000)-(0, 8000), _RGB(255, 255, 0) Earth Cross Lines - useful for programming
        '        LINE (-8000, 0)-(8000, 0), _RGB(255, 255, 0)

        If AtmosphereDrag$ = "Yes" And Scene$ <> "MARS" And Scene$ <> "Venus and Encke" And Scene$ <> "Mercury and Encke" Then
            For i = 6371 To 6871 Step 10 ' Atmosphere
                EarthColorization = 120 - (100 - (6771 - i) / 5)
                Circle (0, 0), i, _RGB(EarthColorization, EarthColorization, EarthColorization * 2)
            Next i
        End If
        If AtmosphereDrag$ = "Yes" And Scene$ = "MARS" Then
            For i = 3396 To 3896 Step 10 ' Atmosphere
                EarthColorization = 160 - (100 - (3396 - i) / 5)
                Circle (0, 0), i, _RGB(EarthColorization * 2, EarthColorization * 1.5, EarthColorization)
            Next i
        End If

        If Scene$ <> "Venus and Encke" And Scene$ <> "Mercury and Encke" Then
            For ii = 1 To 1100 '  Draw continents on Earth
                skip = 0
                Select Case CarolinaView$
                    Case "Top"
                        If WorldZ(ii) > 0 Then
                            If (WorldX(ii) = 0 And WorldY(ii) = 0) Then skip = 1
                            If (WorldX(ii + 1) = 0 And WorldY(ii + 1) = 0) Then skip = 1
                            If skip = 0 Then Line (WorldX(ii), WorldY(ii))-(WorldX(ii + 1), WorldY(ii + 1)), _RGB(255, 255, 255)
                        End If
                    Case "Bottom"
                        If WorldZ(ii) < 0 Then
                            If (WorldX(ii) = 0 And WorldY(ii) = 0) Then skip = 1
                            If (WorldX(ii + 1) = 0 And WorldY(ii + 1) = 0) Then skip = 1
                            If skip = 0 Then Line (-1 * WorldX(ii), WorldY(ii))-(-1 * WorldX(ii + 1), WorldY(ii + 1)), _RGB(255, 255, 255)
                        End If
                    Case "Back"
                        If WorldX(ii) > 0 Then
                            If (WorldX(ii) = 0 And WorldY(ii) = 0) Then skip = 1
                            If (WorldX(ii + 1) = 0 And WorldY(ii + 1) = 0) Then skip = 1
                            If skip = 0 Then Line (WorldY(ii), WorldZ(ii))-(WorldY(ii + 1), WorldZ(ii + 1)), _RGB(255, 255, 255)
                        End If
                    Case "Front"
                        If WorldX(ii) < 0 Then
                            If (WorldX(ii) = 0 And WorldY(ii) = 0) Then skip = 1
                            If (WorldX(ii + 1) = 0 And WorldY(ii + 1) = 0) Then skip = 1
                            If skip = 0 Then Line (-1 * WorldY(ii), WorldZ(ii))-(-1 * WorldY(ii + 1), WorldZ(ii + 1)), _RGB(255, 255, 255)
                        End If
                    Case "LeftSide"
                        If WorldY(ii) <= 0 Then
                            If (WorldX(ii) = 0 And WorldY(ii) = 0) Then skip = 1
                            If (WorldX(ii + 1) = 0 And WorldY(ii + 1) = 0) Then skip = 1
                            If skip = 0 Then Line (WorldX(ii), WorldZ(ii))-(WorldX(ii + 1), WorldZ(ii + 1)), _RGB(255, 255, 255)
                        End If
                    Case "RightSide"
                        If WorldY(ii) >= 0 Then
                            If (WorldX(ii) = 0 And WorldY(ii) = 0) Then skip = 1
                            If (WorldX(ii + 1) = 0 And WorldY(ii + 1) = 0) Then skip = 1
                            If skip = 0 Then Line (-1 * WorldX(ii), WorldZ(ii))-(-1 * WorldX(ii + 1), WorldZ(ii + 1)), _RGB(255, 255, 255)
                        End If
                End Select
                If EarthRotation$ = "Yes" And BeginSplash$ = "Yes" Then
                    aaa = WorldX(ii)
                    WorldX(ii) = WorldX(ii) * Cos(EarthRotation) - WorldY(ii) * Sin(EarthRotation)
                    WorldY(ii) = WorldY(ii) * Cos(EarthRotation) + aaa * Sin(EarthRotation)
                End If
            Next ii
        End If


        R1 = Rnd(30) * 70: R2 = Rnd(31) * 40: R3 = Rnd(32) * 25: R4 = (Rnd(34) - .5) * 40: R5 = (Rnd(35) - .5) * 50


        For ii = 0 To MaxZ1 ' Calculate the locations of the comets themselves
            Distance = Sqr(CometItselfX(ii) ^ 2 + CometItselfY(ii) ^ 2 + CometItselfZ(ii) ^ 2)
            EAcc = (GEarth / (Distance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
            CometItselfSpeedX(ii) = CometItselfSpeedX(ii) + (EAcc / Distance) * (0 - CometItselfX(ii)) * 1
            CometItselfSpeedY(ii) = CometItselfSpeedY(ii) + (EAcc / Distance) * (0 - CometItselfY(ii)) * 1
            CometItselfSpeedZ(ii) = CometItselfSpeedZ(ii) + (EAcc / Distance) * (0 - CometItselfZ(ii)) * 1
            CometItselfX(ii) = CometItselfX(ii) + CometItselfSpeedX(ii)
            CometItselfY(ii) = CometItselfY(ii) + CometItselfSpeedY(ii)
            CometItselfZ(ii) = CometItselfZ(ii) + CometItselfSpeedZ(ii)
            If Distance < PlanetRadius + CometItselfRadius(ii) And BeginSplash$ <> "Yes" Then TimeCount = 1: BeginSplash$ = "Yes" ' reset timer to 1 after impact
        Next ii

        '        If Scene$ = "Encke and Swift-Tuttle Origins" Then BeginSplash$ = "No"




        If Scene$ = "Encke and Swift-Tuttle Origins" Or Scene$ = "Earth and Encke Nov" Or Scene$ = "Earth and Encke July" Or Scene$ = "Earth and ST" Or Scene$ = "Venus and Encke" Or Scene$ = "Mercury and Encke" Then
            SunMass = 1.9891 * 10 ^ 30 ' mass of Sun in kg
            GravityConstant = 6.67408 * 10 ^ -11 ' km^3/kg s^2     NOTE G is in km here but in meters in the rest of the program
            GSunHere = GravityConstant * SunMass
            GEarth = GravityConstant * 5.972 * 10 ^ 24 ' mass of Earth in kg
            CSunY = 0: CSunZ = 0
            Select Case Scene$
                Case "Mercury and Encke": CSunX = 57910000: GEarth = GravityConstant * 3.3011 * 10 ^ 23 ' mass of Mercury in kg
                Case "Venus and Encke"
                    CSunX = 108210000: GEarth = GravityConstant * 4.8675 * 10 ^ 24 ' mass of Venus in kg   ***** Setup for sun at 0,0, Venus to left 108,000,000 km
                    ' CSunX = 81978370: CSunY = -70215000: GEarth = GravityConstant * 4.8675 * 10 ^ 24 ' mass of Venus in kg
                Case "Encke and Swift-Tuttle Origins": CSunX = 149760000
                Case "Earth and ST": CSunX = 122670000: CSunY = -85898800 ' - Aug 14 crossing at 45 degrees"
                Case "Earth and Encke Nov": CSunX = 105896300: CSunY = 105896300 ' - Nov 7 crossing at 45 degrees"
                Case "Earth and Encke July": CSunX = 26005500: CSunY = -147485000 '  Encke crossing Earth path July 1, at 80 degrees from June 21
            End Select
        End If

        If (Scene$ = "Encke and Swift-Tuttle Origins" Or Scene$ = "Earth and Encke Nov" Or Scene$ = "Earth and Encke July" Or Scene$ = "Earth and ST" Or Scene$ = "Venus and Encke" Or Scene$ = "Mercury and Encke") And Abs(ZoomWindow1) < 1500000 Then
            For ii = 0 To MaxZ1
                CstartX = CometItselfX(ii): CstartY = CometItselfY(ii): CstartZ = CometItselfZ(ii)
                CSpeedX = CometItselfSpeedX(ii)
                CSpeedY = CometItselfSpeedY(ii)
                CSpeedZ = CometItselfSpeedZ(ii)
                CColor = CometItselfColor(ii)
                '                If ii = 0 And CarolinaView$ = "Top" And PrevcstartX <> CometItselfX(0) Then Line (CstartX + (CstartX - PrevcstartX) * 200, CstartY + (CstartY - PrevCStartY) * 200)-(CstartX - (CstartX - PrevcstartX) * 200, CstartY - (CstartY - PrevCStartY) * 200), _RGB(255, 255, 0)
                PrevcstartX = CometItselfX(0)
                PrevCStartY = CometItselfY(0)

                For jj = 1 To 50
                    Distance = Sqr(CstartX ^ 2 + CstartY ^ 2 + CstartZ ^ 2)
                    EAcc = ((GEarth / (Distance ^ 2)) / 1000 ^ 3) * 100
                    CSpeedX = CSpeedX + (EAcc / Distance) * -CstartX
                    CSpeedY = CSpeedY + (EAcc / Distance) * -CstartY
                    CSpeedZ = CSpeedZ + (EAcc / Distance) * -CstartZ
                    CstartX = CstartX + CSpeedX * 100
                    CstartY = CstartY + CSpeedY * 100
                    CstartZ = CstartZ + CSpeedZ * 100
                    '                    Locate 15, 10: Print CarolinaView$
                    Select Case CarolinaView$
                        Case "Top": Circle (CstartX, CstartY), 5, CColor
                            Circle (CstartX, CstartY), 5, CColor
                            '                            If jj = 1 And ii = 2 Then
                            '                                Locate 10, 10: Print "X:  ", CstartX
                            '                                Locate 11, 10: Print "Y:  ", CstartY
                            '                                Locate 12, 10: Print "Z:  ", CstartZ
                            '                                Locate 13, 10: Print "X Speed:  ", CSpeedX
                            '                                Locate 14, 10: Print "Y Speed:  ", CSpeedY
                            '                                Locate 15, 10: Print "Z Speed:  ", CSpeedZ
                            '                                    Beep: Beep: Beep: Beep: Beep: Beep
                            '                            End If
                        Case "Bottom": Circle (-CstartX, CstartY), 5, CColor
                        Case "Back": Circle (CstartY, CstartZ), 5, CColor
                        Case "Front": Circle (-CstartY, CstartZ), 5, CColor
                        Case "LeftSide": Circle (CstartX, CstartZ), 5, CColor
                        Case "RightSide": Circle (-CstartX, CstartZ), 5, CColor
                    End Select
                Next jj
            Next ii



            '            '            Screen _NewImage(1777, 1000, 32)
            '            View (1250, 50)-(1750, 387), _RGB(0, 0, 0), _RGB(100, 100, 50)
            '            Window (-140000, -30000)-(40000, 30000)
            '            Cls ' redraw without changing locations
            '            Circle (-14000, 0), 200, _RGB(255, 0, 0)
            '            Circle (-14000, 0), 2000, _RGB(255, 0, 0)
            '            Circle (-14000, 0), 20000, _RGB(255, 0, 0)
            '       View (0, 0)-(1776, 999), _RGB(0, 0, 0)
            '       Window (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, ZoomWindow4)

            '            _Display

        End If



        If (Scene$ = "Encke and Swift-Tuttle Origins" Or Scene$ = "Earth and Encke Nov" Or Scene$ = "Earth and Encke July" Or Scene$ = "Earth and ST" Or Scene$ = "Venus and Encke" Or Scene$ = "Mercury and Encke") And Abs(ZoomWindow1) > 1500000 Then


            Locate 10, 10: Print CarolinaView$


            Select Case CarolinaView$
                Case "Top"
                    '                    Locate 10, 10: Print "X:  ", CometItselfX(3)
                    '                    Locate 11, 10: Print "Y:  ", CometItselfY(3)
                    '                    Locate 12, 10: Print "Z:  ", CometItselfZ(3)
                    '                    Locate 13, 10: Print "X Speed:  ", CometItselfSpeedX(3)
                    '                    Locate 14, 10: Print "Y Speed:  ", CometItselfSpeedY(3)
                    '                    Locate 15, 10: Print "Z Speed:  ", CometItselfSpeedZ(3)
                    Circle (CSunX, CSunY), 1000000, _RGB(255, 255, 0): Circle (CSunX, CSunY), 2000000, _RGB(255, 255, 0) ' Sun itself
                    Circle (CSunX, CSunY), 57909000, _RGB(255, 0, 0) ' Mercury Orbit average in Km = 57,909,000 Km
                    Circle (CSunX, CSunY), 108208000, _RGB(255, 255, 255) ' Venus Orbit in Km = 108,000,000 Km
                    Circle (CSunX, CSunY), 149760000, _RGB(0, 255, 255) ' Earth Orbit
                    Circle (CSunX, CSunY), 228900000, _RGB(255, 0, 0) ' Mars Orbit average
                    Circle (CSunX, CSunY), 613000000, _RGB(110, 110, 210) ' Encke Farthest distance
                    Circle (CSunX, CSunY), 778479000, _RGB(255, 125, 0) ' Jupiter Orbit average
                    Circle (CSunX, CSunY), 1433530000, _RGB(0, 255, 255) ' Saturn Orbit average
                    Circle (CSunX, CSunY), 2880000000, _RGB(100, 255, 100) ' Uranus Orbit average
                    Circle (CSunX, CSunY), 4500000000, _RGB(150, 255, 50) ' Neptune Orbit average
                Case "Bottom"
                    Circle (-CSunX, CSunY), 1000000, _RGB(255, 255, 0): Circle (-CSunX, -CSunY), 2000000, _RGB(255, 255, 0)
                    Circle (-CSunX, CSunY), 57909000, _RGB(255, 0, 0) ' Mercury Orbit average in Km = 57,909,000 Km
                    Circle (-CSunX, CSunY), 108208000, _RGB(255, 255, 255) ' Venus Orbit in Km = 108,000,000 Km
                    Circle (-CSunX, CSunY), 149760000, _RGB(0, 255, 255) ' Earth Orbit
                    Circle (-CSunX, CSunY), 228900000, _RGB(255, 0, 0) ' Mars Orbit average
                    Circle (-CSunX, CSunY), 613000000, _RGB(110, 110, 210) ' Encke Farthest distance
                    Circle (-CSunX, CSunY), 778479000, _RGB(255, 125, 0) ' Jupiter Orbit average
                    Circle (-CSunX, CSunY), 1433530000, _RGB(0, 255, 255) ' Saturn Orbit average
                    Circle (-CSunX, CSunY), 2880000000, _RGB(100, 255, 100) ' Uranus Orbit average
                    Circle (-CSunX, CSunY), 4500000000, _RGB(150, 255, 50) ' Neptune Orbit average
                Case "Back": Circle (CSunY, CSunZ), 1000000, _RGB(255, 255, 0): Circle (CSunY, CSunZ), 2000000, _RGB(255, 255, 0)
                    Line (-100000000, -5000000)-(108208000, 5000000), _RGB(255, 255, 255) ' Venus Orbit
                    Line (-149760000, 0)-(149760000, 0), _RGB(0, 255, 255) ' Earth Orbit
                Case "Front": Circle (-CSunY, CSunZ), 1000000, _RGB(255, 255, 0): Circle (-CSunY, -CSunZ), 2000000, _RGB(255, 255, 0)
                    Line (-100000000, 5000000)-(108208000, -5000000), _RGB(255, 255, 255) ' Venus Orbit
                    Line (-149760000, 0)-(149760000, 0), _RGB(0, 255, 255) ' Earth Orbit
                Case "LeftSide": Circle (CSunX, CSunZ), 1000000, _RGB(255, 255, 0): Circle (CSunX, CSunZ), 2000000, _RGB(255, 255, 0)
                Case "RightSide": Circle (-CSunX, CSunZ), 1000000, _RGB(255, 255, 0): Circle (-CSunX, CSunZ), 2000000, _RGB(255, 255, 0)
            End Select


            Circle (CometItselfX(4), CometItselfY(4)), 2000000, _RGB(0, 255, 0)
            For ii = 0 To MaxZ1
                CstartX = CometItselfX(ii): CstartY = CometItselfY(ii): CstartZ = CometItselfZ(ii)
                CSpeedX = CometItselfSpeedX(ii)
                Select Case Scene$
                    Case "Earth and Encke July"
                        CSpeedX = CometItselfSpeedX(ii) - 29.3275 ' add in Earth's orbital speed with Earth at July 1 position, or 80 degrees from June 21-23 = Sin(80) of full Earth Orbit speed
                        CSpeedY = CometItselfSpeedY(ii) - 5.17124 ' add in Earth's orbital speed
                    Case "Earth and ST"
                        CSpeedX = CometItselfSpeedX(ii) + 17.0811 ' add in Earth's orbital speed with Earth at August 14 position, or 55 degrees from June 21 = Cos(55) of full Earth Orbit speed
                        CSpeedY = CometItselfSpeedY(ii) - 24.3943 ' add in Earth's orbital speed with Earth at August 14 position, or 55 degrees from June 21 = Sin(55) of full Earth Orbit speed
                    Case "Earth and Encke Nov" ' - Nov 7 crossing"
                        CSpeedX = CometItselfSpeedX(ii) + 21.0576 ' add in Earth's orbital speed with Earth at November 7 position, or 45 degrees from Dec 21-23 = Sin(45) of full Earth Orbit speed
                        CSpeedY = CometItselfSpeedY(ii) - 21.0576 ' add in Earth's orbital speed
                    Case "Mercury and Encke"
                        CSpeedY = CometItselfSpeedY(ii) - 47.36 ' add in Mercury's orbital speed
                    Case "Venus and Encke"
                        CSpeedY = CometItselfSpeedY(ii) - 35.02 ' add in Venus's orbital speed assuming Venus is due left at 108 m km
                        '                        CSpeedX = CometItselfSpeedX(ii) - 26.724 ' add in Venus's orbital speed assuming Venus is at 9 pm on clock position
                        '                        CSpeedY = CometItselfSpeedY(ii) - 22.632 ' add in Venus's orbital speed assuming Venus is at 9 pm on clock position
                    Case Else
                        CSpeedY = CometItselfSpeedY(ii) - 29.78 ' add in Earth's orbital speed
                End Select
                CSpeedZ = CometItselfSpeedZ(ii)
                CColor = CometItselfColor(ii)
                '                Locate 10 + ii, 10: Print "Comet #: ", ii, "Speed Y: ", CSpeedY
                '                Locate 20 + ii, 10: Print "Comet #: ", ii, "X: ", CstartX, "Y: ", CstartY, "Z: ", CstartZ

                ' BACKWARDS orbit calculation
                For jj = 1 To 24000
                    SDistance = Sqr((CstartX - CSunX) ^ 2 + (CstartY - CSunY) ^ 2 + (CstartZ - CSunZ) ^ 2)
                    SAcc = ((GSunHere / (SDistance ^ 2)) / 1000 ^ 3) * 40000
                    CSpeedX = CSpeedX - (SAcc / SDistance) * (CSunX - CstartX)
                    CSpeedY = CSpeedY - (SAcc / SDistance) * (CSunY - CstartY)
                    CSpeedZ = CSpeedZ - (SAcc / SDistance) * (CSunZ - CstartZ)
                    CstartX = CstartX - CSpeedX * 40000
                    CstartY = CstartY - CSpeedY * 40000
                    CstartZ = CstartZ - CSpeedZ * 40000
                    '                    Select Case CarolinaView$
                    '                        Case "Top": Circle (CstartX, CstartY), 200, CColor
                    '                        Case "Bottom": Circle (-CstartX, -CstartY), 200, CColor
                    '                        Case "Back": Circle (CstartY, CstartZ), 200, CColor
                    '                        Case "Front": Circle (-CstartY, -CstartZ), 200, CColor
                    '                        Case "LeftSide": Circle (CstartX, CstartZ), 200, CColor
                    '                        Case "RightSide": Circle (-CstartX, CstartY), 200, CColor
                    '                    End Select
                Next jj



                ' FORWARDS orbit calculation
                For jj = 1 To 48000 ' Start at -150 steps and run forward past original start to last 100 points
                    SDistance = Sqr((CstartX - CSunX) ^ 2 + (CstartY - CSunY) ^ 2 + (CstartZ - CSunZ) ^ 2)
                    SAcc = ((GSunHere / (SDistance ^ 2)) / 1000 ^ 3) * 40000
                    CSpeedX = CSpeedX + (SAcc / SDistance) * (CSunX - CstartX)
                    CSpeedY = CSpeedY + (SAcc / SDistance) * (CSunY - CstartY)
                    CSpeedZ = CSpeedZ + (SAcc / SDistance) * (CSunZ - CstartZ)
                    CstartX = CstartX + CSpeedX * 40000
                    CstartY = CstartY + CSpeedY * 40000
                    CstartZ = CstartZ + CSpeedZ * 40000
                    Select Case CarolinaView$
                        Case "Top": Circle (CstartX, CstartY), 200, CColor
                        Case "Bottom": Circle (-CstartX, -CstartY), 200, CColor
                        Case "Back": Circle (CstartY, CstartZ), 200, CColor
                        Case "Front": Circle (-CstartY, -CstartZ), 200, CColor
                        Case "LeftSide": Circle (CstartX, CstartZ), 200, CColor
                        Case "RightSide": Circle (-CstartX, CstartY), 200, CColor
                    End Select
                    '                    If CstartX > 67000000 And CstartX < 68000000 And ii = 6 Then
                    '                        Circle (CstartX, CstartY), 2000000, _RGB(255, 255, 0)
                    '                        Circle (CstartX, CstartY), 200000, _RGB(255, 0, 0)
                    '                        Locate 10, 10: Print "X: ", CstartX, "   Y: ", CstartY, "    Z: ", CstartZ
                    '                        Locate 12, 10: Print "CspeedX: ", CSpeedX, "CspeedY: ", CSpeedY, "CspeedZ: ", CSpeedZ
                    '                        A$ = "": While A$ = "": A$ = InKey$: Wend
                    '                    End If
                Next jj
            Next ii
        End If



        If BeginSplash$ = "Yes" And Scene$ <> "Encke and Swift-Tuttle Origins" And Scene$ <> "Earth and Encke Nov" And Scene$ <> "Earth and Encke July" And Scene$ <> "Earth and ST" And Scene$ <> "Venus and Encke" And Scene$ <> "Mercury and Encke" Then
            If Scene$ = "Egypt" And CarolinaView$ = "Front" And TimeCount > 40 Then ' Begin smoking from volcano
                ' Thera is at X=1950, Y=-4740, Z=3780
                ' Qattera Center is at 465,3480
                Circle (-466, 3917), 10, _RGB(255, 255, 0)
                Circle (-466, 3917), 20, _RGB(255, 0, 0)
                ka = (TimeCount - Int(TimeCount / 10) * 10) * 2
                kb = TimeCount: If kb > 355 Then kb = 355
                For kk = ka To kb Step 20
                    CirRad = kk
                    If TimeCount < 80 Then Circle (-466, 3917), CirRad, _RGB(255 - kk, 255 - kk, 255 - kk)
                    If TimeCount >= 80 And TimeCount < 170 Then Circle (-466, 3917), CirRad, _RGB(355 - kk, 255 - kk, 255 - kk)
                Next kk
                Select Case TimeCount
                    Case Is < 80: ColorToBe1 = 100: ColorToBe2 = 100: ColorToBe3 = 100
                    Case Is < 120: ColorToBe1 = 255 * (TimeCount / 200): ColorToBe2 = 100: ColorToBe3 = 100: If ColorToBe1 > 255 Then ColorToBe1 = 255
                    Case Else: ColorToBe1 = 255: ColorToBe2 = 200: ColorToBe3 = 0
                End Select
                If TimeCount < 140 Then
                    For k = 1 To 30
                        Line (-466, 3917)-(-466 + 200 * (Rnd(32) - .5) * Rnd(99), 3917 + 200 * (Rnd(33) - .5) * Rnd(98)), _RGB(ColorToBe1, ColorToBe2, ColorToBe3)
                        If TimeCount > 100 Then Line (-466, 3917)-(-466 + 200 * (Rnd(32) - .5) * Rnd(99), 3917 + 200 * (Rnd(33) - .5) * Rnd(98)), _RGB(ColorToBe1, 0, 0)
                    Next k
                End If
            End If

            EndII = 150
            If AddMorePoints$ = "200" Then EndII = 200
            If AddMorePoints$ = "250" Then EndII = 250
            If AddMorePoints$ = "300" Then EndII = 300
            If Scene$ = "Egypt" Then EndII = 175
            If Scene$ = "Egypt" And TimeCount > 140 Then EndII = 225

            '            EndII = 300

            For ii = 1 To EndII
                For jj = 1 To 300 '   ################################################################################################################
                    Distance = Sqr(CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2)
                    Speed = Sqr(CometSpeedX(ii, jj) ^ 2 + CometSpeedY(ii, jj) ^ 2 + CometSpeedZ(ii, jj) ^ 2)

                    If CometMass(ii, jj) = 1.2 Then ' still in flight
                        EAcc = (GEarth / (Distance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
                        CometSpeedX(ii, jj) = CometSpeedX(ii, jj) + (EAcc / Distance) * (0 - CometX(ii, jj)) * 1
                        CometSpeedY(ii, jj) = CometSpeedY(ii, jj) + (EAcc / Distance) * (0 - CometY(ii, jj)) * 1
                        CometSpeedZ(ii, jj) = CometSpeedZ(ii, jj) + (EAcc / Distance) * (0 - CometZ(ii, jj)) * 1
                        ' add in atmospheric drag based on US Standard Atmosphere (from US Standard Atmosphere charts of 1976 - us-standard-atmosphere_st76-1562_noaa.pdf)
                        ' Standard Atmosphereic density vs altitude: 0 km 1.225 kg/m^3; 1 km 1.116; 2 km 1.006; 3 km 0.909; 4 km 0.819; 5 km 0.736; 6 km 0.66; 7 km 0.59; 8 km 0.525; 9 km 0.466; 10 km 0.413;
                        ' 11 km 0.364; 12 km 0.311; 13 km 0.265; 14 km 0.227; 15  km 0.194; 16 km 0.165; 17 km 0.141; 18 km 0.121; 19 km 0.103; 20 km 0.088;
                        ' 21 km 0.075; 22 km 0.064; 23 km 0.054; 24 km 0.046; 25 km 0.039; 26 km 0.034; 27 km 0.029; 28 km 0.024; 29 km 0.021; 30 km 0.018
                        ' 35 km 0.007;  40 km 0.0038; 45 km 0.0019; 50 km 0.00097; 55 km 0.00053; 60 km 0.00029; 65 km 0.00015; 70 km 0.000074; 75 km 0.000035; 80 km 0.000016; 90 km 0.0000034
                        ' 100 km 0.00000056;  150 km 0.000000002; 200 km 0.00000000025;

                        'the equation for drag force: If an object moves through a fluid, it experiences a resisting force, the drag force. The value of this force depends on the size and shape of an object, density of the fluid and relative velocity of the object and the fluid. The equation is
                        '   Fd = 1/2 * D * V^2 * A * Cd
                        '    where   Fd is the drag force in Newtons; D is the gas/liquid density; V is the relative velocity; A is the reference area; Cd is the drag coefficient.
                        '  for a sphere, the Drag Coiefficient is 0.1 for high speeds, .45 for lower speeds, .48 for rough outside surface. Skier is about 1.0 Bullet about 0.3, USE 1 as reasonable number
                        ' 1 Newton - acceleration required to add 1 m/sec to 1 kg. So 1000 Newton are needed to add or remove 1 Km/s to a 1 kg object.
                        ' Assume spheres, cross section is pi r ^ 2, Volume is 4/3 pi r ^ 3, at density of 1, mass is (4/3 pi r^3) m^3, * 1000 kg/(m^3)

                        ' CometSize(ii, jj) ranges from 25 to 500m radius, area = pi * size^2, mass = 1000 * pi *4/3 *size^3 kg


                        If AtmosphereDrag$ = "Yes" Then
                            SpeedDiff = 0: Airdensity = 0
                            If TimeCount > 30 Then ' no drag in first half minute due to cloud dragging atmosphere with it
                                Select Case Distance - PlanetRadius
                                    Case Is < 1: Airdensity = 1.225
                                    Case Is < 2: Airdensity = 1.116
                                    Case Is < 3: Airdensity = 1.006
                                    Case Is < 4: Airdensity = 0.909
                                    Case Is < 5: Airdensity = 0.819
                                    Case Is < 6: Airdensity = 0.736
                                    Case Is < 7: Airdensity = 0.66
                                    Case Is < 8: Airdensity = 0.59
                                    Case Is < 9: Airdensity = 0.525
                                    Case Is < 10: Airdensity = 0.466
                                    Case Is < 11: Airdensity = 0.413
                                    Case Is < 12: Airdensity = 0.364
                                    Case Is < 15: Airdensity = 0.2525 ' Average 12 to 15
                                    Case Is < 18: Airdensity = 0.1575
                                    Case Is < 21: Airdensity = 0.098
                                    Case Is < 24: Airdensity = 0.0605
                                    Case Is < 27: Airdensity = 0.0375
                                    Case Is < 30: Airdensity = 0.0235
                                    Case Is < 50: Airdensity = 0.0038
                                    Case Is < 75: Airdensity = 0.000177 ' average 50 - 75 km
                                    Case Is < 100: Airdensity = 0.000004
                                        '                       0.00000056 =  100 km density from chart
                                    Case Is < 150: Airdensity = 0.00000038
                                        '                       0.000000002 =  150 km density
                                    Case Is < 200: Airdensity = 0.00000000125
                                        '                       0.00000000025 =  200 km density
                                    Case Is < 250: Airdensity = 0.0000000001
                                End Select
                                If Scene$ = "MARS" Then Airdensity = Airdensity / 100 ' no chart of densities but generally its a 100 factor
                                DragArea = 3.141592654 * CometSize(ii, jj) ^ 2 ' Note: Cometsize is in METERS not Km.
                                CometMassForDrag = 4188.79 * CometSize(ii, jj) ^ 3 ' 4/3 pi = 4.18879, then multiply by 1000 to get kg/cu meter.
                                DragNewtons = 0.5 * Airdensity * (Speed * 1000) ^ 2 * DragArea * 1 '  Assume a density of 1 for ice which is most of it and adds more drag to a particle then if it is rock so it errs on the side of being too much instead of too little.
                                SpeedDiff = (DragNewtons / CometMassForDrag) / 1000 ' Newtons works in m/sec and we need km/sec
                                '                                IF ii = 55 AND jj = 58 THEN
                                '                                    LOCATE 20, 20: PRINT Distance - 6371, Speed, DragNewtons, CometMassForDrag, Airdensity, SpeedDiff, CometSize(ii, jj), DragArea, "           "
                                '                                    LOCATE 30, 20: PRINT CometSpeedX(ii, jj), CometSpeedY(ii, jj), CometSpeedZ(ii, jj)
                                '                                    _DISPLAY
                                '                                    Aaa$ = "": WHILE Aaa$ = "": Aaa$ = INKEY$: WEND
                                '                                END IF
                                CometSpeedX(ii, jj) = CometSpeedX(ii, jj) - SpeedDiff * CometSpeedX(ii, jj) / Speed
                                CometSpeedY(ii, jj) = CometSpeedY(ii, jj) - SpeedDiff * CometSpeedY(ii, jj) / Speed
                                CometSpeedZ(ii, jj) = CometSpeedZ(ii, jj) - SpeedDiff * CometSpeedZ(ii, jj) / Speed
                            End If
                        End If
                        PreviousCometX2(ii, jj) = PreviousCometX(ii, jj): PreviousCometX(ii, jj) = CometX(ii, jj)
                        PreviousCometY2(ii, jj) = PreviousCometY(ii, jj): PreviousCometY(ii, jj) = CometY(ii, jj)
                        PreviousCometZ2(ii, jj) = PreviousCometZ(ii, jj): PreviousCometZ(ii, jj) = CometZ(ii, jj)
                        PreviousCometY(ii, jj) = CometY(ii, jj)
                        PreviousCometZ(ii, jj) = CometZ(ii, jj)
                        CometX(ii, jj) = CometX(ii, jj) + CometSpeedX(ii, jj)
                        CometY(ii, jj) = CometY(ii, jj) + CometSpeedY(ii, jj)
                        CometZ(ii, jj) = CometZ(ii, jj) + CometSpeedZ(ii, jj)
                    End If

                    If CometMass(ii, jj) = 1 Then '     Has Hit Earth
                        If EarthRotation$ = "Yes" Then '                                    Rotate Earth 0.004166666666 degrees every second
                            aaa = PreviousCometX2(ii, jj)
                            PreviousCometX2(ii, jj) = PreviousCometX2(ii, jj) * Cos(EarthRotation) - PreviousCometY2(ii, jj) * Sin(EarthRotation)
                            PreviousCometY2(ii, jj) = PreviousCometY2(ii, jj) * Cos(EarthRotation) + aaa * Sin(EarthRotation)
                            aaa = CometX(ii, jj)
                            CometX(ii, jj) = CometX(ii, jj) * Cos(EarthRotation) - CometY(ii, jj) * Sin(EarthRotation)
                            CometY(ii, jj) = CometY(ii, jj) * Cos(EarthRotation) + aaa * Sin(EarthRotation)
                        End If
                    End If
                    '   ################################################################################################################
                    If CometMass(ii, jj) > 0 Then ' Draw Fire for in flight or on ground
                        Distance = Sqr(CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2)
                        If Distance <= PlanetRadius + 190 And TimeCount > 70 And CometFiresOn$ = "Yes" Then
                            Speed = Sqr(CometSpeedX(ii, jj) ^ 2 + CometSpeedY(ii, jj) ^ 2 + CometSpeedZ(ii, jj) ^ 2)
                            If Speed > 6 Then ' air blast
                                FireFactor = (PlanetRadius + 200 - Distance) / 4
                                Select Case CarolinaView$
                                    Case "Top"
                                        If Sqr(CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2) >= PlanetRadius Or CometZ(ii, jj) >= 0 Then
                                            For k = 1 To 30
                                                Line (CometX(ii, jj), CometY(ii, jj))-(CometX(ii, jj) + FireFactor * (Rnd(32) - .5), CometY(ii, jj) + FireFactor * (Rnd(33) - .5)), _RGB(FireFactor * 4 + 50, 50, 0)
                                            Next k
                                        End If
                                    Case "Bottom"
                                        If Sqr(CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2) >= PlanetRadius Or CometZ(ii, jj) <= 0 Then
                                            For k = 1 To 30
                                                Line (-1 * CometX(ii, jj), CometY(ii, jj))-(-1 * CometX(ii, jj) + FireFactor * (Rnd(32) - .5), CometY(ii, jj) + FireFactor * (Rnd(33) - .5)), _RGB(FireFactor * 4 + 50, 50, 0)
                                            Next k
                                        End If
                                    Case "Back"
                                        If Sqr(CometY(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2) >= PlanetRadius Or CometX(ii, jj) >= 0 Then
                                            For k = 1 To 30
                                                Line (CometY(ii, jj), CometZ(ii, jj))-(CometY(ii, jj) + FireFactor * (Rnd(32) - .5), CometZ(ii, jj) + FireFactor * (Rnd(33) - .5)), _RGB(FireFactor * 4 + 50, 50, 0)
                                            Next k
                                        End If
                                    Case "Front"
                                        If Sqr(CometZ(ii, jj) ^ 2 + CometY(ii, jj) ^ 2) >= PlanetRadius Or CometX(ii, jj) <= 0 Then
                                            For k = 1 To 30
                                                Line (-1 * CometY(ii, jj), CometZ(ii, jj))-(-1 * CometY(ii, jj) + FireFactor * (Rnd(32) - .5), CometZ(ii, jj) + FireFactor * (Rnd(33) - .5)), _RGB(FireFactor * 4 + 50, 50, 0)
                                            Next k
                                        End If
                                    Case "LeftSide"
                                        If Sqr(CometX(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2) >= PlanetRadius Or CometY(ii, jj) <= 0 Then
                                            For k = 1 To 30
                                                Line (CometX(ii, jj), CometZ(ii, jj))-(CometX(ii, jj) + FireFactor * (Rnd(32) - .5), CometZ(ii, jj) + FireFactor * (Rnd(33) - .5)), _RGB(FireFactor * 4 + 50, 50, 0)
                                            Next k
                                        End If
                                    Case "RightSide"
                                        If Sqr(CometX(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2) >= PlanetRadius Or CometY(ii, jj) >= 0 Then
                                            For k = 1 To 30
                                                Line (-1 * CometX(ii, jj), CometZ(ii, jj))-(-1 * CometX(ii, jj) + FireFactor * (Rnd(32) - .5), CometZ(ii, jj) + FireFactor * (Rnd(33) - .5)), _RGB(FireFactor * 4 + 50, 50, 0)
                                            Next k
                                        End If
                                End Select
                            End If
                        End If
                        If Scene$ = "Egypt" Then
                            If Distance <= PlanetRadius And TimeCount > 5 Then CometMass(ii, jj) = 1
                        Else
                            If Distance <= PlanetRadius + 2 And TimeCount > 3 Then CometMass(ii, jj) = 1
                        End If
                        '   ################################################################################################################
                        If Distance > 50000 And TimeCount < 3500 Then CometMass(ii, jj) = 0 ' stop showing the particles far from Earth if rapidly getting there
                    End If

                    SkipIfZero:
                Next jj
            Next ii
        End If

        StartII = 0
        For ii = StartII To MaxZ1 ' Display the comet Itself in flight
            Select Case CarolinaView$
                Case "Top": If Sqr(CometItselfX(ii) ^ 2 + CometItselfY(ii) ^ 2) >= PlanetRadius Or CometItselfZ(ii) >= 0 Then Circle (CometItselfX(ii), CometItselfY(ii)), CometItselfRadius(ii) * 2, CometItselfColor(ii)
                Case "Bottom": If Sqr(CometItselfX(ii) ^ 2 + CometItselfY(ii) ^ 2) >= PlanetRadius Or CometItselfZ(ii) <= 0 Then Circle (-1 * CometItselfX(ii), CometItselfY(ii)), CometItselfRadius(ii) * 2, CometItselfColor(ii)
                Case "Back": If Sqr(CometItselfY(ii) ^ 2 + CometItselfZ(ii) ^ 2) >= PlanetRadius Or CometItselfX(ii) >= 0 Then Circle (CometItselfY(ii), CometItselfZ(ii)), CometItselfRadius(ii) * 2, CometItselfColor(ii)
                Case "Front": If Sqr(CometItselfZ(ii) ^ 2 + CometItselfY(ii) ^ 2) >= PlanetRadius Or CometItselfX(ii) <= 0 Then Circle (-1 * CometItselfY(ii), CometItselfZ(ii)), CometItselfRadius(ii) * 2, CometItselfColor(ii)
                Case "LeftSide": If Sqr(CometItselfX(ii) ^ 2 + CometItselfZ(ii) ^ 2) >= PlanetRadius Or CometItselfY(ii) <= 0 Then Circle (CometItselfX(ii), CometItselfZ(ii)), CometItselfRadius(ii) * 2, CometItselfColor(ii)
                Case "RightSide": If Sqr(CometItselfX(ii) ^ 2 + CometItselfZ(ii) ^ 2) >= PlanetRadius Or CometItselfY(ii) >= 0 Then Circle (-1 * CometItselfX(ii), CometItselfZ(ii)), CometItselfRadius(ii) * 2, CometItselfColor(ii)
            End Select
        Next ii


        If BeginSplash$ = "Yes" And Scene$ <> "Encke and Swift-Tuttle Origins" Then
            EndII = 150
            If AddMorePoints$ = "200" Then EndII = 200
            If AddMorePoints$ = "250" Then EndII = 250
            If AddMorePoints$ = "300" Then EndII = 300
            If Scene$ = "Egypt" Then EndII = 175
            If Scene$ = "Egypt" And TimeCount > 40 Then EndII = 225

            '            EndII = 300

            For ii = 1 To EndII
                For jj = 1 To 300 '   ################################################################################################################
                    If CometMass(ii, jj) = 1.2 Then ' Particle still in flight
                        Distance = Sqr(CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2)
                        If Distance > PlanetRadius Then
                            Select Case CarolinaView$
                                Case "Top"
                                    If Sqr(CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2) >= PlanetRadius Or CometZ(ii, jj) >= 0 Then
                                        If MonoColor$ = "No" Then
                                            If HighlightSpeed$ = "Yes" Then
                                                Speed = Sqr(CometSpeedX(ii, jj) ^ 2 + CometSpeedY(ii, jj) ^ 2 + CometSpeedZ(ii, jj) ^ 2)
                                                If Scene$ = "MARS" Then ' Mars escape velocity = 4.25 km/s
                                                    Select Case Speed
                                                        Case Is <= 0.01: PSet (CometX(ii, jj), CometY(ii, jj)), CometColor(ii, jj)
                                                        Case Is <= 2: Circle (CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(100, 255, 100)
                                                        Case Is <= 3: Circle (CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(0, 255, 255)
                                                        Case Is <= 4.25: Circle (CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(0, 255, 0)
                                                        Case Is <= 5: Circle (CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 0, 0)
                                                        Case Is <= 7: Circle (CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 255, 0)
                                                        Case Is <= 10: Circle (CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(100, 100, 255)
                                                        Case Is > 10: Circle (CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 255, 255)
                                                    End Select
                                                Else
                                                    Select Case Speed ' Earth escape velocity = 11.2 km/s
                                                        Case Is <= 0.01: PSet (CometX(ii, jj), CometY(ii, jj)), CometColor(ii, jj)
                                                        Case Is <= 2: Circle (CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(100, 255, 100)
                                                        Case Is <= 3: Circle (CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(0, 255, 255)
                                                        Case Is <= 5: Circle (CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(0, 255, 0)
                                                        Case Is <= 7: Circle (CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 0, 0)
                                                        Case Is <= 9: Circle (CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 255, 0)
                                                        Case Is <= 11.2: Circle (CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(100, 100, 255)
                                                        Case Is > 11.2: Circle (CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 255, 255)
                                                    End Select
                                                End If
                                            Else
                                                PSet (CometX(ii, jj), CometY(ii, jj)), CometColor(ii, jj)
                                            End If
                                        Else
                                            If HighlightSpeed$ = "Yes" Then
                                                Circle (CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, PresentMonoColor
                                            Else
                                                PSet (CometX(ii, jj), CometY(ii, jj)), PresentMonoColor
                                            End If
                                        End If
                                    End If
                                Case "Bottom"
                                    If Sqr(CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2) >= PlanetRadius Or CometZ(ii, jj) <= 0 Then
                                        If MonoColor$ = "No" Then
                                            If HighlightSpeed$ = "Yes" Then
                                                Speed = Sqr(CometSpeedX(ii, jj) ^ 2 + CometSpeedY(ii, jj) ^ 2 + CometSpeedZ(ii, jj) ^ 2)
                                                Select Case Speed
                                                    Case Is <= 0.01: PSet (-1 * CometX(ii, jj), CometY(ii, jj)), CometColor(ii, jj)
                                                    Case Is <= 2: Circle (-1 * CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(100, 255, 100)
                                                    Case Is <= 3: Circle (-1 * CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(0, 255, 255)
                                                    Case Is <= 5: Circle (-1 * CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(0, 255, 0)
                                                    Case Is <= 7: Circle (-1 * CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 0, 0)
                                                    Case Is <= 9: Circle (-1 * CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 255, 0)
                                                    Case Is <= 11.2: Circle (-1 * CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(100, 100, 255)
                                                    Case Is > 11.2: Circle (-1 * CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 255, 255)
                                                End Select
                                            Else
                                                PSet (-1 * CometX(ii, jj), CometY(ii, jj)), CometColor(ii, jj)
                                            End If
                                        Else
                                            If HighlightSpeed$ = "Yes" Then
                                                Circle (-1 * CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, PresentMonoColor
                                            Else
                                                PSet (-1 * CometX(ii, jj), CometY(ii, jj)), PresentMonoColor
                                            End If
                                        End If
                                    End If
                                Case "Back"
                                    If Sqr(CometY(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2) >= PlanetRadius Or CometX(ii, jj) >= 0 Then
                                        If MonoColor$ = "No" Then
                                            If HighlightSpeed$ = "Yes" Then
                                                Speed = Sqr(CometSpeedX(ii, jj) ^ 2 + CometSpeedY(ii, jj) ^ 2 + CometSpeedZ(ii, jj) ^ 2)
                                                Select Case Speed
                                                    Case Is <= 2: Circle (CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(100, 255, 100)
                                                    Case Is <= 3: Circle (CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(0, 255, 255)
                                                    Case Is <= 5: Circle (CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(0, 255, 0)
                                                    Case Is <= 7: Circle (CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 0, 0)
                                                    Case Is <= 9: Circle (CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 255, 0)
                                                    Case Is <= 11.2: Circle (CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(100, 100, 255)
                                                    Case Is > 11.2: Circle (CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 255, 255)
                                                End Select
                                            Else
                                                PSet (CometY(ii, jj), CometZ(ii, jj)), CometColor(ii, jj)
                                            End If
                                        Else
                                            If HighlightSpeed$ = "Yes" Then
                                                Circle (CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, PresentMonoColor
                                            Else
                                                PSet (CometY(ii, jj), CometZ(ii, jj)), PresentMonoColor
                                            End If
                                        End If
                                    End If
                                Case "Front"
                                    If Sqr(CometZ(ii, jj) ^ 2 + CometY(ii, jj) ^ 2) >= PlanetRadius Or CometX(ii, jj) <= 0 Then
                                        If MonoColor$ = "No" Then
                                            If HighlightSpeed$ = "Yes" Then
                                                Speed = Sqr(CometSpeedX(ii, jj) ^ 2 + CometSpeedY(ii, jj) ^ 2 + CometSpeedZ(ii, jj) ^ 2)
                                                Select Case Speed
                                                    Case Is <= 0.01: PSet (-1 * CometY(ii, jj), CometZ(ii, jj)), CometColor(ii, jj)
                                                    Case Is <= 2: Circle (-1 * CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(100, 255, 100)
                                                    Case Is <= 3: Circle (-1 * CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(0, 255, 255)
                                                    Case Is <= 5: Circle (-1 * CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(0, 255, 0)
                                                    Case Is <= 7: Circle (-1 * CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 0, 0)
                                                    Case Is <= 9: Circle (-1 * CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 255, 0)
                                                    Case Is <= 11.2: Circle (-1 * CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(100, 100, 255)
                                                    Case Is > 11.2: Circle (-1 * CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 255, 255)
                                                End Select
                                            Else
                                                PSet (-1 * CometY(ii, jj), CometZ(ii, jj)), CometColor(ii, jj)
                                            End If
                                        Else
                                            If HighlightSpeed$ = "Yes" Then
                                                Circle (-1 * CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, PresentMonoColor
                                            Else
                                                PSet (-1 * CometY(ii, jj), CometZ(ii, jj)), PresentMonoColor
                                            End If
                                        End If
                                    End If
                                Case "LeftSide"
                                    If Sqr(CometX(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2) >= PlanetRadius Or CometY(ii, jj) <= 0 Then
                                        If MonoColor$ = "No" Then
                                            If HighlightSpeed$ = "Yes" Then
                                                Speed = Sqr(CometSpeedX(ii, jj) ^ 2 + CometSpeedY(ii, jj) ^ 2 + CometSpeedZ(ii, jj) ^ 2)
                                                Select Case Speed
                                                    Case Is <= 2: Circle (CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(100, 255, 100)
                                                    Case Is <= 3: Circle (CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(0, 255, 255)
                                                    Case Is <= 5: Circle (CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(0, 255, 0)
                                                    Case Is <= 7: Circle (CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 0, 0)
                                                    Case Is <= 9: Circle (CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 255, 0)
                                                    Case Is <= 11.2: Circle (CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(100, 100, 255)
                                                    Case Is > 11.2: Circle (CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 255, 255)
                                                End Select
                                            Else
                                                PSet (CometX(ii, jj), CometZ(ii, jj)), CometColor(ii, jj)
                                            End If
                                        Else
                                            If HighlightSpeed$ = "Yes" Then
                                                Circle (CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, PresentMonoColor
                                            Else
                                                PSet (CometX(ii, jj), CometZ(ii, jj)), PresentMonoColor
                                            End If
                                        End If
                                    End If

                                Case "RightSide"
                                    If Sqr(CometX(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2) >= PlanetRadius Or CometY(ii, jj) >= 0 Then
                                        If MonoColor$ = "No" Then
                                            If HighlightSpeed$ = "Yes" Then
                                                Speed = Sqr(CometSpeedX(ii, jj) ^ 2 + CometSpeedY(ii, jj) ^ 2 + CometSpeedZ(ii, jj) ^ 2)
                                                Select Case Speed
                                                    Case Is <= 2: Circle (-1 * CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(100, 255, 100)
                                                    Case Is <= 3: Circle (-1 * CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(0, 255, 255)
                                                    Case Is <= 5: Circle (-1 * CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(0, 255, 0)
                                                    Case Is <= 7: Circle (-1 * CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 0, 0)
                                                    Case Is <= 9: Circle (-1 * CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 255, 0)
                                                    Case Is <= 11.2: Circle (-1 * CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(100, 100, 255)
                                                    Case Is > 11.2: Circle (-1 * CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 255, 255)
                                                End Select
                                            Else
                                                PSet (-1 * CometX(ii, jj), CometZ(ii, jj)), CometColor(ii, jj)
                                            End If
                                        Else
                                            If HighlightSpeed$ = "Yes" Then
                                                Circle (-1 * CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, PresentMonoColor
                                            Else
                                                PSet (-1 * CometX(ii, jj), CometZ(ii, jj)), PresentMonoColor
                                            End If
                                        End If
                                    End If
                            End Select
                        End If
                    End If


                    If CometMass(ii, jj) = 1 Then '     Has Hit Earth
                        CS = CometSize(ii, jj) / 250 ' Comet Particles are ranging from 50 to 500 m diameter
                        PointLength = (CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2) ^ 0.5
                        If PointLength < 6371 Then PointLength = 6371
                        PrevPointLength = (PreviousCometX2(ii, jj) ^ 2 + PreviousCometY2(ii, jj) ^ 2 + PreviousCometZ2(ii, jj) ^ 2) ^ 0.5
                        If PrevPointLength < 6371 Then PrevPointLength = 6371
                        RatioPoint = 6371 / PointLength
                        PrevRatioPoint = 6371 / PrevPointLength
                        Select Case CarolinaView$
                            Case "Top":
                                If CometZ(ii, jj) >= 0 Then ' CIRCLE (CometX(ii, jj), CometY(ii, jj)), 10, CometColor(ii, jj): LINE (PreviousCometX2(ii, jj), PreviousCometY2(ii, jj))-(CometX(ii, jj), CometY(ii, jj)), CometColor(ii, jj)
                                    a = CometX(ii, jj) * RatioPoint
                                    b = (PreviousCometX2(ii, jj) * PrevRatioPoint - CometX(ii, jj) * RatioPoint) * CS + CometX(ii, jj)
                                    c = CometY(ii, jj) * RatioPoint
                                    d = (PreviousCometY2(ii, jj) * PrevRatioPoint - CometY(ii, jj)) * CS + CometY(ii, jj)
                                    Call DrawMiniCraters(a, b, c, d, ii, jj)
                                    '                                    LINE (a, c)-(b, d), CometColor(ii, jj)
                                End If

                            Case "Bottom":
                                If CometZ(ii, jj) <= 0 Then '  CIRCLE (-1 * CometX(ii, jj), CometY(ii, jj)), 10, CometColor(ii, jj): LINE (-1 * PreviousCometX2(ii, jj), PreviousCometY2(ii, jj))-(-1 * CometX(ii, jj), CometY(ii, jj)), CometColor(ii, jj)
                                    a = -1 * CometX(ii, jj) * RatioPoint
                                    b = -1 * ((PreviousCometX2(ii, jj) * PrevRatioPoint - CometX(ii, jj) * RatioPoint) * CS + CometX(ii, jj))
                                    c = CometY(ii, jj) * RatioPoint
                                    d = (PreviousCometY2(ii, jj) * PrevRatioPoint - CometY(ii, jj)) * CS + CometY(ii, jj)
                                    Call DrawMiniCraters(a, b, c, d, ii, jj)
                                End If

                            Case "Back"
                                If CometX(ii, jj) >= 0 Then '    CIRCLE (CometY(ii, jj), CometZ(ii, jj)), 10, CometColor(ii, jj)
                                    a = CometY(ii, jj) * RatioPoint
                                    b = (PreviousCometY2(ii, jj) * PrevRatioPoint - CometY(ii, jj) * RatioPoint) * CS + CometY(ii, jj)
                                    c = CometZ(ii, jj) * RatioPoint
                                    d = (PreviousCometZ2(ii, jj) * PrevRatioPoint - CometZ(ii, jj)) * CS + CometZ(ii, jj)
                                    Call DrawMiniCraters(a, b, c, d, ii, jj)
                                End If

                            Case "Front"
                                If CometX(ii, jj) <= 0 Then '   CIRCLE (-1 * CometY(ii, jj), CometZ(ii, jj)), 6, CometColor(ii, jj)
                                    '                                    a = -1 * CometY(ii, jj)
                                    '                                    b = -1 * ((PreviousCometY2(ii, jj) - CometY(ii, jj)) * CS + CometY(ii, jj))
                                    '                                    c = CometZ(ii, jj)
                                    '                                    d = ((PreviousCometZ2(ii, jj) - CometZ(ii, jj)) * CS + CometZ(ii, jj))
                                    a = -1 * CometY(ii, jj) * RatioPoint
                                    b = -1 * ((PreviousCometY2(ii, jj) * PrevRatioPoint - CometY(ii, jj) * RatioPoint) * CS + CometY(ii, jj))
                                    c = CometZ(ii, jj) * RatioPoint
                                    d = (PreviousCometZ2(ii, jj) * PrevRatioPoint - CometZ(ii, jj)) * CS + CometZ(ii, jj)
                                    '                                   LINE (a, c)-(b, d), _RGB(0, 0, 255)
                                    Call DrawMiniCraters(a, b, c, d, ii, jj)
                                End If

                            Case "LeftSide"
                                If CometY(ii, jj) <= 0 Then ' CIRCLE (CometX(ii, jj), CometZ(ii, jj)), 10, CometColor(ii, jj) ' LINE (PreviousCometX2(ii, jj), PreviousCometZ2(ii, jj))-(CometX(ii, jj), CometZ(ii, jj)), CometColor(ii, jj)
                                    a = CometX(ii, jj) * RatioPoint
                                    b = (PreviousCometX2(ii, jj) * PrevRatioPoint - CometX(ii, jj) * RatioPoint) * CS + CometX(ii, jj)
                                    c = CometZ(ii, jj) * RatioPoint
                                    d = (PreviousCometZ2(ii, jj) * PrevRatioPoint - CometZ(ii, jj)) * CS + CometZ(ii, jj)
                                    Call DrawMiniCraters(a, b, c, d, ii, jj)
                                End If

                            Case "RightSide"
                                If CometY(ii, jj) >= 0 Then '  CIRCLE (-1 * CometX(ii, jj), CometZ(ii, jj)), 10, CometColor(ii, jj) ' LINE (-1 * PreviousCometX2(ii, jj), PreviousCometZ2(ii, jj))-(-1 * CometX(ii, jj), CometZ(ii, jj)), CometColor(ii, jj)
                                    a = -1 * CometX(ii, jj) * RatioPoint
                                    b = -1 * ((PreviousCometX2(ii, jj) * PrevRatioPoint - CometX(ii, jj) * RatioPoint) * CS + CometX(ii, jj))
                                    c = CometZ(ii, jj) * RatioPoint
                                    d = (PreviousCometZ2(ii, jj) * PrevRatioPoint - CometZ(ii, jj)) * CS + CometZ(ii, jj)
                                    Call DrawMiniCraters(a, b, c, d, ii, jj)
                                End If
                        End Select
                    End If
                Next jj

                '                AAA$ = InKey$
                '                If Len(AAA$) > 1 Then GoTo CheckIfKeysPressed
                '                If AAA$ <> "" Then KeyPressedInRoutine$ = AAA$
            Next ii
        End If

        If BeginSplash$ = "Yes" Then '  Draw Comet Itself on the Earth
            For ii = 1 To LakeMichCount
                StartJJ = 0: EndJJ = 5: If MaxZ1 > 5 Then EndJJ = MaxZ1
                For jj = StartJJ To EndJJ
                    Select Case jj
                        Case 0: CometColor(0, 0) = _RGB(0, 255, 0) ' green
                        Case 1: CometColor(0, 0) = _RGB(255, 0, 0) ' red
                        Case 2: CometColor(0, 0) = _RGB(0, 0, 255) ' blue
                        Case 3: CometColor(0, 0) = _RGB(255, 255, 255) ' white
                        Case 4: CometColor(0, 0) = _RGB(255, 255, 0) ' yellow
                        Case 5: CometColor(0, 0) = _RGB(0, 0, 0) ' black
                    End Select
                    If Scene$ = "Encke and Swift-Tuttle Origins" Or Scene$ = "Earth and Encke Nov" Or Scene$ = "Earth and Encke July" Or Scene$ = "Earth and ST" Then CometColor(0, 0) = CometItselfColor(jj)
                    If Scene$ = "MARS" Then CometColor(0, 0) = _RGB(255, 0, 0)
                    Select Case CarolinaView$
                        Case "Top":
                            If LakeMichLocZ(ii, jj) > 0 Then
                                For ff = 1 To 20
                                    Circle (LakeMichLocX(ii, jj), LakeMichLocY(ii, jj)), LakeMichLocRad(ii, jj) * ff / 10 + 1, _RGB(0, 0, 0)
                                    Circle (LakeMichLocX(ii, jj), LakeMichLocY(ii, jj)), LakeMichLocRad(ii, jj) * ff / 10, CometColor(0, 0)
                                Next ff
                            End If
                        Case "Bottom"
                            If LakeMichLocZ(ii, jj) < 0 Then
                                For ff = 1 To 20
                                    Circle (-1 * LakeMichLocX(ii, jj), LakeMichLocY(ii, jj)), LakeMichLocRad(ii, jj) * ff / 10 + 1, _RGB(0, 0, 0)
                                    Circle (-1 * LakeMichLocX(ii, jj), LakeMichLocY(ii, jj)), LakeMichLocRad(ii, jj) * ff / 10, CometColor(0, 0)
                                Next ff
                            End If
                        Case "Back": If LakeMichLocX(ii, jj) > 0 Then Circle (LakeMichLocY(ii, jj), LakeMichLocZ(ii, jj)), LakeMichLocRad(ii, jj) * 3, CometColor(0, 0)
                        Case "Front"
                            If LakeMichLocX(ii, jj) < 0 Then
                                For ff = 15 To 20
                                    Circle (-1 * LakeMichLocY(ii, jj), LakeMichLocZ(ii, jj)), LakeMichLocRad(ii, jj) * ff / 10 + 1, _RGB(0, 0, 0)
                                    Circle (-1 * LakeMichLocY(ii, jj), LakeMichLocZ(ii, jj)), LakeMichLocRad(ii, jj) * ff / 10, CometColor(0, 0)
                                Next ff
                            End If
                            If Scene$ = "Egypt" Then
                                If TimeCount > 40 Then ' Edge of Qattera Depression
                                    Circle (115, 3405), 136, _RGB(0, 255, 0), 1.6, 3.4
                                    Circle (115, 3405), 137, _RGB(0, 255, 0), 1.6, 3.4
                                    Circle (115, 3405), 138, _RGB(0, 255, 0), 1.6, 3.4
                                    ' CIRCLE (115, 3405), 142, _RGB(255, 255, 255)
                                End If
                                If TimeCount < 165 Then ' Shock wave from Qaterra
                                    Circle (215, 3405), 10, _RGB(255, 255, 255)
                                    ka = (TimeCount - Int(TimeCount / 10) * 10) * 2
                                    If TimeCount > 70 Then ka = TimeCount - 70
                                    kb = TimeCount
                                    For kk = ka To kb Step 20
                                        CirRad = kk * 20
                                        If CirRad >= 160 Then
                                            Circle (115, 3405), CirRad, _RGB(TimeCount / 2, TimeCount / 2, 275 - TimeCount), 1.2 + (TimeCount / 100), 4.2 - (TimeCount / 200)
                                            Circle (115, 3405), CirRad - 10, _RGB(TimeCount / 2, TimeCount / 2, 275 - TimeCount), 1.2 + (TimeCount / 100), 4.2 - (TimeCount / 200)
                                            Circle (115, 3405), CirRad - 20, _RGB(TimeCount / 2, 255 - TimeCount, 275 - TimeCount), 1.2 + (TimeCount / 100), 4.2 - (TimeCount / 200)
                                            Circle (115, 3405), CirRad - 30, _RGB(TimeCount / 2, TimeCount / 2, 275 - TimeCount), 1.2 + (TimeCount / 100), 4.2 - (TimeCount / 200)
                                        End If
                                    Next kk
                                End If
                                If TimeCount > 145 And TimeCount < 180 Then ' Shock wave from Thera
                                    Circle (-466, 3917), 10, _RGB(255, 255, 255)
                                    ka = (TimeCount - Int(TimeCount / 10) * 10) * 2
                                    kb = TimeCount - 125
                                    For kk = ka To kb Step 20
                                        CirRad = kk * 20
                                        Circle (-466, 3917), CirRad, _RGB(285 - TimeCount / 2, 185 - TimeCount / 4, TimeCount / 4)
                                        Circle (-466, 3917), CirRad - 10, _RGB(285 - TimeCount / 2, 185 - TimeCount / 4, TimeCount / 4)
                                        Circle (-466, 3917), CirRad - 20, _RGB(285 - TimeCount / 2, 185 - TimeCount / 4, TimeCount / 4)
                                    Next kk
                                End If
                                If TimeCount > 175 And TimeCount < 312 Then ' Red Sea Tsumani
                                    '                                    CIRCLE (-466, 3917), 1100, _RGB(255, 255, 255), 5.725, 6.02
                                    kb = TimeCount - 175
                                    CirRad = (TimeCount - 140) * 1.75
                                    Circle (kb, 3950 - kb), CirRad * 10, _RGB(0, 0, 255), 5.66, 6.02 / (1 + .04 * TimeCount / 312)
                                    Circle (kb, 3950 - kb), CirRad * 10 - 5, _RGB(120, 120, 255), 5.66, 6.02 / (1 + .04 * TimeCount / 312)
                                    Circle (kb, 3950 - kb), CirRad * 10 - 10, _RGB(0, 0, 255), 5.66, 6.02 / (1 + .04 * TimeCount / 312)
                                    Circle (kb, 3950 - kb), CirRad * 10 - 15, _RGB(0, 0, 255), 5.66, 6.02 / (1 + .04 * TimeCount / 312)
                                    Circle (kb, 3950 - kb), CirRad * 10 - 20, _RGB(0, 0, 255), 5.66, 6.02 / (1 + .04 * TimeCount / 312)
                                End If
                                If TimeCount > 314 And TimeCount < 463 Then ' Tsumani fall back wave
                                    kb = TimeCount - 312
                                    CirRad = (486 - TimeCount) * 1.75
                                    Circle (kb, 3809 + kb), CirRad * 10, _RGB(0, 0, 255), 5.66, 6.02 / (1 + .04 * (624 - TimeCount) / 312)
                                    Circle (kb, 3809 + kb), CirRad * 10 - 10, _RGB(0, 0, 255), 5.66, 6.02 / (1 + .04 * (624 - TimeCount) / 312)
                                    Circle (kb, 3809 + kb), CirRad * 10 - 20, _RGB(0, 0, 255), 5.66, 6.02 / (1 + .04 * (624 - TimeCount) / 312)
                                End If

                            End If
                        Case "LeftSide"
                            If LakeMichLocY(ii, jj) <= 0 Then
                                For ff = 1 To 20 Step 4
                                    Circle (LakeMichLocX(ii, jj), LakeMichLocZ(ii, jj)), LakeMichLocRad(ii, jj) * ff / 10 + 2, _RGB(0, 0, 0)
                                    Circle (LakeMichLocX(ii, jj), LakeMichLocZ(ii, jj)), LakeMichLocRad(ii, jj) * ff / 10, CometColor(0, 0)
                                Next ff
                            End If
                        Case "RightSide":
                            If LakeMichLocY(ii, jj) >= 0 Then
                                Circle (-1 * LakeMichLocX(ii, jj), LakeMichLocZ(ii, jj)), LakeMichLocRad(ii, jj) * 2, CometColor(0, 0)
                            End If
                    End Select
                    If EarthRotation$ = "Yes" Then
                        aaa = LakeMichLocX(ii, jj)
                        LakeMichLocX(ii, jj) = LakeMichLocX(ii, jj) * Cos(EarthRotation) - LakeMichLocY(ii, jj) * Sin(EarthRotation)
                        LakeMichLocY(ii, jj) = LakeMichLocY(ii, jj) * Cos(EarthRotation) + aaa * Sin(EarthRotation)
                    End If
                Next jj
            Next ii
        End If

        '     HEADER                    ****************************@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*********************************      HEADER

        If Scene$ = "Egypt" And BeginSplash$ = "Yes" And TimeCount < 500 Then
            HeaderDepth = ZoomWindow2 + (ZoomWindow4 - ZoomWindow2) * .04
            Line (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, HeaderDepth), _RGB(215, 215, 185), BF
        End If

        HeaderDepth = ZoomWindow4 - (ZoomWindow4 - ZoomWindow2) * .02
        HeaderDepth2 = (ZoomWindow4 - ZoomWindow2) * .0008
        Line (ZoomWindow1, ZoomWindow4)-(ZoomWindow3, HeaderDepth), _RGB(215, 215, 215), BF
        Line (ZoomWindow1, HeaderDepth)-(ZoomWindow3, HeaderDepth - HeaderDepth2), _RGB(100, 100, 100), BF
        Line (ZoomWindow1, HeaderDepth - HeaderDepth2)-(ZoomWindow3, HeaderDepth - HeaderDepth2 * 1.5), _RGB(220, 220, 220), BF


        Color _RGB(0, 0, 0), _RGB(215, 215, 215)
        Select Case Scene$
            Case "Saginaw 1": _PrintString (10, 3), "Simulation of Saginaw Bay Impact at ~ 20 degrees, forming the Carolina Bays"
            Case "Saginaw 2": _PrintString (10, 3), "Simulation of Saginaw Bay Impact and second impact at ~ 20 degrees, forming the Carolina Bays"
            Case "Encke and Swift-Tuttle Origins": _PrintString (10, 3), "Simulation of one comet leading to Encke and Swift Tuttle"
            Case "Mercury and Encke": _PrintString (10, 3), "Simulation of a comet passing Mercury, but NOT leading to Encke orbit"
            Case "Venus and Encke": _PrintString (10, 3), "Simulation of a comet passing Venus, leading to Encke orbit"
            Case "Earth and ST": _PrintString (10, 3), "Simulation of a comet passing Earth, leading to Swift-Tuttle"
            Case "Earth and Encke July": _PrintString (10, 3), "Simulation of a comet passing Earth, leading to Encke - July Interaction"
            Case "Earth and Encke Nov": _PrintString (10, 3), "Simulation of a comet passing Earth, leading to Encke - November Interaction"
            Case "Carolina Bays": _PrintString (10, 3), "Simulation of Swift Tuttle skip impacting at ~ 10 degrees, forming Lake Michigan and the Carolina Bays"
            Case "Egypt": _PrintString (10, 3), "Simulation of impact 1628 BC, forming Qattera Depression, Egypt, and causing devastation to civilizations"
            Case "MARS": _PrintString (10, 3), "Simulation of 27.5 km radius comet hitting MARS at ~ 5 degrees, forming Orcus Patera crater"
        End Select
        If Scene$ = "Egypt" And BeginSplash$ = "Yes" And TimeCount < 500 Then ' Print messages telling people what is happening
            Color _RGB(0, 0, 0), _RGB(215, 215, 185)
            Select Case TimeCount
                Case Is < 20: _PrintString (10, 962), "This is a reconstruction of a possiible event of approximately 1628 BC that led to the Exodus event."
                Case Is < 45: _PrintString (10, 962), "A large comet hit Earth at a very low angle and high speed, showering the land under it with debris as it passed."
                Case Is < 65: _PrintString (10, 962), "As the comet Passed Over Thebes, the shock waves and debris destroyed the city, killing many people."
                Case Is < 90: _PrintString (10, 962), "The comet hit northern Egypt, forming the Qattara Depression in northern Egypt."
                Case Is < 115: _PrintString (10, 962), "The impact caused a shock wave to travel north and west, causing tsumanis across the Mediterranean Sea and triggering the Volcano Thera."
                Case Is < 150: _PrintString (10, 962), "Thera began the long process of erupting explosively - but it smoked and spewed out lava for two or so weeks first."
                Case Is < 190: _PrintString (10, 962), "Thera's eruption was one of the largest volcano explosions in Earth's history. Civilization around the Mediterranean Sea was again devasted."
                Case Is < 320: _PrintString (10, 962), "Thera's eruption sent a shock wave out, causing a massive tsumani in the Red Sea, moving the water southward for many hours."
                Case Is < 400: _PrintString (10, 962), "The Red Sea tsumani passed and the water returned to its normal levels hours later, but while lowered Egypt's army had wandered onto the sea bed,"
                Case Is < 450: _PrintString (10, 962), "And the returning waters drowned the Egypt army, allowing the Hebrew people camped on the sea's shore to leave Egypt and travel to the desert."
                Case Is < 500: _PrintString (10, 962), "The extensive devastation led to the destruction of many cities, and allowed the Hyksos, fleeing from their own devasted cities, to invade and conquer Egypt."
            End Select
        End If

        Color _RGB(0, 0, 0), _RGB(215, 215, 215)


        If BeginSplash$ = "No" Then
            _PrintString (1060, 3), "Time before Impact: " + Str$(300 - TimeCount) + " Seconds  "
        Else
            _PrintString (1060, 3), "Time since Impact: " + Str$(TimeCount) + "  Seconds  "
            If TimeCount < 30000 Then _PrintString (1420, 3), Str$(Int(TimeCount / 6) / 10) Else _PrintString (1420, 3), Str$(Int(TimeCount / 60)) ' no decimal needed for > 500 minutes
            _PrintString (1490, 3), "Minutes  "
            _PrintString (1580, 3), Str$(Int(TimeCount / 360) / 10)
            _PrintString (1645, 3), " Hours   "
        End If

        Color _RGB(0, 0, 255)
        If AddMorePoints$ <> "No" Then _PrintString (1740, 3), AddMorePoints$
        Color _RGB(0, 0, 0), _RGB(215, 215, 215)

        If CarolinaNumbers <> 0 Then
            Select Case CarolinaNumbers
                Case 1: _PrintString (870, 3), "Display: 0 - 2 km/s "
                Case 2: _PrintString (870, 3), "Display: 2 - 3 km/s "
                Case 3: _PrintString (870, 3), "Display: 3 - 4 km/s "
                Case 4: _PrintString (870, 3), "Display: 4 - 5 km/s "
                Case 5: _PrintString (870, 3), "Display: 5 - 6 km/s "
                Case 6: _PrintString (870, 3), "Display: 6 - 7 km/s "
                Case 7: _PrintString (870, 3), "Display: 7 - 8 km/s "
                Case 8: _PrintString (870, 3), "Display: 8 - 10 km/s "
                Case 9: _PrintString (870, 3), "Display: 0 - 10 km/s "
            End Select
        End If
        Color _RGB(255, 255, 255), _RGB(0, 0, 0)

        'Locate function key reminders in bottom menu bar

        HeaderDepth = ZoomWindow2 + (ZoomWindow4 - ZoomWindow2) * .02
        HeaderDepth2 = (ZoomWindow4 - ZoomWindow2) * .0008
        Color _RGB(55, 55, 55), _RGB(215, 215, 185)
        Line (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, HeaderDepth), _RGB(215, 215, 185), BF
        'HeaderDepth - HeaderDepth2 * 2)-(ZoomWindow3, HeaderDepth - HeaderDepth2 * 3), _RGB(255, 0, 0), BF
        _PrintString (10, 982), "Space Bar: Pause   End Program: 'Esc'   Cursor Keys: Zoom/View   F1-F5: 2D Skip Impacts   F6:                   F7:                           F8:                        F9:                       F10:                  "
        Select Case DrawCraters$
            Case "Both": Color _RGB(0, 0, 255): _PrintString (758, 982), "Craters are ON  "
            Case "Words": Color _RGB(0, 0, 255): _PrintString (758, 982), "Labels  are ON  "
            Case "Craters": Color _RGB(0, 0, 255): _PrintString (758, 982), "Labels  are OFF "
            Case "No": Color _RGB(255, 0, 0): _PrintString (758, 982), "Craters are OFF "
        End Select
        If AtmosphereDrag$ = "Yes" Then
            Color _RGB(0, 0, 255): _PrintString (935, 982), "Atmospheric Drag is ON  "
        Else
            Color _RGB(255, 0, 0): _PrintString (935, 982), "Atmospheric Drag is OFF "
        End If
        If EarthRotation$ = "Yes" Then
            Color _RGB(0, 0, 255): _PrintString (1174, 982), "Earth rotation is ON  "
        Else
            Color _RGB(255, 0, 0): _PrintString (1174, 982), "Earth rotation is OFF "
        End If
        If CometFiresOn$ = "Yes" Then
            Color _RGB(0, 0, 255): _PrintString (1389, 982), "Display Fires is ON "
        Else
            Color _RGB(255, 0, 0): _PrintString (1389, 982), "Display Fires is OFF"
        End If
        If HighlightSpeed$ = "Yes" Then
            Color _RGB(0, 0, 255): _PrintString (1605, 982), "Display:Speeds       "
        Else
            Color _RGB(0, 0, 100): _PrintString (1605, 982), "Display:Comet Source "
        End If

        Color _RGB(255, 255, 255), _RGB(0, 0, 0)

        _Display


        CheckIfKeysPressed:

        If KeyPressedInRoutine$ <> "" Then A$ = KeyPressedInRoutine$
        ' do not do a screen print until a loop has finished but do allow an immeadiate change to another scene
        If A$ <> "" Then If Asc(A$) <> 16 Then Call CheckifChangeScene(A$, RunProgram$) '            CASE 1, 4, 5, 6, 7, 8, 12, 17, 18, 19, 20, 23, 25 ' Ctrl A, D, E, F, Q, R, S, T, W, Y - start over
        If RunProgram$ = "StartOver" Or RunProgram$ = "StartOverMenu" Then RunImpactProbabilities$ = A$: Exit Sub
        If Len(A$) = 1 Then
            Select Case Asc(A$)
                Case 32 ' space bar
                    A$ = "": While A$ = "": A$ = InKey$: Wend
                Case 24 ' Ctrl X
                    Select Case CarolinaView$
                        Case "Top": CarolinaView$ = "Bottom"
                        Case "LeftSide": CarolinaView$ = "Top"
                        Case "Front": CarolinaView$ = "LeftSide"
                        Case "RightSide": CarolinaView$ = "Front"
                        Case "Back": CarolinaView$ = "RightSide"
                        Case "Bottom": CarolinaView$ = "Back"
                    End Select
                    GoTo StartDisplayCarolinaBays
                Case 26 ' Ctrl Z
                    Select Case CarolinaView$
                        Case "Top": CarolinaView$ = "LeftSide"
                        Case "LeftSide": CarolinaView$ = "Front"
                        Case "Front": CarolinaView$ = "RightSide"
                        Case "RightSide": CarolinaView$ = "Back"
                        Case "Back": CarolinaView$ = "Bottom"
                        Case "Bottom": CarolinaView$ = "Top"
                    End Select
                    GoTo StartDisplayCarolinaBays
                Case 96: ' Pressing the "~`" key changes the displayed colors
                    Select Case MonoColor$
                        Case "Yellow": MonoColor$ = "Green": PresentMonoColor = _RGB(0, 255, 0)
                        Case "White": MonoColor$ = "Yellow": PresentMonoColor = _RGB(255, 255, 0)
                        Case "No": MonoColor$ = "White": PresentMonoColor = _RGB(255, 255, 255)
                        Case "Green": MonoColor$ = "No"
                    End Select
            End Select
        End If

    Wend '   End of loop of drawing impact particles


    If A$ <> "" Then
        Call CheckifChangeScene(A$, RunProgram$) '            CASE 1, 4, 5, 6, 7, 8, 12, 17, 18, 19, 20, 23, 25 ' Ctrl A, D, E, F, Q, R, S, T, W, Y - start over
        If RunProgram$ = "StartOver" Or RunProgram$ = "StartOverMenu" Then RunImpactProbabilities$ = A$: Exit Sub
    End If

    RunProgram$ = A$ ' Checking for these key presses outside of loop allows the screen to update before screen saves

    If Len(A$) = 1 Then
        Select Case Asc(A$)
            Case 16 ' Ctrl P = immeadiate screen save to pre-determined folder with predetermined names - Already saved in CheckIfChangeScene sub routine but need to continue without screen save
                GoTo StartDisplayCarolinaBayswithoutCLS
            Case 48: CarolinaNumbers = 0 ' 0 pressed
                If TimeCount > 3000 Then CarolinaNumbers = 0: A$ = "" ' do not let an accidental key press ruin a long calculation
            Case 49: CarolinaNumbers = 1 ' 1 pressed
                If TimeCount > 3000 Then CarolinaNumbers = 0: A$ = "" ' do not let an accidental key press ruin a long calculation
            Case 50: CarolinaNumbers = 2 ' 2 pressed
                If TimeCount > 3000 Then CarolinaNumbers = 0: A$ = "" ' do not let an accidental key press ruin a long calculation
            Case 51: CarolinaNumbers = 3 ' 3 pressed
                If TimeCount > 3000 Then CarolinaNumbers = 0: A$ = "" ' do not let an accidental key press ruin a long calculation
            Case 52: CarolinaNumbers = 4 ' 4 pressed
                If TimeCount > 3000 Then CarolinaNumbers = 0: A$ = "" ' do not let an accidental key press ruin a long calculation
            Case 53: CarolinaNumbers = 5 ' 5 pressed
                If TimeCount > 3000 Then CarolinaNumbers = 0: A$ = "" ' do not let an accidental key press ruin a long calculation
            Case 54: CarolinaNumbers = 6 ' 6 pressed
                If TimeCount > 3000 Then CarolinaNumbers = 0: A$ = "" ' do not let an accidental key press ruin a long calculation
            Case 55: CarolinaNumbers = 7 ' 7 pressed
                If TimeCount > 3000 Then CarolinaNumbers = 0: A$ = "" ' do not let an accidental key press ruin a long calculation
            Case 56: CarolinaNumbers = 8 ' 8 pressed
                If TimeCount > 3000 Then CarolinaNumbers = 0: A$ = "" ' do not let an accidental key press ruin a long calculation
            Case 57: CarolinaNumbers = 9 ' 9 pressed
                If TimeCount > 3000 Then CarolinaNumbers = 0: A$ = "" ' do not let an accidental key press ruin a long calculation
        End Select

        Select Case Asc(A$)
            Case 48 To 57: ZoomWindow1 = -14850: ZoomWindow2 = -8355: ZoomWindow3 = 14850: ZoomWindow4 = 8355: ZoomedtoComet$ = "No": A$ = Chr$(19): Exit Sub ' CHR$(19) = Ctrl S, so start over
        End Select
    End If

    ascii2byte = 0
    If Len(A$) > 1 Then ascii2byte = Asc(A$, 2) ' read second character of 2 byte codes such as function keys and cursor keys

    If ascii2byte <> 0 Then
        ZoomXDiff = ZoomWindow3 - ZoomWindow1
        ZoomYDiff = ZoomWindow4 - ZoomWindow2
        Select Case ascii2byte
            Case 64 ' F6 = Toggle Comet craters on or off
                Select Case DrawCraters$
                    Case "Both": DrawCraters$ = "Words"
                    Case "Words": DrawCraters$ = "Craters"
                    Case "Craters": DrawCraters$ = "No"
                    Case "No": DrawCraters$ = "Both"
                End Select
                GoTo StartDisplayCarolinaBayswithoutCLS
            Case 65: ' F7 toggle Atmosphere
                If AtmosphereDrag$ <> "Yes" Then AtmosphereDrag$ = "Yes" Else AtmosphereDrag$ = "No"
                GoTo StartDisplayCarolinaBayswithoutCLS
            Case 66: ' F8 toggle Rotation
                If EarthRotation$ <> "Yes" Then EarthRotation$ = "Yes" Else EarthRotation$ = "No"
                If Scene$ = "Egypt" Then EarthRotation$ = "No"
                GoTo StartDisplayCarolinaBayswithoutCLS
            Case 67: ' F9 toggle Fire Display on/off
                If CometFiresOn$ <> "Yes" Then CometFiresOn$ = "Yes" Else CometFiresOn$ = "No"
                GoTo StartDisplayCarolinaBayswithoutCLS
            Case 68: ' F10 toggle speed display
                If HighlightSpeed$ <> "Yes" Then HighlightSpeed$ = "Yes" Else HighlightSpeed$ = "No"
                GoTo StartDisplayCarolinaBayswithoutCLS
            Case 133: ' F11 Add more points - requires a restart to recalculate in more points, does not require a restart to stop showing them
                If Scene$ = "Egypt" Then AddMorePoints$ = "No": Beep: GoTo StartDisplayCarolinaBayswithoutCLS
                Select Case AddMorePoints$
                    Case "", "No": AddMorePoints$ = "200"
                    Case "200": AddMorePoints$ = "250"
                    Case "250": AddMorePoints$ = "300"
                    Case "300": AddMorePoints$ = "No": GoTo StartDisplayCarolinaBayswithoutCLS
                    Case Else: AddMorePoints$ = "No": GoTo StartDisplayCarolinaBayswithoutCLS
                End Select
                ZoomWindow1 = -14850: ZoomWindow2 = -8355: ZoomWindow3 = 14850: ZoomWindow4 = 8355 ' Center on Earth = 0,0 co-ordinates
                ZoomedtoComet$ = "No"
                Exit Sub
            Case 134: ' F12 - toggle show displays
                If ShowPaths$ <> "Yes" Then ShowPaths$ = "Yes" Else ShowPaths$ = "No"
                GoTo StartDisplayCarolinaBays
            Case 71 '        cursor home
                ZoomWindow1 = -133250: ZoomWindow2 = -71940: ZoomWindow3 = 133250: ZoomWindow4 = 71940
                GoTo StartDisplayCarolinaBays
            Case 80 '        cursor key down
                ZoomWindow4 = ZoomWindow4 + ZoomYDiff * .1
                ZoomWindow2 = ZoomWindow2 + ZoomYDiff * .1
                '                LOCATE 10, 10: PRINT ZoomWindow1, ZoomWindow2, ZoomWindow3, ZoomWindow4
                '                _DISPLAY
                '                AAA$ = "": WHILE AAA$ = "": AAA$ = INKEY$: WEND
                GoTo StartDisplayCarolinaBays
            Case 73 '        cursor key page up
                ZoomWindow1 = ZoomWindow1 + ZoomXDiff * .25
                ZoomWindow2 = ZoomWindow2 + ZoomYDiff * .25
                ZoomWindow3 = ZoomWindow3 - ZoomXDiff * .25
                ZoomWindow4 = ZoomWindow4 - ZoomYDiff * .25
                GoTo StartDisplayCarolinaBays
            Case 72 '        cursor key up
                ZoomWindow4 = ZoomWindow4 - ZoomYDiff * .1
                ZoomWindow2 = ZoomWindow2 - ZoomYDiff * .1
                '                If Scene$ = "Venus and Encke" Or Scene$ = "Encke and Swift-Tuttle Origins" Or Scene$ = "Mercury and Encke" Then
                '                    Locate 11, 10: Print "1: ", ZoomWindow1, " 2: ", ZoomWindow2, " 3: ", ZoomWindow3, " 4: ", ZoomWindow4
                '                    _Display
                '                    AA$ = "": While AA$ = "": AA$ = InKey$: Wend
                '                End If

                GoTo StartDisplayCarolinaBays
            Case 81 '        cursor key page down
                ZoomWindow1 = ZoomWindow1 - ZoomXDiff * .25
                ZoomWindow2 = ZoomWindow2 - ZoomYDiff * .25
                ZoomWindow3 = ZoomWindow3 + ZoomXDiff * .25
                ZoomWindow4 = ZoomWindow4 + ZoomYDiff * .25
                '                If Scene$ = "Venus and Encke" Or Scene$ = "Encke and Swift-Tuttle Origins" Or Scene$ = "Mercury and Encke" Then
                '                    Locate 11, 10: Print "1: ", ZoomWindow1, " 2: ", ZoomWindow2, " 3: ", ZoomWindow3, " 4: ", ZoomWindow4
                '                    _Display
                '                    AA$ = "": While AA$ = "": AA$ = InKey$: Wend
                '                End If

                GoTo StartDisplayCarolinaBays
            Case 75 '        cursor key left

                ZoomWindow1 = ZoomWindow1 + ZoomXDiff * .1
                ZoomWindow3 = ZoomWindow3 + ZoomXDiff * .1
                GoTo StartDisplayCarolinaBays
            Case 77 '        cursor key left
                ZoomWindow1 = ZoomWindow1 - ZoomXDiff * .1
                ZoomWindow3 = ZoomWindow3 - ZoomXDiff * .1
                GoTo StartDisplayCarolinaBays
            Case 79 ' Cursor End
                If Scene$ = "Venus and Encke" Or Scene$ = "Encke and Swift-Tuttle Origins" Or Scene$ = "Earth and Encke Nov" Or Scene$ = "Earth and Encke July" Or Scene$ = "Earth and ST" Or Scene$ = "Mercury and Encke" Then
                    Select Case ZoomedtoComet$
                        Case "WholePlanet"
                            ZoomedtoComet$ = "OneBackFrom Planet"
                            ZoomWindow1 = -112767: ZoomWindow2 = -63445: ZoomWindow3 = 112767: ZoomWindow4 = 63445 ' Center on Earth = 0,0 co-ordinates
                        Case "OneBackFrom Planet"
                            ZoomedtoComet$ = "EarthVenusMercuryOrbits"
                            ZoomWindow1 = -110700000: ZoomWindow2 = -133500000: ZoomWindow3 = 363840000: ZoomWindow4 = 133500000
                        Case "EarthVenusMercuryOrbits"
                            ZoomedtoComet$ = "SaturnJupiter"
                            ZoomWindow1 = -2576100000: ZoomWindow2 = -1520650000: ZoomWindow3 = 2825210000: ZoomWindow4 = 1520650000
                        Case "SaturnJupiter"
                            ZoomedtoComet$ = "AllPlanetOrbits"
                            ZoomWindow1 = -10136000000: ZoomWindow2 = -5775000000: ZoomWindow3 = 10389100000: ZoomWindow4 = 5775000000 ' Center on Earth = 0,0 co-ordinates
                        Case "AllPlanetOrbits"
                            ZoomedtoComet$ = "WholePlanet"
                            ZoomWindow1 = -14850: ZoomWindow2 = -8355: ZoomWindow3 = 14850: ZoomWindow4 = 8355 ' Center on Earth = 0,0 co-ordinates
                        Case Else
                            ZoomedtoComet$ = "WholePlanet"
                            ZoomWindow1 = -112767: ZoomWindow2 = -63445: ZoomWindow3 = 112767: ZoomWindow4 = 63445 ' Center on Earth = 0,0 co-ordinates
                    End Select
                Else
                    If ZoomedtoComet$ <> "Yes" Then
                        ZoomWindow1 = -1855: ZoomWindow2 = 2841: ZoomWindow3 = 1855: ZoomWindow4 = 4931 ' Center on Earth = 0,0 co-ordinates
                        If Scene$ = "Egypt" Then ZoomWindow1 = -4173: ZoomWindow2 = 1534: ZoomWindow3 = 4173: ZoomWindow4 = 6237 ' Center on Earth = 0,0 co-ordinates
                        If Scene$ = "MARS" Then ZoomWindow1 = -2086: ZoomWindow2 = -474: ZoomWindow3 = 2086: ZoomWindow4 = 1877 ' Center on Earth = 0,0 co-ordinates
                        ZoomedtoComet$ = "Yes"
                    Else
                        ZoomWindow1 = -14850: ZoomWindow2 = -8355: ZoomWindow3 = 14850: ZoomWindow4 = 8355 ' Center on Earth = 0,0 co-ordinates
                        ZoomedtoComet$ = "No"
                    End If
                End If

                GoTo StartDisplayCarolinaBays
        End Select
    End If

    GoTo StartDisplayCarolinaBays

End Sub


Sub DrawMiniCraters (a, b, c, d, ii, jj)

    TempCometColor = CometColor(ii, jj)
    If Scene$ = "MARS" Then TempCometColor = _RGB(0, 0, 255)
    If MonoColor$ <> "No" Then TempCometColor = PresentMonoColor

    ' screen is divided into 1777 wide by 1000 high for _Printstring  by original command at beginning of program:  SCREEN _NEWIMAGE(1777, 1000, 32)
    If Abs(ZoomWindow1 - ZoomWindow3) > 8000 Then Circle (b, d), 6, TempCometColor: Exit Sub


    CS = CometSize(ii, jj) / 250 ' Comet Particles are ranging from 20 to 300 m radius
    e = b - a: f = d - c
    Line (a, c)-(b, d), TempCometColor
    If DrawCraters$ = "Both" Or DrawCraters$ = "Craters" Then
        Circle (a, c), 2 * CS, TempCometColor
        Circle (a + e * .25, c + f * .25), 3 * CS, TempCometColor
        Circle (a + e * .5, c + f * .5), 3.3 * CS, TempCometColor
        Circle (a + e * .75, c + f * .75), 2.5 * CS, TempCometColor
        Circle (b, d), 1.8 * CS, TempCometColor
    End If


    If Scene$ = "Egypt" And ii > 150 Then Exit Sub
    MaxII = 280
    If Scene$ = "ChesapeakeBay" Then MaxII = 300

    If ii <= MaxII Then
        If DrawCraters$ = "Both" Or DrawCraters$ = "Words" Then
            If Abs(ZoomWindow1 - ZoomWindow3) < 500 Then ' print speed and angle: screen is divided into 1777 wide by 1000 high for _Printstring  by original command at beginning of program:  SCREEN _NEWIMAGE(1777, 1000, 32)
                If a > ZoomWindow1 And a < ZoomWindow3 And c >= ZoomWindow2 And c <= ZoomWindow4 Then
                    If DrawCraters$ = "Both" Then Circle (a, c), 1 * CS, _RGB(255, 255, 255)
                    speed = Sqr((PreviousCometX2(ii, jj) - CometX(ii, jj)) ^ 2 + (PreviousCometY2(ii, jj) - CometY(ii, jj)) ^ 2 + (PreviousCometZ2(ii, jj) - CometZ(ii, jj)) ^ 2) / 2 ' two steps back from CometX so 1/2 the speed
                    If DrawCraters$ = "Both" Then Circle (b, d), 0.5 * CS, _RGB(255, 255, 0)
                    PrintLocX = 1777 * Abs((a - ZoomWindow1) / (ZoomWindow1 - ZoomWindow3))
                    PrintLocY1 = 1000 * Abs((c - ZoomWindow4) / (ZoomWindow2 - ZoomWindow4))
                    If CometColor(ii, jj) <> _RGB(0, 0, 255) Then ' blue does not show numbers well
                        Color CometColor(ii, jj), _RGB(0, 0, 0)
                    Else
                        Color _RGB(150, 150, 255), _RGB(0, 0, 0)
                    End If
                    aaa = Int(speed * 10) / 10: AS$ = "": If aaa < 1 Then AS$ = "0"
                    If speed >= 1 Then
                        _PrintString (PrintLocX, PrintLocY1), AS$ + LTrim$(Str$(Int(speed * 10) / 10)) + " km/s"
                    Else
                        _PrintString (PrintLocX, PrintLocY1), AS$ + LTrim$(Str$(Int(speed * 1000) / 1000)) + " km/s"
                        '                    _PRINTSTRING (PrintLocX, PrintLocY1 + 30), LTRIM$(STR$(INT(CometSize(ii, jj) * 10) / 10)) + " m" ' CometSize is in METERS, Comet Speed is in Km/s
                    End If
                    If ii < 6 And jj < 6 Then _PrintString (PrintLocX, PrintLocY1 + 30), LTrim$(Str$(Int(CometSize(ii, jj) * 10) / 10)) + " m" ' CometSize is in METERS, Comet Speed is in Km/s

                    DotXY = (PreviousCometX2(ii, jj) * (CometX(ii, jj) - PreviousCometX2(ii, jj)) + PreviousCometY2(ii, jj) * (CometY(ii, jj) - PreviousCometY2(ii, jj)) + PreviousCometZ2(ii, jj) * (CometZ(ii, jj) - PreviousCometZ2(ii, jj)))
                    XYMagnitude = ((CometX(ii, jj) - PreviousCometX2(ii, jj)) ^ 2 + (CometY(ii, jj) - PreviousCometY2(ii, jj)) ^ 2 + (CometZ(ii, jj) - PreviousCometZ2(ii, jj)) ^ 2) ^ 0.5 * (CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2) ^ 0.5
                    Checkangle = 1
                    If Abs(XYMagnitude) > .0000001 Then Checkangle = DotXY / XYMagnitude
                    If Abs(Checkangle) > 1 Then Checkangle = 1
                    AngleofImpact = ARCCOS(Checkangle) * 180 / pi '   or 90 degrees minus that
                    CombinedAngle = AngleofImpact - 90
                    PrintLocX = 1777 * Abs((b - ZoomWindow1) / (ZoomWindow1 - ZoomWindow3))

                    PrintLocY = 1000 * Abs((d - ZoomWindow4) / (ZoomWindow2 - ZoomWindow4))
                    If PrintLocY < PrintLocY1 + 15 Then PrintLocY = PrintLocY1 + 15
                    _PrintString (PrintLocX, PrintLocY), Str$(Int(CombinedAngle * 10) / 10) + Chr$(167)
                    _Display
                End If
            End If
        End If
    End If

End Sub


Sub ImpactProbabilitiesPrintResults (PreviousX, startX, PreviousY, startY, PreviousZ, startZ, TotalPointsCalculated, CometSpeedAtImpact)

    ' Angle = arccos(A.X/|a| |x|) =  Cos-1[(x*a+y*b+z*c)/(Sqrt(x^2+y^2+z^2) * Sqrt(a^2+b^2+c^2))]    Scalar Law - https://en.wikipedia.org/wiki/Dot_product
    '  a=startx, b=starty, c=startz
    '  x=PreviousX, y=PreviousY, z=PreviousZ
    '  Angle between incoming comet and earth is then:
    '  Vector of earth radius =(0,0,0)-(a,b,c); Vector of incoming comet = (0,0,0)-(x-a,y-b,z-c) with x,y,z = PreviousX,Y,Z; a,b,c=startX,Starty,startz
    '  DotXY = (PreviousX*(startX-PreviousX)  + PreviousY*(startY-PreviousY)  + PreviousZ*(startZ-PreviousZ))
    '  XYMagnitude = ((startX-PreviousX)^2 + (startY-PreviousY)^2 + (startZ-PreviousZ)^2)^0.5 * (startx^2 + starty^2 + startz ^2)^0.5
    '  Angle of Impact then = Arccos (DotXY/XYMagnitude) * 180 / pi    or 90 degrees minus that


    ' ***************    NOTE: ARCOS (x) needs X <=1  **************************        IF x < 1 THEN ARCCOS = (2 * ATN(1)) - ATN(x / SQR(1 - x * x)) ELSE BEEP

    DotXY = (PreviousX * (startX - PreviousX) + PreviousY * (startY - PreviousY) + PreviousZ * (startZ - PreviousZ))
    XYMagnitude = ((startX - PreviousX) ^ 2 + (startY - PreviousY) ^ 2 + (startZ - PreviousZ) ^ 2) ^ 0.5 * (startX ^ 2 + startY ^ 2 + startZ ^ 2) ^ 0.5

    If Abs(XYMagnitude) > .0000001 Then
        Checkangle = DotXY / XYMagnitude
    Else
        Checkangle = 1
    End If
    If Abs(Checkangle) > 1 Then Checkangle = 1
    AngleofImpact = ARCCOS(Checkangle) * 180 / pi '   or 90 degrees minus that
    CombinedAngle = AngleofImpact - 90


    Color _RGB(0, 0, 0), _RGB(215, 215, 215)
    _PrintString (800, 3), " Impact Speed:  " + Left$(Str$(CometSpeedAtImpact), 6) + "  km/s"
    _PrintString (1100, 3), " Impact Angle:  " + Left$(Str$(CombinedAngle), 6) + "   "
    Color _RGB(255, 255, 255), _RGB(0, 0, 0)

    I9 = Int(CombinedAngle / 5 - .0001) + 1 ' 1 for 0-5, 2 for 5.0001 to 10 etc
    If I9 < 0 Then I9 = 0
    If I9 > 20 Then I9 = 20
    ImpactAngleProbs(I9) = ImpactAngleProbs(I9) + 1
    ImpactAngleProbPercents(I9) = 100 * ImpactAngleProbs(I9) / TotalPointsCalculated

End Sub

Sub OldImpactProbabilitiesPrintResults (Z1, i, PreviousX, startX, PreviousY, startY, PreviousZ, startZ, Distance, NumPointsToCalculate, CometSpeedAtImpact)

    If ToggleDrawCometCenterPath = 1 Then ' List comet impact angles onthe screen


        Px = PreviousX - startX: Py = PreviousY - startY: Pz = PreviousZ - startZ
        DistanceOfCometTravel = Sqr(Px ^ 2 + Py ^ 2 + Pz ^ 2)
        If DistanceOfCometTravel < 0.00001 Then DistanceOfCometTravel = 0.00001
        CometAngle = ARCSIN((PreviousY - startY) / DistanceOfCometTravel) * 180 / pi

        PlanetAngleD = Distance
        If PlanetAngleD < 0.00001 Then PlanetAngleD = 0.00001
        '                    PlanetAngle = 90 - ARCSIN((startY - PlanetCenterY) / PlanetRadius) * 180 / pi    '   PlanetCenterY = 0
        PlanetAngle = 90 - Abs(ARCSIN(startY / PlanetAngleD) * 180 / pi)

        '        IF startX <= PlanetCenterX AND startY >= PlanetCenterY THEN CombinedAngle = CometAngle - PlanetAngle
        '        IF startX > PlanetCenterX AND startY >= PlanetCenterY THEN CombinedAngle = CometAngle + PlanetAngle: BEEP
        '        IF startX > PlanetCenterX AND startY < PlanetCenterY THEN CombinedAngle = 180 - PlanetAngle - CometAngle
        '        IF startX <= PlanetCenterX AND startY < PlanetCenterY THEN CombinedAngle = PlanetAngle - CometAngle - 180
        '
        If startX <= 0 And startY >= 0 Then CombinedAngle = CometAngle - PlanetAngle
        If startX > 0 And startY >= 0 Then CombinedAngle = CometAngle + PlanetAngle
        If startX > 0 And startY < 0 Then CombinedAngle = PlanetAngle - CometAngle
        If startX <= 0 And startY < 0 Then CombinedAngle = Abs(CometAngle) - PlanetAngle

        PrintPlanetAngles = 0
        If PrintPlanetAngles = 1 Then
            Select Case i
                Case Is < 75: _PrintString (600, 40 + i * 12), Str$(i) + " Angle:" + Left$(Str$(PlanetAngle), 6)
                Case Is < 150: _PrintString (800, 40 + i * 12 - 900), Str$(i) + " Angle:" + Left$(Str$(PlanetAngle), 6)
                Case Is < 225: _PrintString (1000, 40 + i * 12 - 1800), Str$(i) + " Angle:" + Left$(Str$(PlanetAngle), 6)
                Case Is < 300: _PrintString (1200, 40 + i * 12 - 2700), Str$(i) + " Angle:" + Left$(Str$(PlanetAngle), 6)
                Case Is < 375: _PrintString (1400, 40 + i * 12 - 3600), Str$(i) + " Angle:" + Left$(Str$(PlanetAngle), 6)
                Case Is > 375: _PrintString (1600, 40 + i * 12 - 4500), Str$(i) + " Angle:" + Left$(Str$(PlanetAngle), 6)
            End Select
        End If
        PrintCometAngles = 0
        If PrintCometAngles = 1 Then
            Select Case i
                Case Is < 75: _PrintString (600, 40 + i * 12), Str$(i) + " Angle:" + Left$(Str$(CometAngle), 6)
                Case Is < 150: _PrintString (800, 40 + i * 12 - 900), Str$(i) + " Angle:" + Left$(Str$(CometAngle), 6)
                Case Is < 225: _PrintString (1000, 40 + i * 12 - 1800), Str$(i) + " Angle:" + Left$(Str$(CometAngle), 6)
                Case Is < 300: _PrintString (1200, 40 + i * 12 - 2700), Str$(i) + " Angle:" + Left$(Str$(CometAngle), 6)
                Case Is < 375: _PrintString (1400, 40 + i * 12 - 3600), Str$(i) + " Angle:" + Left$(Str$(CometAngle), 6)
                Case Is > 375: _PrintString (1600, 40 + i * 12 - 4500), Str$(i) + " Angle:" + Left$(Str$(CometAngle), 6)
            End Select
        End If
        PrintCombinedAngles = 0
        If PrintCombinedAngles = 1 Then
            Select Case i
                Case Is < 75: _PrintString (600, 40 + i * 12), Str$(i) + " Angle:" + Left$(Str$(CombinedAngle), 6)
                Case Is < 150: _PrintString (800, 40 + i * 12 - 900), Str$(i) + " Angle:" + Left$(Str$(CombinedAngle), 6)
                Case Is < 225: _PrintString (1000, 40 + i * 12 - 1800), Str$(i) + " Angle:" + Left$(Str$(CombinedAngle), 6)
                Case Is < 300: _PrintString (1200, 40 + i * 12 - 2700), Str$(i) + " Angle:" + Left$(Str$(CombinedAngle), 6)
                Case Is < 375: _PrintString (1400, 40 + i * 12 - 3600), Str$(i) + " Angle:" + Left$(Str$(CombinedAngle), 6)
                Case Is > 375: _PrintString (1600, 40 + i * 12 - 4500), Str$(i) + " Angle:" + Left$(Str$(CombinedAngle), 6)
            End Select
            '                            IF CometTime = 1 THEN
            '                               SaveFileName$ = "D:/CometImages/ImpactProbabilitiesFile" + STR$(CometInitialSpeedX) + ".csv"
            '                          OPEN SaveFileName$ FOR APPEND AS #9
            '                         WRITE #9, i, CombinedAngle
            '                        CLOSE #9
            '                   END IF
        End If

        _PrintString (600, 15), Str$(i) + "  Z             " + Left$(Str$(Z1), 6) + "     "
        _PrintString (600, 40), Str$(i) + "  Planet Angle: " + Left$(Str$(PlanetAngle), 6) + "   "
        _PrintString (600, 70), Str$(i) + "  Comet Angle:  " + Left$(Str$(CometAngle), 6) + "   "
        _PrintString (600, 90), Str$(i) + "  Impact Angle: " + Left$(Str$(CombinedAngle), 6) + "   "
        _PrintString (600, 120), Str$(i) + "  Impact Speed: " + Left$(Str$(CometSpeedAtImpact), 6) + "   km/s"

        I9 = Int(CombinedAngle / 5 - .0001) + 1 ' 1 for 0-5, 2 for 5.0001 to 10 etc
        If I9 < 0 Then I9 = 0
        If I9 > 20 Then I9 = 20
        ImpactAngleProbs(I9) = ImpactAngleProbs(I9) + 1
        ImpactAngleProbPercents(I9) = 100 * ImpactAngleProbs(I9) / NumPointsToCalculate
    End If

    AA$ = InKey$:
    If AA$ = Chr$(27) Then End
    If AA$ = Chr$(32) Then ' Pause if space bar pressed
        AA$ = "": While AA$ = "": AA$ = InKey$: Wend
    End If

End Sub

Sub circularizeComet
    CircularizeCount = CircularizeCount - 1
    If CircularizeCount < 1 Then CircularizeCount = 299
    For j = CircularizeCount To CircularizeCount + 1
        '    FOR j = 1 TO 300
        For i = 1 To 300
            If CometMass(i, j) >= 1 Then
                w = (CometX(i, j) - CometX(CometCenterX, CometCenterY)) ^ 2 + (CometY(i, j) - CometY(CometCenterX, CometCenterY)) ^ 2
                w = Sqr(w)
                If w < CometRadius * 3 And w > CometRadius * 1.5 Then
                    z = Rnd(w)
                    CometX(i, j) = CometX(CometCenterX, CometCenterY) + (z - .5) * CometRadius * 3
                    z = Rnd(w)
                    CometY(i, j) = CometY(CometCenterX, CometCenterY) + (z - .5) * CometRadius * 3
                    '                    CometColor(i, j) = _RGB(0, 0, 255)
                End If
                w = (CometX(i, j) - CometX(CometCenterX, CometCenterY)) ^ 2 + (CometY(i, j) - CometY(CometCenterX, CometCenterY)) ^ 2
                w = Sqr(w)
                If w < CometRadius * 3 And w > CometRadius * 1.5 Then
                    z = Rnd(w)
                    CometX(i, j) = CometX(CometCenterX, CometCenterY) + (z - .5) * CometRadius * 3
                    z = Rnd(w)
                    CometY(i, j) = CometY(CometCenterX, CometCenterY) + (z - .5) * CometRadius * 3
                    '                    CometColor(i, j) = _RGB(0, 0, 255)
                End If
                w = (CometX(i, j) - CometX(CometCenterX, CometCenterY)) ^ 2 + (CometY(i, j) - CometY(CometCenterX, CometCenterY)) ^ 2
                w = Sqr(w)
                If w < CometRadius * 3 And w > CometRadius * 1.5 Then
                    z = Rnd(w)
                    CometX(i, j) = CometX(CometCenterX, CometCenterY) + (z - .5) * CometRadius * 3
                    z = Rnd(w)
                    CometY(i, j) = CometY(CometCenterX, CometCenterY) + (z - .5) * CometRadius * 3
                    '                    CometColor(i, j) = _RGB(0, 0, 255)
                End If
            End If
        Next i
    Next j
End Sub


Sub DrawMoon
    For i = 17 To 1737 Step 20
        Circle (PlanetCenterX + 384400, PlanetCenterY), i, _RGB(200, 200, 200)
    Next i
    For i = 20 To 760 Step 20
        Circle (PlanetCenterX + 384400, PlanetCenterY + 890), i, _RGB(100, 100, 100)
    Next i

    For i = 20 To 500 Step 20
        Circle (PlanetCenterX + 384400 - 750, PlanetCenterY + 1000), i, _RGB(100, 100, 100), , , 1.2
        Circle (PlanetCenterX + 384400 - 900, PlanetCenterY + 650), i, _RGB(100, 100, 100), , , 1.2
        Circle (PlanetCenterX + 384400 - 350, PlanetCenterY - 100), i, _RGB(100, 100, 100)
    Next i
    For i = 20 To 300 Step 20
        Circle (PlanetCenterX + 384400 + 850, PlanetCenterY + 650), i, _RGB(80, 80, 80)
        Circle (PlanetCenterX + 384400 + 950, PlanetCenterY + 100), i, _RGB(80, 80, 80)
    Next i
    For i = 20 To 200 Step 20
        Circle (PlanetCenterX + 384400 + 1550, PlanetCenterY + 150), i, _RGB(80, 80, 80), , , 1.5
        Circle (PlanetCenterX + 384400 + 1250, PlanetCenterY - 300), i, _RGB(80, 80, 80), , , 1.25
        Circle (PlanetCenterX + 384400 - 350, PlanetCenterY - 900), i, _RGB(255, 255, 255)
        Circle (PlanetCenterX + 384400 - 950, PlanetCenterY - 200), i, _RGB(80, 80, 80)
    Next i

End Sub

Sub Circle3DLatitudes ' draw North America, equator and lake Michigan
    _PrintString (100, 10), " Earth Tilt:" + Str$(TiltofEarth) + "        "

    ' Draw Equator
    CalSin = Sin((90 - TiltofEarth) * pi / 180)
    CalCos = Cos((90 - TiltofEarth) * pi / 180)
    A = CalSin * PlanetRadius ' x value of point some degrees from vertical
    B = CalCos * PlanetRadius
    CalSin = Sin((-90 - TiltofEarth) * pi / 180)
    CalCos = Cos((-90 - TiltofEarth) * pi / 180)
    C = CalSin * PlanetRadius ' x value of point some degrees from vertical
    D = CalCos * PlanetRadius
    Line (PlanetCenterX + A, PlanetCenterY + B)-(PlanetCenterX + C, PlanetCenterY + D), _RGB(0, 0, 255)
    Line (PlanetCenterX + A, PlanetCenterY + B)-(PlanetCenterX + C, PlanetCenterY + D), _RGB(255, 0, 0), , &B0000111111110000 '16-bits

    ' draw North America
    TiltRadians = TiltofEarth * pi / 180

    CalSin = Sin((-20.74 - TiltofEarth) * pi / 180)
    CalCos = Cos((-20.74 - TiltofEarth) * pi / 180)
    A = CalSin * 6092
    B = CalCos * 6092
    CalSin = Sin((-8.23 - TiltofEarth) * pi / 180)
    CalCos = Cos((-8.23 - TiltofEarth) * pi / 180)
    C = CalSin * 6209
    D = CalCos * 6209
    Line (PlanetCenterX + A, PlanetCenterY + B)-(PlanetCenterX + C, PlanetCenterY + D), _RGB(0, 255, 0)
    CalSin = Sin((29.9 - TiltofEarth) * pi / 180)
    CalCos = Cos((29.9 - TiltofEarth) * pi / 180)
    A = CalSin * 5165
    B = CalCos * 5165
    CalSin = Sin((48.55 - TiltofEarth) * pi / 180)
    CalCos = Cos((48.55 - TiltofEarth) * pi / 180)
    C = CalSin * 4951
    D = CalCos * 4951
    Line (PlanetCenterX + A, PlanetCenterY + B)-(PlanetCenterX + C, PlanetCenterY + D), _RGB(0, 255, 0)

    CalSin = Sin((-4 - TiltofEarth) * pi / 180) * 4701
    CalCos = Cos((-4 - TiltofEarth) * pi / 180) * 4701
    Circle (PlanetCenterX + CalSin, PlanetCenterY + CalCos), 1601, _RGB(0, 255, 0), 1.2 + TiltRadians, 1.9 + TiltRadians, 1
    CalSin = Sin((10.61 - TiltofEarth) * pi / 180) * 7418
    CalCos = Cos((10.61 - TiltofEarth) * pi / 180) * 7418
    Circle (PlanetCenterX + CalSin, PlanetCenterY + CalCos), 1601, _RGB(0, 255, 0), 3.89 + TiltRadians, 4.7 + TiltRadians, 1
    CalSin = Sin((25.95 - TiltofEarth) * pi / 180) * 6701
    CalCos = Cos((25.95 - TiltofEarth) * pi / 180) * 6701
    Circle (PlanetCenterX + CalSin, PlanetCenterY + CalCos), 1611, _RGB(0, 255, 0), 3.34 + TiltRadians, 4.5 + TiltRadians, 1
    CalSin = Sin((40.57 - TiltofEarth) * pi / 180) * 6752
    CalCos = Cos((40.57 - TiltofEarth) * pi / 180) * 6752
    Circle (PlanetCenterX + CalSin, PlanetCenterY + CalCos), 1639, _RGB(0, 255, 0), 3.7 + TiltRadians, 3.95 + TiltRadians, 1
    CalSin = Sin((47.41 - TiltofEarth) * pi / 180) * 3604
    CalCos = Cos((47.41 - TiltofEarth) * pi / 180) * 3604
    Circle (PlanetCenterX + CalSin, PlanetCenterY + CalCos), 1639, _RGB(0, 255, 0), 0.41 + TiltRadians, 1.19 + TiltRadians, 1
    CalSin = Sin((57.08 - TiltofEarth) * pi / 180) * 6775
    CalCos = Cos((57.08 - TiltofEarth) * pi / 180) * 6775
    Circle (PlanetCenterX + CalSin, PlanetCenterY + CalCos), 1639, _RGB(0, 255, 0), 3.5 + TiltRadians, 4.45 + TiltRadians, 1
    CalSin = Sin((54.68 - TiltofEarth) * pi / 180) * 5933
    CalCos = Cos((54.68 - TiltofEarth) * pi / 180) * 5933
    Circle (PlanetCenterX + CalSin, PlanetCenterY + CalCos), 354, _RGB(0, 255, 0), 1.7 + TiltRadians, 4.4 + TiltRadians, 1
    CalSin = Sin((59.60 - TiltofEarth) * pi / 180) * 7234
    CalCos = Cos((59.60 - TiltofEarth) * pi / 180) * 7234
    Circle (PlanetCenterX + CalSin, PlanetCenterY + CalCos), 1601, _RGB(0, 255, 0), 3.5 + TiltRadians, 4 + TiltRadians, 1
    CalSin = Sin((57.92 - TiltofEarth) * pi / 180) * 5067
    CalCos = Cos((57.92 - TiltofEarth) * pi / 180) * 5067
    Circle (PlanetCenterX + CalSin, PlanetCenterY + CalCos), 1206, _RGB(0, 255, 0), 0.41 + TiltRadians, 1.15 + TiltRadians, 1

    'Draw Can-US Border
    CalSin = Sin((13.28 - TiltofEarth) * pi / 180)
    CalCos = Cos((13.28 - TiltofEarth) * pi / 180)
    A = CalSin * 5850
    B = CalCos * 5850
    CalSin = Sin((23.07 - TiltofEarth) * pi / 180)
    CalCos = Cos((23.07 - TiltofEarth) * pi / 180)
    C = CalSin * 6093
    D = CalCos * 6093
    Line (PlanetCenterX + A, PlanetCenterY + B)-(PlanetCenterX + C, PlanetCenterY + D), _RGB(180, 180, 0)
    CalSin = Sin((28.41 - TiltofEarth) * pi / 180)
    CalCos = Cos((28.41 - TiltofEarth) * pi / 180)
    A = CalSin * 6193
    B = CalCos * 6193
    Line (PlanetCenterX + A, PlanetCenterY + B)-(PlanetCenterX + C, PlanetCenterY + D), _RGB(180, 180, 0)
    CalSin = Sin((32.07 - TiltofEarth) * pi / 180)
    CalCos = Cos((32.07 - TiltofEarth) * pi / 180)
    C = CalSin * 6271
    D = CalCos * 6271
    Line (PlanetCenterX + A, PlanetCenterY + B)-(PlanetCenterX + C, PlanetCenterY + D), _RGB(180, 180, 0)
    CalSin = Sin((35.27 - TiltofEarth) * pi / 180)
    CalCos = Cos((35.27 - TiltofEarth) * pi / 180)
    A = CalSin * 6315
    B = CalCos * 6315
    Line (PlanetCenterX + A, PlanetCenterY + B)-(PlanetCenterX + C, PlanetCenterY + D), _RGB(180, 180, 0)

    'Draw Yucatan & Central America
    CalSin = Sin((67.4 - TiltofEarth) * pi / 180)
    CalCos = Cos((67.4 - TiltofEarth) * pi / 180)
    A = CalSin * 6026
    B = CalCos * 6026
    CalSin = Sin((63.11 - TiltofEarth) * pi / 180)
    CalCos = Cos((63.11 - TiltofEarth) * pi / 180)
    C = CalSin * 6113
    D = CalCos * 6113
    Line (PlanetCenterX + A, PlanetCenterY + B)-(PlanetCenterX + C, PlanetCenterY + D), _RGB(0, 255, 0)
    CalSin = Sin((64.78 - TiltofEarth) * pi / 180)
    CalCos = Cos((64.78 - TiltofEarth) * pi / 180)
    A = CalSin * 5772
    B = CalCos * 5772
    CalSin = Sin((65.12 - TiltofEarth) * pi / 180)
    CalCos = Cos((65.12 - TiltofEarth) * pi / 180)
    C = CalSin * 5900
    D = CalCos * 5900
    Line (PlanetCenterX + A, PlanetCenterY + B)-(PlanetCenterX + C, PlanetCenterY + D), _RGB(0, 255, 0)
    CalSin = Sin((62.54 - TiltofEarth) * pi / 180)
    CalCos = Cos((62.54 - TiltofEarth) * pi / 180)
    A = CalSin * 5984
    B = CalCos * 5984
    Line (PlanetCenterX + A, PlanetCenterY + B)-(PlanetCenterX + C, PlanetCenterY + D), _RGB(0, 255, 0)
    CalSin = Sin((62.99 - TiltofEarth) * pi / 180)
    CalCos = Cos((62.99 - TiltofEarth) * pi / 180)
    C = CalSin * 6095
    D = CalCos * 6095
    Line (PlanetCenterX + A, PlanetCenterY + B)-(PlanetCenterX + C, PlanetCenterY + D), _RGB(0, 255, 0)
    CalSin = Sin((68.01 - TiltofEarth) * pi / 180)
    CalCos = Cos((68.01 - TiltofEarth) * pi / 180)
    A = CalSin * 6026
    B = CalCos * 6026
    CalSin = Sin((71.69 - TiltofEarth) * pi / 180)
    CalCos = Cos((71.69 - TiltofEarth) * pi / 180)
    C = CalSin * 6150
    D = CalCos * 6150
    Line (PlanetCenterX + A, PlanetCenterY + B)-(PlanetCenterX + C, PlanetCenterY + D), _RGB(0, 255, 0)
    CalSin = Sin((78.69 - TiltofEarth) * pi / 180)
    CalCos = Cos((78.69 - TiltofEarth) * pi / 180)
    A = CalSin * 6350
    B = CalCos * 6350
    Line (PlanetCenterX + A, PlanetCenterY + B)-(PlanetCenterX + C, PlanetCenterY + D), _RGB(0, 255, 0)
    CalSin = Sin((82 - TiltofEarth) * pi / 180)
    CalCos = Cos((82 - TiltofEarth) * pi / 180)
    A = CalSin * 6350
    B = CalCos * 6350
    CalSin = Sin((79 - TiltofEarth) * pi / 180)
    CalCos = Cos((79 - TiltofEarth) * pi / 180)
    C = CalSin * 6200
    D = CalCos * 6200
    Line (PlanetCenterX + A, PlanetCenterY + B)-(PlanetCenterX + C, PlanetCenterY + D), _RGB(0, 255, 0)
    CalSin = Sin((76.27 - TiltofEarth) * pi / 180)
    CalCos = Cos((76.27 - TiltofEarth) * pi / 180)
    A = CalSin * 6068
    B = CalCos * 6068
    Line (PlanetCenterX + A, PlanetCenterY + B)-(PlanetCenterX + C, PlanetCenterY + D), _RGB(0, 255, 0)
    CalSin = Sin((68.19 - TiltofEarth) * pi / 180)
    CalCos = Cos((68.19 - TiltofEarth) * pi / 180)
    C = CalSin * 5650
    D = CalCos * 5650
    Line (PlanetCenterX + A, PlanetCenterY + B)-(PlanetCenterX + C, PlanetCenterY + D), _RGB(0, 255, 0)



    ' California
    CalSin = Sin((47.83 - TiltofEarth) * pi / 180)
    CalCos = Cos((47.83 - TiltofEarth) * pi / 180)
    A = CalSin * 4998
    B = CalCos * 4998
    CalSin = Sin((48.55 - TiltofEarth) * pi / 180)
    CalCos = Cos((48.55 - TiltofEarth) * pi / 180)
    C = CalSin * 4951
    D = CalCos * 4951
    Line (PlanetCenterX + A, PlanetCenterY + B)-(PlanetCenterX + C, PlanetCenterY + D), _RGB(0, 255, 0)
    CalSin = Sin((33.55 - TiltofEarth) * pi / 180)
    CalCos = Cos((33.55 - TiltofEarth) * pi / 180)
    C = CalSin * 5159
    D = CalCos * 5159
    Line (PlanetCenterX + A, PlanetCenterY + B)-(PlanetCenterX + C, PlanetCenterY + D), _RGB(0, 255, 0)
    CalSin = Sin((35.21 - TiltofEarth) * pi / 180)
    CalCos = Cos((35.21 - TiltofEarth) * pi / 180)
    A = CalSin * 5212
    B = CalCos * 5212
    Line (PlanetCenterX + A, PlanetCenterY + B)-(PlanetCenterX + C, PlanetCenterY + D), _RGB(0, 255, 0)



    ' Alaska
    CalSin = Sin((-4.31 - TiltofEarth) * pi / 180)
    CalCos = Cos((-4.31 - TiltofEarth) * pi / 180)
    A = CalSin * 6367
    B = CalCos * 6367
    CalSin = Sin((-4.86 - TiltofEarth) * pi / 180)
    CalCos = Cos((-4.86 - TiltofEarth) * pi / 180)
    C = CalSin * 6300
    D = CalCos * 6300
    Line (PlanetCenterX + A, PlanetCenterY + B)-(PlanetCenterX + C, PlanetCenterY + D), _RGB(0, 255, 0)

    ' Lake Michigan
    For i = 1 To 20
        CalSin = Sin((41.5 - TiltofEarth) * pi / 180)
        CalCos = Cos((41.5 - TiltofEarth) * pi / 180)
        A = CalSin * 6300 - i * 2
        B = CalCos * 6300 - i * 2
        CalSin = Sin((38.1 - TiltofEarth) * pi / 180)
        CalCos = Cos((38.1 - TiltofEarth) * pi / 180)
        C = CalSin * 6315 - i * 2
        D = CalCos * 6315 - i * 2
        Line (PlanetCenterX + A, PlanetCenterY + B)-(PlanetCenterX + C, PlanetCenterY + D), _RGB(110, 110, 255)
    Next i

End Sub

Sub InitializePlanets
    ' **********************************************    SETUP OF PLANET FACTORS    ******************************************************


    EarthGravity$ = "On": MarsGravity$ = "On": JupiterGravity$ = "On": SaturnGravity$ = "On": UranusNeptuneGravity$ = "On"

    CometYears = 0: PreviousY = 0: PreviousDif = 0: PreviousCT = 0


    ' Mass of the Sun = 1.9891 X 10^30
    'EarthSpeed = 29790 ' Earth Speed in m/s
    'EarthRadius = 6371000 'Earth Radius in Meters (6,371 km)
    'Earth Distance from Sun = 149.6 X 10^9 m
    'Earth Mass = 5.972 X 10^24 kg
    'G = 6.67408 x 10^-11 m^3 / kg s^2
    'G = 6.67408 x 10^-14 km^3 / kg s^2
    'EarthGM = 400200000000000 ' Earth G * M in m/sec^3
    'SunRadius = 695700000 ' Sun Radius in Meters (695,700 km)
    'EarthGM = 400200000000000 ' Earth G * M in m/sec^3
    'EarthRadius = 6371000 'Earth Radius in Meters (6,371 km)

    GravityConstant = 6.67408 * 10 ^ -11 ' m3/kg s = 6.67408 * 10^ -2 km3/kg s    NOTE G is in meters NOT km



    ' Mercury distance from sun = 57,908,000 km = 57,908,000,000 meters and the calculations are in m/sec NOT Km/sec
    ' Mercury Speed:47.36 km/s
    ' Mercury Mass = 3.301 X 10^23 kg
    ' Mercury Radius = 2439 km

    MercuryMass = 3.301 * 10 ^ 23
    MercuryCenterX = 57908000: MercuryCenterY = 0: MercuryCenterZ = 0
    MercurySpeedX = 0
    MercurySpeedY = 47360
    MercurySpeedZ = 0
    MercuryRadius = 2439
    GMercury = GravityConstant * MercuryMass

    ' Venus distance from sun = 108,208,000 km
    ' Venus Speed:35.02 km/s
    ' Venus Mass = 4.8675 X 10^23
    ' Venus Radius = 6051 km

    VenusMass = 4.8675 * 10 ^ 23
    VenusCenterX = 108208000: VenusCenterY = 0: VenusCenterZ = -5000000
    VenusSpeedX = 0
    VenusSpeedY = 35020
    VenusSpeedZ = 1600
    VenusRadius = 6051
    GVenus = GravityConstant * VenusMass



    'Earth Distance from Sun = 149.6 X 10^9 m
    'Earth002CenterX = -149600000: Earth002CenterY = 0: Earth002CenterZ = 0

    '                        Circle (0, 0), 149600000, _RGB(0, 0, 255), , , OrbitAspect ' Earth Orbit
    '                        Circle (0, 0), 147100000, _RGB(0, 0, 255), , , OrbitAspect ' Earth Orbit
    '                        Circle (0, 0), 152100000, _RGB(0, 0, 255), , , OrbitAspect ' Earth Orbit



    Earth002Mass = 5.972 * 10 ^ 24 ' mass of Earth in kg
    Earth002CenterX = 152100000: Earth002CenterY = 0: Earth002CenterZ = 0
    Earth002SpeedX = 0
    Earth002SpeedY = 29900
    Earth002SpeedZ = 0
    Earth002Radius = 6371
    GEarth002 = GravityConstant * Earth002Mass

    ' Mars distance from sun = 227,939,200 km average, but varies a lot. Max = 249,200,000; Min = 206,700,000
    ' Mars Speed:24.0 km/s average but varies a lot: Max = 26.5, Min = 22.0
    ' Mars Mass = 6.417 X 10^23
    ' Mars Radius = 3396 km

    MarsMass = 6.417 * 10 ^ 23

    MarsCenterX = 207000000 '249200000 max distance, MarsCenterX = 227939200 ' average ,  MarsCenterX = 206700000 ' min distance
    MarsCenterY = 0: MarsCenterZ = 0
    MarsSpeedX = 0
    MarsSpeedY = 27100 ' -22000 min speed, -24000 ' average,  -26500 ' max speed
    MarsSpeedZ = 0

    MarsRadius = 3396
    GMars = GravityConstant * MarsMass


    'Jupiter average distance from Sun: 778,479,000 km, Min = 740595000 km, Max = 816363000
    'Jupiter average speed: 13.07 km/s, Min =  12.44 km/s, Max = 13.72 Km/s
    'Jupiter Radius: 69911 km
    'Jupiter Mass: 1.8982 X 10^27
    JupiterMass = 1.8982 * 10 ^ 27
    JupiterCenterX = 740600000: JupiterCenterY = 0: JupiterCenterZ = 0
    JupiterSpeedX = 0
    JupiterSpeedY = 14000
    JupiterSpeedZ = 0
    JupiterRadius = 69911
    GJupiter = GravityConstant * JupiterMass


    If Scene$ = "Encke" Then ' Set Earth & Jupiter to about 40 degrees from north for Oct 16, 2023 setting, Saturn x=max
        MercuryCenterX = -24622784
        MercuryCenterY = -47366920
        MercurySpeedX = 43712
        MercurySpeedY = -27293
        VenusCenterX = -4650781
        VenusCenterY = 102720050
        VenusCenterZ = 4967992
        VenusSpeedX = -36756
        VenusSpeedY = -2976
        VenusSpeedZ = 1562
        Earth002CenterX = 71796872
        Earth002CenterY = 131750542
        Earth002SpeedX = -26843
        Earth002SpeedY = 14085
        MarsCenterX = -119297500
        MarsCenterY = -206744860
        MarsSpeedX = 21345
        MarsSpeedY = -10032
        JupiterCenterX = 356737501
        JupiterCenterY = 668936420
        JupiterSpeedX = -11810
        JupiterSpeedY = 6919
    End If



    ' distance from Jupiter 1070400 km  Jupiter distance from Sun 778,000,000 Plus 1,070,400 = 779,070,400
    '        GanymedeCenterX = -779070400: GanymedeCenterY = 0: GanymedeCenterZ = 0
    '        GanymedeSpeedX = 10880
    '        GanymedeSpeedY = 13071
    GanymedeMass = 6.417 * 10 ^ 22
    GanymedeCenterX = 741670400: GanymedeCenterY = 0: GanymedeCenterZ = 0
    GanymedeSpeedX = 0
    GanymedeSpeedY = JupiterSpeedY + 71
    GanymedeSpeedZ = 0
    GanymedeRadius = 2634
    GGanymede = GravityConstant * GanymedeMass



    'Saturn average distance from Sun: 1,433,530,000 km, Min = 1,352,550,000, Max = 1,514,500,000 km
    'Saturn speed: average 9.68 km/s, Max = 10.14 km/s, Min = 9.14
    'Saturn Radius: 58000 km
    'Saturn Mass: 5.6834 X 10^26
    SaturnMass = 5.6834 * 10 ^ 26

    SaturnCenterX = 1514500000: SaturnCenterY = 0: SaturnCenterZ = 0
    SaturnCenterX = 1459560000 ' From Astrograv, at Oct 26, 2023 _ Encke's closest approach to sun in 2023
    SaturnSpeedX = -500
    SaturnSpeedY = 9680 ' Saturn Average Orbital Speed, Wikipedia
    SaturnSpeedZ = 0
    SaturnRadius = 58000
    GSaturn = GravityConstant * SaturnMass


    ' Uranus distance from sun = 2,875,000,000 km
    ' Uranus Speed: 6.80 km/s
    ' Uranus Mass = 8.6810 X 10^25 kg
    ' Uranus Radius = 25,559 km

    UranusMass = 8.681 * 10 ^ 25
    UranusCenterX = 2730000000: UranusCenterY = 0: UranusCenterZ = 0
    UranusSpeedX = 0
    UranusSpeedY = 7330
    UranusSpeedZ = 0
    UranusRadius = 25559
    GUranus = GravityConstant * UranusMass


    ' Neptune distance from sun = 4,500,000,000 km
    ' Neptune Speed: 5.43 km/s
    ' Neptune Mass = 6.417 X 10^23
    ' Neptune Radius = 24,764 km

    NeptuneMass = 1.02413 * 10 ^ 26

    NeptuneCenterX = 4500000000: NeptuneCenterY = 0: NeptuneCenterZ = 0
    NeptuneSpeedX = 0
    NeptuneSpeedY = 5550
    NeptuneSpeedZ = 0
    NeptuneRadius = 24764
    GNeptune = GravityConstant * NeptuneMass


    If RunReverse$ = "Yes" Then
        MercurySpeedX = -43712
        MercurySpeedY = 27293
        VenusSpeedX = 36756
        VenusSpeedY = 2976
        VenusSpeedZ = -1562
        Earth002SpeedX = 26843
        Earth002SpeedY = -14085
        MarsSpeedX = -21345
        MarsSpeedY = 10032
        JupiterSpeedX = 11810
        JupiterSpeedY = -6919
        GanymedeSpeedY = 0
        SaturnSpeedX = 500
        SaturnSpeedY = -9680
        UranusSpeedY = -7330
        NeptuneSpeedY = -5550
        Exit Sub
    End If


    If InStr(Scene$, "Jupiter") > 0 Then
        Earth002CenterX = 150000000: Earth002CenterY = 0: Earth002CenterZ = 0 ' in JPL Comet database, planets run anti-clockwise, Dec 21 is at top.
        Earth002SpeedX = 0
        Earth002SpeedY = -29790
        Earth002SpeedZ = 0

        MarsCenterX = 227939200: MarsCenterY = 0: MarsCenterZ = 0
        MarsSpeedX = 0
        MarsSpeedY = -24000
        MarsSpeedZ = 0

        JupiterCenterX = -778000000: JupiterCenterY = 0: JupiterCenterZ = 0
        JupiterSpeedX = 0
        JupiterSpeedY = 13071
        JupiterSpeedZ = 0
        JupiterRadius = 69911

        GanymedeCenterX = -779570400: GanymedeCenterY = 0: GanymedeCenterZ = 0
        GanymedeSpeedX = 0
        GanymedeSpeedY = 13071 + 0
        GanymedeSpeedZ = 0

        SaturnCenterX = 1433530000: SaturnCenterY = 0: SaturnCenterZ = 0
        SaturnSpeedX = 0
        SaturnSpeedY = -9680
        SaturnSpeedZ = 0


        UranusCenterX = 2875000000: UranusCenterY = 0: UranusCenterZ = 0
        UranusSpeedX = 0
        UranusSpeedY = -6800
        UranusSpeedZ = 0


        NeptuneCenterX = 4500000000: NeptuneCenterY = 0: NeptuneCenterZ = 0
        NeptuneSpeedX = 0
        NeptuneSpeedY = -5430
        NeptuneSpeedZ = 0


        SunCenterX = 0: SunCenterY = 0: SunCenterZ = 0
        SunMass = 1.9891 * 10 ^ 30 ' mass of Sun in kg *1000
        GSun = GravityConstant * SunMass
        GEarth = GSun ' In case I missed smething

        CometInitialSpeedX = 0 ' m/sec
        CometInitialSpeedY = 42600 ' m/sec
        CometStartX = -150000000: CometStartY = 0

    End If
    If Scene$ = "Impact Earth not Jupiter" Then
        Earth002CenterX = 0: Earth002CenterY = 150000000 ' in JPL Comet database, planets run anti-clockwise, Dec 21 is at top.
        Earth002SpeedX = -29790
        Earth002SpeedY = 0
        MarsSpeedY = 24000
        SaturnSpeedY = 9680
        UranusSpeedY = 6800
        NeptuneSpeedY = 5430

        JupiterCenterX = 740600000
        JupiterSpeedY = 14000
        GanymedeCenterX = 741670400
        GanymedeSpeedY = JupiterSpeedY + 71
    End If
End Sub

Sub DrawPlanetsJupiter
    ' Draw Earth002                *****************************************************************************************************************************************************

    Earth002Distance = Sqr((Earth002CenterX - SunCenterX) ^ 2 + (Earth002CenterY - SunCenterY) ^ 2) ' Distance is distance fom planet center to Sun center
    If Earth002Distance < 1000 Then Earth002Distance = 1000
    Earth002Acceleration = (GSun / (Earth002Distance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
    Earth002SpeedX = Earth002SpeedX + ((Earth002Acceleration / Earth002Distance) * (SunCenterX - Earth002CenterX)) * SunZoomFactor
    Earth002SpeedY = Earth002SpeedY + ((Earth002Acceleration / Earth002Distance) * (SunCenterY - Earth002CenterY)) * SunZoomFactor
    Earth002CenterX = Earth002CenterX + Earth002SpeedX * SpeedUpFactor
    Earth002CenterY = Earth002CenterY + Earth002SpeedY * SpeedUpFactor
    Circle (Earth002CenterX, Earth002CenterY), 5000000, _RGB(0, 0, 255)
    Circle (Earth002CenterX, Earth002CenterY), 6000000, _RGB(0, 0, 255)
    Circle (Earth002CenterX, Earth002CenterY), 7000000, _RGB(0, 0, 255)

    ' Draw Mars                *****************************************************************************************************************************************************

    MarsDistance = Sqr((MarsCenterX - SunCenterX) ^ 2 + (MarsCenterY - SunCenterY) ^ 2) ' Distance is distance fom planet center to Sun center
    If MarsDistance < 1000 Then MarsDistance = 1000
    MarsAcceleration = (GSun / (MarsDistance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
    MarsSpeedX = MarsSpeedX + ((MarsAcceleration / MarsDistance) * (SunCenterX - MarsCenterX)) * SunZoomFactor
    MarsSpeedY = MarsSpeedY + ((MarsAcceleration / MarsDistance) * (SunCenterY - MarsCenterY)) * SunZoomFactor
    MarsCenterX = MarsCenterX + MarsSpeedX * SpeedUpFactor
    MarsCenterY = MarsCenterY + MarsSpeedY * SpeedUpFactor
    Circle (MarsCenterX, MarsCenterY), 2500000, _RGB(255, 0, 0)
    Circle (MarsCenterX, MarsCenterY), 3000000, _RGB(255, 0, 0)
    Circle (MarsCenterX, MarsCenterY), 3500000, _RGB(255, 0, 0)

    ' Draw Jupiter                *****************************************************************************************************************************************************

    JupiterDistance = Sqr((JupiterCenterX - SunCenterX) ^ 2 + (JupiterCenterY - SunCenterY) ^ 2) ' Distance is distance fom planet center to Sun center
    If JupiterDistance < 1000 Then JupiterDistance = 1000
    JupiterAcceleration = (GSun / (JupiterDistance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
    JupiterSpeedX = JupiterSpeedX + ((JupiterAcceleration / JupiterDistance) * (SunCenterX - JupiterCenterX)) * SunZoomFactor
    JupiterSpeedY = JupiterSpeedY + ((JupiterAcceleration / JupiterDistance) * (SunCenterY - JupiterCenterY)) * SunZoomFactor
    JupiterCenterX = JupiterCenterX + JupiterSpeedX * SpeedUpFactor
    JupiterCenterY = JupiterCenterY + JupiterSpeedY * SpeedUpFactor
    Circle (JupiterCenterX, JupiterCenterY), 10000, _RGB(255, 255, 0)
    Circle (JupiterCenterX, JupiterCenterY), 10000000, _RGB(255, 155, 50)
    Circle (JupiterCenterX, JupiterCenterY), 12000000, _RGB(255, 155, 50)
    Circle (JupiterCenterX, JupiterCenterY), 14000000, _RGB(255, 155, 50)


    'Draw Ganymede                *****************************************************************************************************************************************************
    GanymedeDistance = Sqr((GanymedeCenterX - SunCenterX) ^ 2 + (GanymedeCenterY - SunCenterY) ^ 2) ' Distance is distance fom Ganymede center to Jupiter Center
    If GanymedeDistance < 1000 Then GanymedeDistance = 1000
    GanymedeAcceleration = (GSun / (GanymedeDistance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
    GanymedeSpeedX = GanymedeSpeedX + ((GanymedeAcceleration / GanymedeDistance) * (SunCenterX - GanymedeCenterX)) * SunZoomFactor
    GanymedeSpeedY = GanymedeSpeedY + ((GanymedeAcceleration / GanymedeDistance) * (SunCenterY - GanymedeCenterY)) * SunZoomFactor
    GanymedeCenterX = GanymedeCenterX + GanymedeSpeedX * SpeedUpFactor
    GanymedeCenterY = GanymedeCenterY + GanymedeSpeedY * SpeedUpFactor

    GanymedeDistance = Sqr((GanymedeCenterX - JupiterCenterX) ^ 2 + (GanymedeCenterY - JupiterCenterY) ^ 2) ' Distance is distance fom Ganymede center to Jupiter Center
    If GanymedeDistance < 1000 Then GanymedeDistance = 1000
    GanymedeAcceleration = (GJupiter / (GanymedeDistance ^ 2)) / 1000 ^ 3 '
    GanymedeSpeedX = GanymedeSpeedX + (GanymedeAcceleration / GanymedeDistance) * (JupiterCenterX - GanymedeCenterX) * SunZoomFactor
    GanymedeSpeedY = GanymedeSpeedY + (GanymedeAcceleration / GanymedeDistance) * (JupiterCenterY - GanymedeCenterY) * SunZoomFactor
    GanymedeCenterX = GanymedeCenterX + GanymedeSpeedX * SpeedUpFactor
    GanymedeCenterY = GanymedeCenterY + GanymedeSpeedY * SpeedUpFactor

    Circle (GanymedeCenterX, GanymedeCenterY), 250000, _RGB(255, 155, 255)
    Circle (GanymedeCenterX, GanymedeCenterY), 300000, _RGB(255, 155, 255)
    Circle (GanymedeCenterX, GanymedeCenterY), 350000, _RGB(255, 255, 255)



    ' Draw Saturn                *****************************************************************************************************************************************************

    SaturnDistance = Sqr((SaturnCenterX - SunCenterX) ^ 2 + (SaturnCenterY - SunCenterY) ^ 2) ' Distance is distance fom planet center to Sun center
    If SaturnDistance < 1000 Then SaturnDistance = 1000
    SaturnAcceleration = (GSun / (SaturnDistance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
    SaturnSpeedX = SaturnSpeedX + ((SaturnAcceleration / SaturnDistance) * (SunCenterX - SaturnCenterX)) * SunZoomFactor
    SaturnSpeedY = SaturnSpeedY + ((SaturnAcceleration / SaturnDistance) * (SunCenterY - SaturnCenterY)) * SunZoomFactor
    SaturnCenterX = SaturnCenterX + SaturnSpeedX * SpeedUpFactor
    SaturnCenterY = SaturnCenterY + SaturnSpeedY * SpeedUpFactor
    '    CIRCLE (SaturnCenterX, SaturnCenterY / 10), 11000000, _RGB(255, 255, 0)
    '    CIRCLE (SaturnCenterX, SaturnCenterY / 10), 13000000, _RGB(255, 255, 0)
    '    CIRCLE (SaturnCenterX, SaturnCenterY / 10), 16000000, _RGB(255, 255, 0)
    Circle (SaturnCenterX, SaturnCenterY), 11000000, _RGB(255, 255, 0)
    Circle (SaturnCenterX, SaturnCenterY), 13000000, _RGB(255, 255, 0)
    Circle (SaturnCenterX, SaturnCenterY), 16000000, _RGB(255, 255, 0)

    ' Draw Uranus               *****************************************************************************************************************************************************

    UranusDistance = Sqr((UranusCenterX - SunCenterX) ^ 2 + (UranusCenterY - SunCenterY) ^ 2) ' Distance is distance fom planet center to Sun center
    If UranusDistance < 1000 Then UranusDistance = 1000
    UranusAcceleration = (GSun / (UranusDistance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
    UranusSpeedX = UranusSpeedX + ((UranusAcceleration / UranusDistance) * (SunCenterX - UranusCenterX)) * SunZoomFactor
    UranusSpeedY = UranusSpeedY + ((UranusAcceleration / UranusDistance) * (SunCenterY - UranusCenterY)) * SunZoomFactor
    UranusCenterX = UranusCenterX + UranusSpeedX * SpeedUpFactor
    UranusCenterY = UranusCenterY + UranusSpeedY * SpeedUpFactor
    '    CIRCLE (UranusCenterX, UranusCenterY / 10), 11000000, _RGB(255, 0, 255)
    '    CIRCLE (UranusCenterX, UranusCenterY / 10), 13000000, _RGB(255, 0, 255)
    '    CIRCLE (UranusCenterX, UranusCenterY / 10), 16000000, _RGB(255, 0, 255)
    Circle (UranusCenterX, UranusCenterY), 11000000, _RGB(0, 255, 0)
    Circle (UranusCenterX, UranusCenterY), 13000000, _RGB(0, 255, 0)
    Circle (UranusCenterX, UranusCenterY), 16000000, _RGB(0, 255, 0)


    ' Draw Neptune               *****************************************************************************************************************************************************

    NeptuneDistance = Sqr((NeptuneCenterX - SunCenterX) ^ 2 + (NeptuneCenterY - SunCenterY) ^ 2) ' Distance is distance fom planet center to Sun center
    If NeptuneDistance < 1000 Then NeptuneDistance = 1000
    NeptuneAcceleration = (GSun / (NeptuneDistance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
    NeptuneSpeedX = NeptuneSpeedX + ((NeptuneAcceleration / NeptuneDistance) * (SunCenterX - NeptuneCenterX)) * SunZoomFactor
    NeptuneSpeedY = NeptuneSpeedY + ((NeptuneAcceleration / NeptuneDistance) * (SunCenterY - NeptuneCenterY)) * SunZoomFactor
    NeptuneCenterX = NeptuneCenterX + NeptuneSpeedX * SpeedUpFactor
    NeptuneCenterY = NeptuneCenterY + NeptuneSpeedY * SpeedUpFactor
    '    CIRCLE (NeptuneCenterX, NeptuneCenterY / 10), 11000000, _RGB(0, 255, 255)
    '    CIRCLE (NeptuneCenterX, NeptuneCenterY / 10), 13000000, _RGB(0, 255, 255)
    '    CIRCLE (NeptuneCenterX, NeptuneCenterY / 10), 16000000, _RGB(0, 255, 255)
    Circle (NeptuneCenterX, NeptuneCenterY), 11000000, _RGB(0, 255, 255)
    Circle (NeptuneCenterX, NeptuneCenterY), 13000000, _RGB(0, 255, 255)
    Circle (NeptuneCenterX, NeptuneCenterY), 16000000, _RGB(0, 255, 255)


    'Draw Sun on grid:
    For i = 1 To DrawSunRadius Step DrawSunRadius / 30
        Circle (SunCenterX, SunCenterY), i, _RGB(255, 255, 0)
    Next i

    If CometPAthOnOff = 1 And CometTime > 10 Then 'draw line showing path of comet
        A = 100 * (CometX(CometCenterX, CometCenterY) - CometLastCenterX)
        B = 100 * (CometY(CometCenterX, CometCenterY) - CometLastCenterY)
        Line (CometX(CometCenterX, CometCenterY) - A, CometY(CometCenterX, CometCenterY) - B)-(A + CometX(CometCenterX, CometCenterY), B + CometY(CometCenterX, CometCenterY)), _RGB(255, 0, 0)
    End If

    CometLastCenterX = CometLastCenterX2: CometLastCenterY = CometLastCenterY2
    CometLastCenterX2 = CometLastCenterX3: CometLastCenterY2 = CometLastCenterY3
    CometLastCenterX3 = CometX(CometCenterX, CometCenterY): CometLastCenterY3 = CometY(CometCenterX, CometCenterY)
    CDistance = Sqr((CometX(CometCenterX, CometCenterY) - SunCenterX) ^ 2 + (CometY(CometCenterX, CometCenterY) - SunCenterY) ^ 2)
    If StartImpactTime = 0 And CDistance - CometRadius < SunRadius Then StartImpactTime = CometTime
    If StartImpactTime > 0 And EndImpactTime = 0 And CDistance - CometRadius > SunRadius Then EndImpactTime = CometTime


End Sub



Sub DemoShapes
    ' 3D version
    ' Planet Center = 0,0,0
    PlanetRadius = 6371
    ImpactProbView$ = "Top"
    ShowBigComet$ = "No"
    ShowPlanetDebris$ = "Yes"
    ShowFlyingDebris$ = "Yes"
    ShowShockEffect$ = "Yes"

    Call WorldCoordinates
    ZoomWindow1 = -14850: ZoomWindow2 = -9355: ZoomWindow3 = 14850: ZoomWindow4 = 7355 ' Center on Earth = 0,0 co-ordinates =  same as pressing End key plus Page Up
    '    ZoomWindow1 = -7425: ZoomWindow2 = -177: ZoomWindow3 = 7425: ZoomWindow4 = 8177 ' Center on Earth = 0,0 co-ordinates =  same as pressing End key plus Page Up
    '    ZoomWindow1 = -3712: ZoomWindow2 = 4411: ZoomWindow3 = 3712: ZoomWindow4 = 8589 ' Center on Earth = 0,0 co-ordinates =  same as pressing End key plus Page Up
    ZoomScale = .2: ZoomShift = 7000
    ZoomWindow1 = ZoomWindow1 * ZoomScale
    ZoomWindow2 = ZoomWindow2 * ZoomScale + ZoomShift
    ZoomWindow3 = ZoomWindow3 * ZoomScale
    ZoomWindow4 = ZoomWindow4 * ZoomScale + ZoomShift


    ReStartDemo:

    CometRadius = 30
    ToggleRadius = CometRadius

    StartX = 20000 ' perfect X for long skip  = 20,000  @ -40 km/s
    StartY = 6565 ' perfect Y for long skip  = 6,530 @ -.1 km/s
    CometInitialSpeedX = -40 ' km/sec
    CometInitialSpeedY = -.10 ' km/sec
    CometAngleofApproach = 0.4
    CursorCometSpeed = -40
    CometInitialX = StartX
    CometInitialY = StartY
    CometInitialZ = StartZ


    '  ############################################    *********************************  @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@   ***********************************************    #######################################


    BeginImpactProbabilities:

    StartZ = 0
    CometInitialSpeedZ = 0 ' km/sec ' this is essentially a 2D demo, so Z is always 0
    StartX = CometInitialX
    StartY = CometInitialY
    StartZ = CometInitialZ

    PointsTotal = 500
    TimeFactor = 5 '  how much to slow down the demo by calculating many steps per second
    PointsTotal = (PointsTotal / TimeFactor) * 20
    If PointsTotalFromMenu > 1000 Then PointsTotal = PointsTotalFromMenu Else PointsTotalFromMenu = PointsTotal
    DistanceLessThanTop$ = "No"
    CombinedAngle = 0

    ' Draw Earth Points available to be hit
    For i = 0 To 3000
        For j = 0 To 450
            DemoEarthPoints(i, j) = 0
            K = PlanetRadius - j
            If Sqr((i - 1500) ^ 2 + K * K) < PlanetRadius Then DemoEarthPoints(i, j) = 1
        Next j
    Next i
    MaxEarthJ = 0

    '    CometParticleMax = CometRadius * 2 ' if always 150X150 then small comets dig deeper holes. This sets most comets comparitively to give similar results.
    '    IF CometParticleMax > 150 THEN CometParticleMax = 150
    CometParticleMax = CometRadius * 3 ' if always 300X300 then small comets dig deeper holes. This sets most comets comparitively to give similar results.
    If CometParticleMax > 300 Then CometParticleMax = 300

    For x = 1 To CometParticleMax
        For y = 1 To CometParticleMax
            XRND = (Rnd(98) - .5) * CometRadius * 2 ' = +/- 0 to Comet Radius
            YRND = (Rnd(97) - .5) * CometRadius * 2 ' = +/- 0 to Comet Radius
            ZRND = (Rnd(96) - .5) * CometRadius * 2 ' = +/- 0 to Comet Radius
            w = Sqr(XRND ^ 2 + YRND ^ 2 + ZRND ^ 2): LoopCount = 0
            While w > CometRadius And LoopCount < 5
                LoopCount = LoopCount + 1
                XRND = (Rnd(98) - .5) * CometRadius * 2 ' = +/- 0 to Comet Radius
                YRND = (Rnd(97) - .5) * CometRadius * 2 ' = +/- 0 to Comet Radius
                ZRND = (Rnd(96) - .5) * CometRadius * 2 ' = +/- 0 to Comet Radius
                If LoopCount = 2 Then ZRND = 0 ' Bias some more particles to be on Z=0 plane for smoother interaction with Earth particles for large comets.
                w = Sqr(XRND ^ 2 + YRND ^ 2 + ZRND ^ 2)
            Wend
            DemoCometMass(x, y) = 1.2 ' mass of 1.2 = traveling in space, Mass of 1 = hit earth
            If LoopCount > 4 Then DemoCometMass(x, y) = 0 ' prevents infinite loops
            DemoCometX(x, y) = XRND: DemoCometY(x, y) = YRND: DemoCometZ(x, y) = ZRND
            DemoCometSpeedX(x, y) = CometInitialSpeedX
            DemoCometSpeedY(x, y) = CometInitialSpeedY
            DemoCometSpeedZ(x, y) = CometInitialSpeedZ
            DemoCometColor(x, y) = _RGB(255, 255, 255) ' _RGB(255, (255 * w / CometRadius), 0)
            If w > CometRadius * .8 Then DemoCometColor(x, y) = _RGB(255, 0, 0)
            If w > CometRadius * .5 And w < CometRadius * .8 Then DemoCometColor(x, y) = _RGB(0, 0, 255)

        Next y
    Next x

    DemoCometX(0, 0) = 0: DemoCometY(0, 0) = 0: DemoCometZ(0, 0) = 0
    DemoCometSpeedX(0, 0) = CometInitialSpeedX: DemoCometSpeedY(0, 0) = CometInitialSpeedY: DemoCometSpeedZ(0, 0) = CometInitialSpeedZ
    DemoCometMass(0, 0) = 1.2


    'Shift comet center to where we want it on grid 15,000 X 7,500 1 km spacings
    'start simulation with comet center at:
    For x = 0 To 300
        For y = 0 To 300
            DemoCometX(x, y) = DemoCometX(x, y) + StartX
            DemoCometY(x, y) = DemoCometY(x, y) + StartY
            DemoCometZ(x, y) = DemoCometZ(x, y) + StartZ
        Next y
    Next x


    For Cii = 0 To 400 '  Blank out any previous comet impact circles
        For Cjj = 0 To 300
            CometX(Cii, Cjj) = 0: CometY(Cii, Cjj) = 0: CometZ(Cii, Cjj) = 0
            CometMass(Cii, Cjj) = 0: CometSize(Cii, Cjj) = 0
            CometColor(Cii, Cjj) = _RGB(0, 0, 0)
        Next Cjj
    Next Cii


    If ToggleRadius = 0 Then CometRadius = 30 Else CometRadius = ToggleRadius 'Comet diameter = 2 X CometRadius, with 1 pixel = 1 km size

    For i = 0 To 100: ImpactAngleProbs(i) = 0: ImpactAngleProbPercents(i) = 0: Next i ' set ImpactAngleProbs(0) as misses, ImpactAngleProbs(1) for 0-5 degrees, ImpactAngleProbs(2) as 5 to 10 etc.
    RunImpactProbabilities$ = ""
    NumPointsHitting = 0
    TotalPointsCalculated = 0


    Cii = 1: Cjj = 0: CometIIcount = 0


    Y1 = 1
    CometIIcount = 1
    CometContinuing = 0
    TotalPointsCalculated = TotalPointsCalculated + 1

    PointstoDraw = 1
    CometPathSpeedX = CometInitialSpeedX
    CometPathSpeedY = CometInitialSpeedY
    CometPathSpeedZ = CometInitialSpeedZ
    PreviousImpactThickness = 0
    ItHasImpactedOnBottom = 0

    ' ##################################################  BEGIN MAIN CALCULATION  #######################################################################################

    While PointstoDraw < PointsTotal

        Distance = Sqr(StartX ^ 2 + StartY ^ 2 + StartZ ^ 2)
        If Distance > PlanetRadius + CometRadius * 1.5 Then
            ' Check if comet shrinking from gravity / path with intersection, and if so, then correct. But only do so if far from planet
            MaxRadius = 0
            For x = 1 To CometParticleMax
                For y = 1 To CometParticleMax
                    If DemoCometMass(x, y) = 1.2 Then
                        w = Sqr((DemoCometX(x, y) - DemoCometX(0, 0)) ^ 2 + (DemoCometY(x, y) - DemoCometY(0, 0)) ^ 2 + (DemoCometZ(x, y) - DemoCometZ(0, 0)) ^ 2) ' w is always > 0
                        If MaxRadius < w Then MaxRadius = w
                    End If
                Next y
            Next x
            '            LOCATE 20, 20: PRINT "MaxRadius", MaxRadius
            '            _DISPLAY
            If MaxRadius < CometRadius / 5 Then MaxRadius = 1 ' partial comet ?
            If MaxRadius < CometRadius * .995 Or MaxRadius > CometRadius * 1.005 Then
                ModifyRadius = CometRadius / MaxRadius
                For x = 1 To CometParticleMax
                    For y = 1 To CometParticleMax
                        If DemoCometMass(x, y) = 1.2 Then
                            DemoCometX(x, y) = (DemoCometX(x, y) - DemoCometX(0, 0)) * ModifyRadius + DemoCometX(0, 0)
                            DemoCometY(x, y) = (DemoCometY(x, y) - DemoCometY(0, 0)) * ModifyRadius + DemoCometY(0, 0)
                            DemoCometZ(x, y) = (DemoCometZ(x, y) - DemoCometZ(0, 0)) * ModifyRadius + DemoCometZ(0, 0)
                        End If
                    Next y
                Next x
            End If
        End If

        Cls
        Distance = Sqr(StartX ^ 2 + StartY ^ 2 + StartZ ^ 2)
        If Distance < PlanetRadius + CometRadius And DistanceLessThanTop$ <> "Yes" Then '  BOTTOM of comet is hitting  ************************
            DotXY = (PreviousX * (StartX - PreviousX) + PreviousY * (StartY - PreviousY) + PreviousZ * (StartZ - PreviousZ))
            XYMagnitude = ((StartX - PreviousX) ^ 2 + (StartY - PreviousY) ^ 2 + (StartZ - PreviousZ) ^ 2) ^ 0.5 * (StartX ^ 2 + StartY ^ 2 + StartZ ^ 2) ^ 0.5

            Checkangle = 1
            If Abs(XYMagnitude) > .0000001 Then Checkangle = DotXY / XYMagnitude
            If Abs(Checkangle) > 1 Then Checkangle = 1
            AngleofImpact = ARCCOS(Checkangle) * 180 / pi '   or 90 degrees minus that
            CombinedAngle = AngleofImpact - 90

            ItHasImpactedOnBottom = 1
            PointsTotal = PointsTotal + 5 ' do not start removing points while it is still hitting

            ImpactThickness = PlanetRadius + CometRadius - Distance
            Cjj = Cjj + 1: If Cjj > 300 Then Cjj = 1: Cii = Cii + 1: CometIIcount = CometIIcount + 1: If CometIIcount > 400 Then CometIIcount = 400
            If Cii > 400 Then Cii = 400
            CometX(Cii, Cjj) = StartX: CometY(Cii, Cjj) = StartY: CometZ(Cii, Cjj) = StartZ
            CometMass(Cii, Cjj) = 1

            If ImpactThickness > PreviousImpactThickness Then '  if less then its leaving the planet surface not still impacting
                If ImpactThickness <= CometRadius * 2 Then CircleRad = Sqr(CometRadius ^ 2 - (CometRadius - ImpactThickness) ^ 2)
                '                LOCATE 20, 20: PRINT "CircleRad: ", CircleRad
                CometSize(Cii, Cjj) = CircleRad '* 2
                If ShowShockEffect$ = "Yes" Then CometSize(Cii, Cjj) = CircleRad * 2
                If ShowShockEffect$ = "Yes4X" Then CometSize(Cii, Cjj) = CircleRad * 4
                CometColor(Cii, Cjj) = _RGB(0, 155, 155)
                If CombinedAngle < 15 Then CometColor(Cii, Cjj) = _RGB(155, 155, 255)
                If CombinedAngle < 10 Then CometColor(Cii, Cjj) = _RGB(255, 255, 155)
                If CombinedAngle < 5 Then CometColor(Cii, Cjj) = _RGB(255, 155, 155)
                If CombinedAngle < 2 Then CometColor(Cii, Cjj) = _RGB(255, 0, 0)
                If CombinedAngle > 40 And CombinedAngle < 50 Then CometColor(Cii, Cjj) = _RGB(0, 205, 155)
                If CombinedAngle >= 80 Then CometColor(Cii, Cjj) = _RGB(0, 255, 255)
                PreviousImpactThickness = ImpactThickness
            End If
        End If


        If Distance < PlanetRadius - CometRadius And DistanceLessThanTop$ <> "Yes" Then '********************************* HIT PLANET by TOP of comet *************************************************************************************
            DistanceLessThanTop$ = "Yes"
            CometSpeedAtImpact = Sqr(CometPathSpeedX ^ 2 + CometPathSpeedY ^ 2 + CometPathSpeedZ ^ 2)

            DotXY = (PreviousX * (StartX - PreviousX) + PreviousY * (StartY - PreviousY) + PreviousZ * (StartZ - PreviousZ))
            XYMagnitude = ((StartX - PreviousX) ^ 2 + (StartY - PreviousY) ^ 2 + (StartZ - PreviousZ) ^ 2) ^ 0.5 * (StartX ^ 2 + StartY ^ 2 + StartZ ^ 2) ^ 0.5

            Checkangle = 1
            If Abs(XYMagnitude) > .0000001 Then Checkangle = DotXY / XYMagnitude
            If Abs(Checkangle) > 1 Then Checkangle = 1
            AngleofImpact = ARCCOS(Checkangle) * 180 / pi '   or 90 degrees minus that
            CombinedAngle = AngleofImpact - 90

            Cjj = Cjj + 1: If Cjj > 300 Then Cjj = 1: Cii = Cii + 1: CometIIcount = CometIIcount + 1: If CometIIcount > 400 Then CometIIcount = 400
            If Cii > 400 Then Cii = 400
            CometX(Cii, Cjj) = StartX: CometY(Cii, Cjj) = StartY: CometZ(Cii, Cjj) = StartZ
            CometMass(Cii, Cjj) = 1
            CometColor(Cii, Cjj) = _RGB(255, 255, 150)
        End If


        EAcc = ((GEarth / (Distance ^ 2)) / 1000 ^ 3) * TimeFactor
        CometPathSpeedX = CometPathSpeedX + (EAcc / Distance) * -StartX
        CometPathSpeedY = CometPathSpeedY + (EAcc / Distance) * -StartY
        CometPathSpeedZ = CometPathSpeedZ + (EAcc / Distance) * -StartZ

        PreviousX = StartX
        PreviousY = StartY
        PreviousZ = StartZ
        StartX = StartX + CometPathSpeedX * TimeFactor
        StartY = StartY + CometPathSpeedY * TimeFactor
        StartZ = StartZ + CometPathSpeedZ * TimeFactor
        PointstoDraw = PointstoDraw + 1

        DemoCometSpeedX(0, 0) = DemoCometSpeedX(0, 0) + (EAcc / Distance) * -DemoCometX(0, 0)
        DemoCometSpeedY(0, 0) = DemoCometSpeedY(0, 0) + (EAcc / Distance) * -DemoCometY(0, 0)
        DemoCometSpeedZ(0, 0) = DemoCometSpeedZ(0, 0) + (EAcc / Distance) * -DemoCometZ(0, 0)
        DemoCometX(0, 0) = DemoCometX(0, 0) + DemoCometSpeedX(0, 0) * TimeFactor
        DemoCometY(0, 0) = DemoCometY(0, 0) + DemoCometSpeedY(0, 0) * TimeFactor
        DemoCometZ(0, 0) = DemoCometZ(0, 0) + DemoCometSpeedZ(0, 0) * TimeFactor
        DemoDistance = Sqr(DemoCometX(0, 0) ^ 2 + DemoCometY(0, 0) ^ 2 + DemoCometZ(0, 0) ^ 2)
        If DemoDistance < PlanetRadius - CometRadius Then DemoCometMass(0, 0) = 0

        For x = 1 To CometParticleMax
            For y = 1 To CometParticleMax
                If DemoCometMass(x, y) > 1 Then
                    DemoCometSpeedX(x, y) = DemoCometSpeedX(x, y) + (EAcc / Distance) * -DemoCometX(x, y)
                    DemoCometSpeedY(x, y) = DemoCometSpeedY(x, y) + (EAcc / Distance) * -DemoCometY(x, y)
                    DemoCometSpeedZ(x, y) = DemoCometSpeedZ(x, y) + (EAcc / Distance) * -DemoCometZ(x, y)
                    DemoCometX(x, y) = DemoCometX(x, y) + DemoCometSpeedX(x, y) * TimeFactor
                    DemoCometY(x, y) = DemoCometY(x, y) + DemoCometSpeedY(x, y) * TimeFactor
                    DemoCometZ(x, y) = DemoCometZ(x, y) + DemoCometSpeedZ(x, y) * TimeFactor
                    DemoDistance = Sqr(DemoCometX(x, y) ^ 2 + DemoCometY(x, y) ^ 2 + DemoCometZ(x, y) ^ 2)
                    If DemoDistance < PlanetRadius Then
                        i = Int(DemoCometX(x, y)) + 1500: j = PlanetRadius - Int(DemoCometY(x, y))
                        K = Int(DemoCometZ(x, y))
                        If i < 0 Then i = 0
                        If i > 3000 Then i = 3000
                        If j < 0 Then j = 0
                        If j > 448 Then j = 448
                        If DemoEarthPoints(i, j) = 1 Then
                            If K = 1 Or K = 0 Then DemoEarthPoints(i, j) = 2 ' EarthPoints are 2 D, so only remove Earth Points if DemoCometZ is on center plane or 0 to 1
                            If K = 1 Or K = 0 And Abs(DemoCometSpeedY(x, y)) < 4 Then
                                DemoEarthPoints(i, j + 1) = 2 'Remove some more points - too little is going away at present. But for vertical impacts, it takes away too many so skip for small Y
                                DemoEarthPoints(i, j + 2) = 2
                            End If
                            DemoCometMass(x, y) = DemoCometMass(x, y) - .06
                            '   DemoCometMass(x, y) = 0
                            DemoCometSpeedX(x, y) = DemoCometSpeedX(x, y) * (Rnd(99) + .5) + 30 * (Rnd(34) - .5)
                            DemoCometSpeedY(x, y) = DemoCometSpeedY(x, y) * (Rnd(98) + .5) + 30 * (Rnd(34) - .5)
                            DemoCometSpeedZ(x, y) = DemoCometSpeedZ(x, y) * (Rnd(98) + .5) + 30 * (Rnd(34) - .5)
                            If MaxEarthJ <= j + 2 Then MaxEarthJ = j + 2

                        End If
                    End If
                End If
            Next y
        Next x


        '                            #####################################   DRAW COMET AND EARTH       ############################################################

        ZoomWindow1 = -2970: ZoomWindow2 = 4729: ZoomWindow3 = 2970: ZoomWindow4 = 8071
        ZoomWindow1 = -1333: ZoomWindow2 = 5650: ZoomWindow3 = 1333: ZoomWindow4 = 7150
        Window (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, ZoomWindow4)


        Circle (0, 0), PlanetRadius, _RGB(0, 0, 155) ' Draw Earth
        Paint (0, 6000), _RGB(0, 0, 155), _RGB(0, 0, 155) ' PAINT needs to be inside the circle, and you list the border color of the circle after the co-ordinates and desired fill color.

        BottomWindow = (ZoomWindow4 - ZoomWindow2) * .3 + ZoomWindow2
        MidBottomWindow = (BottomWindow - ZoomWindow2) / 2 + ZoomWindow2
        Line (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, BottomWindow), _RGB(0, 0, 25), BF
        Line (ZoomWindow1, BottomWindow - 22)-(ZoomWindow3, BottomWindow), _RGB(215, 215, 215), BF
        ' Km tick marks for scale
        For xi = -1500 To 1500 Step 100
            Line (xi, 5650)-(xi, 5690), _RGB(155, 155, 0)
        Next xi
        For xi = -1000 To 1000 Step 1000
            Line (xi, 5650)-(xi, 5695), _RGB(255, 0, 0)
        Next xi

        Color _RGB(0, 0, 0), _RGB(215, 215, 215)
        _PrintString (25, 699), "Lower scene is the View from Above.     Upper scene is the View from the side.        Relative depth of crater is shown in red, indicating a comet particle hitting an Earth particle with no shock effects."
        Color _RGB(255, 255, 255), _RGB(0, 0, 0)

        ' Draw Earth Points available to be hit
        For i = 0 To 3000
            For j = 0 To MaxEarthJ ' Display available Earth Points to interact with
                If DemoEarthPoints(i, j) = 1 Then PSet (i - 1500, PlanetRadius - j), _RGB(30, 30, 185)
            Next j
        Next i



        If ShowBigComet$ = "Yes" Then ' Show big image of comet, stationary in upper left
            For x = 1 To CometParticleMax
                For y = 1 To CometParticleMax
                    If DemoCometMass(x, y) = 1.2 Then
                        PSet ((DemoCometX(x, y) - DemoCometX(0, 0)) * 5 - 800, (DemoCometY(x, y) - DemoCometY(0, 0)) * 5 + 6700), DemoCometColor(x, y)
                    End If
                Next y
            Next x
        End If



        If DemoCometX(0, 0) < -2200 Or DemoCometY(0, 0) < 5000 Then TimeFactor = 5
        If DemoCometX(0, 0) < ZoomWindow3 And DemoCometY(0, 0) < ZoomWindow4 Then
            If ItHasImpactedOnBottom <> 1 Then TimeFactor = .5 ' slow down for closeup part of scene
            For x = 1 To CometParticleMax
                For y = 1 To CometParticleMax
                    If ShowPlanetDebris$ = "Yes" Then PSet (DemoCometX(x, y), DemoCometY(x, y)), _RGB(255, 255, 255) ' shows the ones that hit Earth in upper screen
                    Select Case DemoCometMass(x, y)
                        Case 1.2 ' Comet in flight
                            PSet (DemoCometX(x, y), DemoCometY(x, y)), DemoCometColor(x, y)
                            '                            CIRCLE ((DemoCometX(x, y) - DemoCometX(0, 0)) * 2 + DemoCometX(0, 0), DemoCometZ(x, y) * 2 + MidBottomWindow), 2, DemoCometColor(x, y) ' 2X Diameter
                            Circle ((DemoCometX(x, y) - DemoCometX(0, 0)) + DemoCometX(0, 0), DemoCometZ(x, y) + MidBottomWindow), 2, DemoCometColor(x, y)
                        Case Is > 1 ' Show scattered points
                            If ShowFlyingDebris$ = "Yes" Then
                                PSet (DemoCometX(x, y), DemoCometY(x, y)), DemoCometColor(x, y)
                                Circle ((DemoCometX(x, y) - DemoCometX(0, 0)) * 2 + DemoCometX(0, 0), DemoCometZ(x, y) * 2 + MidBottomWindow), 2, DemoCometColor(x, y)
                            End If
                        Case Is <= 1 ' Show points on earth in lower screen
                            PSet ((DemoCometX(x, y)), DemoCometZ(x, y) * 2 + MidBottomWindow), _RGB(200, 200, 0)
                            Circle ((DemoCometX(x, y)), DemoCometZ(x, y) * 2 + MidBottomWindow), 2, _RGB(200, 200, 0)
                    End Select
                Next y
            Next x
        End If

        For i = 0 To 3000
            For j = 0 To MaxEarthJ ' Display Earth Points that have been hit
                If DemoEarthPoints(i, j) = 2 Then Circle (i - 1500, PlanetRadius - j), 2, _RGB(255, 255, 0): Circle (i - 1500, PlanetRadius - j), 1, _RGB(255, 0, 0)
            Next j
        Next i

        For ii = 1 To CometIIcount ' Display large circles for crater
            For jj = 1 To 300
                If CometMass(ii, jj) = 1 Then '     Has Hit Earth
                    Circle (CometX(ii, jj), MidBottomWindow), CometSize(ii, jj), CometColor(ii, jj): Circle (CometX(ii, jj), MidBottomWindow), CometSize(ii, jj) + 1, CometColor(ii, jj)
                    '                    IF ABS(CombinedAngle) > 9 THEN CIRCLE (CometX(ii, jj), MidBottomWindow), CometSize(ii, jj), _RGB(255, 255, 255): CIRCLE (CometX(ii, jj), MidBottomWindow), CometSize(ii, jj) + 1, _RGB(255, 255, 255)
                End If
            Next jj
        Next ii


        If ItHasImpactedOnBottom = 1 Then PointsTotal = PointsTotal - 5
        If DemoCometMass(0, 0) = 0 Then PointsTotal = PointsTotal - 5 ' rapidly reduces max num of points to draw but does not end abruptly on impact
        If DemoCometX(0, 0) < ZoomWindow1 Then PointsTotal = PointsTotal - 10 ' rapidly moves comet away from planet after it leaves the main scene.



        '                      #############################  MINI IMAGE   #####################################
        Window (-126575, -69260)-(25000, 16000) ' mini image of comet approaching planet


        Circle (StartX, StartY), CometRadius * 2, _RGB(255, 255, 0)

        For i = 7 To 6371 Step 10 ' Draw Earth
            EarthColorization = 255 - 100 * i / 6371
            EarthColorization2 = 165 - 160 * i / 6371
            Circle (0, 0), i, _RGB(EarthColorization2 / 1.5, EarthColorization2 / 1.5, EarthColorization / 1.5)
        Next i

        For ii = 1 To CometIIcount
            For jj = 1 To 300
                If CometMass(ii, jj) = 1 Then '     Has Hit Earth
                    If CometZ(ii, jj) >= 0 Then Circle (CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj), CometColor(ii, jj)
                    If jj > 1 Then Line (CometX(ii, jj), CometY(ii, jj) - CometSize(ii, jj))-(CometX(ii, jj - 1), CometY(ii, jj - 1) - CometSize(ii, jj - 1)), _RGB(255, 0, 0)
                End If
            Next jj
        Next ii
        '   #####################################   END MINI IMAGE   ###########################################################################


        Window (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, ZoomWindow4)
        ' ************************ HEADER *************************************
        HeaderDepth = ZoomWindow4 - (ZoomWindow4 - ZoomWindow2) * .02
        HeaderDepth2 = (ZoomWindow4 - ZoomWindow2) * .0008
        Line (ZoomWindow1, ZoomWindow4)-(ZoomWindow3, HeaderDepth), _RGB(215, 215, 215), BF
        Line (ZoomWindow1, HeaderDepth)-(ZoomWindow3, HeaderDepth - HeaderDepth2), _RGB(100, 100, 100), BF
        Line (ZoomWindow1, HeaderDepth - HeaderDepth2)-(ZoomWindow3, HeaderDepth - HeaderDepth2 * 1.5), _RGB(220, 220, 220), BF
        Color _RGB(0, 0, 0), _RGB(215, 215, 215)

        _PrintString (5, 3), " Comet Diameter: " + Left$(Str$(CometRadius * 2), 6) + " km "
        InitialOverallSpeed = Sqr(CometInitialSpeedX ^ 2 + CometInitialSpeedY ^ 2 + CometInitialSpeedZ ^ 2)
        If CometAngleofApproach <> 0 Then
            _PrintString (270, 3), "Initial Speed & Angle: " + Left$(Str$(Abs(Int(InitialOverallSpeed))), 5) + " km/s   " + Str$(Int(CometAngleofApproach)) + Chr$(248) ' CHR$(248) = Degree symbol
        Else
            _PrintString (270, 3), "Initial Speed: " + Left$(Str$(Abs(Int(InitialOverallSpeed))), 5) + " km/s   "
        End If

        If DemoCometMass(0, 0) > 0 Then DemoImpactSpeed = Sqr(DemoCometSpeedX(0, 0) ^ 2 + DemoCometSpeedY(0, 0) ^ 2 + DemoCometSpeedZ(0, 0) ^ 2)

        If CombinedAngle <> 0 Then
            _PrintString (670, 3), "Impact Speed & Angle: " + Left$(Str$(DemoImpactSpeed), 5) + " km/s   " + Left$(Str$(Abs(Int(CombinedAngle * 10) / 10)), 5) + Chr$(248)
        Else
            If ItHasImpactedOnBottom = 1 Then

                _PrintString (670, 3), "Impact Speed:         " + Left$(Str$(DemoImpactSpeed), 5) + " km/s"
            Else
                _PrintString (670, 3), "Present Speed:        " + Left$(Str$(DemoImpactSpeed), 5) + " km/s"
            End If
        End If
        _PrintString (1150, 3), "Start X: " + Str$(Int(CometInitialX)) + " km"
        _PrintString (1350, 3), "Start Y: " + Str$(Int(CometInitialY)) + " km"
        _PrintString (1600, 3), "Time: " + Str$(PointstoDraw)

        Color _RGB(255, 0, 0), _RGB(0, 0, 0)
        Color _RGB(0, 0, 0), _RGB(215, 215, 215)
        'Locate function key reminders in bottom menu bar
        HeaderDepth = ZoomWindow2 + (ZoomWindow4 - ZoomWindow2) * .02
        HeaderDepth2 = (ZoomWindow4 - ZoomWindow2) * .0008
        Color _RGB(55, 55, 55), _RGB(215, 215, 185)
        Line (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, HeaderDepth), _RGB(215, 215, 185), BF
        _PrintString (10, 982), "Space Bar: Pause   Stop Program: 'Esc'    0-9 keys:Comet speed      F6:Comet Radius    F9: Shock Effect 2X or 4X     F10: Show Flying Debris    F11: Show Debris on Planet    F12: Show Giant Comet     Set X,Y: Press 'L'"
        Color _RGB(0, 0, 255),
        ' Note: 8 pixels = 1 character
        If ShowShockEffect$ = "Yes" Then _PrintString (738, 982), "Shock Effect 2X"
        If ShowShockEffect$ = "Yes4X" Then _PrintString (738, 982), "Shock Effect": _PrintString (890, 982), "4X"
        If ShowFlyingDebris$ = "Yes" Then _PrintString (986, 982), "Show Flying Debris"
        If ShowPlanetDebris$ = "Yes" Then _PrintString (1202, 982), "Show Debris on Planet"
        If ShowBigComet$ = "Yes" Then _PrintString (1442, 982), "Show Giant Comet"

        Color _RGB(255, 255, 255), _RGB(0, 0, 0)
        _Display


        '        LOCATE 20, 20: PRINT "CometAngleofApproach: ", CometAngleofApproach, "StartX: ", StartX, "StartY: ", StartY, "Speed Y: ", CometInitialSpeedY
        '        LOCATE 25, 20: PRINT "AFTER  IF StartX < -120000 THEN PointstoDraw = PointsTotal", PointstoDraw, PointsTotal
        '        _DISPLAY
        '       A$ = "": WHILE A$ = "": A$ = INKEY$: WEND




        A$ = InKey$
        If A$ <> "" Then

            If A$ <> Chr$(16) And A$ <> Chr$(12) Then Call CheckifChangeScene(A$, RunProgram$): If RunProgram$ = "StartOver" Or RunProgram$ = "StartOverMenu" Then Exit Sub
            asciibyte = Asc(A$)
            Select Case asciibyte
                Case 12: GoTo BeginImpactProbabilities ' No changes if Ctrl L pressed - just rerun present scene
                Case 32 ' space bar
                    A$ = "": While A$ = "": A$ = InKey$: Wend
                    ' Planet Radius = 6371
                Case 48: CometInitialSpeedX = 0: CometInitialSpeedY = -10: CometInitialX = 0: CometInitialY = 13000: CometAngleofApproach = 90: GoTo BeginImpactProbabilities ' 0 pressed
                Case 49: CometInitialSpeedX = -1: CometInitialSpeedY = 0: CometInitialX = 3000: CometInitialY = 13000: CometAngleofApproach = 65: GoTo BeginImpactProbabilities ' 1 pressed
                Case 50: CometInitialSpeedX = -2: CometInitialSpeedY = 0: CometInitialX = 7000: CometInitialY = 13000: CometAngleofApproach = 43: GoTo BeginImpactProbabilities ' 2 pressed
                Case 51: CometInitialSpeedX = -3: CometInitialSpeedY = 0: CometInitialX = 7000: CometInitialY = 11000: CometAngleofApproach = 33: GoTo BeginImpactProbabilities ' 3 pressed
                Case 52: CometInitialSpeedX = -5: CometInitialSpeedY = 0: CometInitialX = 9500: CometInitialY = 9500: CometAngleofApproach = 18: GoTo BeginImpactProbabilities ' 4 pressed
                Case 53: CometInitialSpeedX = -10: CometInitialSpeedY = 0: CometInitialX = 12000: CometInitialY = 8000: CometAngleofApproach = 7.7: GoTo BeginImpactProbabilities ' 5 pressed
                Case 54: CometInitialSpeedX = -20: CometInitialSpeedY = 0: CometInitialX = 15000: CometInitialY = 7000: CometAngleofApproach = 2.5: GoTo BeginImpactProbabilities ' 6 pressed
                Case 55: CometInitialSpeedX = -40: CometInitialSpeedY = 0: CometInitialX = 19000: CometInitialY = 6550: CometAngleofApproach = 0.5: GoTo BeginImpactProbabilities ' 7 pressed
                Case 56: CometInitialSpeedX = -60: CometInitialSpeedY = 0: CometInitialX = 20000: CometInitialY = 6442: CometAngleofApproach = 0: GoTo BeginImpactProbabilities ' 8 pressed
                Case 57: CometInitialSpeedX = -80: CometInitialSpeedY = 0: CometInitialX = 20000: CometInitialY = 6415: CometAngleofApproach = 0: GoTo BeginImpactProbabilities ' 9 pressed
                Case 76, 108: Call SetCometXY(CometInitialX, CometInitialY): GoTo BeginImpactProbabilities '  "L OR l" pressed - afterwards,  re-run the demo
                Case 16 ' Ctrl P = immeadiate screen save to pre-determined folder with predetermined names
                    desktop& = _ScreenImage(0, 0, 1785, 1035) ' Co-ordinates relate to image on computer monitor not to coordinates in QB64 window.
                    t$ = Time$: t2$ = Date$: DemoFileName$ = CometFileName$ + Mid$(t2$, 7, 4) + "-" + Mid$(t2$, 1, 2) + "-" + Mid$(t2$, 4, 2) + "-" + Mid$(t$, 1, 2) + Mid$(t$, 4, 2) + Mid$(t$, 7, 2)
                    SaveImage desktop&, DemoFileName$ 'saves entire program screen
                    _FreeImage desktop&
                    Beep
            End Select
        End If

        ascii2byte = 0
        If Len(A$) > 1 Then ascii2byte = Asc(A$, 2) ' read second character of 2 byte codes such as function keys and cursor keys
        If ascii2byte <> 0 Then
            Select Case ascii2byte
                Case 64 ' F6 = Toggle Comet Radius Size, reset comet to new size
                    '                    IF ToggleRadius = 0 THEN CometRadius = 30 ELSE CometRadius = ToggleRadius 'Comet diameter = 2 X CometRadius, with 1 pixel = 1 km size
                    Select Case ToggleRadius
                        Case 0 To 15: ToggleRadius = ToggleRadius + 5
                        Case 20 To 59: ToggleRadius = ToggleRadius + 10
                        Case 60 To 100: ToggleRadius = ToggleRadius + 20
                        Case Else: ToggleRadius = 5
                    End Select
                    CometRadius = ToggleRadius
                    GoTo BeginImpactProbabilities
                Case 67: ' F9 - Add 2X or 4X width for shock effects
                    Select Case ShowShockEffect$
                        Case "No": ShowShockEffect$ = "Yes"
                        Case "Yes": ShowShockEffect$ = "Yes4X"
                        Case Else: ShowShockEffect$ = "No"
                    End Select
                Case 68: ' F10 - turn off scattered pieces
                    If ShowFlyingDebris$ <> "Yes" Then ShowFlyingDebris$ = "Yes" Else ShowFlyingDebris$ = "No"
                Case 133: ' F11 - toggle show debris on planet
                    If ShowPlanetDebris$ <> "Yes" Then ShowPlanetDebris$ = "Yes" Else ShowPlanetDebris$ = "No"
                Case 134: ' F12 - toggle show displays
                    If ShowBigComet$ <> "Yes" Then ShowBigComet$ = "Yes" Else ShowBigComet$ = "No"
                Case 71 '        cursor home
                    CometInitialX = 0 ' perfect X for long skip  = 20,000  @ -40 km/s
                    CometInitialY = 20000 ' perfect Y for long skip  = 6,530 @ -.1 km/s
                    CometInitialSpeedX = 0 ' km/sec
                    CometInitialSpeedY = -1 * Abs(CursorCometSpeed) ' km/sec but should be down for this, not up and away
                    CometAngleofApproach = 90
                    GoTo BeginImpactProbabilities
                Case 72 '        cursor key up -  Aim for 1 degree increments on cursors, 10 degrees on page up and down
                    CometAngleofApproach = CometAngleofApproach + 1
                    If CometAngleofApproach > 90 Then CometAngleofApproach = 90
                    DemoRadians = Radian(CometAngleofApproach)
                    CometInitialY = Sin(DemoRadians) * 20000 + 6500
                    CometInitialX = Cos(DemoRadians) * 20000
                    CometInitialSpeedY = Sin(DemoRadians) * CursorCometSpeed
                    CometInitialSpeedX = Cos(DemoRadians) * CursorCometSpeed
                    GoTo BeginImpactProbabilities
                Case 73 '        cursor key page up
                    If CometAngleofApproach < 25 Then CometAngleofApproach = CometAngleofApproach + 5 Else CometAngleofApproach = CometAngleofApproach + 10
                    If CometAngleofApproach > 90 Then CometAngleofApproach = 90
                    DemoRadians = Radian(CometAngleofApproach)
                    CometInitialY = Sin(DemoRadians) * 20000 + 6500
                    CometInitialX = Cos(DemoRadians) * 20000
                    CometInitialSpeedY = Sin(DemoRadians) * CursorCometSpeed
                    CometInitialSpeedX = Cos(DemoRadians) * CursorCometSpeed
                    GoTo BeginImpactProbabilities
                Case 80 '        cursor key down
                    CometAngleofApproach = CometAngleofApproach - 1
                    If CometAngleofApproach < 0 Then CometAngleofApproach = 0
                    DemoRadians = Radian(CometAngleofApproach)
                    CometInitialY = Sin(DemoRadians) * 20000 + 6500
                    CometInitialX = Cos(DemoRadians) * 20000
                    CometInitialSpeedY = Sin(DemoRadians) * CursorCometSpeed
                    CometInitialSpeedX = Cos(DemoRadians) * CursorCometSpeed
                    GoTo BeginImpactProbabilities
                Case 81 '        cursor key page down
                    If CometAngleofApproach < 25 Then CometAngleofApproach = CometAngleofApproach - 5 Else CometAngleofApproach = CometAngleofApproach - 10
                    If CometAngleofApproach < 0 Then CometAngleofApproach = 0
                    DemoRadians = Radian(CometAngleofApproach)
                    CometInitialY = Sin(DemoRadians) * 20000 + 6500
                    CometInitialX = Cos(DemoRadians) * 20000
                    CometInitialSpeedY = Sin(DemoRadians) * CursorCometSpeed
                    CometInitialSpeedX = Cos(DemoRadians) * CursorCometSpeed
                    GoTo BeginImpactProbabilities
                Case 75 '        cursor key left - do nothing
                    '                    CursorCometSpeed = CursorCometSpeed - 5
                    '                    IF CursorCometSpeed < -100 THEN CursorCometSpeed = -100
                    GoTo BeginImpactProbabilities
                Case 77 '        cursor key left - do nothing
                    '                    CursorCometSpeed = CursorCometSpeed + 5
                    '                    IF CursorCometSpeed > 0 THEN CursorCometSpeed = 0
                    GoTo BeginImpactProbabilities
                Case 79 ' Cursor End
                    CometInitialX = 20000 ' perfect X for long skip  = 20,000  @ -40 km/s
                    CometInitialY = 6565 ' perfect Y for long skip  = 6,565 @ -.1 km/s
                    CometInitialSpeedX = -40 ' km/sec
                    CometInitialSpeedY = -.10 ' km/sec
                    CometAngleofApproach = 0.4
                    GoTo BeginImpactProbabilities
                Case Else
                    Call CheckFunctionandCursorKeys(ascii2byte, Scene$, RunProgram$) ' function and cursor keys
                    If RunProgram$ = "StartOver" Or RunProgram$ = "StartOverMenu" Then RunImpactProbabilities$ = "StartOver": CometPAthOnOff = 1: ToggleDrawCometCenterPath = 1: Exit Sub
            End Select
        End If

    Wend

    ' ##############################################################   END OF CALCULATION ROUTINE    ########################################################

    Beep

    GoTo BeginImpactProbabilities

End Sub


Sub SetCometXY (CometInitialX, CometInitialY)
    '    VIEW (400, 250)-(750, 800), _RGB(0, 0, 0), _RGB(100, 100, 50)
    '    WINDOW SCREEN(400, 250)-(750, 800)
    OriginalStartX = CometInitialX: OriginalStartY = CometInitialY
    OriginalSpeedX = CometInitialSpeedX: OriginalSpeedY = CometInitialSpeedY
    OriginalCometRadius = CometRadius

    CometInitialXSTR$ = LTrim$(RTrim$(Str$(Int(CometInitialX))))
    CometInitialSpeedXSTR$ = LTrim$(RTrim$(Str$(CometInitialSpeedX)))
    CometInitialYSTR$ = LTrim$(RTrim$(Str$(Int(CometInitialY))))
    CometInitialSpeedYSTR$ = LTrim$(RTrim$(Str$(CometInitialSpeedY)))
    CometRadiusSTR$ = LTrim$(RTrim$(Str$(CometRadius)))

    OriginalCometFileName$ = CometFileName$

    ButtonNumber = 1


    Call DisplayCometXYOptions(CometInitialXSTR$, CometInitialYSTR$, CometInitialSpeedXSTR$, CometInitialSpeedYSTR$, CometRadiusSTR$)

    KeyPressed$ = ""
    While KeyPressed$ = ""
        KeyPressed$ = InKey$

        If KeyPressed$ <> "" Then
            If Len(KeyPressed$) = 1 Then
                TestKey = Asc(KeyPressed$)
                If TestKey = 27 Then ' esc goes back to original, ends sub
                    CometInitialX = OriginalStartX: CometInitialY = OriginalStartY
                    CometInitialSpeedX = OriginalSpeedX: CometInitialSpeedY = OriginalSpeedY
                    CometRadius = OriginalCometRadius
                    CometFileName$ = OriginalCometFileName$
                    StartX = CometInitialX
                    StartY = CometInitialY
                    View (0, 0)-(1776, 999)
                    Window (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, ZoomWindow4)
                    Color _RGB(255, 255, 255), _RGB(0, 0, 0)
                    Exit Sub
                End If

                Select Case ButtonNumber
                    Case 1 'enter new X location
                        '                        LOCATE 10, 10: PRINT "X:", CometInitialX, "Int X:", INT(CometInitialX), "Str(Int(X)):", STR$(INT(CometInitialX)), LTRIM$(RTRIM$(STR$(INT(CometInitialX))))
                        Select Case TestKey
                            Case 8: CometInitialXSTR$ = Left$(CometInitialXSTR$, Len(CometInitialXSTR$) - 1) ' BackSpace
                            Case 45, 46, 48 To 57: CometInitialXSTR$ = CometInitialXSTR$ + KeyPressed$ ' Add a character to number
                            Case 13: ButtonNumber = 2
                        End Select
                    Case 2 'enter new X speed
                        Select Case TestKey
                            Case 8: CometInitialSpeedXSTR$ = Left$(CometInitialSpeedXSTR$, Len(CometInitialSpeedXSTR$) - 1) ' BackSpace
                            Case 45, 46, 48 To 57: CometInitialSpeedXSTR$ = CometInitialSpeedXSTR$ + KeyPressed$ ' Add a character to number
                            Case 13: ButtonNumber = 3
                        End Select
                    Case 3 'enter new Y location
                        Select Case TestKey
                            Case 8: CometInitialYSTR$ = Left$(CometInitialYSTR$, Len(CometInitialYSTR$) - 1) ' BackSpace
                            Case 45, 46, 48 To 57: CometInitialYSTR$ = CometInitialYSTR$ + KeyPressed$ ' Add a character to number
                            Case 13: ButtonNumber = 4
                        End Select
                    Case 4 'enter new Y speed
                        NewNumber$ = LTrim$(RTrim$(Str$(Int(CometInitialSpeedY))))
                        Select Case TestKey
                            Case 8: CometInitialSpeedYSTR$ = Left$(CometInitialSpeedYSTR$, Len(CometInitialSpeedYSTR$) - 1) ' BackSpace
                            Case 45, 46, 48 To 57: CometInitialSpeedYSTR$ = CometInitialSpeedYSTR$ + KeyPressed$ ' Add a character to number
                            Case 13: ButtonNumber = 5
                        End Select
                        If NewNumber$ <> "" Then CometInitialSpeedY = Val(NewNumber$) Else CometInitialSpeedY = 0
                    Case 5 'enter new Comet Radius
                        Select Case TestKey
                            Case 8: CometRadiusSTR$ = Left$(CometRadiusSTR$, Len(CometRadiusSTR$) - 1) ' BackSpace
                            Case 45, 46, 48 To 57: CometRadiusSTR$ = CometRadiusSTR$ + KeyPressed$ ' Add a character to number
                            Case 13: ButtonNumber = 6
                        End Select
                    Case 6 'enter new file name for CometFileName$
                        Select Case TestKey
                            Case 8: CometFileName$ = Left$(CometFileName$, Len(CometFileName$) - 1) ' BackSpace
                            Case 32, 43 To 57, 65 To 122: CometFileName$ = CometFileName$ + KeyPressed$ ' Add a character to filename
                            Case 13: ButtonNumber = 8
                        End Select
                    Case 7 ' Cancel Button
                        If TestKey = 13 Then ' Done,set new values and return to main scene
                            CometInitialX = OriginalStartX: CometInitialY = OriginalStartY
                            CometInitialSpeedX = OriginalSpeedX: CometInitialSpeedY = OriginalSpeedY
                            CometRadius = OriginalCometRadius
                            CometFileName$ = OriginalCometFileName$
                            StartX = CometInitialX
                            StartY = CometInitialY
                            View (0, 0)-(1776, 999)
                            Window (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, ZoomWindow4)
                            Color _RGB(255, 255, 255), _RGB(0, 0, 0)
                            Exit Sub
                        End If
                    Case 8
                        If TestKey = 13 Then ' Done,set new values and return to main scene
                            If CometFileName$ = "" Then CometFileName$ = OriginalCometFileName$
                            CometInitialX = Val(CometInitialXSTR$)
                            CometInitialSpeedX = Val(CometInitialSpeedXSTR$)
                            CometInitialY = Val(CometInitialYSTR$)
                            CometInitialSpeedY = Val(CometInitialSpeedYSTR$)
                            CometRadius = Val(CometRadiusSTR$)
                            ToggleRadius = CometRadius
                            StartX = CometInitialX
                            StartY = CometInitialY
                            View (0, 0)-(1776, 999)
                            Window (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, ZoomWindow4)
                            Color _RGB(255, 255, 255), _RGB(0, 0, 0)
                            Exit Sub
                        End If
                End Select
            Else
                If Len(KeyPressed$) > 1 Then TestKey = Asc(Right$(KeyPressed$, 1)) Else TestKey = 0 ' 2 character keys pressed
                Select Case TestKey
                    Case 71 '        cursor home
                        ButtonNumber = 1
                    Case 72, 73, 75 '        cursor key up and page up and left
                        If ButtonNumber = 2 Then ButtonNumber = 1
                        If ButtonNumber = 3 Then ButtonNumber = 2
                        If ButtonNumber = 4 Then ButtonNumber = 3
                        If ButtonNumber = 5 Then ButtonNumber = 4
                        If ButtonNumber = 6 Then ButtonNumber = 5
                        If ButtonNumber = 7 Then ButtonNumber = 6
                        If ButtonNumber = 8 Then ButtonNumber = 7
                    Case 80, 81, 77 '        cursor key down and page down and right
                        If ButtonNumber = 7 Then ButtonNumber = 8
                        If ButtonNumber = 6 Then ButtonNumber = 7
                        If ButtonNumber = 5 Then ButtonNumber = 6
                        If ButtonNumber = 4 Then ButtonNumber = 5
                        If ButtonNumber = 3 Then ButtonNumber = 4
                        If ButtonNumber = 2 Then ButtonNumber = 3
                        If ButtonNumber = 1 Then ButtonNumber = 2
                    Case 79 ' Cursor End
                        ButtonNumber = 9
                End Select
            End If
        End If
        If CometFileName$ = "" And ButtonNumber <> 6 Then CometFileName$ = OriginalCometFileName$
        KeyPressed$ = ""
        Call DisplayCometXYOptions(CometInitialXSTR$, CometInitialYSTR$, CometInitialSpeedXSTR$, CometInitialSpeedYSTR$, CometRadiusSTR$)
    Wend


    View (0, 0)-(1776, 999)
    Window (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, ZoomWindow4)
    Color _RGB(255, 255, 255), _RGB(0, 0, 0)

End Sub

Sub SetCometXYwithMouse (CometInitialX, CometInitialY)
    '    VIEW (400, 250)-(750, 800), _RGB(0, 0, 0), _RGB(100, 100, 50)
    '    WINDOW SCREEN(400, 250)-(750, 800)
    OriginalStartX = CometInitialX: OriginalStartY = CometInitialY
    OriginalSpeedX = CometInitialSpeedX: OriginalSpeedY = CometInitialSpeedY
    OriginalCometRadius = CometRadius

    CometInitialXSTR$ = LTrim$(RTrim$(Str$(Int(CometInitialX))))
    CometInitialSpeedXSTR$ = LTrim$(RTrim$(Str$(CometInitialSpeedX)))
    CometInitialYSTR$ = LTrim$(RTrim$(Str$(Int(CometInitialY))))
    CometInitialSpeedYSTR$ = LTrim$(RTrim$(Str$(CometInitialSpeedY)))
    CometRadiusSTR$ = LTrim$(RTrim$(Str$(CometRadius)))

    OriginalCometFileName$ = CometFileName$

    aMouse = _MouseInput ' clear MouseInput
    aMouse = _MouseInput ' clear MouseInput
    aMouse = _MouseInput ' clear MouseInput

    ButtonNumber = 1


    Call DisplayCometXYOptions(CometInitialXSTR$, CometInitialYSTR$, CometInitialSpeedXSTR$, CometInitialSpeedYSTR$, CometRadiusSTR$)

    KeyPressed$ = ""
    While KeyPressed$ = ""
        KeyPressed$ = InKey$
        If _MouseInput = -1 Then
            xx& = _MouseX: yy& = _MouseY: Mousex = xx&: Mousey = yy&
            ButtonClicked = _MouseButton(1)
            Select Case Mousex
                Case 420 To 720 '  in Button area
                    Select Case Mousey ' which row?
                        Case 310 To 350: If Mousex > 410 And Mousex < 730 Then ButtonNumber = 1
                        Case 370 To 410: If Mousex > 410 And Mousex < 730 Then ButtonNumber = 2
                        Case 430 To 470: If Mousex > 410 And Mousex < 730 Then ButtonNumber = 3
                        Case 490 To 530: If Mousex > 410 And Mousex < 730 Then ButtonNumber = 4
                        Case 550 To 590: If Mousex > 410 And Mousex < 730 Then ButtonNumber = 5
                        Case 640 To 680: If Mousex > 410 And Mousex < 730 Then ButtonNumber = 6
                        Case 700 To 725
                            If Mousex > 420 And Mousex < 550 Then ButtonNumber = 7
                            If Mousex > 570 And Mousex < 730 Then ButtonNumber = 8
                    End Select
            End Select
            Select Case ButtonClicked
                Case -1
                    Select Case Mousey
                        Case 640 To 680: If Mousex > 410 And Mousex < 730 Then ButtonNumber = 6
                        Case 698 To 725
                            If Mousex > 420 And Mousex < 550 Then ' Cancel Button = # 7
                                CometInitialX = OriginalStartX: CometInitialY = OriginalStartY
                                CometInitialSpeedX = OriginalSpeedX: CometInitialSpeedY = OriginalSpeedY
                                CometRadius = OriginalCometRadius
                                CometFileName$ = OriginalCometFileName$
                                StartX = CometInitialX
                                StartY = CometInitialY
                                View (0, 0)-(1776, 999)
                                Window (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, ZoomWindow4)
                                Color _RGB(255, 255, 255), _RGB(0, 0, 0)
                                Exit Sub
                            End If
                            If Mousex > 570 And Mousex < 730 Then ' Begin Saving button = # 8
                                If CometFileName$ = "" Then CometFileName$ = OriginalCometFileName$
                                CometInitialX = Val(CometInitialXSTR$)
                                CometInitialSpeedX = Val(CometInitialSpeedXSTR$)
                                CometInitialY = Val(CometInitialYSTR$)
                                CometInitialSpeedY = Val(CometInitialSpeedYSTR$)
                                CometRadius = Val(CometRadiusSTR$)
                                ToggleRadius = CometRadius
                                StartX = CometInitialX
                                StartY = CometInitialY
                                Cls
                                View (0, 0)-(1776, 999)
                                Window (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, ZoomWindow4)
                                Color _RGB(255, 255, 255), _RGB(0, 0, 0)
                                Exit Sub
                            End If
                    End Select
            End Select
            KeyPressed$ = ""
        End If

        If KeyPressed$ <> "" Then
            If Len(KeyPressed$) = 1 Then
                TestKey = Asc(KeyPressed$)
                If TestKey = 27 Then ' esc goes back to original, ends sub
                    CometInitialX = OriginalStartX: CometInitialY = OriginalStartY
                    CometInitialSpeedX = OriginalSpeedX: CometInitialSpeedY = OriginalSpeedY
                    CometRadius = OriginalCometRadius
                    CometFileName$ = OriginalCometFileName$
                    StartX = CometInitialX
                    StartY = CometInitialY
                    View (0, 0)-(1776, 999)
                    Window (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, ZoomWindow4)
                    Color _RGB(255, 255, 255), _RGB(0, 0, 0)
                    Exit Sub
                End If

                Select Case ButtonNumber
                    Case 1 'enter new X location
                        '                        LOCATE 10, 10: PRINT "X:", CometInitialX, "Int X:", INT(CometInitialX), "Str(Int(X)):", STR$(INT(CometInitialX)), LTRIM$(RTRIM$(STR$(INT(CometInitialX))))
                        Select Case TestKey
                            Case 8: CometInitialXSTR$ = Left$(CometInitialXSTR$, Len(CometInitialXSTR$) - 1) ' BackSpace
                            Case 45, 46, 48 To 57: CometInitialXSTR$ = CometInitialXSTR$ + KeyPressed$ ' Add a character to number
                            Case 13: ButtonNumber = 2
                        End Select
                    Case 2 'enter new X speed
                        Select Case TestKey
                            Case 8: CometInitialSpeedXSTR$ = Left$(CometInitialSpeedXSTR$, Len(CometInitialSpeedXSTR$) - 1) ' BackSpace
                            Case 45, 46, 48 To 57: CometInitialSpeedXSTR$ = CometInitialSpeedXSTR$ + KeyPressed$ ' Add a character to number
                            Case 13: ButtonNumber = 3
                        End Select
                    Case 3 'enter new Y location
                        Select Case TestKey
                            Case 8: CometInitialYSTR$ = Left$(CometInitialYSTR$, Len(CometInitialYSTR$) - 1) ' BackSpace
                            Case 45, 46, 48 To 57: CometInitialYSTR$ = CometInitialYSTR$ + KeyPressed$ ' Add a character to number
                            Case 13: ButtonNumber = 4
                        End Select
                    Case 4 'enter new Y speed
                        NewNumber$ = LTrim$(RTrim$(Str$(Int(CometInitialSpeedY))))
                        Select Case TestKey
                            Case 8: CometInitialSpeedYSTR$ = Left$(CometInitialSpeedYSTR$, Len(CometInitialSpeedYSTR$) - 1) ' BackSpace
                            Case 45, 46, 48 To 57: CometInitialSpeedYSTR$ = CometInitialSpeedYSTR$ + KeyPressed$ ' Add a character to number
                            Case 13: ButtonNumber = 5
                        End Select
                        If NewNumber$ <> "" Then CometInitialSpeedY = Val(NewNumber$) Else CometInitialSpeedY = 0
                    Case 5 'enter new Comet Radius
                        Select Case TestKey
                            Case 8: CometRadiusSTR$ = Left$(CometRadiusSTR$, Len(CometRadiusSTR$) - 1) ' BackSpace
                            Case 45, 46, 48 To 57: CometRadiusSTR$ = CometRadiusSTR$ + KeyPressed$ ' Add a character to number
                            Case 13: ButtonNumber = 6
                        End Select
                    Case 6 'enter new file name for CometFileName$
                        Select Case TestKey
                            Case 8: CometFileName$ = Left$(CometFileName$, Len(CometFileName$) - 1) ' BackSpace
                            Case 32, 43 To 57, 65 To 122: CometFileName$ = CometFileName$ + KeyPressed$ ' Add a character to filename
                            Case 13: ButtonNumber = 8
                        End Select
                    Case 7 ' Cancel Button
                        If TestKey = 13 Then ' Done,set new values and return to main scene
                            CometInitialX = OriginalStartX: CometInitialY = OriginalStartY
                            CometInitialSpeedX = OriginalSpeedX: CometInitialSpeedY = OriginalSpeedY
                            CometRadius = OriginalCometRadius
                            CometFileName$ = OriginalCometFileName$
                            StartX = CometInitialX
                            StartY = CometInitialY
                            View (0, 0)-(1776, 999)
                            Window (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, ZoomWindow4)
                            Color _RGB(255, 255, 255), _RGB(0, 0, 0)
                            Exit Sub
                        End If
                    Case 8
                        If TestKey = 13 Then ' Done,set new values and return to main scene
                            If CometFileName$ = "" Then CometFileName$ = OriginalCometFileName$
                            CometInitialX = Val(CometInitialXSTR$)
                            CometInitialSpeedX = Val(CometInitialSpeedXSTR$)
                            CometInitialY = Val(CometInitialYSTR$)
                            CometInitialSpeedY = Val(CometInitialSpeedYSTR$)
                            CometRadius = Val(CometRadiusSTR$)
                            ToggleRadius = CometRadius
                            StartX = CometInitialX
                            StartY = CometInitialY
                            View (0, 0)-(1776, 999)
                            Window (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, ZoomWindow4)
                            Color _RGB(255, 255, 255), _RGB(0, 0, 0)
                            Exit Sub
                        End If
                End Select
            Else
                If Len(KeyPressed$) > 1 Then TestKey = Asc(Right$(KeyPressed$, 1)) Else TestKey = 0 ' 2 character keys pressed
                Select Case TestKey
                    Case 71 '        cursor home
                        ButtonNumber = 1
                    Case 72, 73, 75 '        cursor key up and page up and left
                        If ButtonNumber = 2 Then ButtonNumber = 1
                        If ButtonNumber = 3 Then ButtonNumber = 2
                        If ButtonNumber = 4 Then ButtonNumber = 3
                        If ButtonNumber = 5 Then ButtonNumber = 4
                        If ButtonNumber = 6 Then ButtonNumber = 5
                        If ButtonNumber = 7 Then ButtonNumber = 6
                        If ButtonNumber = 8 Then ButtonNumber = 7
                    Case 80, 81, 77 '        cursor key down and page down and right
                        If ButtonNumber = 7 Then ButtonNumber = 8
                        If ButtonNumber = 6 Then ButtonNumber = 7
                        If ButtonNumber = 5 Then ButtonNumber = 6
                        If ButtonNumber = 4 Then ButtonNumber = 5
                        If ButtonNumber = 3 Then ButtonNumber = 4
                        If ButtonNumber = 2 Then ButtonNumber = 3
                        If ButtonNumber = 1 Then ButtonNumber = 2
                    Case 79 ' Cursor End
                        ButtonNumber = 9
                End Select
            End If
        End If
        If CometFileName$ = "" And ButtonNumber <> 6 Then CometFileName$ = OriginalCometFileName$
        KeyPressed$ = ""
        Call DisplayCometXYOptions(CometInitialXSTR$, CometInitialYSTR$, CometInitialSpeedXSTR$, CometInitialSpeedYSTR$, CometRadiusSTR$)
    Wend


    View (0, 0)-(1776, 999)
    Window (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, ZoomWindow4)
    Color _RGB(255, 255, 255), _RGB(0, 0, 0)

End Sub

Sub DisplayCometXYOptions (CometInitialXSTR$, CometInitialYSTR$, CometInitialSpeedXSTR$, CometInitialSpeedYSTR$, CometradiusSTR$)
    '    VIEW (400, 250)-(765, 780), _RGB(0, 0, 0), _RGB(100, 100, 50)
    '_printstring(x,y) X ranges from 400 most left to 765 most right - tied to VIEW, not window
    '_printstring(x,y) Y ranges from 250 most top to 780 most bottom

    ' Need to change initial X, Y locations, initial X, Y Speeds, Comet size


    CometInitialX = Val(CometInitialXSTR$)
    CometInitialSpeedX = Val(CometInitialSpeedXSTR$)
    CometInitialY = Val(CometInitialYSTR$)
    CometInitialSpeedY = Val(CometInitialSpeedYSTR$)
    CometRadius = Val(CometradiusSTR$)
    CombinedAngle = 0
    CometImpacted$ = "No"

    View (750, 250)-(1300, 800)
    Window (-40000, -40000)-(40000, 40000)
    Line (-40000, -40000)-(40000, 40000), _RGB(180, 180, 50), BF
    Line (-39700, -39700)-(39700, 39700), _RGB(25, 25, 25), BF
    Circle (0, 0), PlanetRadius, _RGB(0, 0, 200)
    Paint (0, 10), _RGB(0, 0, 200), _RGB(0, 0, 200) ' PAINT needs to be inside the circle, and you list the border color of the circle after the co-ordinates and desired fill color.
    Line (-1335, 6100)-(1335, 6370), _RGB(255, 0, 0), BF

    SetStartX = CometInitialX: SetStartY = CometInitialY
    SetSpeedX = CometInitialSpeedX: SetSpeedY = CometInitialSpeedY
    Circle (SetStartX, SetStartY), 500, _RGB(255, 0, 0)

    Timefactor = 2
    For i = 1 To 6000
        distance = Sqr(SetStartX ^ 2 + SetStartY ^ 2)
        EAcc = ((GEarth / (distance ^ 2)) / 1000 ^ 3) * Timefactor
        PreviousStartX = SetStartX
        PreviousStartY = SetStartY
        SetSpeedX = SetSpeedX + (EAcc / distance) * -SetStartX
        SetSpeedY = SetSpeedY + (EAcc / distance) * -SetStartY
        SetStartX = SetStartX + SetSpeedX * Timefactor
        SetStartY = SetStartY + SetSpeedY * Timefactor
        distance = Sqr(SetStartX ^ 2 + SetStartY ^ 2)
        PSet (SetStartX, SetStartY), _RGB(255, 255, 0)
        If distance < PlanetRadius + CometRadius Then
            Circle (SetStartX, SetStartY), 400, _RGB(255, 255, 255)
            CometImpacted$ = "Yes"
            DotXY = (PreviousStartX * (SetStartX - PreviousStartX) + PreviousStartY * (SetStartY - PreviousStartY))
            XYMagnitude = ((SetStartX - PreviousStartX) ^ 2 + (SetStartY - PreviousStartY) ^ 2) ^ 0.5 * (SetStartX ^ 2 + SetStartY ^ 2) ^ 0.5
            Checkangle = 1
            If Abs(XYMagnitude) > .0000001 Then Checkangle = DotXY / XYMagnitude
            If Abs(Checkangle) > 1 Then Checkangle = 1
            AngleofImpact = ARCCOS(Checkangle) * 180 / pi '   or 90 degrees minus that
            CombinedAngle = AngleofImpact - 90
        End If
        If distance < PlanetRadius - CometRadius Then i = 6000
        If SetStartX < -40000 Or SetStartX > 40000 Then i = 6000
        If SetStartY < -40000 Or SetStartY > 40000 Then i = 6000
    Next i



    View (400, 250)-(750, 800), _RGB(220, 0, 0), _RGB(200, 100, 50)
    Window Screen(400, 250)-(750, 800) ' use Window Screen to have y = 0 at top
    Line (400, 250)-(750, 800), _RGB(220, 220, 220), BF ' main box

    Color _RGB(0, 0, 0), _RGB(210, 210, 0)
    Line (400, 250)-(750, 280), _RGB(210, 210, 0), BF ' Top note
    _PrintString (485, 256), "Impact Initial Settings"
    Line (400, 755)-(750, 800), _RGB(210, 210, 0), BF ' bottom note
    _PrintString (410, 760), " Use cursors to move" '  or mouse to select"
    _PrintString (410, 780), "Press 'Return' to move down to next item"

    Color _RGB(0, 0, 0), _RGB(220, 220, 220)
    _PrintString (410, 300), "X Initial Position:  km"
    Line (410, 320)-(730, 340), _RGB(0, 0, 0), BF
    _PrintString (410, 360), "X Initial Speed:  km/s"
    Line (410, 380)-(730, 400), _RGB(0, 0, 0), BF
    _PrintString (410, 420), "Y Initial Position:  km"
    Line (410, 440)-(730, 460), _RGB(0, 0, 0), BF
    _PrintString (410, 480), "Y Initial Speed:  km/s"
    Line (410, 500)-(730, 520), _RGB(0, 0, 0), BF
    _PrintString (410, 540), "Comet Radius:     km"
    Line (410, 560)-(730, 580), _RGB(0, 0, 0), BF
    If CometImpacted$ = "Yes" Then _PrintString (410, 600), "Impact at " + Str$(Abs(Int(CombinedAngle * 10) / 10)) + Chr$(248)

    Color _RGB(0, 220, 0), _RGB(0, 0, 0)
    _PrintString (420, 325), CometInitialXSTR$
    _PrintString (420, 385), CometInitialSpeedXSTR$
    _PrintString (420, 445), CometInitialYSTR$
    _PrintString (420, 505), CometInitialSpeedYSTR$
    _PrintString (420, 565), CometradiusSTR$
    Color _RGB(0, 0, 0), _RGB(150, 150, 150)
    Select Case ButtonNumber
        Case 1
            Line (410, 320)-(730, 340), _RGB(255, 255, 255), BF
            _PrintString (420, 325), CometInitialXSTR$ + " "
            Color _RGB(0, 0, 0), _RGB(255, 255, 255)
            _PrintString (420, 325), CometInitialXSTR$
        Case 2
            Line (410, 380)-(730, 400), _RGB(255, 255, 255), BF
            _PrintString (420, 385), CometInitialSpeedXSTR$ + " "
            Color _RGB(0, 0, 0), _RGB(255, 255, 255)
            _PrintString (420, 385), CometInitialSpeedXSTR$
        Case 3
            Line (410, 440)-(730, 460), _RGB(255, 255, 255), BF
            _PrintString (420, 445), CometInitialYSTR$ + " "
            Color _RGB(0, 0, 0), _RGB(255, 255, 255)
            _PrintString (420, 445), CometInitialYSTR$
        Case 4
            Line (410, 500)-(730, 520), _RGB(255, 255, 255), BF
            _PrintString (420, 505), CometInitialSpeedYSTR$ + " "
            Color _RGB(0, 0, 0), _RGB(255, 255, 255)
            _PrintString (420, 505), CometInitialSpeedYSTR$
        Case 5
            Line (410, 560)-(730, 580), _RGB(255, 255, 255), BF
            _PrintString (420, 565), CometradiusSTR$ + " "
            Color _RGB(0, 0, 0), _RGB(255, 255, 255)
            _PrintString (420, 565), CometradiusSTR$
    End Select
    Color _RGB(255, 255, 255), _RGB(0, 0, 0)


    i = 465: k = 110: J1 = 350: JStep = 36

    ' Button # 6 - Change File name
    Color _RGB(0, 0, 0), _RGB(220, 220, 220): If ButtonNumber = 6 Then Color _RGB(145, 100, 0), _RGB(210, 210, 210)
    _PrintString (420, 635), "Change File Name for Screen Saves"

    Line (420, 655)-(730, 675), _RGB(250, 250, 250), BF ' Enter File Name
    If ButtonNumber = 6 Then ' show a cursor by doing a different background for last character
        Color _RGB(145, 100, 0), _RGB(150, 150, 150)
        _PrintString (425, 656), CometFileName$ + " "
    End If
    Color _RGB(0, 0, 0), _RGB(255, 255, 255)
    _PrintString (425, 656), CometFileName$

    i = 420: j = 703: k = 140 ' Button # 7 - Cancel
    Call DrawButton(i, j, k)
    Color _RGB(125, 25, 25), _RGB(220, 220, 220): If ButtonNumber = 7 Then Color _RGB(125, 25, 25), _RGB(190, 190, 190)
    _PrintString (429, j), "Cancel Settings"

    i = 580: j = 703: k = 140 '  Button # 8 Run settings
    Call DrawButton(i, j, k)
    Color _RGB(25, 125, 25), _RGB(220, 220, 220): If ButtonNumber = 8 Then Color _RGB(25, 125, 25), _RGB(190, 190, 190)
    _PrintString (593, j), "Run Selection"

    Color _RGB(25, 125, 25), _RGB(220, 220, 220)
    _Display

End Sub

Sub CheckifChangeScene (A$, RunProgram$)
    RunProgram$ = "StartOver"
    If Len(A$) > 1 Then
        ascii2byte = Asc(A$, 2) ' read second character of 2 byte codes such as function keys and cursor keys
        Select Case ascii2byte
            Case 59: Scene$ = "Swift Tuttle from above at 66.55 degrees after impact - Relative Speed 42 km/s" '  F1 function pressed
            Case 60: Scene$ = "From Above at 45 degrees - Relative Speed 40 km/s" '  F2 function pressed
            Case 61: Scene$ = "Overtaking Earth from behind at 10 km/s" '  F3 function pressed
            Case 62: Scene$ = "Crossing from Sun 100km comet - Relative Speed 40 km/s" '  F4 function pressed
            Case 63: Scene$ = "Head On Impact as if Halley's comet hit - Relative Speed 70 km/s" '  F5 function pressed
            Case Else: RunProgram$ = ""
        End Select
        Exit Sub
    Else
        If Len(A$) = 1 Then asciinumber = Asc(A$) Else asciinumber = 0
        Select Case asciinumber
            Case 5: Scene$ = "Impact Jupiter then Earth twice at 1.5 and 1.6 years later" ' Ctrl E
            Case 10: Scene$ = "ChesapeakeBay" ' Ctrl J
            Case 9: Scene$ = "Encke": CometFileName$ = "D:/CometEnckeImages1/": RunReverse$ = "Yes" ' Ctrl I
            Case 11: Scene$ = "Encke": CometFileName$ = "D:/CometImages/": RunReverse$ = "No" ' Ctrl K
            Case 15: Scene$ = "Encke": CometFileName$ = "D:/CometEnckeImages3/": RunReverse$ = "No" ' Ctrl O
            Case 12: Scene$ = "Demo Shapes" ' Ctrl L
            Case 17: Scene$ = "SwiftTuttle Impact at Start" '  Ctrl Q
            Case 18: Scene$ = "Impact Jupiter then Earth a year later" '  Ctrl R
            Case 20: Scene$ = "Impact Jupiter, near miss Earth, then impact Earth 8.1 years later" ' Ctrl T
            Case 21: Scene$ = "Impact Earth not Jupiter" ' Ctrl U
            Case 23: Scene$ = "SwiftTuttle Orbit, outgassing along the orbit" '  Ctrl W
            Case 25: Scene$ = "Impact Jupiter then Earth 10.2 years later" ' Ctrl Y
            Case 27: End ' end program if "Esc" Pressed

            Case 1: Scene$ = "Demonstration of impact probabilities" ' Ctrl A
            Case 4: Scene$ = "Saginaw 1" ' Ctrl D
            Case 6: Scene$ = "Saginaw 2" ' Ctrl F
            Case 7: Scene$ = "Egypt" ' Ctrl G
            Case 8: Scene$ = "Menu": RunProgram$ = "StartOverMenu" ' Ctrl H
            Case 19: Scene$ = "Carolina Bays" ' Ctrl S
            Case 22: Scene$ = "Venus and Encke" ' Ctrl V
            Case 2: Scene$ = "Mercury and Encke" ' Ctrl B
            Case 14:
                Select Case Scene$
                    Case "Earth and Encke Nov": Scene$ = "Earth and Encke July"
                    Case "Earth and Encke July": Scene$ = "Earth and ST"
                    Case "Earth and ST": Scene$ = "Earth and Encke Nov"
                    Case Else: Scene$ = "Earth and Encke Nov"
                End Select
                '                Scene$ = "Encke and Swift-Tuttle Origins" ' Ctrl N
            Case 13 ' Ctrl M    and also RETURN. Disable when running Long simulations!
                If CometTime > 5000 Then RunProgram$ = "": Exit Sub
                Scene$ = "MARS"
            Case 16 ' Ctrl P = immeadiate screen save to pre-determined folder with predetermined names
                desktop& = _ScreenImage(0, 0, 1785, 1035) ' Co-ordinates relate to image on computer monitor not to coordinates in QB64 window.
                t$ = Time$: t2$ = Date$: FileName3D$ = Mid$(t2$, 7, 4) + "-" + Mid$(t2$, 1, 2) + "-" + Mid$(t2$, 4, 2) + "-" + Mid$(t$, 1, 2) + Mid$(t$, 4, 2) + Mid$(t$, 7, 2)
                If CometTime > 0 Then CometFileNameNow$ = CometFileName$ + LTrim$(Str$(CometTime)) Else CometFileNameNow$ = CometFileName$ + FileName3D$
                If Scene$ = "Egypt" Then CometFileNameNow$ = CometFileName$ + FileName3D$
                '                i& = _LOADIMAGE("nice.jpg", 32) ' loads a 32 bit .JPG file image
                '               SaveImage i&, "nice" 'saves it as .BMP file "nice.bmp"
                If SaveTheImage = 0 Then SaveImage desktop&, CometFileNameNow$ 'saves entire program screen as "CometSim.bmp", IF SAVETHEIMAGE IS >0 THEN IT HAS ALREADY SAVED THE CURRANT IMAGE
                _FreeImage desktop&
                Color _RGB(255, 55, 55), _RGB(215, 215, 185)
                _PrintString (1600, 982), " SAVING SCREEN  "
                Color _RGB(255, 255, 255), _RGB(0, 0, 0)
                _Display
                SaveTheImage = 0
                Beep
                RunProgram$ = ""
            Case Else: RunProgram$ = ""
        End Select
    End If
End Sub



Sub ChesapeakeBay
    ' 3D  version
    ' Planet Center = 0,0,0
    PlanetRadius = 6371

    For x = 1 To 300
        For y = 1 To 300
            CometX(x, y) = 0: CometY(x, y) = 0: CometZ(x, y) = 0
            CometSpeedX(x, y) = 0
            CometSpeedY(x, y) = 0
            CometSpeedZ(x, y) = 0
            CometMass(x, y) = 0
            CometColor(x, y) = _RGB(0, 0, 0)
        Next y
    Next x
    For ii = 0 To 100 ' Initialize Lake Michigan impact locations
        For jj = 0 To 5
            LakeMichLocX(ii, jj) = 0: LakeMichLocY(ii, jj) = 0: LakeMichLocZ(ii, jj) = 0: LakeMichLocRad(ii, jj) = 0
        Next jj
    Next ii


    ZoomWindow1 = -11286: ZoomWindow2 = 0: ZoomWindow3 = 594: ZoomWindow4 = 6684 ' Center on Chesapeake Bay


    '  *********************************  @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@   ***********************************************
    CBayBeginImpactProbabilities:

    If ToggleRadius = 0 Then CometRadius = 30 Else CometRadius = ToggleRadius 'Comet diameter = 2 X CometRadius, with 1 pixel = 1 km size

    For i = 0 To 100: ImpactAngleProbs(i) = 0: ImpactAngleProbPercents(i) = 0: Next i ' set ImpactAngleProbs(0) as misses, ImpactAngleProbs(1) for 0-5 degrees, ImpactAngleProbs(2) as 5 to 10 etc.
    RunImpactProbabilities$ = ""
    NumPointsHitting = 0
    TotalPointsCalculated = 0

    '**************************************
    NumPointsToCalculate = 1500
    '**************************************

    CometStartY = CometRadius * NumPointsToCalculate * 2
    CometStartZ = CometRadius * NumPointsToCalculate * 2

    Select Case Abs(CometInitialSpeedX)
        Case Is < 1.1: PointsTotal = 200000
        Case 1.1 To 5: PointsTotal = 2000000
        Case 5 To 10: PointsTotal = 2000000
        Case 10 To 50: PointsTotal = 800000
        Case Else: PointsTotal = 800000
    End Select


    Window (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, ZoomWindow4)
    Cls
    _Display

    For i = 7 To 6371 Step 10
        EarthColorization = 255 - 100 * i / 6371
        EarthColorization2 = 165 - 160 * i / 6371
        Circle (0, 0), i, _RGB(EarthColorization2 / 1.5, EarthColorization2 / 1.5, EarthColorization / 1.5)
    Next i

    Locate 20, 90: Print " Calculating for 5 seconds. Please Wait"
    _Display



    CometRadius = 30
    LakeMichCount = 0

    For Z1 = 0 To 4
        Select Case Scene$
            Case "ChesapeakeBay"
                CometItselfSpeedX(Z1) = 37 ' km/sec
                CometItselfSpeedY(Z1) = 0 ' km/sec
                CometItselfSpeedZ(Z1) = -48 ' km/sec

                CometItselfRadius(0) = 3: CometItselfX(0) = -13500: CometItselfY(0) = -980: CometItselfZ(0) = 14920: CometItselfColor(0) = _RGB(0, 255, 0) ' GREEN
                CometItselfRadius(1) = 3: CometItselfX(1) = -13500: CometItselfY(1) = -980: CometItselfZ(1) = 14920: CometItselfColor(1) = _RGB(255, 0, 0) ' RED
                CometItselfRadius(2) = 3: CometItselfX(2) = -13500: CometItselfY(2) = -980: CometItselfZ(2) = 14920: CometItselfColor(2) = _RGB(0, 0, 255) ' BLUE
                CometItselfRadius(3) = 3: CometItselfX(3) = -13500: CometItselfY(3) = -980: CometItselfZ(3) = 14920: CometItselfColor(3) = _RGB(255, 255, 255) ' White
                CometItselfRadius(4) = 3: CometItselfX(4) = -13500: CometItselfY(4) = -980: CometItselfZ(4) = 14920: CometItselfColor(4) = _RGB(255, 255, 0) ' Yellow

        End Select

        CometRadius = CometItselfRadius(Z1): DrawPathstartX = CometItselfX(Z1): DrawPathstartY = CometItselfY(Z1): DrawPathstartZ = CometItselfZ(Z1)
        CometInitialSpeedX = CometItselfSpeedX(Z1) ' km/sec
        CometInitialSpeedY = CometItselfSpeedY(Z1) ' km/sec
        CometInitialSpeedZ = CometItselfSpeedZ(Z1) ' km/sec

        TotalPointsCalculated = TotalPointsCalculated + 1

        pointstoDraw = 1
        startX = DrawPathstartX
        startY = DrawPathstartY
        startZ = DrawPathstartZ
        CometPathSpeedX = CometInitialSpeedX
        CometPathSpeedY = CometInitialSpeedY
        CometPathSpeedZ = CometInitialSpeedZ
        PreviousImpactThickness = 0
        ItHasImpactedOnBottom = 0

        While pointstoDraw < PointsTotal
            Distance = Sqr(startX ^ 2 + startY ^ 2 + startZ ^ 2)

            If Distance < PlanetRadius + CometRadius Then '  BOTTOM of comet is hitting  ************************
                If PreviousImpactThickness = 0 Then ' Initialize Comet particles so that some of comet continues on after impact - need present comet location and speeds to do that.
                    Select Case Z1 ' Too many points if we use all 300 potential points
                        Case 0: ii1 = 1: ii2 = 75: NextCometColor = _RGB(0, 255, 0)
                        Case 1: ii1 = 76: ii2 = 95: NextCometColor = _RGB(255, 0, 0)
                        Case 2: ii1 = 96: ii2 = 110: NextCometColor = _RGB(0, 0, 255)
                        Case 3: ii1 = 111: ii2 = 125: NextCometColor = _RGB(255, 255, 255)
                        Case 4: ii1 = 126: ii2 = 150: NextCometColor = _RGB(255, 255, 0)
                    End Select
                    For ii = ii1 To ii2
                        For jj = 1 To 300
                            CometX(ii, jj) = 0
                            CometY(ii, jj) = 0
                            CometZ(ii, jj) = 0
                            CometSpeedX(ii, jj) = 0
                            CometSpeedY(ii, jj) = 0
                            CometSpeedZ(ii, jj) = 0
                            CometMass(ii, jj) = 2
                            CometColor(ii, jj) = _RGB(100, 0, 255)
                        Next jj
                    Next ii
                End If

                DotXY = (PreviousX * (startX - PreviousX) + PreviousY * (startY - PreviousY) + PreviousZ * (startZ - PreviousZ))
                XYMagnitude = ((startX - PreviousX) ^ 2 + (startY - PreviousY) ^ 2 + (startZ - PreviousZ) ^ 2) ^ 0.5 * (startX ^ 2 + startY ^ 2 + startZ ^ 2) ^ 0.5

                Checkangle = 1
                If Abs(XYMagnitude) > .0000001 Then Checkangle = DotXY / XYMagnitude
                If Abs(Checkangle) > 1 Then Checkangle = 1
                AngleofImpact = ARCCOS(Checkangle) * 180 / pi '   or 90 degrees minus that
                CombinedAngle = AngleofImpact - 90

                ItHasImpactedOnBottom = 1
                ImpactThickness = PlanetRadius + CometRadius - Distance

                If ImpactThickness > PreviousImpactThickness Then '  if less then its leaving the planet surface not still impacting
                    If ImpactThickness <= CometRadius * 2 Then
                        If ImpactThickness <= CometRadius Then
                            CircleRad = Sqr(CometRadius ^ 2 - (CometRadius - ImpactThickness) ^ 2)
                        Else
                            CircleRad = Sqr(CometRadius ^ 2 - (ImpactThickness - CometRadius) ^ 2)
                        End If
                    End If
                    Circle (startX, startY), CircleRad * 2 * 2, _RGB(0, 155, 155) '  a crater should be about 10X the comet diameter but only add 2X
                    If CombinedAngle < 15 Then Circle (startX, startY), CircleRad * 2 * 2, _RGB(155, 155, 255)
                    If CombinedAngle < 10 Then Circle (startX, startY), CircleRad * 2 * 2, _RGB(255, 255, 155)
                    If CombinedAngle < 5 Then Circle (startX, startY), CircleRad * 2 * 2, _RGB(255, 155, 155)
                    If CombinedAngle < 2 Then Circle (startX, startY), CircleRad * 2 * 2, _RGB(255, 0, 0)
                    If CombinedAngle > 40 And CombinedAngle < 50 Then Circle (startX, startY), CircleRad * 2 * 2, _RGB(0, 205, 155)
                    If CombinedAngle >= 80 Then Circle (startX, startY), CircleRad * 2 * 2, _RGB(0, 255, 255)
                    PreviousImpactThickness = ImpactThickness

                    LakeMichCount = LakeMichCount + 1: If LakeMichCount > 100 Then LakeMichCount = 100
                    LakeMichLocX(LakeMichCount, Z1) = startX: LakeMichLocY(LakeMichCount, Z1) = startY: LakeMichLocZ(LakeMichCount, Z1) = startZ: LakeMichLocRad(LakeMichCount, Z1) = CircleRad

                    Call AssignExplosionPoints(Z1, ImpactThickness, startX, startY, startZ, CometPathSpeedX, CometPathSpeedY, CometPathSpeedZ)

                End If
            End If
            '               IF Distance < PlanetRadius + CometRadius AND Distance > PlanetRadius + CometRadius * .8 THEN '********************************* HIT PLANET by TOP of comet *************************************************************************************
            '                    CIRCLE (startX, startY), 20, _RGB(255, 0, 0)
            '                END IF
            If Distance < PlanetRadius - CometRadius Then '********************************* HIT PLANET by TOP of comet *************************************************************************************
                CometSpeedAtImpact = Sqr(CometPathSpeedX ^ 2 + CometPathSpeedY ^ 2 + CometPathSpeedZ ^ 2)
                '                    CALL ImpactProbabilitiesPrintResults(PreviousX, startX, PreviousY, startY, PreviousZ, startZ, TotalPointsCalculated, CometSpeedAtImpact)
                '  Angle = arccos(A.X/|a| |x|) =  Cos-1[(x*a+y*b+z*c)/(Sqrt(x^2+y^2+z^2) * Sqrt(a^2+b^2+c^2))]    Scalar Law - https://en.wikipedia.org/wiki/Dot_product
                '  a=startx, b=starty, c=startz
                '  x=PreviousX, y=PreviousY, z=PreviousZ
                '  Angle between incoming comet and earth is then:
                '  Vector of earth radius =(0,0,0)-(a,b,c); Vector of incoming comet = (0,0,0)-(x-a,y-b,z-c) with x,y,z = PreviousX,Y,Z; a,b,c=startX,Starty,startz
                '  DotXY = (PreviousX*(startX-PreviousX)  + PreviousY*(startY-PreviousY)  + PreviousZ*(startZ-PreviousZ))
                '  XYMagnitude = ((startX-PreviousX)^2 + (startY-PreviousY)^2 + (startZ-PreviousZ)^2)^0.5 * (startx^2 + starty^2 + startz ^2)^0.5
                '  Angle of Impact then = Arccos (DotXY/XYMagnitude) * 180 / pi    or 90 degrees minus that
                '  ***************    NOTE: ARCOS (x) needs X <=1  **************************        IF x < 1 THEN ARCCOS = (2 * ATN(1)) - ATN(x / SQR(1 - x * x)) ELSE BEEP

                DotXY = (PreviousX * (startX - PreviousX) + PreviousY * (startY - PreviousY) + PreviousZ * (startZ - PreviousZ))
                XYMagnitude = ((startX - PreviousX) ^ 2 + (startY - PreviousY) ^ 2 + (startZ - PreviousZ) ^ 2) ^ 0.5 * (startX ^ 2 + startY ^ 2 + startZ ^ 2) ^ 0.5

                Checkangle = 1
                If Abs(XYMagnitude) > .0000001 Then Checkangle = DotXY / XYMagnitude
                If Abs(Checkangle) > 1 Then Checkangle = 1
                AngleofImpact = ARCCOS(Checkangle) * 180 / pi '   or 90 degrees minus that
                CombinedAngle = AngleofImpact - 90


                Color _RGB(0, 0, 0), _RGB(215, 215, 215)
                _PrintString (800, 3), " Impact Speed:  " + Left$(Str$(CometSpeedAtImpact), 6) + "  km/s"
                _PrintString (1100, 3), " Impact Angle:  " + Left$(Str$(CombinedAngle), 6) + "   "
                Color _RGB(255, 255, 255), _RGB(0, 0, 0)
                '                _DISPLAY

                I9 = Int(CombinedAngle / 5 - .0001) + 1 ' 1 for 0-5, 2 for 5.0001 to 10 etc
                If I9 < 0 Then I9 = 0
                If I9 > 20 Then I9 = 20
                ImpactAngleProbs(I9) = ImpactAngleProbs(I9) + 1
                ImpactAngleProbPercents(I9) = 100 * ImpactAngleProbs(I9) / TotalPointsCalculated
                NumPointsHitting = NumPointsHitting + 1
                pointstoDraw = PointsTotal


                If Z1 <= NumPointsToCalculate / 2 Then
                    Circle (startX, startY), CometRadius * 1.5, _RGB(200, 200, 200) '  DRAW COMET at its actual diameter (Radius X 2) at point of comet's top impacting less a bit for distance
                Else
                    Circle (startX, startY), CometRadius * 2, _RGB(255, 255, 150) '  DRAW COMET at its actual diameter (Radius X 2) at point of comet's top impacting
                End If
            End If

            EAcc = (GEarth / (Distance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
            CometPathSpeedX = CometPathSpeedX + (EAcc / Distance) * (0 - startX) * 1
            CometPathSpeedY = CometPathSpeedY + (EAcc / Distance) * (0 - startY) * 1
            CometPathSpeedZ = CometPathSpeedZ + (EAcc / Distance) * (0 - startZ) * 1
            PreviousX = startX
            PreviousY = startY
            PreviousZ = startZ
            startX = startX + CometPathSpeedX
            startY = startY + CometPathSpeedY
            startZ = startZ + CometPathSpeedZ
            pointstoDraw = pointstoDraw + 1

            If startX < -250000 Then pointstoDraw = PointsTotal
            If startX > 250000 Then pointstoDraw = PointsTotal
            If startY < -250000 Then pointstoDraw = PointsTotal
            If startY > 250000 Then pointstoDraw = PointsTotal
            If startZ < -250000 Then pointstoDraw = PointsTotal
            If startZ > 250000 Then pointstoDraw = PointsTotal
        Wend


        If Distance >= PlanetRadius + CometRadius Then ' missed planet
            If ItHasImpactedOnBottom = 1 Then ' hit at bottom but not at top
                ImpactAngleProbs(1) = ImpactAngleProbs(1) + 1
                ImpactAngleProbPercents(1) = 100 * ImpactAngleProbs(1) / TotalPointsCalculated
                NumPointsHitting = NumPointsHitting + 1
            Else ' Missed totally
                ImpactAngleProbs(0) = ImpactAngleProbs(0) + 1
                ImpactAngleProbPercents(0) = 100 * ImpactAngleProbs(0) / TotalPointsCalculated
            End If
        End If


        If RunImpactProbabilities$ = "" Then RunImpactProbabilities$ = InKey$
        If RunImpactProbabilities$ <> "" And RunImpactProbabilities$ <> Chr$(16) Then
            Call CheckifChangeScene(RunImpactProbabilities$, RunProgram$) ' check if someone wants to switch to another scene before the 5 seconds calculations are over
            If RunProgram$ = "StartOver" Or RunProgram$ = "StartOverMenu" Then Exit Sub
            RunImpactProbabilities$ = ""
        End If

    Next Z1

    ' Draw Splash around comet impact
    CometRadius20 = 6
    For ii = 151 To 225
        For jj = 1 To 300
            CometX(ii, jj) = -5000 ' Center of impact
            CometY(ii, jj) = -975
            CometZ(ii, jj) = 3850
            While Sqr(CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2) < PlanetRadius + CometRadius * .5: CometX(ii, jj) = CometX(ii, jj) * 1.001: CometY(ii, jj) = CometY(ii, jj) * 1.001: CometZ(i, jj) = CometZ(ii, jj) * 1.001: Wend
            Tmp = CometRadius20 * (Rnd(99) - .5) * 1.64 * 3850 / 5010
            Tmp2 = 1 + (5000 / 3850) ^ 2 ' Y = SQRT(Cometradius^2 + X/Z portion of radius ^2);  and Z = X*5000/3850
            CX1 = Tmp
            CZ1 = CX1 * 5000 / 3850

            While (CX1 ^ 2 + CZ1 ^ 2) ^ .5 > CometRadius20: CX1 = CX1 * .99: CZ1 = CZ1 * .99: Wend

            If (CometRadius20 ^ 2 - CX1 ^ 2 * Tmp2) < 0 Then CY1 = 0 Else CY1 = ((CometRadius20 ^ 2 - CX1 ^ 2 * Tmp2) ^ .5)
            While Sqr(CX1 ^ 2 + CY1 ^ 2 + CZ1 ^ 2) < CometRadius20
                CX1 = CX1 * 1.001
                CZ1 = CX1 * 5000 / 3850
                If (CometRadius20 ^ 2 - CX1 ^ 2 * Tmp2) < 0 Then CY1 = 0 Else CY1 = ((CometRadius20 ^ 2 - CX1 ^ 2 * Tmp2) ^ .5)
            Wend

            If Rnd(95) - .5 < 0 Then CY1 = -CY1

            CometX(ii, jj) = CometX(ii, jj) + CX1 ' points around impact center point at radius of comet
            CometY(ii, jj) = CometY(ii, jj) + CY1
            CometZ(ii, jj) = CometZ(ii, jj) + CZ1
            While Sqr(CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2) < PlanetRadius + CometRadius * .5: CometX(ii, jj) = CometX(ii, jj) * 1.001: CometY(ii, jj) = CometY(ii, jj) * 1.001: CometZ(ii, jj) = CometZ(ii, jj) * 1.001: Wend

            Call RandomNumbersFewNearZero

            ' Comet splash speed is essentially a vector along the path from center of earth to point plus a vector from center of impact to point.
            CometSpeedX(ii, jj) = 1.35 * RA * CometX(ii, jj) / 6371 + 1.6 * RA * (CometX(ii, jj) + 5000) / CometRadius20
            CometSpeedY(ii, jj) = 1.35 * RB * CometY(ii, jj) / 6371 + 1.6 * RB * (CometY(ii, jj) + 975) / CometRadius20
            CometSpeedZ(ii, jj) = 1.35 * RC * CometZ(ii, jj) / 6371 + 1.6 * RC * (CometZ(ii, jj) - 3850) / CometRadius20



            If EarthRotation$ = "Yes" Then CometSpeedY(ii, jj) = CometSpeedY(ii, jj) - .5 ' - .5 is earth rotation
            CometMass(ii, jj) = 1.2
            If Sqr(CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2) < PlanetRadius - CometRadius * .5 Then CometMass(ii, jj) = 0
            CometSize(ii, jj) = 15 * Rnd(22) + 1
            '            CometColor(ii, jj) = _RGB(255, 0, 0)
            CometColor(ii, jj) = _RGB(255 * Rnd(99), 255 * Rnd(23), 255 * Rnd(45))

        Next jj
    Next ii


    ' Draw FireBall around comet impact point  *************************
    CometRadius20 = 6
    For ii = 226 To 300
        For jj = 1 To 300
            CometX(ii, jj) = -5000
            CometY(ii, jj) = -975
            CometZ(ii, jj) = 3850
            While Sqr(CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2) < PlanetRadius + CometRadius * .5: CometX(ii, jj) = CometX(ii, jj) * 1.001: CometY(ii, jj) = CometY(ii, jj) * 1.001: CometZ(i, jj) = CometZ(ii, jj) * 1.001: Wend
            '            ChkHere = 0
            '            WHILE (SQR((CometX(ii, jj) + CX1) ^ 2 + (CometY(ii, jj) + CY1) ^ 2 + (CometZ(ii, jj) + CZ1) ^ 2) > PlanetRadius + CometRadius) OR (SQR((CometX(ii, jj) + CX1) ^ 2 + (CometY(ii, jj) + CY1) ^ 2 + (CometZ(ii, jj) + CZ1) ^ 2) < PlanetRadius + CometRadius) AND ChkHere < 5
            '                ChkHere = ChkHere + 1
            CX1 = CometRadius20 * (Rnd(99) - .5)
            CY1 = CometRadius20 * (Rnd(98) - .5)
            CZ1 = CometRadius20 * (Rnd(97) - .5)
            While Sqr(CX1 ^ 2 + CY1 ^ 2 + CZ1 ^ 2) < CometRadius20: CX1 = CX1 * 1.01: CY1 = CY1 * 1.01: CZ1 = CZ1 * 1.01: Wend
            While Sqr(CX1 ^ 2 + CY1 ^ 2 + CZ1 ^ 2) > CometRadius20: CX1 = CX1 * .99: CY1 = CY1 * .99: CZ1 = CZ1 * .99: Wend
            '            WEND
            CometX(ii, jj) = CometX(ii, jj) + CX1
            CometY(ii, jj) = CometY(ii, jj) + CY1
            CometZ(ii, jj) = CometZ(ii, jj) + CZ1

            Call RandomNumbersFewNearZero
            ' Set speed only in line from comet impact point. Should send particles out in a sphere
            Temp = 2 * RB
            CometSpeedX(ii, jj) = (CometX(ii, jj) + 5000) * 10
            CometSpeedY(ii, jj) = (CometY(ii, jj) + 975) * 10
            CometSpeedZ(ii, jj) = (CometZ(ii, jj) - 3850) * 10



            If EarthRotation$ = "Yes" Then CometSpeedY(ii, jj) = CometSpeedY(ii, jj) - .5 ' - .5 is earth rotation
            CometMass(ii, jj) = 1.2
            If Sqr(CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2) < PlanetRadius - CometRadius * .5 Then CometMass(ii, jj) = 0
            CometSize(ii, jj) = 10
            CometColor(ii, jj) = _RGB(255, 0, 0)
        Next jj
    Next ii



    ' Draw Mushroom Cloud around comet impact point  *************************
    CometRadius20 = 20
    For ii = 261 To 300
        For jj = 1 To 300
            CometX(ii, jj) = -5000
            CometY(ii, jj) = -975
            CometZ(ii, jj) = 3850
            While Sqr(CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2) < PlanetRadius + CometRadius * .5: CometX(ii, jj) = CometX(ii, jj) * 1.001: CometY(ii, jj) = CometY(ii, jj) * 1.001: CometZ(i, jj) = CometZ(ii, jj) * 1.001: Wend
            CX1 = CometRadius20 * (Rnd(99) - .5)
            CY1 = CometRadius20 * (Rnd(98) - .5)
            CZ1 = CometRadius20 * (Rnd(97) - .5)
            While Sqr(CX1 ^ 2 + CY1 ^ 2 + CZ1 ^ 2) < CometRadius20: CX1 = CX1 * 1.01: CY1 = CY1 * 1.01: CZ1 = CZ1 * 1.01: Wend
            While Sqr(CX1 ^ 2 + CY1 ^ 2 + CZ1 ^ 2) > CometRadius20: CX1 = CX1 * .99: CY1 = CY1 * .99: CZ1 = CZ1 * .99: Wend
            '            WEND
            CometX(ii, jj) = CometX(ii, jj) + CX1
            CometY(ii, jj) = CometY(ii, jj) + CY1
            CometZ(ii, jj) = CometZ(ii, jj) + CZ1

            Call RandomNumbersFewNearZero
            ' Set speed only in line from comet impact point. Should send particles out in a sphere
            Temp = 2 * RB
            CometSpeedX(ii, jj) = (CometX(ii, jj) + 5000) * .14 - 3.6 * (Rnd(99) + .2)
            CometSpeedY(ii, jj) = (CometY(ii, jj) + 975) * .14 - .7 * (Rnd(99) + .2)
            CometSpeedZ(ii, jj) = (CometZ(ii, jj) - 3850) * .14 + 2.8 * (Rnd(99) + .2)

            '            CometSpeedX(ii, jj) = (CometX(ii, jj) + 5000) * .35 - 3.6 * (RND(99) + .2)
            '            CometSpeedY(ii, jj) = (CometY(ii, jj) + 975) * .35 - .7 * (RND(99) + .2)
            '            CometSpeedZ(ii, jj) = (CometZ(ii, jj) - 3850) * .35 + 2.8 * (RND(99) + .2)



            If EarthRotation$ = "Yes" Then CometSpeedY(ii, jj) = CometSpeedY(ii, jj) - .5 ' - .5 is earth rotation
            CometMass(ii, jj) = 1.2
            If Sqr(CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2) < PlanetRadius - CometRadius * .5 Then CometMass(ii, jj) = 0
            ' Removes bottom of sphere of ejecta, otherwise one gets a perfect sphere
            Speed = Sqr(CometSpeedX(ii, jj) ^ 2 + CometSpeedY(ii, jj) ^ 2 + CometSpeedZ(ii, jj) ^ 2)
            If Speed < 2 Then CometMass(ii, jj) = 0
            CometSize(ii, jj) = 100
            CometColor(ii, jj) = _RGB(255 * Speed / 10, 255 - (255 * Speed / 10), 0)
        Next jj
    Next ii





    Cls

    '     ############################################   BEGIN DISPLAY OF CAROLINA BAY SCENES    ###################################################    ##################################    #############################
    '     ############################################   BEGIN DISPLAY OF CAROLINA BAY SCENES    ###################################################    ##################################    #############################

    '    CALL DisplayCarolinaBayImpacts(A$)
    '    IF RunProgram$ = "StartOver" OR RunProgram$ = "StartOverMenu" THEN EXIT SUB
    '    RunImpactProbabilities$ = A$
    '   GOTO CheckFunctionKeysHere
    '
    'END SUB

    'SUB DisplayCarolinaBayImpacts (A$)

    ' Display 3D  Version
    '    EarthRotation$ = "No" We want this to be chosen while running the program. Since it needs the particles to have .5 added to their Y speed, it needs the whole routine to be re-run  is F2, Ctrl S
    CarolinaView$ = "LeftSide"
    DrawCraters$ = "Both"
    AtmosphereDrag$ = "Yes"
    HighlightSpeed$ = "Yes"
    RemoveHighSpeed$ = "No"
    ShowPaths$ = "No"
    CometFiresOn$ = "No"
    HighlightSpeed$ = "No"
    CometHitEarth$ = "No"
    '    EarthRotation$ = "No" '  ***************** Generally do not have this line here AND it also needs to be in the main calculation section NOT here


    If CarolinaNumbers <> 0 Then
        DrawCraters$ = "Both"
        AtmosphereDrag$ = "Yes"
        HighlightSpeed$ = "No"
        CometFiresOn$ = "No"
        ShowPaths$ = "Yes"
        EarthRotation$ = "No"
        Select Case CarolinaNumbers
            Case 1: StartRemove = 0: EndRemove = 2 ' Show 0-2 km/s
            Case 2: StartRemove = 2: EndRemove = 3: ' Show 2-3 km/s
            Case 3: StartRemove = 3: EndRemove = 4 ' Show 3-4
            Case 4: StartRemove = 4: EndRemove = 5 ' Show 4-5
            Case 5: StartRemove = 5: EndRemove = 6 ' Show 5-6
            Case 6: StartRemove = 6: EndRemove = 7 ' Show 6-7
            Case 7: StartRemove = 7: EndRemove = 8 ' Show 7-8
            Case 8: StartRemove = 8: EndRemove = 10 ' Show 8-10
            Case 9: StartRemove = 0: EndRemove = 10 ' Show 0-10
        End Select
        For ii = 1 To 300
            For jj = 1 To 300
                Speed = Sqr(CometSpeedX(ii, jj) ^ 2 + CometSpeedY(ii, jj) ^ 2 + CometSpeedZ(ii, jj) ^ 2)
                If Speed < StartRemove Or Speed > EndRemove Then CometMass(ii, jj) = 0
            Next jj
        Next ii
    End If

    If LakeMichCount > 100 Then LakeMichCount = 100
    Call WorldCoordinates

    ' Rotate about Z axis:
    '   X = X * cosTheta - Y * sinTheta
    '   Y = Y * cosTheta + X * sinTheta
    ' Rotate about Y axis:
    '   X = X * cosTheta + Z * sinTheta;
    '   Z = Z * cosTheta - X * sinTheta;
    '    aaa = CometSpeedX(ii, jj)
    '    CometSpeedX(ii, jj) = .7 * CometSpeedX(ii, jj) - .7 * CometSpeedZ(ii, jj)
    '    CometSpeedZ(ii, jj) = .7 * CometSpeedZ(ii, jj) + .7 * aaa
    ' Rotate about X axis:
    '   Y = Y * cosTheta - Z * sinTheta;  Cos 42 = .743, Sin 42 = .669
    '   Z = Z * cosTheta + Y * sinTheta;
    '    aaa = CometSpeedY(ii, jj)
    '    CometSpeedY(ii, jj) = .743 * CometSpeedY(ii, jj) - .669 * CometSpeedZ(ii, jj)
    '    CometSpeedZ(ii, jj) = .743 * CometSpeedZ(ii, jj) + .669 * aaa
    ' Rotate back about Y axis: (rotate from Equator to Michigan ~ 45 degrees)
    '   X = X * cosTheta + Z * sinTheta;  Cos 45 = .7, Sin 45 = .7; cos 60 = .5, sin 60 = .866
    '   Z = Z * cosTheta - X * sinTheta;  Cos -45 = .7, Sin -45 = -.7; cos -60 = .5, sin -60 = -.866
    '    aaa = CometSpeedX(ii, jj)
    '    CometSpeedX(ii, jj) = .7 * CometSpeedX(ii, jj) + .7 * CometSpeedZ(ii, jj)
    '    CometSpeedZ(ii, jj) = .7 * CometSpeedZ(ii, jj) - .7 * aaa


    ' EarthRotation = EarthRotation * pi / 180 ' radians of rotation per second
    ' EARTH ROTATES 360/24HOURS/60 MINUTES/60 SECONDS PER SECOND =360/(24*60*60)
    ' Cal rotation in radians = degrees * pi/180
    ' So calculate (360/180)*pi/(86400)
    EarthRotation = 2 * 3.141592654 / (86400) ' radians of rotation per second

    FreshStart:

    BeginSplash$ = "No"
    TimeCount = 0

    StartDisplayCarolinaBays:
    Cls

    StartDisplayCarolinaBayswithoutCLS:

    KeyPressedInRoutine$ = ""

    A$ = "": While A$ = "": A$ = InKey$
        Window (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, ZoomWindow4)
        TimeCount = TimeCount + 1
        '        IF INT(TimeCount / 10) * 10 = TimeCount THEN a2a$ = "": WHILE a2a$ = "": a2a$ = INKEY$: WEND

        If ShowPaths$ <> "Yes" Then Cls

        For i = 7 To 6371 Step 10
            EarthColorization = 255 - 100 * i / 6371
            EarthColorization2 = 165 - 160 * i / 6371
            Circle (0, 0), i, _RGB(EarthColorization2 / 1.5, EarthColorization2 / 1.5, EarthColorization / 1.5)
        Next i
        '        LINE (0, -8000)-(0, 8000), _RGB(255, 255, 0) Earth Cross Lines - useful for programming
        '        LINE (-8000, 0)-(8000, 0), _RGB(255, 255, 0)

        If AtmosphereDrag$ = "Yes" Then
            For i = 6371 To 6871 Step 10 ' Atmosphere
                EarthColorization = 120 - (100 - (6771 - i) / 5)
                Circle (0, 0), i, _RGB(EarthColorization, EarthColorization, EarthColorization * 2)
            Next i
        End If

        For ii = 1 To 1100
            skip = 0
            Select Case CarolinaView$
                Case "Top"
                    If WorldZ(ii) > 0 Then
                        If (WorldX(ii) = 0 And WorldY(ii) = 0) Then skip = 1
                        If (WorldX(ii + 1) = 0 And WorldY(ii + 1) = 0) Then skip = 1
                        If skip = 0 Then Line (WorldX(ii), WorldY(ii))-(WorldX(ii + 1), WorldY(ii + 1)), _RGB(255, 255, 255)
                    End If
                Case "Bottom"
                    If WorldZ(ii) < 0 Then
                        If (WorldX(ii) = 0 And WorldY(ii) = 0) Then skip = 1
                        If (WorldX(ii + 1) = 0 And WorldY(ii + 1) = 0) Then skip = 1
                        If skip = 0 Then Line (-1 * WorldX(ii), WorldY(ii))-(-1 * WorldX(ii + 1), WorldY(ii + 1)), _RGB(255, 255, 255)
                    End If
                Case "Back"
                    If WorldX(ii) > 0 Then
                        If (WorldX(ii) = 0 And WorldY(ii) = 0) Then skip = 1
                        If (WorldX(ii + 1) = 0 And WorldY(ii + 1) = 0) Then skip = 1
                        If skip = 0 Then Line (WorldY(ii), WorldZ(ii))-(WorldY(ii + 1), WorldZ(ii + 1)), _RGB(255, 255, 255)
                    End If
                Case "Front"
                    If WorldX(ii) < 0 Then
                        If (WorldX(ii) = 0 And WorldY(ii) = 0) Then skip = 1
                        If (WorldX(ii + 1) = 0 And WorldY(ii + 1) = 0) Then skip = 1
                        If skip = 0 Then Line (-1 * WorldY(ii), WorldZ(ii))-(-1 * WorldY(ii + 1), WorldZ(ii + 1)), _RGB(255, 255, 255)
                    End If
                Case "LeftSide"
                    If WorldY(ii) <= 0 Then
                        If (WorldX(ii) = 0 And WorldY(ii) = 0) Then skip = 1
                        If (WorldX(ii + 1) = 0 And WorldY(ii + 1) = 0) Then skip = 1
                        If skip = 0 Then Line (WorldX(ii), WorldZ(ii))-(WorldX(ii + 1), WorldZ(ii + 1)), _RGB(255, 255, 255)
                    End If
                Case "RightSide"
                    If WorldY(ii) >= 0 Then
                        If (WorldX(ii) = 0 And WorldY(ii) = 0) Then skip = 1
                        If (WorldX(ii + 1) = 0 And WorldY(ii + 1) = 0) Then skip = 1
                        If skip = 0 Then Line (-1 * WorldX(ii), WorldZ(ii))-(-1 * WorldX(ii + 1), WorldZ(ii + 1)), _RGB(255, 255, 255)
                    End If
            End Select
            If EarthRotation$ = "Yes" And BeginSplash$ = "Yes" Then
                aaa = WorldX(ii)
                WorldX(ii) = WorldX(ii) * Cos(EarthRotation) - WorldY(ii) * Sin(EarthRotation)
                WorldY(ii) = WorldY(ii) * Cos(EarthRotation) + aaa * Sin(EarthRotation)
            End If
        Next ii


        R1 = Rnd(30) * 70: R2 = Rnd(31) * 40: R3 = Rnd(32) * 25: R4 = (Rnd(34) - .5) * 40: R5 = (Rnd(35) - .5) * 50


        For ii = 0 To 4 ' Calculate the locations of the comets themselves
            Distance = Sqr(CometItselfX(ii) ^ 2 + CometItselfY(ii) ^ 2 + CometItselfZ(ii) ^ 2)
            EAcc = (GEarth / (Distance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
            CometItselfSpeedX(ii) = CometItselfSpeedX(ii) + (EAcc / Distance) * (0 - CometItselfX(ii)) * 1
            CometItselfSpeedY(ii) = CometItselfSpeedY(ii) + (EAcc / Distance) * (0 - CometItselfY(ii)) * 1
            CometItselfSpeedZ(ii) = CometItselfSpeedZ(ii) + (EAcc / Distance) * (0 - CometItselfZ(ii)) * 1
            CometItselfX(ii) = CometItselfX(ii) + CometItselfSpeedX(ii)
            CometItselfY(ii) = CometItselfY(ii) + CometItselfSpeedY(ii)
            CometItselfZ(ii) = CometItselfZ(ii) + CometItselfSpeedZ(ii)
            If Distance < PlanetRadius + CometItselfRadius(ii) And BeginSplash$ <> "Yes" Then TimeCount = 1: BeginSplash$ = "Yes" ' reset timer to 1 after impact
        Next ii


        If BeginSplash$ = "Yes" Then
            BeginII = 1
            EndII = 150
            If Scene$ = "ChesapeakeBay" Then EndII = 300: BeginII = 226

            For ii = BeginII To EndII
                For jj = 1 To 300 '   ################################################################################################################
                    Distance = Sqr(CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2)
                    Speed = Sqr(CometSpeedX(ii, jj) ^ 2 + CometSpeedY(ii, jj) ^ 2 + CometSpeedZ(ii, jj) ^ 2)

                    If ii > 225 And ii < 261 And CometMass(ii, jj) > 0 Then ' DIMINISH FIREBALL as time passes   ******************************
                        CometColor(ii, jj) = _RGB(255 - (TimeCount * 10), 0, 0)
                        If TimeCount > 20 Then CometMass(ii, jj) = 0
                    End If


                    If CometMass(ii, jj) = 1.2 Then ' still in flight
                        EAcc = (GEarth / (Distance ^ 2)) / 1000 ^ 3 ' /1000 converts acc to km per sec
                        If ii < 226 Or ii > 260 Then ' Do not add gravity to fireball  ************************** GRAVITY  GRAVITY  GRAVITY***** GRAVITY  GRAVITY  GRAVITY***** GRAVITY  GRAVITY  GRAVITY***** GRAVITY  GRAVITY  GRAVITY
                            CometSpeedX(ii, jj) = CometSpeedX(ii, jj) + (EAcc / Distance) * (0 - CometX(ii, jj)) * 1
                            CometSpeedY(ii, jj) = CometSpeedY(ii, jj) + (EAcc / Distance) * (0 - CometY(ii, jj)) * 1
                            CometSpeedZ(ii, jj) = CometSpeedZ(ii, jj) + (EAcc / Distance) * (0 - CometZ(ii, jj)) * 1
                        End If
                        ' add in atmospheric drag based on US Standard Atmosphere (from US Standard Atmosphere charts of 1976 - us-standard-atmosphere_st76-1562_noaa.pdf)
                        ' Standard Atmosphereic density vs altitude: 0 km 1.225 kg/m^3; 1 km 1.116; 2 km 1.006; 3 km 0.909; 4 km 0.819; 5 km 0.736; 6 km 0.66; 7 km 0.59; 8 km 0.525; 9 km 0.466; 10 km 0.413;
                        ' 11 km 0.364; 12 km 0.311; 13 km 0.265; 14 km 0.227; 15  km 0.194; 16 km 0.165; 17 km 0.141; 18 km 0.121; 19 km 0.103; 20 km 0.088;
                        ' 21 km 0.075; 22 km 0.064; 23 km 0.054; 24 km 0.046; 25 km 0.039; 26 km 0.034; 27 km 0.029; 28 km 0.024; 29 km 0.021; 30 km 0.018
                        ' 35 km 0.007;  40 km 0.0038; 45 km 0.0019; 50 km 0.00097; 55 km 0.00053; 60 km 0.00029; 65 km 0.00015; 70 km 0.000074; 75 km 0.000035; 80 km 0.000016; 90 km 0.0000034
                        ' 100 km 0.00000056;  150 km 0.000000002; 200 km 0.00000000025;

                        'the equation for drag force: If an object moves through a fluid, it experiences a resisting force, the drag force. The value of this force depends on the size and shape of an object, density of the fluid and relative velocity of the object and the fluid. The equation is
                        '   Fd = 1/2 * D * V^2 * A * Cd
                        '    where   Fd is the drag force in Newtons; D is the gas/liquid density; V is the relative velocity; A is the reference area; Cd is the drag coefficient.
                        '  for a sphere, the Drag Coiefficient is 0.1 for high speeds, .45 for lower speeds, .48 for rough outside surface. Skier is about 1.0 Bullet about 0.3, USE 1 as reasonable number
                        ' 1 Newton - acceleration required to add 1 m/sec to 1 kg. So 1000 Newton are needed to add or remove 1 Km/s to a 1 kg object.
                        ' Assume spheres, cross section is pi r ^ 2, Volume is 4/3 pi r ^ 3, at density of 1, mass is (4/3 pi r^3) m^3, * 1000 kg/(m^3)

                        ' CometSize(ii, jj) ranges from 25 to 500m radius, area = pi * size^2, mass = 1000 * pi *4/3 *size^3 kg


                        If AtmosphereDrag$ = "Yes" Then
                            SpeedDiff = 0: Airdensity = 0
                            If TimeCount > 30 Then ' no drag in first half minute due to cloud dragging atmosphere with it
                                Select Case Distance - PlanetRadius
                                    Case Is < 1: Airdensity = 1.225
                                    Case Is < 2: Airdensity = 1.116
                                    Case Is < 3: Airdensity = 1.006
                                    Case Is < 4: Airdensity = 0.909
                                    Case Is < 5: Airdensity = 0.819
                                    Case Is < 6: Airdensity = 0.736
                                    Case Is < 7: Airdensity = 0.66
                                    Case Is < 8: Airdensity = 0.59
                                    Case Is < 9: Airdensity = 0.525
                                    Case Is < 10: Airdensity = 0.466
                                    Case Is < 11: Airdensity = 0.413
                                    Case Is < 12: Airdensity = 0.364
                                    Case Is < 15: Airdensity = 0.2525 ' Average 12 to 15
                                    Case Is < 18: Airdensity = 0.1575
                                    Case Is < 21: Airdensity = 0.098
                                    Case Is < 24: Airdensity = 0.0605
                                    Case Is < 27: Airdensity = 0.0375
                                    Case Is < 30: Airdensity = 0.0235
                                    Case Is < 50: Airdensity = 0.0038
                                    Case Is < 75: Airdensity = 0.000177 ' average 50 - 75 km
                                    Case Is < 100: Airdensity = 0.000004
                                        '                       0.00000056 =  100 km density from chart
                                    Case Is < 150: Airdensity = 0.00000038
                                        '                       0.000000002 =  150 km density
                                    Case Is < 200: Airdensity = 0.00000000125
                                        '                       0.00000000025 =  200 km density
                                    Case Is < 250: Airdensity = 0.0000000001
                                End Select
                                DragArea = 3.141592654 * CometSize(ii, jj) ^ 2 ' Note: Cometsize is in METERS not Km.
                                CometMassForDrag = 4188.79 * CometSize(ii, jj) ^ 3 ' 4/3 pi = 4.18879, then multiply by 1000 to get kg/cu meter.
                                DragNewtons = 0.5 * Airdensity * (Speed * 1000) ^ 2 * DragArea * 1 '  Assume a density of 1 for ice which is most of it and adds more drag to a particle then if it is rock so it errs on the side of being too much instead of too little.
                                SpeedDiff = (DragNewtons / CometMassForDrag) / 1000 ' Newtons works in m/sec and we need km/sec
                                CometSpeedX(ii, jj) = CometSpeedX(ii, jj) - SpeedDiff * CometSpeedX(ii, jj) / Speed
                                CometSpeedY(ii, jj) = CometSpeedY(ii, jj) - SpeedDiff * CometSpeedY(ii, jj) / Speed
                                CometSpeedZ(ii, jj) = CometSpeedZ(ii, jj) - SpeedDiff * CometSpeedZ(ii, jj) / Speed
                            End If
                        End If
                        PreviousCometX2(ii, jj) = PreviousCometX(ii, jj): PreviousCometX(ii, jj) = CometX(ii, jj)
                        PreviousCometY2(ii, jj) = PreviousCometY(ii, jj): PreviousCometY(ii, jj) = CometY(ii, jj)
                        PreviousCometZ2(ii, jj) = PreviousCometZ(ii, jj): PreviousCometZ(ii, jj) = CometZ(ii, jj)
                        PreviousCometY(ii, jj) = CometY(ii, jj)
                        PreviousCometZ(ii, jj) = CometZ(ii, jj)
                        CometX(ii, jj) = CometX(ii, jj) + CometSpeedX(ii, jj)
                        CometY(ii, jj) = CometY(ii, jj) + CometSpeedY(ii, jj)
                        CometZ(ii, jj) = CometZ(ii, jj) + CometSpeedZ(ii, jj)
                    End If

                    If CometMass(ii, jj) = 1 Then '     Has Hit Earth
                        If ii > 225 And ii < 260 Then CometMass(ii, jj) = 0 ' REMOVE FIREBALL after it hits earth
                        If EarthRotation$ = "Yes" Then '                                    Rotate Earth 0.004166666666 degrees every second
                            aaa = PreviousCometX2(ii, jj)
                            PreviousCometX2(ii, jj) = PreviousCometX2(ii, jj) * Cos(EarthRotation) - PreviousCometY2(ii, jj) * Sin(EarthRotation)
                            PreviousCometY2(ii, jj) = PreviousCometY2(ii, jj) * Cos(EarthRotation) + aaa * Sin(EarthRotation)
                            aaa = CometX(ii, jj)
                            CometX(ii, jj) = CometX(ii, jj) * Cos(EarthRotation) - CometY(ii, jj) * Sin(EarthRotation)
                            CometY(ii, jj) = CometY(ii, jj) * Cos(EarthRotation) + aaa * Sin(EarthRotation)
                        End If
                    End If
                    '   ################################################################################################################
                    If CometMass(ii, jj) > 0 Then ' Draw Fire for in flight or on ground
                        Distance = Sqr(CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2)
                        If Distance <= PlanetRadius + 190 And TimeCount > 70 And CometFiresOn$ = "Yes" Then
                            Speed = Sqr(CometSpeedX(ii, jj) ^ 2 + CometSpeedY(ii, jj) ^ 2 + CometSpeedZ(ii, jj) ^ 2)
                            If Speed > 6 Then ' air blast
                                FireFactor = (PlanetRadius + 200 - Distance) / 4
                                Select Case CarolinaView$
                                    Case "Top"
                                        If Sqr(CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2) >= PlanetRadius Or CometZ(ii, jj) >= 0 Then
                                            For k = 1 To 30
                                                Line (CometX(ii, jj), CometY(ii, jj))-(CometX(ii, jj) + FireFactor * (Rnd(32) - .5), CometY(ii, jj) + FireFactor * (Rnd(33) - .5)), _RGB(FireFactor * 4 + 50, 50, 0)
                                            Next k
                                        End If
                                    Case "Bottom"
                                        If Sqr(CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2) >= PlanetRadius Or CometZ(ii, jj) <= 0 Then
                                            For k = 1 To 30
                                                Line (-1 * CometX(ii, jj), CometY(ii, jj))-(-1 * CometX(ii, jj) + FireFactor * (Rnd(32) - .5), CometY(ii, jj) + FireFactor * (Rnd(33) - .5)), _RGB(FireFactor * 4 + 50, 50, 0)
                                            Next k
                                        End If
                                    Case "Back"
                                        If Sqr(CometY(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2) >= PlanetRadius Or CometX(ii, jj) >= 0 Then
                                            For k = 1 To 30
                                                Line (CometY(ii, jj), CometZ(ii, jj))-(CometY(ii, jj) + FireFactor * (Rnd(32) - .5), CometZ(ii, jj) + FireFactor * (Rnd(33) - .5)), _RGB(FireFactor * 4 + 50, 50, 0)
                                            Next k
                                        End If
                                    Case "Front"
                                        If Sqr(CometZ(ii, jj) ^ 2 + CometY(ii, jj) ^ 2) >= PlanetRadius Or CometX(ii, jj) <= 0 Then
                                            For k = 1 To 30
                                                Line (-1 * CometY(ii, jj), CometZ(ii, jj))-(-1 * CometY(ii, jj) + FireFactor * (Rnd(32) - .5), CometZ(ii, jj) + FireFactor * (Rnd(33) - .5)), _RGB(FireFactor * 4 + 50, 50, 0)
                                            Next k
                                        End If
                                    Case "LeftSide"
                                        If Sqr(CometX(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2) >= PlanetRadius Or CometY(ii, jj) <= 0 Then
                                            For k = 1 To 30
                                                Line (CometX(ii, jj), CometZ(ii, jj))-(CometX(ii, jj) + FireFactor * (Rnd(32) - .5), CometZ(ii, jj) + FireFactor * (Rnd(33) - .5)), _RGB(FireFactor * 4 + 50, 50, 0)
                                            Next k
                                        End If
                                    Case "RightSide"
                                        If Sqr(CometX(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2) >= PlanetRadius Or CometY(ii, jj) >= 0 Then
                                            For k = 1 To 30
                                                Line (-1 * CometX(ii, jj), CometZ(ii, jj))-(-1 * CometX(ii, jj) + FireFactor * (Rnd(32) - .5), CometZ(ii, jj) + FireFactor * (Rnd(33) - .5)), _RGB(FireFactor * 4 + 50, 50, 0)
                                            Next k
                                        End If
                                End Select
                            End If
                        End If
                        If Scene$ = "Egypt" Then
                            If Distance <= PlanetRadius And TimeCount > 5 Then CometMass(ii, jj) = 1
                        Else
                            If Distance <= PlanetRadius + 2 And TimeCount > 3 Then CometMass(ii, jj) = 1
                        End If
                        '   ################################################################################################################
                        If Distance > 50000 And TimeCount < 3500 Then CometMass(ii, jj) = 0 ' stop showing the particles far from Earth if rapidly getting there
                    End If

                    SkipIfZero:
                Next jj
            Next ii
        End If

        StartII = 0
        For ii = StartII To MazZ1 ' Display the comet Itself in flight
            DistFromSurface = Sqr(CometItselfX(ii) ^ 2 + CometItselfY(ii) ^ 2 + CometItselfZ(ii) ^ 2) - 6371
            If DistFromSurface < -10 Then CometHitEarth$ = "Yes"
            If CometHitEarth$ <> "Yes" Then
                Select Case CarolinaView$
                    Case "Top": If Sqr(CometItselfX(ii) ^ 2 + CometItselfY(ii) ^ 2) >= PlanetRadius Or CometItselfZ(ii) >= 0 Then Circle (CometItselfX(ii), CometItselfY(ii)), CometItselfRadius(ii) * 2, CometItselfColor(ii)
                    Case "Bottom": If Sqr(CometItselfX(ii) ^ 2 + CometItselfY(ii) ^ 2) >= PlanetRadius Or CometItselfZ(ii) <= 0 Then Circle (-1 * CometItselfX(ii), CometItselfY(ii)), CometItselfRadius(ii) * 2, CometItselfColor(ii)
                    Case "Back": If Sqr(CometItselfY(ii) ^ 2 + CometItselfZ(ii) ^ 2) >= PlanetRadius Or CometItselfX(ii) >= 0 Then Circle (CometItselfY(ii), CometItselfZ(ii)), CometItselfRadius(ii) * 2, CometItselfColor(ii)
                    Case "Front": If Sqr(CometItselfZ(ii) ^ 2 + CometItselfY(ii) ^ 2) >= PlanetRadius Or CometItselfX(ii) <= 0 Then Circle (-1 * CometItselfY(ii), CometItselfZ(ii)), CometItselfRadius(ii) * 2, CometItselfColor(ii)
                    Case "LeftSide": If Sqr(CometItselfX(ii) ^ 2 + CometItselfZ(ii) ^ 2) >= PlanetRadius Or CometItselfY(ii) <= 0 Then Circle (CometItselfX(ii), CometItselfZ(ii)), CometItselfRadius(ii) * 2, CometItselfColor(ii)
                    Case "RightSide": If Sqr(CometItselfX(ii) ^ 2 + CometItselfZ(ii) ^ 2) >= PlanetRadius Or CometItselfY(ii) >= 0 Then Circle (-1 * CometItselfX(ii), CometItselfZ(ii)), CometItselfRadius(ii) * 2, CometItselfColor(ii)
                End Select
            End If
        Next ii

        If BeginSplash$ = "Yes" Then
            BeginII = 1
            EndII = 150
            If AddMorePoints$ = "200" Then EndII = 200
            If AddMorePoints$ = "250" Then EndII = 250
            If AddMorePoints$ = "300" Then EndII = 300
            If Scene$ = "Egypt" Then EndII = 175
            If Scene$ = "Egypt" And TimeCount > 40 Then EndII = 225
            If Scene$ = "ChesapeakeBay" Then EndII = 300: BeginII = 226

            For ii = BeginII To EndII
                For jj = 1 To 300 '   ################################################################################################################
                    If CometMass(ii, jj) = 1.2 Then ' Particle still in flight
                        Distance = Sqr(CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2)
                        If Distance > PlanetRadius Then
                            Select Case CarolinaView$
                                Case "Top"
                                    If Sqr(CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2) >= PlanetRadius Or CometZ(ii, jj) >= 0 Then
                                        If MonoColor$ = "No" Then
                                            If HighlightSpeed$ = "Yes" Then
                                                Speed = Sqr(CometSpeedX(ii, jj) ^ 2 + CometSpeedY(ii, jj) ^ 2 + CometSpeedZ(ii, jj) ^ 2)
                                                Select Case Speed
                                                    Case Is <= 0.01: PSet (CometX(ii, jj), CometY(ii, jj)), CometColor(ii, jj)
                                                    Case Is <= 2: Circle (CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(100, 255, 100)
                                                    Case Is <= 3: Circle (CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(0, 255, 255)
                                                    Case Is <= 5: Circle (CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(0, 255, 0)
                                                    Case Is <= 7: Circle (CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 0, 0)
                                                    Case Is <= 9: Circle (CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 255, 0)
                                                    Case Is <= 11.2: Circle (CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(100, 100, 255)
                                                    Case Is > 11.2: Circle (CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 255, 255)
                                                End Select
                                            Else
                                                PSet (CometX(ii, jj), CometY(ii, jj)), CometColor(ii, jj)
                                            End If
                                        Else
                                            If HighlightSpeed$ = "Yes" Then
                                                Circle (CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, PresentMonoColor
                                            Else
                                                PSet (CometX(ii, jj), CometY(ii, jj)), PresentMonoColor
                                            End If
                                        End If
                                    End If
                                Case "Bottom"
                                    If Sqr(CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2) >= PlanetRadius Or CometZ(ii, jj) <= 0 Then
                                        If MonoColor$ = "No" Then
                                            If HighlightSpeed$ = "Yes" Then
                                                Speed = Sqr(CometSpeedX(ii, jj) ^ 2 + CometSpeedY(ii, jj) ^ 2 + CometSpeedZ(ii, jj) ^ 2)
                                                Select Case Speed
                                                    Case Is <= 0.01: PSet (-1 * CometX(ii, jj), CometY(ii, jj)), CometColor(ii, jj)
                                                    Case Is <= 2: Circle (-1 * CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(100, 255, 100)
                                                    Case Is <= 3: Circle (-1 * CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(0, 255, 255)
                                                    Case Is <= 5: Circle (-1 * CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(0, 255, 0)
                                                    Case Is <= 7: Circle (-1 * CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 0, 0)
                                                    Case Is <= 9: Circle (-1 * CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 255, 0)
                                                    Case Is <= 11.2: Circle (-1 * CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(100, 100, 255)
                                                    Case Is > 11.2: Circle (-1 * CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 255, 255)
                                                End Select
                                            Else
                                                PSet (-1 * CometX(ii, jj), CometY(ii, jj)), CometColor(ii, jj)
                                            End If
                                        Else
                                            If HighlightSpeed$ = "Yes" Then
                                                Circle (-1 * CometX(ii, jj), CometY(ii, jj)), CometSize(ii, jj) * .04, PresentMonoColor
                                            Else
                                                PSet (-1 * CometX(ii, jj), CometY(ii, jj)), PresentMonoColor
                                            End If
                                        End If
                                    End If
                                Case "Back"
                                    If Sqr(CometY(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2) >= PlanetRadius Or CometX(ii, jj) >= 0 Then
                                        If MonoColor$ = "No" Then
                                            If HighlightSpeed$ = "Yes" Then
                                                Speed = Sqr(CometSpeedX(ii, jj) ^ 2 + CometSpeedY(ii, jj) ^ 2 + CometSpeedZ(ii, jj) ^ 2)
                                                Select Case Speed
                                                    Case Is <= 2: Circle (CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(100, 255, 100)
                                                    Case Is <= 3: Circle (CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(0, 255, 255)
                                                    Case Is <= 5: Circle (CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(0, 255, 0)
                                                    Case Is <= 7: Circle (CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 0, 0)
                                                    Case Is <= 9: Circle (CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 255, 0)
                                                    Case Is <= 11.2: Circle (CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(100, 100, 255)
                                                    Case Is > 11.2: Circle (CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 255, 255)
                                                End Select
                                            Else
                                                PSet (CometY(ii, jj), CometZ(ii, jj)), CometColor(ii, jj)
                                            End If
                                        Else
                                            If HighlightSpeed$ = "Yes" Then
                                                Circle (CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, PresentMonoColor
                                            Else
                                                PSet (CometY(ii, jj), CometZ(ii, jj)), PresentMonoColor
                                            End If
                                        End If
                                    End If
                                Case "Front"
                                    If Sqr(CometZ(ii, jj) ^ 2 + CometY(ii, jj) ^ 2) >= PlanetRadius Or CometX(ii, jj) <= 0 Then
                                        If MonoColor$ = "No" Then
                                            If HighlightSpeed$ = "Yes" Then
                                                Speed = Sqr(CometSpeedX(ii, jj) ^ 2 + CometSpeedY(ii, jj) ^ 2 + CometSpeedZ(ii, jj) ^ 2)
                                                Select Case Speed
                                                    Case Is <= 0.01: PSet (-1 * CometY(ii, jj), CometZ(ii, jj)), CometColor(ii, jj)
                                                    Case Is <= 2: Circle (-1 * CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(100, 255, 100)
                                                    Case Is <= 3: Circle (-1 * CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(0, 255, 255)
                                                    Case Is <= 5: Circle (-1 * CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(0, 255, 0)
                                                    Case Is <= 7: Circle (-1 * CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 0, 0)
                                                    Case Is <= 9: Circle (-1 * CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 255, 0)
                                                    Case Is <= 11.2: Circle (-1 * CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(100, 100, 255)
                                                    Case Is > 11.2: Circle (-1 * CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 255, 255)
                                                End Select
                                            Else
                                                PSet (-1 * CometY(ii, jj), CometZ(ii, jj)), CometColor(ii, jj)
                                            End If
                                        Else
                                            If HighlightSpeed$ = "Yes" Then
                                                Circle (-1 * CometY(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, PresentMonoColor
                                            Else
                                                PSet (-1 * CometY(ii, jj), CometZ(ii, jj)), PresentMonoColor
                                            End If
                                        End If
                                    End If
                                Case "LeftSide"
                                    If Sqr(CometX(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2) >= PlanetRadius Or CometY(ii, jj) <= 0 Then
                                        If MonoColor$ = "No" Then
                                            If HighlightSpeed$ = "Yes" Then
                                                Speed = Sqr(CometSpeedX(ii, jj) ^ 2 + CometSpeedY(ii, jj) ^ 2 + CometSpeedZ(ii, jj) ^ 2)
                                                Select Case Speed
                                                    Case Is <= 2: Circle (CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(100, 255, 100)
                                                    Case Is <= 3: Circle (CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(0, 255, 255)
                                                    Case Is <= 5: Circle (CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(0, 255, 0)
                                                    Case Is <= 7: Circle (CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 0, 0)
                                                    Case Is <= 9: Circle (CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 255, 0)
                                                    Case Is <= 11.2: Circle (CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(100, 100, 255)
                                                    Case Is > 11.2: Circle (CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 255, 255)
                                                End Select
                                            Else
                                                PSet (CometX(ii, jj), CometZ(ii, jj)), CometColor(ii, jj)
                                            End If
                                        Else
                                            If HighlightSpeed$ = "Yes" Then
                                                Circle (CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, PresentMonoColor
                                            Else
                                                PSet (CometX(ii, jj), CometZ(ii, jj)), PresentMonoColor
                                            End If
                                        End If
                                    End If

                                Case "RightSide"
                                    If Sqr(CometX(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2) >= PlanetRadius Or CometY(ii, jj) >= 0 Then
                                        If MonoColor$ = "No" Then
                                            If HighlightSpeed$ = "Yes" Then
                                                Speed = Sqr(CometSpeedX(ii, jj) ^ 2 + CometSpeedY(ii, jj) ^ 2 + CometSpeedZ(ii, jj) ^ 2)
                                                Select Case Speed
                                                    Case Is <= 2: Circle (-1 * CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(100, 255, 100)
                                                    Case Is <= 3: Circle (-1 * CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(0, 255, 255)
                                                    Case Is <= 5: Circle (-1 * CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(0, 255, 0)
                                                    Case Is <= 7: Circle (-1 * CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 0, 0)
                                                    Case Is <= 9: Circle (-1 * CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 255, 0)
                                                    Case Is <= 11.2: Circle (-1 * CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(100, 100, 255)
                                                    Case Is > 11.2: Circle (-1 * CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, _RGB(255, 255, 255)
                                                End Select
                                            Else
                                                PSet (-1 * CometX(ii, jj), CometZ(ii, jj)), CometColor(ii, jj)
                                            End If
                                        Else
                                            If HighlightSpeed$ = "Yes" Then
                                                Circle (-1 * CometX(ii, jj), CometZ(ii, jj)), CometSize(ii, jj) * .04, PresentMonoColor
                                            Else
                                                PSet (-1 * CometX(ii, jj), CometZ(ii, jj)), PresentMonoColor
                                            End If
                                        End If
                                    End If
                            End Select
                        End If
                    End If

                    If CometMass(ii, jj) = 1 Then '     Has Hit Earth
                        CS = CometSize(ii, jj) / 250 ' Comet Particles are ranging from 50 to 500 m diameter
                        PointLength = (CometX(ii, jj) ^ 2 + CometY(ii, jj) ^ 2 + CometZ(ii, jj) ^ 2) ^ 0.5
                        If PointLength < 6371 Then PointLength = 6371
                        PrevPointLength = (PreviousCometX2(ii, jj) ^ 2 + PreviousCometY2(ii, jj) ^ 2 + PreviousCometZ2(ii, jj) ^ 2) ^ 0.5
                        If PrevPointLength < 6371 Then PrevPointLength = 6371
                        RatioPoint = 6371 / PointLength
                        PrevRatioPoint = 6371 / PrevPointLength
                        Select Case CarolinaView$
                            Case "Top":
                                If CometZ(ii, jj) >= 0 Then ' CIRCLE (CometX(ii, jj), CometY(ii, jj)), 10, CometColor(ii, jj): LINE (PreviousCometX2(ii, jj), PreviousCometY2(ii, jj))-(CometX(ii, jj), CometY(ii, jj)), CometColor(ii, jj)
                                    a = CometX(ii, jj) * RatioPoint
                                    b = PreviousCometX2(ii, jj) * PrevRatioPoint
                                    c = CometY(ii, jj) * RatioPoint
                                    d = PreviousCometY2(ii, jj) * PrevRatioPoint
                                    Call DrawMiniCraters(a, b, c, d, ii, jj)
                                End If
                            Case "Bottom":
                                If CometZ(ii, jj) <= 0 Then '  CIRCLE (-1 * CometX(ii, jj), CometY(ii, jj)), 10, CometColor(ii, jj): LINE (-1 * PreviousCometX2(ii, jj), PreviousCometY2(ii, jj))-(-1 * CometX(ii, jj), CometY(ii, jj)), CometColor(ii, jj)
                                    a = -1 * CometX(ii, jj) * RatioPoint
                                    b = -1 * PreviousCometX2(ii, jj) * PrevRatioPoint
                                    c = CometY(ii, jj) * RatioPoint
                                    d = PreviousCometY2(ii, jj) * PrevRatioPoint
                                    Call DrawMiniCraters(a, b, c, d, ii, jj)
                                End If
                            Case "Back"
                                If CometX(ii, jj) >= 0 Then '    CIRCLE (CometY(ii, jj), CometZ(ii, jj)), 10, CometColor(ii, jj)
                                    a = CometY(ii, jj) * RatioPoint
                                    b = PreviousCometY2(ii, jj) * PrevRatioPoint
                                    c = CometZ(ii, jj) * RatioPoint
                                    d = PreviousCometZ2(ii, jj) * PrevRatioPoint
                                    Call DrawMiniCraters(a, b, c, d, ii, jj)
                                End If
                            Case "Front"
                                If CometX(ii, jj) <= 0 Then '   CIRCLE (-1 * CometY(ii, jj), CometZ(ii, jj)), 6, CometColor(ii, jj)
                                    a = -1 * CometY(ii, jj) * RatioPoint
                                    b = -1 * PreviousCometY2(ii, jj) * PrevRatioPoint
                                    c = CometZ(ii, jj) * RatioPoint
                                    d = PreviousCometZ2(ii, jj) * PrevRatioPoint
                                    Call DrawMiniCraters(a, b, c, d, ii, jj)
                                End If
                            Case "LeftSide"
                                If CometY(ii, jj) <= 0 Then ' CIRCLE (CometX(ii, jj), CometZ(ii, jj)), 10, CometColor(ii, jj) ' LINE (PreviousCometX2(ii, jj), PreviousCometZ2(ii, jj))-(CometX(ii, jj), CometZ(ii, jj)), CometColor(ii, jj)
                                    a = CometX(ii, jj) * RatioPoint
                                    b = PreviousCometX2(ii, jj) * PrevRatioPoint
                                    c = CometZ(ii, jj) * RatioPoint
                                    d = PreviousCometZ2(ii, jj) * PrevRatioPoint
                                    Call DrawMiniCraters(a, b, c, d, ii, jj)
                                End If
                            Case "RightSide"
                                If CometY(ii, jj) >= 0 Then '  CIRCLE (-1 * CometX(ii, jj), CometZ(ii, jj)), 10, CometColor(ii, jj) ' LINE (-1 * PreviousCometX2(ii, jj), PreviousCometZ2(ii, jj))-(-1 * CometX(ii, jj), CometZ(ii, jj)), CometColor(ii, jj)
                                    a = -1 * CometX(ii, jj) * RatioPoint
                                    b = -1 * PreviousCometX2(ii, jj) * PrevRatioPoint
                                    c = CometZ(ii, jj) * RatioPoint
                                    d = PreviousCometZ2(ii, jj) * PrevRatioPoint
                                    Call DrawMiniCraters(a, b, c, d, ii, jj)
                                End If
                        End Select
                    End If
                Next jj

                A$ = InKey$
                If Len(A$) > 1 Then GoTo CheckIfKeysPressed
                If A$ <> "" Then KeyPressedInRoutine$ = A$
            Next ii
        End If

        If BeginSplash$ = "Yes" Then '  Draw Comet Itself on the Earth
            For ii = 1 To LakeMichCount
                StartJJ = 0
                For jj = StartJJ To 5
                    Select Case jj
                        Case 0: CometColor(0, 0) = _RGB(0, 255, 0) ' green
                        Case 1: CometColor(0, 0) = _RGB(255, 0, 0) ' red
                        Case 2: CometColor(0, 0) = _RGB(0, 0, 255) ' blue
                        Case 3: CometColor(0, 0) = _RGB(255, 255, 255) ' white
                        Case 4: CometColor(0, 0) = _RGB(255, 255, 0) ' yellow
                        Case 5: CometColor(0, 0) = _RGB(0, 0, 0) ' black
                    End Select
                    Select Case CarolinaView$
                        Case "Top":
                            If LakeMichLocZ(ii, jj) > 0 Then
                                For ff = 1 To 20
                                    Circle (LakeMichLocX(ii, jj), LakeMichLocY(ii, jj)), LakeMichLocRad(ii, jj) * ff / 10 + 1, _RGB(0, 0, 0)
                                    Circle (LakeMichLocX(ii, jj), LakeMichLocY(ii, jj)), LakeMichLocRad(ii, jj) * ff / 10, CometColor(0, 0)
                                Next ff
                            End If
                        Case "Bottom"
                            If LakeMichLocZ(ii, jj) < 0 Then
                                For ff = 1 To 20
                                    Circle (-1 * LakeMichLocX(ii, jj), LakeMichLocY(ii, jj)), LakeMichLocRad(ii, jj) * ff / 10 + 1, _RGB(0, 0, 0)
                                    Circle (-1 * LakeMichLocX(ii, jj), LakeMichLocY(ii, jj)), LakeMichLocRad(ii, jj) * ff / 10, CometColor(0, 0)
                                Next ff
                            End If
                        Case "Back": If LakeMichLocX(ii, jj) > 0 Then Circle (LakeMichLocY(ii, jj), LakeMichLocZ(ii, jj)), LakeMichLocRad(ii, jj) * 3, CometColor(0, 0)
                        Case "Front"
                            If LakeMichLocX(ii, jj) < 0 Then
                                For ff = 15 To 20
                                    Circle (-1 * LakeMichLocY(ii, jj), LakeMichLocZ(ii, jj)), LakeMichLocRad(ii, jj) * ff / 10 + 1, _RGB(0, 0, 0)
                                    Circle (-1 * LakeMichLocY(ii, jj), LakeMichLocZ(ii, jj)), LakeMichLocRad(ii, jj) * ff / 10, CometColor(0, 0)
                                Next ff
                            End If
                        Case "LeftSide"
                            If LakeMichLocY(ii, jj) <= 0 Then
                                For ff = 1 To 20 Step 4
                                    Circle (LakeMichLocX(ii, jj), LakeMichLocZ(ii, jj)), LakeMichLocRad(ii, jj) * ff / 10 + 2, _RGB(0, 0, 0)
                                    Circle (LakeMichLocX(ii, jj), LakeMichLocZ(ii, jj)), LakeMichLocRad(ii, jj) * ff / 10, CometColor(0, 0)
                                Next ff
                            End If
                        Case "RightSide":
                            If LakeMichLocY(ii, jj) >= 0 Then
                                Circle (-1 * LakeMichLocX(ii, jj), LakeMichLocZ(ii, jj)), LakeMichLocRad(ii, jj) * 2, CometColor(0, 0)
                            End If
                    End Select
                    If EarthRotation$ = "Yes" Then
                        aaa = LakeMichLocX(ii, jj)
                        LakeMichLocX(ii, jj) = LakeMichLocX(ii, jj) * Cos(EarthRotation) - LakeMichLocY(ii, jj) * Sin(EarthRotation)
                        LakeMichLocY(ii, jj) = LakeMichLocY(ii, jj) * Cos(EarthRotation) + aaa * Sin(EarthRotation)
                    End If
                Next jj
            Next ii
        End If

        '     HEADER                    ****************************@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*********************************      HEADER


        HeaderDepth = ZoomWindow4 - (ZoomWindow4 - ZoomWindow2) * .02
        HeaderDepth2 = (ZoomWindow4 - ZoomWindow2) * .0008
        Line (ZoomWindow1, ZoomWindow4)-(ZoomWindow3, HeaderDepth), _RGB(215, 215, 215), BF
        Line (ZoomWindow1, HeaderDepth)-(ZoomWindow3, HeaderDepth - HeaderDepth2), _RGB(100, 100, 100), BF
        Line (ZoomWindow1, HeaderDepth - HeaderDepth2)-(ZoomWindow3, HeaderDepth - HeaderDepth2 * 1.5), _RGB(220, 220, 220), BF



        Color _RGB(0, 0, 0), _RGB(215, 215, 215)
        Select Case Scene$
            Case "Saginaw 1": _PrintString (10, 3), "Simulation of Saginaw Bay Impact at ~ 20 degrees, forming the Carolina Bays"
            Case "Saginaw 2": _PrintString (10, 3), "Simulation of Saginaw Bay Impact and second impact at ~ 20 degrees, forming the Carolina Bays"
            Case "Encke and Swift-Tuttle Origins": _PrintString (10, 3), "Simulation of one comet leading to Encke and Swift Tuttle        "
            Case "Carolina Bays": _PrintString (10, 3), "Simulation of Swift Tuttle skip impacting at ~ 10 degrees, forming Lake Michigan and the Carolina Bays"
            Case "Egypt": _PrintString (10, 3), "Simulation of impact 1628 BC, forming Qattera Depression, Egypt, and causing devastation to civilizations"
            Case "ChesapeakeBay": _PrintString (10, 3), "Simulation of Chesapeake Bay impact, with jetting of material leading to North AMerican Tekite field"
        End Select

        Color _RGB(0, 0, 0), _RGB(215, 215, 215)


        If BeginSplash$ = "No" Then
            _PrintString (1060, 3), "Time before Impact: " + Str$(300 - TimeCount) + " Seconds  "
        Else
            _PrintString (1060, 3), "Time since Impact: " + Str$(TimeCount) + "  Seconds  "
            If TimeCount < 30000 Then _PrintString (1420, 3), Str$(Int(TimeCount / 6) / 10) Else _PrintString (1420, 3), Str$(Int(TimeCount / 60)) ' no decimal needed for > 500 minutes
            _PrintString (1490, 3), "Minutes  "
            _PrintString (1580, 3), Str$(Int(TimeCount / 360) / 10)
            _PrintString (1645, 3), " Hours   "
        End If

        Color _RGB(0, 0, 255)
        If AddMorePoints$ <> "No" Then _PrintString (1740, 3), AddMorePoints$
        Color _RGB(0, 0, 0), _RGB(215, 215, 215)

        If CarolinaNumbers <> 0 Then
            Select Case CarolinaNumbers
                Case 1: _PrintString (870, 3), "Display: 0 - 2 km/s "
                Case 2: _PrintString (870, 3), "Display: 2 - 3 km/s "
                Case 3: _PrintString (870, 3), "Display: 3 - 4 km/s "
                Case 4: _PrintString (870, 3), "Display: 4 - 5 km/s "
                Case 5: _PrintString (870, 3), "Display: 5 - 6 km/s "
                Case 6: _PrintString (870, 3), "Display: 6 - 7 km/s "
                Case 7: _PrintString (870, 3), "Display: 7 - 8 km/s "
                Case 8: _PrintString (870, 3), "Display: 8 - 10 km/s "
                Case 9: _PrintString (870, 3), "Display: 0 - 10 km/s "
            End Select
        End If
        Color _RGB(255, 255, 255), _RGB(0, 0, 0)

        'Locate function key reminders in bottom menu bar

        HeaderDepth = ZoomWindow2 + (ZoomWindow4 - ZoomWindow2) * .02
        HeaderDepth2 = (ZoomWindow4 - ZoomWindow2) * .0008
        Color _RGB(55, 55, 55), _RGB(215, 215, 185)
        Line (ZoomWindow1, ZoomWindow2)-(ZoomWindow3, HeaderDepth), _RGB(215, 215, 185), BF
        'HeaderDepth - HeaderDepth2 * 2)-(ZoomWindow3, HeaderDepth - HeaderDepth2 * 3), _RGB(255, 0, 0), BF
        _PrintString (10, 982), "Space Bar: Pause   End Program: 'Esc'   Cursor Keys: Zoom/View   F1-F5: 2D Skip Impacts   F6:                   F7:                           F8:                        F9:                       F10:                  "
        Select Case DrawCraters$
            Case "Both": Color _RGB(0, 0, 255): _PrintString (758, 982), "Craters are ON  "
            Case "Words": Color _RGB(0, 0, 255): _PrintString (758, 982), "Labels  are ON  "
            Case "Craters": Color _RGB(0, 0, 255): _PrintString (758, 982), "Labels  are OFF "
            Case "No": Color _RGB(255, 0, 0): _PrintString (758, 982), "Craters are OFF "
        End Select
        If AtmosphereDrag$ = "Yes" Then
            Color _RGB(0, 0, 255): _PrintString (935, 982), "Atmospheric Drag is ON  "
        Else
            Color _RGB(255, 0, 0): _PrintString (935, 982), "Atmospheric Drag is OFF "
        End If
        If EarthRotation$ = "Yes" Then
            Color _RGB(0, 0, 255): _PrintString (1174, 982), "Earth rotation is ON  "
        Else
            Color _RGB(255, 0, 0): _PrintString (1174, 982), "Earth rotation is OFF "
        End If
        If CometFiresOn$ = "Yes" Then
            Color _RGB(0, 0, 255): _PrintString (1389, 982), "Display Fires is ON "
        Else
            Color _RGB(255, 0, 0): _PrintString (1389, 982), "Display Fires is OFF"
        End If
        If HighlightSpeed$ = "Yes" Then
            Color _RGB(0, 0, 255): _PrintString (1605, 982), "Display:Speeds       "
        Else
            Color _RGB(0, 0, 100): _PrintString (1605, 982), "Display:Comet Source "
        End If

        Color _RGB(255, 255, 255), _RGB(0, 0, 0)

        _Display


        CheckIfKeysPressed:

        If KeyPressedInRoutine$ <> "" Then A$ = KeyPressedInRoutine$
        ' do not do a screen print until a loop has finished but do allow an immeadiate change to another scene
        If A$ <> "" Then If Asc(A$) <> 16 Then Call CheckifChangeScene(A$, RunProgram$) '            CASE 1, 4, 5, 6, 7, 8, 12, 17, 18, 19, 20, 23, 25 ' Ctrl A, D, E, F, Q, R, S, T, W, Y - start over
        If RunProgram$ = "StartOver" Or RunProgram$ = "StartOverMenu" Then RunImpactProbabilities$ = A$: Exit Sub
        If Len(A$) = 1 Then
            Select Case Asc(A$)
                Case 32 ' space bar
                    A$ = "": While A$ = "": A$ = InKey$: Wend
                Case 24 ' Ctrl X
                    Select Case CarolinaView$
                        Case "Top": CarolinaView$ = "Bottom"
                        Case "LeftSide": CarolinaView$ = "Top"
                        Case "Front": CarolinaView$ = "LeftSide"
                        Case "RightSide": CarolinaView$ = "Front"
                        Case "Back": CarolinaView$ = "RightSide"
                        Case "Bottom": CarolinaView$ = "Back"
                    End Select
                    GoTo StartDisplayCarolinaBays
                Case 26 ' Ctrl Z
                    Select Case CarolinaView$
                        Case "Top": CarolinaView$ = "LeftSide"
                        Case "LeftSide": CarolinaView$ = "Front"
                        Case "Front": CarolinaView$ = "RightSide"
                        Case "RightSide": CarolinaView$ = "Back"
                        Case "Back": CarolinaView$ = "Bottom"
                        Case "Bottom": CarolinaView$ = "Top"
                    End Select
                    GoTo StartDisplayCarolinaBays
                Case 96: ' Pressing the "~`" key changes the displayed colors
                    Select Case MonoColor$
                        Case "Yellow": MonoColor$ = "Green": PresentMonoColor = _RGB(0, 255, 0)
                        Case "White": MonoColor$ = "Yellow": PresentMonoColor = _RGB(255, 255, 0)
                        Case "No": MonoColor$ = "White": PresentMonoColor = _RGB(255, 255, 255)
                        Case "Green": MonoColor$ = "No"
                    End Select
            End Select
        End If

    Wend '   End of loop of drawing impact particles


    If A$ <> "" Then
        Call CheckifChangeScene(A$, RunProgram$) '            CASE 1, 4, 5, 6, 7, 8, 12, 17, 18, 19, 20, 23, 25 ' Ctrl A, D, E, F, Q, R, S, T, W, Y - start over
        If RunProgram$ = "StartOver" Or RunProgram$ = "StartOverMenu" Then RunImpactProbabilities$ = A$: Exit Sub
    End If

    RunProgram$ = A$ ' Checking for these key presses outside of loop allows the screen to update before screen saves

    If Len(A$) = 1 Then
        Select Case Asc(A$)
            Case 16 ' Ctrl P = immeadiate screen save to pre-determined folder with predetermined names - Already saved in CheckIfChangeScene sub routine but need to continue without screen save
                GoTo StartDisplayCarolinaBayswithoutCLS
            Case 48: CarolinaNumbers = 0 ' 0 pressed
                If TimeCount > 3000 Then CarolinaNumbers = 0: A$ = "" ' do not let an accidental key press ruin a long calculation
            Case 49: CarolinaNumbers = 1 ' 1 pressed
                If TimeCount > 3000 Then CarolinaNumbers = 0: A$ = "" ' do not let an accidental key press ruin a long calculation
            Case 50: CarolinaNumbers = 2 ' 2 pressed
                If TimeCount > 3000 Then CarolinaNumbers = 0: A$ = "" ' do not let an accidental key press ruin a long calculation
            Case 51: CarolinaNumbers = 3 ' 3 pressed
                If TimeCount > 3000 Then CarolinaNumbers = 0: A$ = "" ' do not let an accidental key press ruin a long calculation
            Case 52: CarolinaNumbers = 4 ' 4 pressed
                If TimeCount > 3000 Then CarolinaNumbers = 0: A$ = "" ' do not let an accidental key press ruin a long calculation
            Case 53: CarolinaNumbers = 5 ' 5 pressed
                If TimeCount > 3000 Then CarolinaNumbers = 0: A$ = "" ' do not let an accidental key press ruin a long calculation
            Case 54: CarolinaNumbers = 6 ' 6 pressed
                If TimeCount > 3000 Then CarolinaNumbers = 0: A$ = "" ' do not let an accidental key press ruin a long calculation
            Case 55: CarolinaNumbers = 7 ' 7 pressed
                If TimeCount > 3000 Then CarolinaNumbers = 0: A$ = "" ' do not let an accidental key press ruin a long calculation
            Case 56: CarolinaNumbers = 8 ' 8 pressed
                If TimeCount > 3000 Then CarolinaNumbers = 0: A$ = "" ' do not let an accidental key press ruin a long calculation
            Case 57: CarolinaNumbers = 9 ' 9 pressed
                If TimeCount > 3000 Then CarolinaNumbers = 0: A$ = "" ' do not let an accidental key press ruin a long calculation
        End Select

        Select Case Asc(A$)
            Case 48 To 57: ZoomWindow1 = -14850: ZoomWindow2 = -8355: ZoomWindow3 = 14850: ZoomWindow4 = 8355: ZoomedtoComet$ = "No": A$ = Chr$(19): Exit Sub ' CHR$(19) = Ctrl S, so start over
        End Select
    End If

    ascii2byte = 0
    If Len(A$) > 1 Then ascii2byte = Asc(A$, 2) ' read second character of 2 byte codes such as function keys and cursor keys

    If ascii2byte <> 0 Then
        ZoomXDiff = ZoomWindow3 - ZoomWindow1
        ZoomYDiff = ZoomWindow4 - ZoomWindow2
        Select Case ascii2byte
            Case 64 ' F6 = Toggle Comet craters on or off
                Select Case DrawCraters$
                    Case "Both": DrawCraters$ = "Words"
                    Case "Words": DrawCraters$ = "Craters"
                    Case "Craters": DrawCraters$ = "No"
                    Case "No": DrawCraters$ = "Both"
                End Select
                GoTo StartDisplayCarolinaBayswithoutCLS
            Case 65: ' F7 toggle Atmosphere
                If AtmosphereDrag$ <> "Yes" Then AtmosphereDrag$ = "Yes" Else AtmosphereDrag$ = "No"
                GoTo StartDisplayCarolinaBayswithoutCLS
            Case 66: ' F8 toggle Rotation
                If EarthRotation$ <> "Yes" Then EarthRotation$ = "Yes" Else EarthRotation$ = "No"
                If Scene$ = "Egypt" Then EarthRotation$ = "No"
                GoTo StartDisplayCarolinaBayswithoutCLS
            Case 67: ' F9 toggle Fire Display on/off
                If CometFiresOn$ <> "Yes" Then CometFiresOn$ = "Yes" Else CometFiresOn$ = "No"
                GoTo StartDisplayCarolinaBayswithoutCLS
            Case 68: ' F10 toggle speed display
                If HighlightSpeed$ <> "Yes" Then HighlightSpeed$ = "Yes" Else HighlightSpeed$ = "No"
                GoTo StartDisplayCarolinaBayswithoutCLS
            Case 133: ' F11 Add more points - requires a restart to recalculate in more points, does not require a restart to stop showing them
                If Scene$ = "Egypt" Then AddMorePoints$ = "No": Beep: GoTo StartDisplayCarolinaBayswithoutCLS
                Select Case AddMorePoints$
                    Case "", "No": AddMorePoints$ = "200"
                    Case "200": AddMorePoints$ = "250"
                    Case "250": AddMorePoints$ = "300"
                    Case "300": AddMorePoints$ = "No": GoTo StartDisplayCarolinaBayswithoutCLS
                    Case Else: AddMorePoints$ = "No": GoTo StartDisplayCarolinaBayswithoutCLS
                End Select
                ZoomWindow1 = -14850: ZoomWindow2 = -8355: ZoomWindow3 = 14850: ZoomWindow4 = 8355 ' Center on Earth = 0,0 co-ordinates
                ZoomedtoComet$ = "No"
                Exit Sub
            Case 134: ' F12 - toggle show displays
                If ShowPaths$ <> "Yes" Then ShowPaths$ = "Yes" Else ShowPaths$ = "No"
                GoTo StartDisplayCarolinaBays
            Case 71 '        cursor home
                ZoomWindow1 = -133250: ZoomWindow2 = -71940: ZoomWindow3 = 133250: ZoomWindow4 = 71940
                GoTo StartDisplayCarolinaBays
            Case 80 '        cursor key down
                ZoomWindow4 = ZoomWindow4 + ZoomYDiff * .1
                ZoomWindow2 = ZoomWindow2 + ZoomYDiff * .1
                '                LOCATE 10, 10: PRINT ZoomWindow1, ZoomWindow2, ZoomWindow3, ZoomWindow4
                '                _DISPLAY
                '                AAA$ = "": WHILE AAA$ = "": AAA$ = INKEY$: WEND
                GoTo StartDisplayCarolinaBays
            Case 73 '        cursor key page up
                ZoomWindow1 = ZoomWindow1 + ZoomXDiff * .25
                ZoomWindow2 = ZoomWindow2 + ZoomYDiff * .25
                ZoomWindow3 = ZoomWindow3 - ZoomXDiff * .25
                ZoomWindow4 = ZoomWindow4 - ZoomYDiff * .25
                GoTo StartDisplayCarolinaBays
            Case 72 '        cursor key up
                ZoomWindow4 = ZoomWindow4 - ZoomYDiff * .1
                ZoomWindow2 = ZoomWindow2 - ZoomYDiff * .1
                GoTo StartDisplayCarolinaBays
            Case 81 '        cursor key page down
                ZoomWindow1 = ZoomWindow1 - ZoomXDiff * .25
                ZoomWindow2 = ZoomWindow2 - ZoomYDiff * .25
                ZoomWindow3 = ZoomWindow3 + ZoomXDiff * .25
                ZoomWindow4 = ZoomWindow4 + ZoomYDiff * .25
                GoTo StartDisplayCarolinaBays
            Case 75 '        cursor key left
                ZoomWindow1 = ZoomWindow1 + ZoomXDiff * .1
                ZoomWindow3 = ZoomWindow3 + ZoomXDiff * .1
                GoTo StartDisplayCarolinaBays
            Case 77 '        cursor key left
                ZoomWindow1 = ZoomWindow1 - ZoomXDiff * .1
                ZoomWindow3 = ZoomWindow3 - ZoomXDiff * .1
                GoTo StartDisplayCarolinaBays
            Case 79 ' Cursor End
                If ZoomedtoComet$ <> "Yes" Then
                    ZoomWindow1 = -1855: ZoomWindow2 = 2841: ZoomWindow3 = 1855: ZoomWindow4 = 4931 ' Center on Earth = 0,0 co-ordinates
                    ZoomedtoComet$ = "Yes"
                Else
                    ZoomWindow1 = -14850: ZoomWindow2 = -8355: ZoomWindow3 = 14850: ZoomWindow4 = 8355 ' Center on Earth = 0,0 co-ordinates
                    ZoomedtoComet$ = "No"
                End If
                GoTo StartDisplayCarolinaBays
        End Select
    End If

    GoTo StartDisplayCarolinaBays

End Sub


